<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class ColorSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $colors = [
            [
                'color' => '#ffffff',
                'label' => __('messages.colors.white'),
            ],
            [
                'color' => '#e1e0e0',
                'label' => __('messages.colors.silver'),
            ],
            [
                'color' => '#b7b7b7',
                'label' => __('messages.colors.ashen'),
            ],
            [
                'color' => '#4b6584',
                'label' => __('messages.colors.gray'),
            ],
            [
                'color' => '#000080',
                'label' => __('messages.colors.navy'),
            ],
            [
                'color' => '#000000',
                'label' => __('messages.colors.black'),
            ],

            [
                'color' => '#800020',
                'label' => __('messages.colors.burgundy'),
            ],
            [
                'color' => '#ea060e',
                'label' => __('messages.colors.red'),
            ],
            [
                'color' => '#ff4d4d',
                'label' => __('messages.colors.light_red'),
            ],
            [
                'color' => '#fa7676',
                'label' => __('messages.colors.light_coral'),
            ],
            [
                'color' => '#ea8685',
                'label' => __('messages.colors.golbeh'),
            ],
            [
                'color' => '#ffb8b8',
                'label' => __('messages.colors.misty_rose'),
            ],
            [
                'color' => '#ffcccc',
                'label' => __('messages.colors.light_rose'),
            ],
            [
                'color' => '#f78fb3',
                'label' => __('messages.colors.flamingo_pink'),
            ],
            [
                'color' => '#ff69b4',
                'label' => __('messages.colors.pink'),
            ],

            [
                'color' => '#835400',
                'label' => __('messages.colors.brown'),
            ],
            [
                'color' => '#c17e06',
                'label' => __('messages.colors.bronze'),
            ],
            [
                'color' => '#f8a203',
                'label' => __('messages.colors.orange'),
            ],
            [
                'color' => '#f7b731',
                'label' => __('messages.colors.gold'),
            ],
            [
                'color' => '#fed330',
                'label' => __('messages.colors.yellow'),
            ],
            [
                'color' => '#ffe891',
                'label' => __('messages.colors.light_yellow'),
            ],

            [
                'color' => '#006400',
                'label' => __('messages.colors.dark_green'),
            ],
            [
                'color' => '#2E8B57',
                'label' => __('messages.colors.sea_green'),
            ],
            [
                'color' => '#26de81',
                'label' => __('messages.colors.green'),
            ],
            [
                'color' => '#00FA9A',
                'label' => __('messages.colors.spring_green'),
            ],
            [
                'color' => '#00FF00',
                'label' => __('messages.colors.lime_green'),
            ],
            [
                'color' => '#1e6280',
                'label' => __('messages.colors.blue_green'),
            ],
            [
                'color' => '#0fb9b1',
                'label' => __('messages.colors.light_blue_green'),
            ],
            [
                'color' => '#40E0D0',
                'label' => __('messages.colors.turquoise'),
            ],

            [
                'color' => '#000fbd',
                'label' => __('messages.colors.dark_blue'),
            ],
            [
                'color' => '#0060ff',
                'label' => __('messages.colors.blue'),
            ],
            [
                'color' => '#3ab4ff',
                'label' => __('messages.colors.medium_blue'),
            ],
            [
                'color' => '#87CEFA',
                'label' => __('messages.colors.sky_blue'),
            ],
            [
                'color' => '#bfefff',
                'label' => __('messages.colors.light_blue'),
            ],

            [
                'color' => '#4B0082',
                'label' => __('messages.colors.indigo'),
            ],
            [
                'color' => '#8854d0',
                'label' => __('messages.colors.purple'),
            ],
            [
                'color' => '#9980FA',
                'label' => __('messages.colors.blue_purple'),
            ],
            [
                'color' => '#bd7dfb',
                'label' => __('messages.colors.light_purple'),
            ],
            [
                'color' => '#dab3ff',
                'label' => __('messages.colors.violet'),
            ],
        ];

        foreach ($colors as $color) {
            DB::table('colors')->insert([
                'color' => $color['color'],
                'label' => $color['label']
            ]);
        }
    }
}