<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('consignment_items', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('consignment_id')->index();
            $table->unsignedBigInteger('store_id')->index()->nullable();
            $table->unsignedBigInteger('inventory_id')->index()->nullable();
            $table->unsignedBigInteger('product_id')->index();
            $table->unsignedBigInteger('storage_id')->index()->nullable();

            $table->string('title');
            $table->text('props')->nullable();
            $table->text('affiliate')->nullable();
            $table->unsignedBigInteger('count');
            $table->unsignedBigInteger('price');
            $table->unsignedBigInteger('discount');
            $table->unsignedBigInteger('shop_share')->nullable();
            $table->unsignedBigInteger('seller_share')->nullable();
            $table->unsignedBigInteger('affiliate_share')->nullable();
            $table->text('reason')->nullable();
            $table->string('status');

            $table->timestamps();

            $table->foreign('consignment_id')->references('id')->on('consignments')->cascadeOnDelete();
            $table->foreign('store_id')->references('id')->on('stores')->cascadeOnDelete();
            $table->foreign('inventory_id')->references('id')->on('inventories')->nullOnDelete();
            $table->foreign('product_id')->references('id')->on('products')->noActionOnDelete();
            $table->foreign('storage_id')->references('id')->on('storages')->nullOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('consignment_items');
    }
};
