<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('articles', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id')->index();
            $table->unsignedBigInteger('edited_by')->index();
            $table->unsignedBigInteger('brand_id')->index()->nullable();
            $table->unsignedBigInteger('category_id')->index();

            $table->string('uuid')->unique();
            $table->string('title');
            $table->string('slug')->unique();
            $table->text('content')->nullable();
            $table->text('source')->nullable();
            $table->text('read_time')->nullable();
            $table->string('type')->default('text');

            $table->text('image')->nullable();
            $table->text('video')->nullable();
            $table->text('podcast')->nullable();

            $table->string('seo_title')->nullable();
            $table->text('seo_description')->nullable();
            $table->text('seo_keywords')->nullable();
            $table->string('seo_canonical')->nullable();

            $table->unsignedBigInteger('view_count')->default('0');
            $table->boolean('comment_status')->default(true);
            $table->boolean('editor_choice')->default(true);
            $table->unsignedBigInteger('vote')->default(0);

            $table->text('reason')->nullable();
            $table->string('status');

            $table->timestamps();

            $table->foreign('user_id')->references('id')->on('users')->cascadeOnDelete();
            $table->foreign('edited_by')->references('id')->on('users')->cascadeOnDelete();
            $table->foreign('brand_id')->references('id')->on('brands')->noActionOnDelete();
            $table->foreign('category_id')->references('id')->on('article_categories')->noActionOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('articles');
    }
};
