<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('product_comments', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id')->index();
            $table->unsignedBigInteger('product_id')->index();

            $table->text('content');
            $table->text('answer')->nullable();
            $table->text('strengths')->nullable();
            $table->text('weakness')->nullable();

            $table->text('images')->nullable();

            $table->string('buy_suggest')->nullable();
            $table->string('rating');
            $table->string('vote_up')->default(0);
            $table->string('vote_down')->default(0);
            $table->boolean('reported')->default(false);

            $table->string('status');

            $table->timestamps();

            $table->foreign('user_id')->references('id')->on('users')->cascadeOnDelete();
            $table->foreign('product_id')->references('id')->on('products')->cascadeOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('product_comments');
    }
};