<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('discounts', function (Blueprint $table) {
            $table->id();

            $table->string('for');
            $table->string('title');
            $table->string('code')->unique();
            $table->timestamp('expire_at');
            $table->unsignedInteger('percent');
            $table->unsignedBigInteger('max_amount');
            $table->unsignedInteger('max_use');
            $table->string('status');

            $table->timestamps();
        });

        Schema::create('discount_user', function (Blueprint $table) {
            $table->unsignedBigInteger("discount_id");
            $table->foreign('discount_id')->references('id')->on('discounts')->cascadeOnDelete();

            $table->unsignedBigInteger("user_id");
            $table->foreign('user_id')->references('id')->on('users')->cascadeOnDelete();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('discounts');
        Schema::dropIfExists('discount_user');
    }
};
