<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('specification_keys', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('specification_id')->index()->nullable();

            $table->string('key');
            $table->text('default_value')->nullable();

            $table->timestamps();

            $table->foreign('specification_id')->references('id')->on('specifications')->cascadeOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('specification_keys');
    }
};
