<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('transactions', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id')->index();

            $table->bigInteger('amount');
            $table->bigInteger('transaction_id')->unique();
            $table->string('payment_gateway')->nullable();
            $table->text('gateway_transaction_id')->nullable();
            $table->string('gateway_reference_id')->nullable();
            $table->text('return_response')->nullable();
            $table->text('payment_details')->nullable();
            $table->text('description')->nullable();
            $table->enum('type', [
                'admin_increase',
                'admin_decrease',

                'user_charge',
                'user_order_returned',
                'coupon_charge',
                'order_decrease',

                'seller_revenue',
                'seller_returned_decrease',

                'affiliate_revenue',
                'affiliate_returned_decrease',

                'bank_withdrawal',
            ]);
            $table->enum('status', [
                'accepted',
                'rejected',
                'waiting_payment',
                'waiting_admin',
            ]);

            $table->timestamps();

            $table->foreign('user_id')->references('id')->on('users')->cascadeOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('transactions');
    }
};
