<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id')->index();
            $table->unsignedBigInteger('edited_by')->index();
            $table->unsignedBigInteger('brand_id')->index()->nullable();
            $table->unsignedBigInteger('category_id')->index();

            $table->string('uuid')->unique();
            $table->string('title');
            $table->string('title_en')->nullable();
            $table->string('slug')->unique();
            $table->text('content')->nullable();
            $table->text('warnings')->nullable();
            $table->string('send_time')->nullable();
            $table->text('guide')->nullable();
            $table->text('tabs')->nullable();

            $table->text('images')->nullable();
            $table->text('videos')->nullable();
            $table->text('model_3d')->nullable();

            $table->text('attrs')->nullable();

            $table->string('seo_title')->nullable();
            $table->text('seo_description')->nullable();
            $table->text('seo_keywords')->nullable();
            $table->string('seo_canonical')->nullable();

            $table->unsignedBigInteger('view_count')->default('0');

            $table->boolean('in_stock_status')->default(true);
            $table->text('inquiry_options')->nullable();

            $table->float('commission')->default(0);

            $table->boolean('is_vip')->default(false);
            $table->boolean('comment_status')->default(true);
            $table->boolean('question_status')->default(true);

            $table->text('reason');
            $table->string('status');

            $table->timestamps();

            $table->foreign('user_id')->references('id')->on('users')->cascadeOnDelete();
            $table->foreign('edited_by')->references('id')->on('users')->cascadeOnDelete();
            $table->foreign('brand_id')->references('id')->on('brands')->cascadeOnDelete();
            $table->foreign('category_id')->references('id')->on('product_categories')->cascadeOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('products');
    }
};
