import { defineComponent, onMounted, onUnmounted, mergeProps, useSSRContext, unref } from "vue";
import { ssrRenderAttrs, ssrRenderComponent, ssrInterpolate, ssrRenderStyle } from "vue/server-renderer";
import { _ as _sfc_main$3 } from "./AdminLayout-CD07IMsK.js";
import { Head } from "@inertiajs/vue3";
import { _ as _sfc_main$4 } from "./Files-B6eiTnN6.js";
import { _ as _sfc_main$5 } from "./ApextBarChart-pRumOpuR.js";
import { _ as _sfc_main$6 } from "./LineChart-CIYq_-2s.js";
import ApexCharts from "apexcharts";
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "laravel-vue-i18n";
import "./Pagination-C1AQrLe3.js";
import "./SearchList-BZnYMQPN.js";
import "lodash/debounce.js";
import "./useRandomNum-DNNSqR7b.js";
import "chart.js/auto";
import "jquery";
const _sfc_main$2 = /* @__PURE__ */ defineComponent({
  __name: "ApexPieChart",
  __ssrInlineRender: true,
  props: {
    id: {},
    labels: {},
    series: {},
    color: {}
  },
  setup(__props) {
    const props = __props;
    var PieChartOptions = {
      chart: {
        height: 275,
        type: "donut",
        toolbar: { show: false }
      },
      dataLabels: { enabled: false },
      stroke: { show: true, width: 1, colors: ["transparent"] },
      colors: props.color,
      series: props.series,
      labels: props.labels,
      legend: {
        position: "bottom",
        horizontalAlign: "center",
        fontFamily: "IRANYekanX",
        offsetY: 8
      },
      fill: { opacity: 1 },
      tooltip: {
        style: {
          fontSize: "12px",
          fontFamily: "IRANYekanX"
        }
      }
    };
    let chart;
    onMounted(() => {
      chart = new ApexCharts(document.querySelector("#pie-chart-" + props.id), PieChartOptions);
      chart.render();
    });
    onUnmounted(() => {
      chart.destroy();
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({
        id: "pie-chart-" + _ctx.id
      }, _attrs))}></div>`);
    };
  }
});
const _sfc_setup$2 = _sfc_main$2.setup;
_sfc_main$2.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/UI/Chart/ApexPieChart.vue");
  return _sfc_setup$2 ? _sfc_setup$2(props, ctx) : void 0;
};
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "ApexRadialBarChart",
  __ssrInlineRender: true,
  props: {
    id: {},
    labels: {},
    series: {},
    color: {}
  },
  setup(__props) {
    const props = __props;
    var radialChartOptions = {
      chart: {
        height: 275,
        type: "radialBar",
        toolbar: { show: false }
      },
      plotOptions: {
        radialBar: {
          offsetY: 0,
          startAngle: 0,
          endAngle: 270,
          hollow: {
            margin: 3,
            size: "20%",
            background: "transparent",
            image: void 0
          },
          dataLabels: {
            name: {
              show: false
            },
            value: {
              show: false
            }
          },
          barLabels: {
            enabled: true,
            useSeriesColors: true,
            offsetX: -8,
            fontSize: "13px",
            fontFamily: "IRANYekanX",
            formatter: function(seriesName, opts) {
              return seriesName + ":  " + opts.w.globals.series[opts.seriesIndex];
            }
          }
        }
      },
      dataLabels: { enabled: false },
      stroke: { show: true, width: 1, colors: ["transparent"] },
      colors: props.color,
      series: props.series,
      labels: props.labels,
      legend: {
        position: "bottom",
        horizontalAlign: "center",
        fontFamily: "IRANYekanX",
        offsetY: 8
      },
      fill: { opacity: 1 },
      tooltip: {
        style: {
          fontSize: "12px",
          fontFamily: "IRANYekanX"
        }
      }
    };
    let chart;
    onMounted(() => {
      chart = new ApexCharts(document.querySelector("#radial-chart-" + props.id), radialChartOptions);
      chart.render();
    });
    onUnmounted(() => {
      chart.destroy();
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({
        id: "radial-chart-" + _ctx.id
      }, _attrs))}></div>`);
    };
  }
});
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/UI/Chart/ApexRadialBarChart.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$3
  },
  __name: "ViewChart",
  __ssrInlineRender: true,
  props: {
    pageView: {},
    pageUniqueView: {},
    operationSystems: {},
    browsers: {}
  },
  setup(__props) {
    const props = __props;
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.view_statistics_chart")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$4, {
        title: _ctx.$t("messages.sentence.view_charts")
      }, null, _parent));
      _push(`<div class="row statistics"><div class="col-12 mb-4"><div class="card shadow-1"><div class="card-body"><div class="details mb-2"><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.page_view_for_last_30_days"))}</span><span class="value">${ssrInterpolate(_ctx.pageView.totalPageView)}</span></div><div class="el-chart-container"><div class="el-chart" style="${ssrRenderStyle({ "direction": "ltr", "min-width": "700px" })}">`);
      _push(ssrRenderComponent(_sfc_main$5, {
        id: 875693,
        labels: props.pageView.dates,
        color: ["#5d87ff", "#49beff"],
        datasets: {
          one: { data: _ctx.pageView.shop.views, label: props.pageView.shop.label },
          two: { data: _ctx.pageView.blog.views, label: props.pageView.blog.label }
        }
      }, null, _parent));
      _push(`</div></div></div></div></div><div class="col-12 mb-4"><div class="card shadow-1"><div class="card-body"><div class="details mb-2"><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.page_unique_view_for_last_30_days"))}</span><span class="value">${ssrInterpolate(_ctx.pageUniqueView.totalPageUniqueView)}</span></div><div class="el-chart-container"><div class="el-chart" style="${ssrRenderStyle({ "direction": "ltr", "min-width": "700px" })}">`);
      _push(ssrRenderComponent(_sfc_main$6, {
        id: 589636,
        labels: props.pageUniqueView.dates,
        datasets: {
          one: { data: _ctx.pageUniqueView.shop.views, label: props.pageView.shop.label, color: "#ffc107" },
          two: { data: _ctx.pageUniqueView.blog.views, label: props.pageView.blog.label, color: "#757ad1" }
        }
      }, null, _parent));
      _push(`</div></div></div></div></div><div class="col-lg-6 col-md-12 col-12 mb-4"><div class="card shadow-1"><div class="card-body"><div class="details mb-2"><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.users_operation_system"))}</span></div><div class="el-chart-container"><div class="el-chart" style="${ssrRenderStyle({ "direction": "ltr" })}">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        id: 236596,
        labels: props.operationSystems.labels,
        series: props.operationSystems.data,
        color: ["#5d87ff", "#ffc107", "#8f9bad", "#49beff", "#fc5b61", "#1abc9c"]
      }, null, _parent));
      _push(`</div></div></div></div></div><div class="col-lg-6 col-md-12 col-12 mb-4"><div class="card shadow-1"><div class="card-body"><div class="details mb-2"><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.users_browsers"))}</span></div><div class="el-chart-container"><div class="el-chart" style="${ssrRenderStyle({ "direction": "ltr" })}">`);
      _push(ssrRenderComponent(_sfc_main$1, {
        id: 896523,
        labels: props.browsers.labels,
        series: props.browsers.data,
        color: ["#49beff", "#ffc107", "#5d87ff", "#8f9bad", "#fc5b61", "#1abc9c"]
      }, null, _parent));
      _push(`</div></div></div></div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Statistics/ViewChart.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
