import { defineComponent, ref, watch, mergeProps, unref, withCtx, createBlock, openBlock, toDisplayString, isRef, createVNode, createTextVNode, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrRenderComponent, ssrRenderAttr, ssrInterpolate, ssrRenderStyle, ssrIncludeBooleanAttr } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./AuthLayout-DZ-VIaI_.js";
import { router, useForm, Link } from "@inertiajs/vue3";
import { _ as _sfc_main$2 } from "./NumInput-Bt6uFGO4.js";
import { u as useRandomStr } from "./useRandomStr-4MeWbtRd.js";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
import "./useHexToRgb-G7J9N7Ap.js";
/* empty css             */
const useAuthCountdown = (remaining, time, sendAgain) => {
  var countDownDate = remaining * 1e3;
  let timeFunction = () => {
    var now = (/* @__PURE__ */ new Date()).getTime();
    var distance = countDownDate - now;
    var minutes = Math.floor(distance % (1e3 * 60 * 60) / (1e3 * 60));
    var seconds = Math.floor(distance % (1e3 * 60) / 1e3);
    time.value = ("0" + minutes).slice(-2) + ":" + ("0" + seconds).slice(-2);
    if (distance < 0) {
      clearInterval(x);
      time.value = "00:00";
    }
    if (Math.floor(distance / 1e3) < 60) {
      sendAgain.value = true;
    }
  };
  timeFunction();
  var x = setInterval(timeFunction, 1e3);
};
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Verify",
  __ssrInlineRender: true,
  props: {
    phone: {},
    remaining: {},
    prev: {}
  },
  setup(__props) {
    const props = __props;
    const remainingTime = ref("");
    const sendAgain = ref(false);
    useAuthCountdown(props.remaining, remainingTime, sendAgain);
    watch(remainingTime, (value) => {
      if (value === "00:00") {
        router.get(route("login"));
      }
    });
    const sendAgainForm = useForm({
      phone: props.phone,
      prev: props.prev
    });
    let code = ref();
    const verifyForm = useForm({
      code: null,
      phone: props.phone,
      prev: props.prev
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "auth-container" }, _attrs))}><div class="logo-container">`);
      _push(ssrRenderComponent(unref(Link), {
        class: "logo",
        href: _ctx.route("index")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            if (_ctx.$page.props.appLogo != null) {
              _push2(`<img${ssrRenderAttr("src", _ctx.$page.props.appLogo)}${ssrRenderAttr("alt", _ctx.$page.props.appFullName)}${_scopeId}>`);
            } else {
              _push2(`<span${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.logo"))}</span>`);
            }
          } else {
            return [
              _ctx.$page.props.appLogo != null ? (openBlock(), createBlock("img", {
                key: 0,
                src: _ctx.$page.props.appLogo,
                alt: _ctx.$page.props.appFullName
              }, null, 8, ["src", "alt"])) : (openBlock(), createBlock("span", { key: 1 }, toDisplayString(_ctx.$t("messages.word.logo")), 1))
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div><div class="card shadow-1"><div class="card-body"><div class="auth-title lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.enter_authentication_code"))}</div><form class="d-block"><div class="timer"><span>${ssrInterpolate(remainingTime.value)}</span><input type="hidden" name="phone"${ssrRenderAttr("value", unref(sendAgainForm).phone)}${ssrIncludeBooleanAttr(unref(sendAgainForm).processing) ? " disabled" : ""}><div class="send-again"><button class="link" style="${ssrRenderStyle(sendAgain.value ? null : { display: "none" })}">${ssrInterpolate(_ctx.$t("messages.sentence.send_again"))}</button></div></div></form><form class="auth-form">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        class: "token-input mb-4 mt-3",
        placeholder: "- - - - -",
        type: "tel",
        inputmode: "numeric",
        autocomplete: "off",
        name: unref(useRandomStr)(15),
        maxlength: "5",
        modelValue: unref(code),
        "onUpdate:modelValue": ($event) => isRef(code) ? code.value = $event : code = $event,
        autofocus: ""
      }, null, _parent));
      _push(`<div class="form-element-row mb-3"><button class="btn btn-primary" type="submit"${ssrIncludeBooleanAttr(unref(verifyForm).processing) ? " disabled" : ""}>${ssrInterpolate(_ctx.$t("messages.word.continue"))}</button></div><div class="form-element-row"><div class="edit-phone lts-05">`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("login", { prev: _ctx.prev }),
        class: "link"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="ri-pencil-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.sentence.edit_phone_number"))}`);
          } else {
            return [
              createVNode("i", { class: "ri-pencil-line" }),
              createTextVNode(" " + toDisplayString(_ctx.$t("messages.sentence.edit_phone_number")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></div></form></div></div><div class="auth-footer">`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("index"),
        class: "lts-05"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.home_page"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("messages.sentence.home_page")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`<span></span>`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("main.products.index"),
        class: "lts-05"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.product_archive"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("messages.sentence.product_archive")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Auth/Verify.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
