import { defineComponent, unref, withCtx, createTextVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderStyle, ssrRenderList } from "vue/server-renderer";
import { _ as _sfc_main$2 } from "./Files-B6eiTnN6.js";
import { _ as _sfc_main$3 } from "./Pagination-C1AQrLe3.js";
import { _ as _sfc_main$1 } from "./AdminLayout-CD07IMsK.js";
import { Head, Link } from "@inertiajs/vue3";
import "toastify-js";
import "./useToastify-D_n0s7Uc.js";
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "laravel-vue-i18n";
import "./SearchList-BZnYMQPN.js";
import "lodash/debounce.js";
import "./useRandomNum-DNNSqR7b.js";
import "simplebar";
import "resize-observer-polyfill";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Usage",
  __ssrInlineRender: true,
  props: {
    discount: {},
    users: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.word.discounts")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.word.consumers"),
        item: _ctx.$t("messages.word.discounts")
      }, null, _parent));
      _push(`<div class="user-list list mb-4"><div class="card"><div class="card-body p-4"><div class="title fs-8 lts-05 mb-4">${ssrInterpolate(_ctx.$t("messages.sentence.discount_usage_list"))}: <span class="badge bg-info fs-8 ms-1">${ssrInterpolate(_ctx.discount.code)}</span></div><div class="table-responsive mb-4"><table class="table" style="${ssrRenderStyle({ "min-width": "990px" })}"><thead><tr><th>${ssrInterpolate(_ctx.$t("messages.word.name"))}</th><th>${ssrInterpolate(_ctx.$t("messages.sentence.usage_count"))}</th></tr></thead><tbody><!--[-->`);
      ssrRenderList(_ctx.users.data, (user) => {
        _push(`<tr><td>`);
        _push(ssrRenderComponent(unref(Link), {
          class: "link fw-normal",
          href: _ctx.route("admin.users.show", user.user.id)
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(user.user.name)}`);
            } else {
              return [
                createTextVNode(toDisplayString(user.user.name), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</td><td>${ssrInterpolate(user.count)}</td></tr>`);
      });
      _push(`<!--]--></tbody></table></div>`);
      if (_ctx.users.data.length == 0) {
        _push(`<div class="product-list-empty"><div class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_sfc_main$3, {
        links: _ctx.users.links
      }, null, _parent));
      _push(`</div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Financial/Discounts/Usage.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
