import { defineComponent, resolveDirective, unref, withCtx, createTextVNode, toDisplayString, createVNode, useSSRContext } from "vue";
import { ssrRenderComponent, ssrRenderStyle, ssrInterpolate, ssrRenderList, ssrRenderAttr, ssrRenderAttrs, ssrGetDirectiveProps } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./AdminLayout-CD07IMsK.js";
import { Head, Link } from "@inertiajs/vue3";
import { _ as _sfc_main$4 } from "./Pagination-C1AQrLe3.js";
import { _ as _sfc_main$3 } from "./SearchList-BZnYMQPN.js";
import { _ as _sfc_main$2 } from "./Files-B6eiTnN6.js";
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "lodash/debounce.js";
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "laravel-vue-i18n";
import "./useRandomNum-DNNSqR7b.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Trash",
  __ssrInlineRender: true,
  props: {
    products: {},
    keyword: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      const _directive_tooltip = resolveDirective("tooltip");
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.product_trash_list")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.sentence.product_trash_list")
      }, null, _parent));
      _push(`<div class="product-list list mb-4"><div class="card"><div class="card-body">`);
      _push(ssrRenderComponent(_sfc_main$3, {
        keyword: _ctx.keyword,
        placeholder: _ctx.$t("messages.sentence.product_title") + " ..."
      }, null, _parent));
      _push(`<div class="table-responsive mb-4"><table class="table" style="${ssrRenderStyle({ "min-width": "900px" })}"><thead><tr><th class="first-small">${ssrInterpolate(_ctx.$t("messages.word.image"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.title"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.view"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.by"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.status"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.last_update"))}</th><th class="first-small"><i class="ri-settings-4-line"></i></th></tr></thead><tbody><!--[-->`);
      ssrRenderList(_ctx.products.data, (product) => {
        _push(`<tr><td><img class="br-10" width="35" height="35"${ssrRenderAttr("src", product.get_images[0]["link"])}${ssrRenderAttr("alt", product.get_images[0]["alt"])}></td><td${ssrRenderAttrs(ssrGetDirectiveProps(_ctx, _directive_tooltip, product.is_vip ? _ctx.$t("messages.sentence.vip_product") : null, void 0, { bottom: true }))}>${ssrInterpolate(product.title)} `);
        if (product.is_vip) {
          _push(`<i class="ri-star-s-fill vip-product"></i>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</td><td>${ssrInterpolate(product.get_formatted_view_count)}</td><td>`);
        if (product.user.type == "owner" || product.user.type == "admin") {
          _push(ssrRenderComponent(unref(Link), {
            class: "link fs-8 fw-normal",
            href: _ctx.route("admin.users.show", product.user_id)
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(product.user.get_name)}`);
              } else {
                return [
                  createTextVNode(toDisplayString(product.user.get_name), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
        } else if (product.user.seller) {
          _push(ssrRenderComponent(unref(Link), {
            class: "link fs-8 fw-normal",
            href: _ctx.route("admin.stores.show", product.user.store.uuid)
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(product.user.store.name)}`);
              } else {
                return [
                  createTextVNode(toDisplayString(product.user.store.name), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
        } else {
          _push(`<!---->`);
        }
        _push(`</td><td class="lts-05"><span class="badge bg-danger">${ssrInterpolate(_ctx.$t("messages.word.deleted"))}</span></td><td>${ssrInterpolate(product.jalali_updated_at[2])}</td><td class="dropdown"><i class="ri-more-2-fill" data-bs-toggle="dropdown"></i><div class="dropdown-menu shadow-smooth-2"><ul><li>`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("admin.products.destroy", product.slug),
          method: "delete",
          as: "button",
          data: { status: "publish" },
          class: "dropdown-item no-btn"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<i class="ri-spam-3-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.word.publish"))}`);
            } else {
              return [
                createVNode("i", { class: "ri-spam-3-line" }),
                createTextVNode(" " + toDisplayString(_ctx.$t("messages.word.publish")), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</li><li><a href="javascript:void(0)" data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#remove-product-" + product.id)} class="dropdown-item no-btn"><i class="ri-delete-bin-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.permanent_delete"))}</a></li></ul></div><div class="modal fade"${ssrRenderAttr("id", "remove-product-" + product.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.are_you_sure_delete_product"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-footer">`);
        _push(ssrRenderComponent(unref(Link), {
          as: "button",
          href: _ctx.route("admin.products.destroy", product.slug),
          method: "delete",
          data: { status: "deep_deleted" },
          class: "btn btn-sm btn-danger px-3",
          "data-bs-dismiss": "modal",
          "aria-label": "Close"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("messages.word.delete"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("messages.word.delete")), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</div></form></div></div></div></td></tr>`);
      });
      _push(`<!--]--></tbody></table></div>`);
      if (_ctx.products.data.length == 0) {
        _push(`<div class="product-list-empty"><div class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_sfc_main$4, {
        links: _ctx.products.links
      }, null, _parent));
      _push(`</div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Products/Products/Trash.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
