import { defineComponent, unref, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderStyle, ssrRenderList, ssrRenderAttr } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./AdminLayout-CD07IMsK.js";
import { Head } from "@inertiajs/vue3";
import { _ as _sfc_main$3 } from "./Pagination-C1AQrLe3.js";
import { _ as _sfc_main$2 } from "./Files-B6eiTnN6.js";
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "laravel-vue-i18n";
import "./SearchList-BZnYMQPN.js";
import "lodash/debounce.js";
import "./useRandomNum-DNNSqR7b.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "TrackingView",
  __ssrInlineRender: true,
  props: {
    statistics: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.view_statistics")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.sentence.tracking_view")
      }, null, _parent));
      _push(`<div class="user-list list mb-4"><div class="card"><div class="card-body"><span class="d-inline-flex alert alert-light lts-05 fs-8 mb-3">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_145856"))}</span><div class="table-responsive mb-4"><table class="table" style="${ssrRenderStyle({ "min-width": "900px" })}"><thead><tr><th>${ssrInterpolate(_ctx.$t("messages.word.url"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.user"))}</th><th>IP</th><th>${ssrInterpolate(_ctx.$t("messages.word.platform"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.section"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.operation_system"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.browser"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.date"))}</th></tr></thead><tbody><!--[-->`);
      ssrRenderList(_ctx.statistics.data, (statistic) => {
        _push(`<tr><td><a${ssrRenderAttr("href", _ctx.$page.props.appUrl + statistic.url)} class="link text-info fw-bold fs-8 lts-05" target="_blank">${ssrInterpolate(_ctx.$t("messages.sentence.viewed_link"))} <i class="ri-external-link-line fw-normal fs-8 ms-1"></i></a></td><td>`);
        if (statistic.get_user.type == "user") {
          _push(`<a${ssrRenderAttr("href", _ctx.route("admin.users.show", statistic.get_user.id))} class="link fw-normal lts-05">${ssrInterpolate(statistic.get_user.name)}</a>`);
        } else {
          _push(`<span>${ssrInterpolate(statistic.get_user.name)}</span>`);
        }
        _push(`</td><td>${ssrInterpolate(statistic.ip)}</td><td>${ssrInterpolate(statistic.get_platform)}</td><td class="lts-05">${ssrInterpolate(statistic.get_service)}</td><td>${ssrInterpolate(statistic.os)}</td><td>${ssrInterpolate(statistic.browser)}</td><td>${ssrInterpolate(statistic.jalali_created_at[2])}</td></tr>`);
      });
      _push(`<!--]--></tbody></table></div>`);
      if (_ctx.statistics.data.length == 0) {
        _push(`<div class="product-list-empty"><div class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_sfc_main$3, {
        links: _ctx.statistics.links
      }, null, _parent));
      _push(`</div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Statistics/TrackingView.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
