import { defineComponent, unref, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderList } from "vue/server-renderer";
/* empty css             */
import { Head } from "@inertiajs/vue3";
import { u as useNumberFormat, _ as _export_sfc } from "../ssr.js";
import "@vue/server-renderer";
import "@inertiajs/vue3/server";
import "ziggy-js";
import "laravel-vue-i18n";
import "axios";
import "lodash/debounce.js";
import "swiper/bundle";
import "jquery";
import "swiper";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "ThermalSalesFactor",
  __ssrInlineRender: true,
  props: {
    store: {},
    order: {},
    consignmentItems: {},
    user_national_number: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: "فاکتور حرارتی - " + _ctx.order.uuid
      }, null, _parent));
      _push(`<div class="thermal-container px-3" data-v-02597d8b><div class="center bold fs-14 mt-4" data-v-02597d8b>فاکتور فروش</div><div class="center fs-10 mt-2" data-v-02597d8b>${ssrInterpolate(_ctx.$page.props.appFullName)}</div><div class="divider" data-v-02597d8b></div><div class="fs-10" data-v-02597d8b><div class="mb-1" data-v-02597d8b>فروشنده: ${ssrInterpolate(_ctx.store.name)}</div><div class="mb-1" data-v-02597d8b>تاریخ: ${ssrInterpolate(_ctx.order.jalali_created_at[1])}</div><div class="mb-1" data-v-02597d8b>کد سفارش: ${ssrInterpolate(_ctx.order.uuid)}</div></div><div class="divider" data-v-02597d8b></div><div class="bold fs-12 mb-1" data-v-02597d8b>مشخصات خریدار</div><div class="fs-10" data-v-02597d8b><div data-v-02597d8b>نام: ${ssrInterpolate(_ctx.order.user.get_name)}</div>`);
      if (_ctx.user_national_number != null) {
        _push(`<div data-v-02597d8b>کد ملی: ${ssrInterpolate(_ctx.user_national_number)}</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div data-v-02597d8b>شهر: ${ssrInterpolate(_ctx.order.get_address.address.city)}</div><div data-v-02597d8b>آدرس: ${ssrInterpolate(_ctx.order.get_address.address.full_address)}</div></div><div class="divider" data-v-02597d8b></div><div class="bold fs-12 mb-1" data-v-02597d8b>اقلام سفارش</div><!--[-->`);
      ssrRenderList(_ctx.consignmentItems, (item) => {
        _push(`<div class="item-row fs-10" data-v-02597d8b><div class="title" data-v-02597d8b>${ssrInterpolate(item.product ? item.product.title : item.title)}</div>`);
        if (item.get_props.length) {
          _push(`<div class="props" data-v-02597d8b><!--[-->`);
          ssrRenderList(item.get_props, (p) => {
            _push(`<span data-v-02597d8b>${ssrInterpolate(p.name)}: `);
            if (p.type === "color") {
              _push(`<span class="d-inline-block" data-v-02597d8b>${ssrInterpolate(p.value.label)}</span>`);
            } else {
              _push(`<span class="d-inline-block" data-v-02597d8b>${ssrInterpolate(p.value)}</span>`);
            }
            _push(`</span>`);
          });
          _push(`<!--]--></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="flex-between mt-1" data-v-02597d8b><span data-v-02597d8b>تعداد: ${ssrInterpolate(item.count)}</span><span data-v-02597d8b>قیمت واحد: ${ssrInterpolate(unref(useNumberFormat)(item.price + item.discount))} تومان</span></div><div class="flex-between" data-v-02597d8b><span data-v-02597d8b>تخفیف: ${ssrInterpolate(unref(useNumberFormat)(item.discount * item.count))}</span><span data-v-02597d8b>مبلغ نهایی: ${ssrInterpolate(unref(useNumberFormat)(item.price * item.count))}</span></div><div class="thin-divider" data-v-02597d8b></div></div>`);
      });
      _push(`<!--]--><div class="fs-12 bold mt-2" data-v-02597d8b><div class="flex-between" data-v-02597d8b><span data-v-02597d8b>جمع کل:</span><span data-v-02597d8b>${ssrInterpolate(unref(useNumberFormat)(_ctx.order.get_total_bill.awaiting.price))} تومان</span></div></div><div class="divider" data-v-02597d8b></div><div class="center fs-10 mt-2" data-v-02597d8b>با تشکر از خرید شما</div><button class="print-btn" data-v-02597d8b>چاپ</button></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Store/Orders/ThermalSalesFactor.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const ThermalSalesFactor = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-02597d8b"]]);
export {
  ThermalSalesFactor as default
};
