import { defineComponent, unref, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderList } from "vue/server-renderer";
/* empty css             */
import { Head } from "@inertiajs/vue3";
import { u as useNumberFormat, _ as _export_sfc } from "../ssr.js";
import "@vue/server-renderer";
import "@inertiajs/vue3/server";
import "ziggy-js";
import "laravel-vue-i18n";
import "axios";
import "lodash/debounce.js";
import "swiper/bundle";
import "jquery";
import "swiper";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "ThermalSalesFactor",
  __ssrInlineRender: true,
  props: {
    order: {},
    consignmentItems: {},
    user_national_number: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: "فاکتور حرارتی - " + _ctx.order.uuid
      }, null, _parent));
      _push(`<div class="thermal-container px-3" data-v-71e0646f><div class="center bold fs-14 mt-4" data-v-71e0646f>فاکتور فروش</div><div class="center fs-10 mt-2" data-v-71e0646f>${ssrInterpolate(_ctx.$page.props.appFullName)}</div><div class="divider" data-v-71e0646f></div><div class="fs-10" data-v-71e0646f><div data-v-71e0646f>تاریخ: ${ssrInterpolate(_ctx.order.jalali_created_at[1])}</div><div data-v-71e0646f>کد سفارش: ${ssrInterpolate(_ctx.order.uuid)}</div></div><div class="divider" data-v-71e0646f></div><div class="bold fs-12 mb-1" data-v-71e0646f>مشخصات خریدار</div><div class="fs-10" data-v-71e0646f><div data-v-71e0646f>نام: ${ssrInterpolate(_ctx.order.user.get_name)}</div>`);
      if (_ctx.user_national_number != null) {
        _push(`<div data-v-71e0646f>کد ملی: ${ssrInterpolate(_ctx.user_national_number)}</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div data-v-71e0646f>شهر: ${ssrInterpolate(_ctx.order.get_address.address.city)}</div><div data-v-71e0646f>آدرس: ${ssrInterpolate(_ctx.order.get_address.address.full_address)}</div></div><div class="divider" data-v-71e0646f></div><div class="bold fs-12 mb-1" data-v-71e0646f>اقلام سفارش</div><!--[-->`);
      ssrRenderList(_ctx.consignmentItems, (item) => {
        _push(`<div class="item-row fs-10" data-v-71e0646f><div class="title" data-v-71e0646f>${ssrInterpolate(item.product ? item.product.title : item.title)}</div>`);
        if (item.get_props.length) {
          _push(`<div class="props" data-v-71e0646f><!--[-->`);
          ssrRenderList(item.get_props, (p) => {
            _push(`<span data-v-71e0646f>${ssrInterpolate(p.name)}: `);
            if (p.type === "color") {
              _push(`<span class="d-inline-block" data-v-71e0646f>${ssrInterpolate(p.value.label)}</span>`);
            } else {
              _push(`<span class="d-inline-block" data-v-71e0646f>${ssrInterpolate(p.value)}</span>`);
            }
            _push(`</span>`);
          });
          _push(`<!--]--></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="flex-between mt-1" data-v-71e0646f><span data-v-71e0646f>تعداد: ${ssrInterpolate(item.count)}</span><span data-v-71e0646f>قیمت واحد: ${ssrInterpolate(unref(useNumberFormat)(item.price + item.discount))} تومان</span></div><div class="flex-between" data-v-71e0646f><span data-v-71e0646f>تخفیف: ${ssrInterpolate(unref(useNumberFormat)(item.discount * item.count))}</span><span data-v-71e0646f>مبلغ نهایی: ${ssrInterpolate(unref(useNumberFormat)(item.price * item.count))}</span></div><div class="thin-divider" data-v-71e0646f></div></div>`);
      });
      _push(`<!--]--><div class="fs-12 bold mt-2" data-v-71e0646f><div class="flex-between" data-v-71e0646f><span data-v-71e0646f>جمع کل:</span><span data-v-71e0646f>${ssrInterpolate(unref(useNumberFormat)(_ctx.order.get_total_bill.awaiting.price))} تومان</span></div></div><div class="divider" data-v-71e0646f></div><div class="center fs-10 mt-2" data-v-71e0646f>با تشکر از خرید شما</div><button class="print-btn" data-v-71e0646f>چاپ</button></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Orders/ThermalSalesFactor.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const ThermalSalesFactor = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-71e0646f"]]);
export {
  ThermalSalesFactor as default
};
