import { defineComponent, useModel, onMounted, mergeProps, unref, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrGetDynamicModelProps } from "vue/server-renderer";
import Tagify from "@yaireo/tagify";
import { u as useRandomStr } from "./useRandomStr-4MeWbtRd.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "Tagify",
  __ssrInlineRender: true,
  props: {
    "modelValue": { required: true },
    "modelModifiers": {}
  },
  emits: ["update:modelValue"],
  setup(__props) {
    const model = useModel(__props, "modelValue");
    let random_id = useRandomStr(10);
    onMounted(() => {
      if (typeof window !== "undefined") {
        document.querySelectorAll(".tags-" + random_id).forEach((elem) => {
          new Tagify(elem);
        });
      }
    });
    return (_ctx, _push, _parent, _attrs) => {
      let _temp0;
      _push(`<input${ssrRenderAttrs((_temp0 = mergeProps({
        value: model.value,
        type: "text",
        placeholder: _ctx.$t("messages.sentence.type_and_inter"),
        class: "form-control tags-" + unref(random_id),
        name: "tags"
      }, _attrs), mergeProps(_temp0, ssrGetDynamicModelProps(_temp0, model.value))))}>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Common/Tagify.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as _
};
