import { defineComponent, onMounted, onUnmounted, mergeProps, useSSRContext } from "vue";
import { ssrRenderAttrs } from "vue/server-renderer";
import ApexCharts from "apexcharts";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "SingleTopChart",
  __ssrInlineRender: true,
  props: {
    id: {},
    size: {},
    color: {},
    type: {}
  },
  setup(__props) {
    const props = __props;
    let SBarOptions = {
      chart: {
        type: "bar",
        height: props.size.height,
        width: props.size.width,
        sparkline: {
          enabled: true
        }
      },
      plotOptions: {
        bar: {
          borderRadius: 2,
          columnWidth: "60%"
        }
      },
      series: [
        {
          name: "",
          data: [36, 77, 52, 90, 74, 35, 55, 23, 47, 35, 55]
        }
      ],
      xaxis: {
        type: "text",
        categories: ["1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11"]
      },
      tooltip: {
        enabled: false
      },
      colors: props.color
    };
    let SLineOptions = {
      chart: {
        type: "line",
        height: props.size.height,
        width: props.size.width,
        sparkline: {
          enabled: true
        }
      },
      series: [
        {
          name: "",
          data: [3844, 3855, 3841, 3867, 3822, 3843, 3821, 3841, 3856, 3843, 3821, 3841, 3856]
        }
      ],
      xaxis: {
        type: "text",
        categories: ["1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13"]
      },
      stroke: {
        width: 3,
        curve: "smooth"
      },
      markers: {
        size: 0
      },
      tooltip: {
        enabled: false
      },
      colors: props.color
    };
    let SPieOptions = {
      series: [60, 25, 15],
      labels: ["", "", ""],
      chart: {
        height: props.size.height,
        width: props.size.width,
        type: "donut",
        fontFamily: "IRANYekanX",
        foreColor: "#c6d1e9"
      },
      plotOptions: {
        pie: {
          donut: {
            size: "65%",
            background: "none",
            labels: {
              show: false
            }
          }
        }
      },
      tooltip: {
        enabled: false
      },
      markers: {
        size: 0
      },
      dataLabels: {
        enabled: false
      },
      legend: {
        show: false
      },
      stroke: {
        show: false
      },
      colors: props.color
    };
    let SSqureChart = {
      series: [
        {
          name: "",
          data: [25, 35, 20, 25, 40, 25, 32, 28]
        },
        {
          name: "",
          data: [35, 40, 20, 35, 40, 35, 30, 40]
        },
        {
          name: "",
          data: [40, 25, 60, 40, 20, 40, 38, 32]
        }
      ],
      chart: {
        type: "bar",
        height: props.size.height,
        width: props.size.width,
        stacked: true,
        stackType: "100%",
        fontFamily: "IRANYekanX",
        toolbar: {
          show: false
        },
        sparkline: {
          enabled: true
        }
      },
      colors: props.color,
      grid: {
        show: false
      },
      plotOptions: {
        bar: {
          horizontal: false,
          columnWidth: "55%",
          borderRadius: [4],
          borderRadiusApplication: "around",
          borderRadiusWhenStacked: "around"
        }
      },
      dataLabels: {
        enabled: false
      },
      stroke: {
        show: false,
        width: 1,
        colors: ["rgba(0,0,0,0.01)"]
      },
      xaxis: {
        axisBorder: {
          show: false
        },
        axisTicks: {
          show: false
        },
        labels: {
          show: false
        }
      },
      yaxis: {
        labels: {
          show: false
        }
      },
      axisBorder: {
        show: false
      },
      fill: {
        opacity: 1
      },
      tooltip: {
        theme: "dark",
        x: {
          show: false
        }
      }
    };
    let SAreaOptions = {
      series: [
        {
          name: "",
          data: [31, 40, 28, 51, 42, 109, 100]
        }
      ],
      chart: {
        height: props.size.height,
        //width: props.size.width,
        type: "area",
        fontFamily: "IRANYekanX",
        toolbar: {
          show: false
        },
        sparkline: {
          enabled: true
        }
      },
      colors: props.color,
      plotOptions: {
        pie: {
          donut: {
            size: "65%",
            background: "none",
            labels: {
              show: false
            }
          }
        }
      },
      tooltip: {
        enabled: false
      },
      markers: {
        size: 0
      },
      dataLabels: {
        enabled: false
      },
      legend: {
        show: false
      },
      stroke: {
        show: false
        //curve: "smooth",
      }
    };
    let chart;
    onMounted(() => {
      let chartType = SBarOptions;
      switch (props.type) {
        case "bar":
          chartType = SBarOptions;
          break;
        case "line":
          chartType = SLineOptions;
          break;
        case "pie":
          chartType = SPieOptions;
          break;
        case "squre":
          chartType = SSqureChart;
          break;
        case "area":
          chartType = SAreaOptions;
          break;
      }
      chart = new ApexCharts(document.querySelector("#top-chart-" + props.id), chartType);
      chart.render();
    });
    onUnmounted(() => {
      chart.destroy();
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({
        id: "top-chart-" + _ctx.id,
        class: { "apexchart-54856": _ctx.type == "pie" }
      }, _attrs))}></div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/UI/Chart/SingleTopChart.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as _
};
