import { defineComponent, ref, resolveDirective, unref, withCtx, createVNode, createBlock, createCommentVNode, createTextVNode, openBlock, toDisplayString, mergeProps, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrIncludeBooleanAttr, ssrLooseEqual, ssrRenderClass, ssrRenderAttr, ssrRenderStyle, ssrRenderList, ssrRenderAttrs, ssrGetDirectiveProps } from "vue/server-renderer";
import { _ as _sfc_main$1, a as _sfc_main$2 } from "./StoreLayout-D2_RagXW.js";
import { useForm, Head, Link } from "@inertiajs/vue3";
import { _ as _sfc_main$3 } from "./SearchList-BZnYMQPN.js";
import { _ as _sfc_main$5 } from "./Pagination-C1AQrLe3.js";
import { _ as _sfc_main$4 } from "./FilterList-CWxGcEKk.js";
import "laravel-vue-i18n";
import "toastify-js";
import "./useToastify-D_n0s7Uc.js";
import Dropdown from "primevue/dropdown/dropdown.esm.js";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "jquery";
import "simplebar";
import "resize-observer-polyfill";
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "./useRandomNum-DNNSqR7b.js";
import "bootstrap";
import "./useNl2br-BIw8h5gy.js";
import "lodash/debounce.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Show",
  __ssrInlineRender: true,
  props: {
    storage: {},
    products: {},
    categories: {},
    brands: {},
    keyword: {}
  },
  setup(__props) {
    const props = __props;
    const exportType = ref("all");
    const category = ref("all");
    const brand = ref("all");
    const categoriesList = ref([]);
    categoriesList.value.push({ id: "all", title: "همه دسته‌بندی ها" });
    for (let category2 in props.categories) {
      categoriesList.value.push(props.categories[category2]);
    }
    const brandsList = ref([]);
    brandsList.value.push({ id: "all", title: "همه برند ها" });
    for (let brand2 in props.brands) {
      brandsList.value.push(props.brands[brand2]);
    }
    const selectedFileName = ref(null);
    useForm({
      file: null
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _directive_tooltip = resolveDirective("tooltip");
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.show_storage", { storage: _ctx.storage.name })
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.sentence.show_storage", { storage: _ctx.storage.name }),
        item: _ctx.$t("messages.word.storages")
      }, null, _parent));
      _push(`<div class="product-list list mb-4"><div class="card"><div class="card-body"><div class="d-flex w-100 align-items-center justify-content-end mb-4"><button data-bs-toggle="modal" data-bs-target="#importStorage" type="button" class="btn btn-light fs-8 fw-bold me-2">${ssrInterpolate(_ctx.$t("messages.sentence.import_excel"))} <i class="ri-file-excel-2-line ms-2 fw-light fs-6"></i></button><div class="modal fade" id="importStorage" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.storage_excel_import"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row upload-file-container"><div class="col-12 mb-4"><p class="lts-05 text-dark lh-25">${_ctx.$t("messages.sentence.msg_id_105510") ?? ""}</p><p class="lts-05 text-dark lh-25">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_550014"))}</p></div><div class="col-12 mb-3"><div class="form-element-row-file"><div class="custom-input-file">`);
      if (!selectedFileName.value) {
        _push(`<!--[--><label for="uploadFile" class="custom-input-file-label"><span class="label"><i class="ri-arrow-up-fill me-1"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.select_file"))}</span></label><input type="file" class="custom-input-file-input" id="uploadFile" accept=".xlsx"><!--]-->`);
      } else {
        _push(`<div class="selected-file-name"><i class="ri-file-excel-2-line me-1"></i> ${ssrInterpolate(selectedFileName.value)} <button type="button" class="btn btn-sm btn-link link text-danger ms-2">${ssrInterpolate(_ctx.$t("messages.word.delete"))}</button></div>`);
      }
      _push(`</div></div></div></div></div><div class="modal-footer"><button class="btn btn-success">${ssrInterpolate(_ctx.$t("messages.word.apply"))}</button></div></form></div></div></div><button data-bs-toggle="modal" data-bs-target="#exportStorage" type="button" class="btn btn-light fs-8 fw-bold">${ssrInterpolate(_ctx.$t("messages.sentence.export_excel"))} <i class="ri-file-excel-2-line ms-2 fw-light fs-6"></i></button><div class="modal fade" id="exportStorage" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.storage_excel_export"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12 mb-4"><span class="lts-05 text-gray">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_888965"))}</span></div><div class="col-12 mb-3"><span class="lts-05 text-dark fw-bold">${ssrInterpolate(_ctx.$t("messages.word.inventory"))}:</span></div><div class="col-lg-4 col-12 mb-4"><label for="eaAll" class="form-label d-flex align-items-center white-space-nowrap clickable"><input${ssrIncludeBooleanAttr(ssrLooseEqual(exportType.value, "all")) ? " checked" : ""} type="radio" value="all" class="form-check-box clickable me-1" id="eaAll"> ${ssrInterpolate(_ctx.$t("messages.sentence.all_products"))}</label></div><div class="col-lg-4 col-12 mb-4"><label for="eaInstock" class="form-label d-flex align-items-center white-space-nowrap clickable"><input${ssrIncludeBooleanAttr(ssrLooseEqual(exportType.value, "instock")) ? " checked" : ""} type="radio" value="instock" class="form-check-box clickable me-1" id="eaInstock"> ${ssrInterpolate(_ctx.$t("messages.sentence.just_instock_products"))}</label></div><div class="col-lg-4 col-12 mb-4"><label for="eaOutofstock" class="form-label d-flex align-items-center white-space-nowrap clickable"><input${ssrIncludeBooleanAttr(ssrLooseEqual(exportType.value, "outofstock")) ? " checked" : ""} type="radio" value="outofstock" class="form-check-box clickable me-1" id="eaOutofstock"> ${ssrInterpolate(_ctx.$t("messages.sentence.just_outofstock_products"))}</label></div><div class="col-12 mb-2"><span class="lts-05 text-dark fw-bold">${ssrInterpolate(_ctx.$t("messages.sentence.category_filter"))}:</span></div><div class="col-12 mb-4">`);
      _push(ssrRenderComponent(unref(Dropdown), {
        class: "pvc-multiselect pvc-multiselect-filter",
        modelValue: category.value,
        "onUpdate:modelValue": ($event) => category.value = $event,
        options: categoriesList.value,
        filter: "",
        emptyFilterMessage: _ctx.$t("messages.sentence.no_items_found"),
        display: "chip",
        optionLabel: "title",
        optionValue: "id",
        appendTo: "#exportStorage",
        placeholder: _ctx.$t("messages.sentence.select_category")
      }, {
        option: withCtx((slotProps, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="category-template flex align-items-center"${_scopeId}><div class="${ssrRenderClass({
              "category-level-one": slotProps.option.level == "one",
              "category-level-two": slotProps.option.level == "two",
              "category-level-three": slotProps.option.level == "three"
            })}"${_scopeId}>`);
            if (slotProps.option.level == "three") {
              _push2(`<span${_scopeId}><i class="ri-arrow-drop-left-line"${_scopeId}></i></span>`);
            } else if (slotProps.option.level == "two") {
              _push2(`<span${_scopeId}><i class="circle-icon ri-circle-fill"${_scopeId}></i></span>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(` ${ssrInterpolate(slotProps.option.title)}</div></div>`);
          } else {
            return [
              createVNode("div", { class: "category-template flex align-items-center" }, [
                createVNode("div", {
                  class: {
                    "category-level-one": slotProps.option.level == "one",
                    "category-level-two": slotProps.option.level == "two",
                    "category-level-three": slotProps.option.level == "three"
                  }
                }, [
                  slotProps.option.level == "three" ? (openBlock(), createBlock("span", { key: 0 }, [
                    createVNode("i", { class: "ri-arrow-drop-left-line" })
                  ])) : slotProps.option.level == "two" ? (openBlock(), createBlock("span", { key: 1 }, [
                    createVNode("i", { class: "circle-icon ri-circle-fill" })
                  ])) : createCommentVNode("", true),
                  createTextVNode(" " + toDisplayString(slotProps.option.title), 1)
                ], 2)
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div><div class="col-12 mb-2"><span class="lts-05 text-dark fw-bold">${ssrInterpolate(_ctx.$t("messages.sentence.brand_filter"))}:</span></div><div class="col-12 mb-3">`);
      _push(ssrRenderComponent(unref(Dropdown), {
        class: "pvc-dropdown",
        modelValue: brand.value,
        "onUpdate:modelValue": ($event) => brand.value = $event,
        options: brandsList.value,
        display: "chip",
        optionLabel: "title",
        optionValue: "id",
        filter: "",
        appendTo: "#exportStorage",
        placeholder: _ctx.$t("messages.sentence.select_brand")
      }, null, _parent));
      _push(`</div></div></div><div class="modal-footer"><a${ssrRenderAttr("href", _ctx.route("seller.storages.export", { storage: _ctx.storage.uuid, type: exportType.value, category: category.value, brand: brand.value }))} class="btn btn-sm btn-primary px-3">${ssrInterpolate(_ctx.$t("messages.word.download"))}</a></div></div></div></div></div>`);
      _push(ssrRenderComponent(_sfc_main$3, {
        keyword: _ctx.keyword,
        routeParam: _ctx.storage.uuid,
        placeholder: _ctx.$t("messages.sentence.product_title") + " ..."
      }, null, _parent));
      _push(ssrRenderComponent(_sfc_main$4, {
        routeParam: { storage: _ctx.storage.uuid },
        filters: {
          publish: _ctx.$t("messages.word.published"),
          awaiting: _ctx.$t("messages.sentence.awaiting_verify"),
          draft: _ctx.$t("messages.word.draft"),
          hasPrice: _ctx.$t("messages.sentence.with_inventory"),
          outofstock: _ctx.$t("messages.word.outofstock")
        }
      }, null, _parent));
      _push(`<div class="d-block w-100 mb-3"><span class="fs-8 lts-05 text-gray">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_855523"))}</span></div><div class="table-responsive mb-4"><table class="table" style="${ssrRenderStyle({ "min-width": "900px" })}"><thead><tr><th class="first-small">${ssrInterpolate(_ctx.$t("messages.word.image"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.title"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.inventories"))}</th><th class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.variety_and_quantity_of_inventory"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.by"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.status"))}</th><th class="first-small"><i class="ri-settings-4-line"></i></th></tr></thead><tbody><!--[-->`);
      ssrRenderList(_ctx.products.data, (product) => {
        _push(`<tr><td><img class="br-10" width="35" height="35"${ssrRenderAttr("src", product.get_images[0]["link"])}${ssrRenderAttr("alt", product.get_images[0]["alt"])}></td><td${ssrRenderAttrs(ssrGetDirectiveProps(_ctx, _directive_tooltip, product.is_vip ? _ctx.$t("messages.sentence.vip_product") : null, void 0, { bottom: true }))}><a class="product-title"${ssrRenderAttr("href", _ctx.route("main.products.show", product.slug))} target="_blank">${ssrInterpolate(product.title)}</a>`);
        if (product.is_vip) {
          _push(`<i class="ri-star-s-fill vip-product"></i>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</td><td>`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("seller.storages.storageList", { storage: _ctx.storage.uuid, product: product.slug }),
          class: "link active-link lts-05"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`مدیریت موجودی`);
            } else {
              return [
                createTextVNode("مدیریت موجودی")
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</td><td class="fs-8 lts-05 white-space-nowrap"><span class="text-gray">تنوع: </span> <span class="fw-bold">${ssrInterpolate(product.inventory_in_storage)}</span><span class="mx-2">-</span><span class="text-gray">تعداد: </span> <span class="fw-bold">${ssrInterpolate(product.inventory_count_in_storage)}</span></td><td>`);
        if (product.user.type == "owner" || product.user.type == "admin") {
          _push(`<a class="link fs-8 fw-normal">${ssrInterpolate(product.user.get_name)}</a>`);
        } else if (product.user.seller) {
          _push(`<a class="link fs-8 fw-normal">${ssrInterpolate(product.user.store.name)}</a>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</td><td class="lts-05">`);
        if (product.status == "publish") {
          _push(`<span class="badge bg-success">${ssrInterpolate(_ctx.$t("messages.word.published"))}</span>`);
        } else if (product.status == "draft") {
          _push(`<span class="badge bg-warning">${ssrInterpolate(_ctx.$t("messages.word.draft"))}</span>`);
        } else if (product.status == "awaiting") {
          _push(`<span class="badge bg-info">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_verify"))}</span>`);
        } else if (product.status == "rejected") {
          _push(`<span class="badge bg-danger">${ssrInterpolate(_ctx.$t("messages.word.rejected"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        if (product.inventory_status.inquery) {
          _push(`<span class="badge bg-purple ms-1">${ssrInterpolate(_ctx.$t("messages.sentence.inventory_inquiry"))}</span>`);
        } else {
          _push(`<!--[-->`);
          if (!product.inventory_status.inventory) {
            _push(`<span${ssrRenderAttrs(mergeProps({ class: "badge bg-warning ms-1" }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.sentence.no_inventory_variation_recorded"), void 0, { top: true })))}>${ssrInterpolate(_ctx.$t("messages.sentence.no_inventory"))}</span>`);
          } else {
            _push(`<!---->`);
          }
          if (product.inventory_status.inventory && !product.inventory_status.instock) {
            _push(`<span${ssrRenderAttrs(mergeProps({ class: "badge bg-danger ms-1" }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.sentence.inventory_count_is_zero"), void 0, { top: true })))}>${ssrInterpolate(_ctx.$t("messages.word.outofstock"))}</span>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<!--]-->`);
        }
        _push(`</td><td class="dropdown"><i class="ri-more-2-fill" data-bs-toggle="dropdown"></i><div class="dropdown-menu shadow-smooth-2"><ul>`);
        if (product.status == "publish") {
          _push(`<li><a class="dropdown-item lts-05" target="_blank"${ssrRenderAttr("href", _ctx.route("main.products.show", product.slug))}><i class="ri-eye-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.show_product"))}</a></li>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</ul></div></td></tr>`);
      });
      _push(`<!--]--></tbody></table></div>`);
      if (_ctx.products.data.length == 0) {
        _push(`<div class="product-list-empty"><div class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_sfc_main$5, {
        links: _ctx.products.links
      }, null, _parent));
      _push(`</div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Store/Storage/Show.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
