import { defineComponent, ref, unref, useSSRContext } from "vue";
import { ssrRenderComponent, ssrRenderAttr, ssrInterpolate, ssrRenderStyle, ssrRenderList, ssrIncludeBooleanAttr, ssrRenderClass } from "vue/server-renderer";
import { _ as _sfc_main$1, a as _sfc_main$2 } from "./StoreLayout-D2_RagXW.js";
import { useForm, Head } from "@inertiajs/vue3";
import NeshanMap from "@neshan-maps-platform/vue3-openlayers";
import { u as useNumberFormat } from "../ssr.js";
import { u as useNl2br } from "./useNl2br-BIw8h5gy.js";
import { _ as _sfc_main$3 } from "./NumInput-Bt6uFGO4.js";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "jquery";
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
import "./Pagination-C1AQrLe3.js";
import "./SearchList-BZnYMQPN.js";
import "lodash/debounce.js";
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "./useRandomNum-DNNSqR7b.js";
import "bootstrap";
import "@vue/server-renderer";
import "@inertiajs/vue3/server";
import "ziggy-js";
import "laravel-vue-i18n";
import "axios";
import "swiper/bundle";
import "swiper";
import "./useRandomStr-4MeWbtRd.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Show",
  __ssrInlineRender: true,
  props: {
    consignment: {},
    payment_transaction: {},
    is_pay_with_wallet: { type: Boolean },
    is_snapppay: { type: Boolean },
    is_digipay_upg: { type: Boolean },
    is_azki: { type: Boolean },
    keyword: {}
  },
  setup(__props) {
    const props = __props;
    const Map = ref();
    const mapResult = props.consignment.send_type == "direct" ? props.consignment.get_address["address"]["get_map"] : props.consignment.get_address.location;
    setTimeout(() => {
      var _a;
      (_a = Map.value) == null ? void 0 : _a.reverse([mapResult.longitude, mapResult.latitude], {
        useMarker: true
      });
    }, 1500);
    setTimeout(() => {
      var _a;
      (_a = Map.value) == null ? void 0 : _a.reverse([mapResult.longitude, mapResult.latitude], {
        useMarker: true
      });
    }, 2e3);
    const cancelProductForm = useForm({
      reason: null
    });
    const cancelProductCountForm = useForm({
      count: null
    });
    const changeOrderStatusForm = useForm({
      status: "",
      tracking_code: null,
      reason: null
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.order_details", { order: _ctx.consignment.uuid })
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.sentence.order_details"),
        item: _ctx.$t("messages.word.orders")
      }, null, _parent));
      _push(`<div class="orders-list list mb-5"><div class="card"><div class="card-body"><div class="d-flex align-item-center justify-content-between mb-3"><div></div><div class="d-inline-flex align-item-center lts-05">`);
      if (_ctx.consignment.status != "cancelled" && _ctx.consignment.status != "returned") {
        _push(`<div class="user-order-item-footer"><a${ssrRenderAttr("href", _ctx.route("seller.orders.thermal_sales_factor", _ctx.consignment.id))} target="_blank" class="btn link fs-7"><i class="ri-file-list-3-line me-1"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.thermal_factor"))}</a></div>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.consignment.status != "cancelled" && _ctx.consignment.status != "returned") {
        _push(`<div class="user-order-item-footer"><a${ssrRenderAttr("href", _ctx.route("seller.orders.sales_factor", _ctx.consignment.id))} target="_blank" class="btn link fs-7"><i class="ri-file-list-3-line me-1"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.normal_factor"))}</a></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div><div class="orders"><div class="d-inline-block alert alert-light lts-05 mb-2"><span class="fs-8 text-gray">${ssrInterpolate(_ctx.$t("messages.sentence.send_type"))}:</span><span class="fw-bold ms-2 text-success">${ssrInterpolate(_ctx.consignment.send_type == "direct" ? _ctx.$t("messages.sentence.direct_send_to_customer") : _ctx.$t("messages.sentence.send_to_main_storage"))}</span></div>`);
      if (_ctx.consignment.send_type == "direct") {
        _push(`<div class="d-block"><div class="d-inline-block alert alert-info lts-05 mb-0 py-1"><span class="fs-8">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_589963"))}</span></div></div>`);
      } else {
        _push(`<div class="d-block"><div class="d-inline-block alert alert-info lts-05 mb-0 py-1"><span class="fs-8">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_587403"))}</span></div></div>`);
      }
      _push(`<div class="user-order-items"><div class="user-order-item"><div class="user-order-item-header"><div class="mb-3"><div class="row"><div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.word.status"))}: </span>`);
      if (_ctx.consignment.status == "created") {
        _push(`<span class="badge bg-info text-info">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_seller_send"))}</span>`);
      } else if (_ctx.consignment.status == "awaiting_seller") {
        _push(`<span class="badge bg-info text-info">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_seller_send"))}</span>`);
      } else if (_ctx.consignment.status == "sent_to_main_storage") {
        _push(`<span class="badge bg-purple text-info">${ssrInterpolate(_ctx.$t("messages.sentence.sent_to_main_storage"))}</span>`);
      } else if (_ctx.consignment.status == "direct_sent_to_customer") {
        _push(`<span class="badge bg-success text-info">${ssrInterpolate(_ctx.$t("messages.sentence.direct_sent_to_customer"))}</span>`);
      } else if (_ctx.consignment.status == "delivered_to_main_storage") {
        _push(`<span class="badge bg-success text-info">${ssrInterpolate(_ctx.$t("messages.sentence.delivered_to_main_storage"))}</span>`);
      } else if (_ctx.consignment.status == "sent_to_customer") {
        _push(`<span class="badge bg-success text-info">${ssrInterpolate(_ctx.$t("messages.sentence.sent_to_customer"))}</span>`);
      } else if (_ctx.consignment.status == "delivered") {
        _push(`<span class="badge bg-success text-info">${ssrInterpolate(_ctx.$t("messages.sentence.delivered_to_customer"))}</span>`);
      } else if (_ctx.consignment.status == "cancelled") {
        _push(`<span class="badge bg-danger text-info">${ssrInterpolate(_ctx.$t("messages.word.cancelled"))}</span>`);
      } else if (_ctx.consignment.status == "returned") {
        _push(`<span class="badge bg-danger text-info">${ssrInterpolate(_ctx.$t("messages.word.returned"))}</span>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</span></div><div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.sentence.consignment_uuid"))}: </span><span>${ssrInterpolate(_ctx.consignment.uuid)}</span></span></div>`);
      if (_ctx.consignment.send_type == "direct" && _ctx.consignment.order.status == "sent") {
        _push(`<div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted lts-05 me-1">${ssrInterpolate(_ctx.consignment.send_method["type"] == "post" && _ctx.consignment.send_method["item"]["uuid"] == "peyk" ? _ctx.$t("messages.sentence.courier_phone_number") : _ctx.$t("messages.sentence.post_tracking_code"))}: </span> ${ssrInterpolate(_ctx.consignment.tracking_code)}</span></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.word.date"))}: </span> ${ssrInterpolate(_ctx.consignment.jalali_created_at[2])}</span></div><div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.sentence.total_amount"))}: </span> ${ssrInterpolate(unref(useNumberFormat)(_ctx.consignment.get_total_bill.price + _ctx.consignment.get_total_bill.discount))} <span class="currency">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span></span></div><div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.sentence.total_discount"))}: </span><span class="text-danger">${ssrInterpolate(unref(useNumberFormat)(_ctx.consignment.get_total_bill.discount))}-</span>`);
      if (_ctx.consignment.get_total_bill.discount > 0) {
        _push(`<span class="currency text-danger">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</span></div>`);
      if (_ctx.consignment.send_type == "direct" && _ctx.consignment.send_method["type"] == "post") {
        _push(`<div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.sentence.send_price"))}: </span>`);
        if (_ctx.consignment.send_method["free"]) {
          _push(`<span>${ssrInterpolate(_ctx.$t("messages.word.free"))}</span>`);
        } else {
          _push(`<span>`);
          if (_ctx.consignment.send_method["price"] != null) {
            _push(`<div>${ssrInterpolate(unref(useNumberFormat)(_ctx.consignment.send_method["price"]))} <span>${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span></div>`);
          } else {
            _push(`<span>${ssrInterpolate(_ctx.$t("messages.sentence.payment_on_spot"))}</span>`);
          }
          _push(`</span>`);
        }
        _push(`</span></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.total_paid_amount"))}: </span> ${ssrInterpolate(unref(useNumberFormat)(_ctx.consignment.get_total_bill.price + _ctx.consignment["send_price"]))} <span class="currency">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span></span></div>`);
      if (_ctx.consignment.get_total_cancel_bill.price > 0) {
        _push(`<div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.total_cancelled_amount"))}: </span><span class="text-danger">${ssrInterpolate(unref(useNumberFormat)(_ctx.consignment.get_total_cancel_bill.price))}-</span><span class="currency text-danger">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span></span></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.main_shop_share"))}: </span> ${ssrInterpolate(unref(useNumberFormat)(_ctx.consignment.get_shares.shop))} <span class="currency">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span></span></div><div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.seller_share"))}: </span> ${ssrInterpolate(unref(useNumberFormat)(_ctx.consignment.get_shares.seller + _ctx.consignment["send_price"]))} <span class="currency">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span></span></div><div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.affiliate_share"))}: </span> ${ssrInterpolate(unref(useNumberFormat)(_ctx.consignment.get_shares.affiliate))} <span class="currency">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span></span></div></div></div>`);
      if (_ctx.consignment.send_type != "direct") {
        _push(`<div class="row send-details mb-4"><div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.sentence.recipient_firstname"))}: </span> ${ssrInterpolate(_ctx.$page.props.appName)}</span></div><div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.word.telephone"))}: </span> ${ssrInterpolate(_ctx.consignment.get_address.phone)}</span></div><div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.word.town"))}: </span> ${ssrInterpolate(_ctx.consignment.get_address.state.replace("استان", ""))}</span></div><div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.word.city"))}: </span> ${ssrInterpolate(_ctx.consignment.get_address.city)}</span></div><div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.word.postal_code"))}: </span> ${ssrInterpolate(_ctx.consignment.get_address.postal_code)}</span></div><div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.word.map"))}: </span><span class="link" data-bs-toggle="modal" data-bs-target="#showMap">${ssrInterpolate(_ctx.$t("messages.word.display"))} <i class="ri-map-pin-2-line ms-1"></i></span></span><div class="modal fade" id="showMap" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-lg modal-dialog-centered"><div class="modal-content"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.word.map"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12"><div class="map-container">`);
        _push(ssrRenderComponent(unref(NeshanMap), {
          ref_key: "Map",
          ref: Map,
          mapKey: _ctx.$page.props.neshan.map_key,
          serviceKey: _ctx.$page.props.neshan.service_key,
          center: unref(mapResult),
          zoom: unref(mapResult).zoom,
          defaultType: "neshan",
          hideLayers: true,
          traffic: false,
          cluster: false,
          hideSearchContainer: true,
          class: "map"
        }, null, _parent));
        _push(`<div class="readonly-map"></div></div></div></div></div><div class="modal-footer"><button class="btn btn-primary" type="button" data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(_ctx.$t("messages.word.close"))}</button></div></div></div></div></div><div class="col-12 user-order-item-header--meta"><span class="user-order-meta mb-0"><span class="text-muted">${ssrInterpolate(_ctx.$t("messages.sentence.full_address"))}: </span><span class="fw-bold ms-1">${ssrInterpolate(_ctx.consignment.get_address.full_address)}</span></span></div></div>`);
      } else if (_ctx.consignment.send_type == "direct") {
        _push(`<div class="row send-details mb-4"><div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.sentence.send_way"))}: </span> ${ssrInterpolate(_ctx.consignment.send_method["type"] == "post" ? _ctx.consignment.send_method["item"]["name"] : _ctx.$t("messages.sentence.receive_in_person"))}</span></div><div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.sentence.recipient_firstname"))}: </span> ${ssrInterpolate(_ctx.consignment.get_address["address"]["first_name"] + " " + _ctx.consignment.get_address["address"]["last_name"])}</span></div><div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.word.telephone"))}: </span> ${ssrInterpolate(_ctx.consignment.get_address["address"]["phone"])}</span></div><div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.word.town"))}: </span> ${ssrInterpolate(_ctx.consignment.get_address["address"]["state"].replace("استان", ""))}</span></div><div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.word.city"))}: </span> ${ssrInterpolate(_ctx.consignment.get_address["address"]["city"])}</span></div><div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.word.postal_code"))}: </span> ${ssrInterpolate(_ctx.consignment.get_address["address"]["postal_code"])}</span></div><div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.word.map"))}: </span><span class="link" data-bs-toggle="modal" data-bs-target="#showMap">${ssrInterpolate(_ctx.$t("messages.word.display"))} <i class="ri-map-pin-2-line ms-1"></i></span></span><div class="modal fade" id="showMap" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-lg modal-dialog-centered"><div class="modal-content"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.word.map"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12"><div class="map-container">`);
        _push(ssrRenderComponent(unref(NeshanMap), {
          ref_key: "Map",
          ref: Map,
          mapKey: _ctx.$page.props.neshan.map_key,
          serviceKey: _ctx.$page.props.neshan.service_key,
          center: unref(mapResult),
          zoom: unref(mapResult).zoom,
          defaultType: "neshan",
          hideLayers: true,
          traffic: false,
          cluster: false,
          hideSearchContainer: true,
          class: "map"
        }, null, _parent));
        _push(`<div class="readonly-map"></div></div></div></div></div><div class="modal-footer"><button class="btn btn-primary" type="button" data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(_ctx.$t("messages.word.close"))}</button></div></div></div></div></div><div class="col-12 user-order-item-header--meta"><span class="user-order-meta mb-0"><span class="text-muted">${ssrInterpolate(_ctx.$t("messages.sentence.full_address"))}: </span><span class="fw-bold ms-1">${ssrInterpolate(_ctx.consignment.get_address["address"]["full_address"])}</span></span></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div><div class="user-order-item-content mb-4"><div class="mb-1 mt-2 mb-4"><div class="fw-bold text-dark"><i class="ri-pantone-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.consignment_information"))}</div></div><div class="consignment-section mb-4"><div class="table-responsive"><table class="table mb-0" style="${ssrRenderStyle({ "min-width": "950px", "width": "100%" })}"><thead><tr><th class="first-small">${ssrInterpolate(_ctx.$t("messages.word.image"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.title"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.storage"))}</th><th class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.total_paid_amount"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.count"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.status"))}</th><th class="first-small"><i class="ri-settings-4-line"></i></th></tr></thead><tbody><!--[-->`);
      ssrRenderList(_ctx.consignment.consignment_items, (item) => {
        _push(`<tr><td class="first-small"><img class="br-10" width="35" height="35"${ssrRenderAttr("src", item.product.get_images[0]["link"])}${ssrRenderAttr("alt", item.product.get_images[0]["alt"])}></td><td><a class="product-title product-title-min-300 link fw-normal mb-2" target="_blank"${ssrRenderAttr("href", _ctx.route("main.products.show", item.product.slug))}>${ssrInterpolate(item.product.title)}</a><ul class="list-of-props-for-table"><!--[-->`);
        ssrRenderList(item.get_props, (prop, index) => {
          _push(`<!--[-->`);
          if (prop.type == "color") {
            _push(`<li><span class="text-gray fs-9">${ssrInterpolate(_ctx.$t("messages.word.color"))}:</span><span class="raw-circle d-inline-block ms-1" style="${ssrRenderStyle("background-color:" + prop["value"]["color"])}"></span><span class="fs-9 ms-1">${ssrInterpolate(prop["value"]["label"])}</span></li>`);
          } else {
            _push(`<li><span class="text-gray fs-9">${ssrInterpolate(prop["name"])}:</span><span class="fs-9 ms-1">${ssrInterpolate(prop["value"])}</span></li>`);
          }
          _push(`<!--]-->`);
        });
        _push(`<!--]--></ul></td><td>${ssrInterpolate(item.storage.name)}</td><td>${ssrInterpolate(unref(useNumberFormat)(item.get_full_count_price))} <span class="unit unit-sm"></span></td><td>${ssrInterpolate(unref(useNumberFormat)(item.count))}</td><td class="first-small lts-05" style="${ssrRenderStyle({ "width": "100px" })}">`);
        if (item.status == "awaiting_seller_send") {
          _push(`<span class="badge bg-info">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_seller_send"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        if (item.status == "awaiting_seller") {
          _push(`<span class="badge bg-info">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_seller_send"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        if (item.status == "awaiting_receipt_from_seller") {
          _push(`<span class="badge bg-purple">${ssrInterpolate(_ctx.$t("messages.sentence.sent_to_main_storage"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        if (item.status == "ready_to_send") {
          _push(`<span class="badge bg-success">${ssrInterpolate(_ctx.$t("messages.sentence.ready_to_send_to_customer"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        if (item.status == "sent") {
          _push(`<span class="badge bg-success">${ssrInterpolate(_ctx.$t("messages.word.sent"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        if (item.status == "delivered") {
          _push(`<span class="badge bg-success">${ssrInterpolate(_ctx.$t("messages.word.delivered"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        if (item.status == "cancelled") {
          _push(`<span class="badge bg-danger">${ssrInterpolate(_ctx.$t("messages.word.cancelled"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        if (item.status == "returned") {
          _push(`<span class="badge bg-danger">${ssrInterpolate(_ctx.$t("messages.word.returned"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</td><td class="dropdown"><i class="ri-more-2-fill" data-bs-toggle="dropdown"></i><div class="dropdown-menu shadow-smooth-2"><ul><li><a href="javascript:void(0)" data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#details-item-" + item.id)} class="dropdown-item no-btn"><i class="ri-wallet-3-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.financial_statistic"))}</a></li>`);
        if (item.status == "awaiting_seller" || item.status == "awaiting_seller_send") {
          _push(`<li>`);
          if (!_ctx.is_digipay_upg) {
            _push(`<a href="javascript:void(0)" data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#cancel-item-" + item.id)} class="dropdown-item no-btn"><i class="ri-close-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.cancel_product"))}</a>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</li>`);
        } else {
          _push(`<!---->`);
        }
        if (item.status != "delivered" && item.status != "sent" && item.status != "cancelled" && item.status != "returned") {
          _push(`<li>`);
          if (_ctx.is_snapppay && item.count > 1) {
            _push(`<a href="javascript:void(0)" data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#cancel-item-count-" + item.id)} class="dropdown-item no-btn"><i class="ri-close-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.cancel_product_count"))}</a>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</li>`);
        } else {
          _push(`<!---->`);
        }
        if (item.status == "cancelled") {
          _push(`<li><a href="javascript:void(0)" data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#cancellation-reason-" + item.id)} class="dropdown-item no-btn"><i class="ri-information-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.product_cancellation_reason"))}</a></li>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</ul></div><div class="modal fade"${ssrRenderAttr("id", "details-item-" + item.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.financial_statistic"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12">`);
        if (item.status == "cancelled" || item.status == "returned") {
          _push(`<div class="mb-3"><span class="fs-8 fw-bold text-danger lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_411125"))}</span></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="table-responsive"><table class="table mb-4" style="${ssrRenderStyle({ "width": "100%", "min-width": "100%" })}"><tbody><tr><td class="lts-05">${ssrInterpolate(_ctx.$t("messages.word.price"))} <span class="fs-10 text-gray fw-normal">(${ssrInterpolate(_ctx.$t("messages.sentence.each_unit"))})</span></td><td>${ssrInterpolate(unref(useNumberFormat)(item.price + item.discount))} <span class="unit unit-sm"></span></td></tr><tr><td class="lts-05">${ssrInterpolate(_ctx.$t("messages.word.discount"))} <span class="fs-10 text-gray fw-normal">(${ssrInterpolate(_ctx.$t("messages.sentence.each_unit"))})</span></td><td class="text-danger">${ssrInterpolate(unref(useNumberFormat)(item.discount))} `);
        if (item.discount > 0) {
          _push(`<span class="unit-red unit-sm"></span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</td></tr><tr><td class="lts-05">${ssrInterpolate(_ctx.$t("messages.word.count"))}</td><td>${ssrInterpolate(unref(useNumberFormat)(item.count))}</td></tr><tr><td class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.total_amount"))}</td><td>${ssrInterpolate(unref(useNumberFormat)((item.price + item.discount) * item.count))} <span class="unit unit-sm"></span></td></tr><tr><td class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.total_discount"))}</td><td class="text-danger">${ssrInterpolate(unref(useNumberFormat)(item.discount * item.count))} `);
        if (item.discount > 0) {
          _push(`<span class="unit-red unit-sm"></span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</td></tr><tr><td class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.total_paid_amount"))}</td><td>${ssrInterpolate(unref(useNumberFormat)(item.price * item.count))} <span class="unit unit-sm"></span></td></tr></tbody></table>`);
        if (item.get_shares.affiliate_information != null) {
          _push(`<!--[--><span class="mb-2 fw-bold lts-05 fs-8 d-flex">${ssrInterpolate(_ctx.$t("messages.sentence.affiliate_share"))}</span><table class="table" style="${ssrRenderStyle({ "width": "100%", "min-width": "100%" })}"><tbody><tr><td class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.sales_associate"))}</td><td>${ssrInterpolate(item.get_shares.affiliate_information.user.get_name)}</td></tr><tr><td class="lts-05">${ssrInterpolate(_ctx.$t("messages.word.level"))}</td><td>`);
          if (item.get_shares.affiliate_information.user.get_level == "bronze") {
            _push(`<span>${ssrInterpolate(_ctx.$t("messages.word.bronze"))}</span>`);
          } else {
            _push(`<!---->`);
          }
          if (item.get_shares.affiliate_information.user.get_level == "silver") {
            _push(`<span>${ssrInterpolate(_ctx.$t("messages.word.silver"))}</span>`);
          } else {
            _push(`<!---->`);
          }
          if (item.get_shares.affiliate_information.user.get_level == "gold") {
            _push(`<span>${ssrInterpolate(_ctx.$t("messages.word.gold"))}</span>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</td></tr><tr><td class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.affiliate_commission"))}</td><td>${ssrInterpolate(item.get_shares.affiliate_information.commission)}%</td></tr><tr><td class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.share_amount"))}</td><td>${ssrInterpolate(unref(useNumberFormat)(item.get_shares.affiliate))} <span class="unit unit-sm"></span></td></tr></tbody></table><span class="text-gray lts-05 fs-9 d-flex mb-4">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_548184"))}</span><!--]-->`);
        } else {
          _push(`<!---->`);
        }
        if (item.store != null) {
          _push(`<!--[--><span class="mb-2 fw-bold lts-05 fs-8 d-flex">${ssrInterpolate(_ctx.$t("messages.sentence.main_shop_share"))}</span><table class="table mb-4" style="${ssrRenderStyle({ "width": "100%", "min-width": "100%" })}"><tbody><tr><td class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.main_shop_commission"))}</td><td>${ssrInterpolate(item.product.commission)}%</td></tr><tr><td class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.share_amount"))}</td><td>${ssrInterpolate(unref(useNumberFormat)(item.get_shares.shop))} <span class="unit unit-sm"></span></td></tr></tbody></table><!--]-->`);
        } else {
          _push(`<!---->`);
        }
        if (item.store != null) {
          _push(`<!--[--><span class="mb-2 fw-bold lts-05 fs-8 d-flex">${ssrInterpolate(_ctx.$t("messages.sentence.seller_share"))}</span><table class="table" style="${ssrRenderStyle({ "width": "100%", "min-width": "100%" })}"><tbody><tr><td class="lts-05">${ssrInterpolate(_ctx.$t("messages.word.seller"))}</td>`);
          if (item.store != null) {
            _push(`<td>${ssrInterpolate(item.store.name)}</td>`);
          } else {
            _push(`<td><span class="fw-bold">${ssrInterpolate(_ctx.$t("messages.sentence.main_shop"))}</span></td>`);
          }
          _push(`</tr><tr><td class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.share_amount"))}</td><td>${ssrInterpolate(unref(useNumberFormat)(item.get_shares.seller))} <span class="unit unit-sm"></span></td></tr></tbody></table><!--]-->`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div></div></div></div><div class="modal-footer"><button class="btn btn-primary" type="button" data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(_ctx.$t("messages.word.close"))}</button></div></div></div></div><div class="modal fade"${ssrRenderAttr("id", "cancel-item-" + item.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.cancel_product"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12"><div class="row"><div class="col-12 mb-1"><label for="eaFirstName" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.reason"))}: </label><textarea type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.write_product_cancellation_reason") + " ...")} class="form-control" name="reason" id="eaFirstName">${ssrInterpolate(unref(cancelProductForm).reason)}</textarea></div><div class="col-12 mb-4"><span class="fs-9 text-gray lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_466589"))}</span></div><div class="mb-3"><span class="fs-8 fw-bold text-danger lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_478525"))}</span></div></div></div></div></div><div class="modal-footer"><button class="btn btn-light" type="button" data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(_ctx.$t("messages.word.cancel"))}</button><button class="btn btn-danger" type="submit"${ssrIncludeBooleanAttr(unref(cancelProductForm).processing) ? " disabled" : ""}>${ssrInterpolate(_ctx.$t("messages.sentence.cancel_product"))}</button></div></form></div></div></div><div class="modal fade"${ssrRenderAttr("id", "cancel-item-count-" + item.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><form><div class="modal-content"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.cancel_product"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12"><div class="row">`);
        if (_ctx.is_snapppay) {
          _push(`<div class="col-12 mb-4"><label for="eaFirstName" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.cancel_count"))}: </label>`);
          _push(ssrRenderComponent(_sfc_main$3, {
            modelValue: unref(cancelProductCountForm).count,
            "onUpdate:modelValue": ($event) => unref(cancelProductCountForm).count = $event,
            required: "",
            style: { "direction": "ltr" }
          }, null, _parent));
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="mb-3"><span class="fs-8 fw-bold text-danger lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_478525"))}</span></div></div></div></div></div><div class="modal-footer"><button class="btn btn-light" type="button" data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(_ctx.$t("messages.word.cancel"))}</button><button class="btn btn-danger" type="submit">${ssrInterpolate(_ctx.$t("messages.word.apply"))}</button></div></div></form></div></div>`);
        if (item.status == "cancelled") {
          _push(`<div class="modal fade"${ssrRenderAttr("id", "cancellation-reason-" + item.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><div class="modal-header"><div class="modal-title lts-05 fs-5 text-danger">${ssrInterpolate(_ctx.$t("messages.sentence.product_cancellation_reason"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12"><div class="row"><div class="col-12 mb-4"><span class="lts-05 lh-30">${unref(useNl2br)(item.reason) ?? ""}</span></div></div></div></div></div><div class="modal-footer"><button class="btn btn-light" type="button" data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(_ctx.$t("messages.word.close"))}</button></div></div></div></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</td></tr>`);
      });
      _push(`<!--]--></tbody></table>`);
      if (_ctx.consignment.store != null && _ctx.consignment.is_all_product_sent && _ctx.consignment.is_products_awaiting_receipt_from_seller) {
        _push(`<div class="message-box mt-3"><span class="d-flex fs-8 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.post_tracking_code"))}: ${ssrInterpolate(_ctx.consignment.tracking_code)}</span></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div>`);
      if (_ctx.consignment.status == "awaiting_seller" || _ctx.consignment.status == "created") {
        _push(`<div class="user-order-item-footer row mb-3"><div class="col-12 d-flex align-item-center justify-content-end"><a href="javascript:void(0)" data-bs-toggle="modal" data-bs-target="#changeOrderStatus" class="btn btn-link fw-bold user-order-detail-link lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.change_status"))} <i class="ri-arrow-left-s-fill"></i></a></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.consignment.status == "awaiting_seller" || _ctx.consignment.status == "created") {
        _push(`<div class="modal fade" id="changeOrderStatus" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content modal-order-status"><form><div class="modal-header pt-2"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.change_order_status"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-md-6 col-6 mb-3"><div class="${ssrRenderClass({ "order-status-label": true, sent: unref(changeOrderStatusForm).status == "sent" })}">${ssrInterpolate(_ctx.$t("messages.word.the_sent"))}</div></div><div class="col-md-6 col-6 mb-3"><div class="${ssrRenderClass({ "order-status-label": true, cancelled: unref(changeOrderStatusForm).status == "cancelled" })}">${ssrInterpolate(_ctx.$t("messages.word.the_cancelled"))}</div></div>`);
        if (unref(changeOrderStatusForm).status == "sent") {
          _push(`<div class="col-12 mt-4"><div class="row"><div class="col-12 mb-2"><label for="eaTrackingCode" class="form-label">${ssrInterpolate(_ctx.consignment.send_type == "direct" && _ctx.consignment.send_method["type"] == "post" && _ctx.consignment.send_method["item"]["uuid"] == "peyk" ? _ctx.$t("messages.sentence.courier_phone_number") : _ctx.$t("messages.sentence.post_tracking_code"))}:</label><input${ssrRenderAttr("value", unref(changeOrderStatusForm).tracking_code)} type="text" required class="form-control" name="tracking_code" id="eaTrackingCode"></div><div class="col-12 mb-3"><span class="description fs-8 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_489631"))}</span></div>`);
          if (_ctx.consignment.send_type != "direct") {
            _push(`<div class="col-12 mb-4"><span class="description lts-05"><span class="fw-bold text-danger me-1">${ssrInterpolate(_ctx.$t("messages.word.attention"))}:</span><span class="text-dark">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_457811"))}</span></span></div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<div class="col-12 mb-4"><span class="description lts-05"><span class="fw-bold text-danger me-1">${ssrInterpolate(_ctx.$t("messages.word.attention"))}:</span><span class="text-dark">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_254850"))}</span></span></div></div></div>`);
        } else {
          _push(`<!---->`);
        }
        if (unref(changeOrderStatusForm).status == "cancelled") {
          _push(`<div class="col-12 mt-4"><div class="row"><div class="col-12 mb-2"><label for="eaReason" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.order_cancelling_reason"))}: </label><textarea type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.write_order_cancelling_reason") + " ...")} required class="form-control" name="reason" id="eaReason">${ssrInterpolate(unref(changeOrderStatusForm).reason)}</textarea></div><div class="col-12 mb-4"><span class="description fs-8 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_266587"))}</span></div></div></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div></div>`);
        if (unref(changeOrderStatusForm).status != "") {
          _push(`<div class="modal-footer"><div class="col-12 d-flex align-items-center justify-content-end"><button type="submit" class="btn btn-primary lts-05 shadow-1"${ssrIncludeBooleanAttr(unref(changeOrderStatusForm).processing) ? " disabled" : ""}>${ssrInterpolate(_ctx.$t("messages.word.apply"))}</button></div></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</form></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div></div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Store/Orders/Show.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
