import { defineComponent, ref, unref, withCtx, createTextVNode, createVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderComponent, ssrRenderAttr, ssrInterpolate, ssrRenderStyle, ssrRenderList, ssrRenderClass } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./AdminLayout-CD07IMsK.js";
import { useForm, Head, Link } from "@inertiajs/vue3";
import NeshanMap from "@neshan-maps-platform/vue3-openlayers";
import { _ as _sfc_main$2 } from "./Files-B6eiTnN6.js";
import { u as useNumberFormat } from "../ssr.js";
import { u as useNl2br } from "./useNl2br-BIw8h5gy.js";
import { _ as _sfc_main$3 } from "./NumInput-Bt6uFGO4.js";
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "laravel-vue-i18n";
import "./Pagination-C1AQrLe3.js";
import "./SearchList-BZnYMQPN.js";
import "lodash/debounce.js";
import "./useRandomNum-DNNSqR7b.js";
import "@vue/server-renderer";
import "@inertiajs/vue3/server";
import "ziggy-js";
import "axios";
import "swiper/bundle";
import "jquery";
import "swiper";
import "./useRandomStr-4MeWbtRd.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Show",
  __ssrInlineRender: true,
  props: {
    order: {},
    paymentMeta: {},
    payment_transaction: {},
    is_pay_with_wallet: { type: Boolean },
    is_snapppay: { type: Boolean },
    is_digipay_upg: { type: Boolean },
    is_azki: { type: Boolean }
  },
  setup(__props) {
    const props = __props;
    const Map = ref();
    const mapResult = props.order.get_address.type == "user" ? props.order.get_address.address.get_map : props.order.get_address.address.location;
    setTimeout(() => {
      var _a;
      (_a = Map.value) == null ? void 0 : _a.reverse([mapResult.longitude, mapResult.latitude], {
        useMarker: true
      });
    }, 1500);
    setTimeout(() => {
      var _a;
      (_a = Map.value) == null ? void 0 : _a.reverse([mapResult.longitude, mapResult.latitude], {
        useMarker: true
      });
    }, 2e3);
    const cancelProductForm = useForm({
      reason: null
    });
    const cancelProductCountForm = useForm({
      count: null
    });
    useForm({
      reason: null
    });
    const requestFormSellerForm = useForm({
      address: null
    });
    useForm({});
    useForm({});
    const changeOrderStatusForm = useForm({
      status: props.order.is_all_item_cancelled ? "cancelled" : "",
      tracking_code: null,
      reason: null
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.order_details", { order: _ctx.order.uuid })
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.sentence.order_details"),
        item: _ctx.$t("messages.word.orders")
      }, null, _parent));
      _push(`<div class="orders-list list mb-5"><div class="card"><div class="card-body"><div class="d-flex align-item-center justify-content-between mb-3"><div></div><div class="d-inline-flex align-item-center lts-05">`);
      if (_ctx.order.status == "sent" || _ctx.order.status == "delivered" || _ctx.order.status == "registered") {
        _push(`<div class="user-order-item-footer"><a${ssrRenderAttr("href", _ctx.route("admin.orders.thermal_sales_factor", _ctx.order.id))} target="_blank" class="btn link fs-7"><i class="ri-file-list-3-line me-1"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.thermal_factor"))}</a></div>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.order.status == "sent" || _ctx.order.status == "delivered" || _ctx.order.status == "registered") {
        _push(`<div class="user-order-item-footer"><a${ssrRenderAttr("href", _ctx.route("admin.orders.sales_factor", _ctx.order.id))} target="_blank" class="btn link fs-7"><i class="ri-file-list-3-line me-1"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.normal_factor"))}</a></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div>`);
      if (_ctx.order.status == "cancelled" || _ctx.order.status == "returned") {
        _push(`<div class="d-flex align-item-center justify-content-start">`);
        if (_ctx.is_snapppay || _ctx.is_digipay_upg) {
          _push(`<p class="text-danger fs-8 lts-05 lh-25">${ssrInterpolate(_ctx.$t("messages.sentence.order_cancelled_and_upg_cancelled"))}</p>`);
        } else {
          _push(`<p class="text-danger fs-8 lts-05 lh-25">${_ctx.$t("messages.sentence.order_cancelled_and_amount_returned_to_user", {
            amount: unref(useNumberFormat)(_ctx.order.get_total_bill.cancel.price + _ctx.order.get_total_bill.send_price) + ""
          }) ?? ""}</p>`);
        }
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="orders"><div class="user-order-items"><div class="user-order-item"><div class="user-order-item-header"><div class="mb-2"><div class="row"><div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.word.status"))}: </span>`);
      if (_ctx.order.status == "registered") {
        _push(`<div>`);
        if (_ctx.order.is_all_item_cancelled) {
          _push(`<span class="badge bg-danger">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_final_cancel"))}</span>`);
        } else if (_ctx.order.is_ready_to_send) {
          _push(`<span class="badge bg-success">${ssrInterpolate(_ctx.$t("messages.sentence.ready_to_send"))}</span>`);
        } else if (_ctx.order.is_awaiting_request_from_seller) {
          _push(`<span class="badge bg-info">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_request_from_seller"))}</span>`);
        } else if (_ctx.order.is_awaiting_seller) {
          _push(`<span class="badge bg-warning">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_seller"))}</span>`);
        } else if (_ctx.order.is_awaiting_receipt_from_seller) {
          _push(`<span class="badge bg-purple">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_receipt_from_seller"))}</span>`);
        } else {
          _push(`<span class="badge bg-info me-1">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_review"))}</span>`);
        }
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.order.status == "sent") {
        _push(`<span class="badge bg-success text-info">${ssrInterpolate(_ctx.$t("messages.word.sent"))}</span>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.order.status == "delivered") {
        _push(`<span class="badge bg-success text-info">${ssrInterpolate(_ctx.$t("messages.word.delivered"))}</span>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.order.status == "cancelled") {
        _push(`<span class="badge bg-danger text-info">${ssrInterpolate(_ctx.$t("messages.word.cancelled"))}</span>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.order.status == "returned") {
        _push(`<span class="badge bg-danger text-info">${ssrInterpolate(_ctx.$t("messages.word.returned"))}</span>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</span></div><div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.word.user"))}: </span>`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("admin.users.show", _ctx.order.user.id),
        class: "link link-icon"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.order.user.get_name)} <i class="ri-external-link-line"${_scopeId}></i>`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.order.user.get_name) + " ", 1),
              createVNode("i", { class: "ri-external-link-line" })
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</span></div><div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.sentence.order_uuid"))}: </span> ${ssrInterpolate(_ctx.order.uuid)}</span></div>`);
      if (_ctx.order.status == "sent" || _ctx.order.status == "delivered") {
        _push(`<div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted lts-05 me-1">${ssrInterpolate(_ctx.order.get_send_method["type"] == "post" && _ctx.order.get_send_method["item"]["uuid"] == "peyk" ? _ctx.$t("messages.sentence.courier_phone_number") : _ctx.$t("messages.sentence.post_tracking_code"))}: </span> ${ssrInterpolate(_ctx.order.post_tracking_code)}</span></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.word.date"))}: </span> ${ssrInterpolate(_ctx.order.jalali_created_at[2])}</span></div><div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.sentence.total_amount"))}: </span> ${ssrInterpolate(unref(useNumberFormat)(_ctx.order.get_total_bill.price + _ctx.order.get_total_bill.discount))} <span class="currency">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span></span></div><div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.sentence.total_discount"))}: </span><span class="text-danger">${ssrInterpolate(unref(useNumberFormat)(_ctx.order.get_total_bill.discount))}-</span>`);
      if (_ctx.order.get_total_bill.discount > 0) {
        _push(`<span class="currency text-danger">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</span></div>`);
      if (_ctx.order.get_discount != null) {
        _push(`<div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.deduction_with_discount_code"))}: </span><span class="text-danger">${ssrInterpolate(unref(useNumberFormat)(_ctx.order.get_discount["amount"]))}-</span><span class="currency text-danger">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span><i data-bs-toggle="modal" data-bs-target="#discountDetails" class="ri-information-line link ms-1"></i></span><div class="modal fade" id="discountDetails" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.discount_code_details"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12"><div class="table-responsive"><table class="table" style="${ssrRenderStyle({ "width": "100%", "min-width": "100%" })}"><tbody><tr><td class="lts-05">${ssrInterpolate(_ctx.$t("messages.word.title"))}</td><td>${ssrInterpolate(_ctx.order.get_discount["information"]["title"])}</td></tr><tr><td class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.discount_code"))}</td><td>${ssrInterpolate(_ctx.order.get_discount["information"]["code"])}</td></tr></tbody></table></div></div></div></div><div class="modal-footer"><button class="btn btn-primary" type="button" data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(_ctx.$t("messages.word.close"))}</button></div></div></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.order.get_send_method["type"] == "post") {
        _push(`<div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.sentence.send_price"))}: </span>`);
        if (_ctx.order.get_send_method["free"]) {
          _push(`<span>${ssrInterpolate(_ctx.$t("messages.word.free"))}</span>`);
        } else {
          _push(`<span>`);
          if (_ctx.order.get_send_method["price"] != null) {
            _push(`<div>${ssrInterpolate(unref(useNumberFormat)(_ctx.order.get_send_method["price"]))} <span>${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span></div>`);
          } else {
            _push(`<span>${ssrInterpolate(_ctx.$t("messages.sentence.payment_on_spot"))}</span>`);
          }
          _push(`</span>`);
        }
        _push(`</span></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.total_paid_amount"))}: </span> ${ssrInterpolate(unref(useNumberFormat)(_ctx.order.get_total_bill.price + _ctx.order.get_total_bill.send_price - (_ctx.order.get_discount != null ? _ctx.order.get_discount["amount"] : 0)))} <span class="currency">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span></span></div>`);
      if (_ctx.order.get_total_bill.cancel.price > 0) {
        _push(`<div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.total_cancelled_amount"))}: </span><span class="text-danger">${ssrInterpolate(unref(useNumberFormat)(_ctx.order.get_total_bill.cancel.price + (_ctx.order.status == "cancelled" ? _ctx.order.get_total_bill.send_price : 0)))}-</span><span class="currency text-danger">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span></span></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.main_shop_share"))}: </span> ${ssrInterpolate(unref(useNumberFormat)(
        _ctx.order.get_shares.shop + (_ctx.order.status != "cancelled" && _ctx.order.status != "returned" && _ctx.order.send_by == null ? _ctx.order.get_total_bill.send_price : 0)
      ))} <span class="currency">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span></span></div><div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.seller_share"))}: </span> ${ssrInterpolate(unref(useNumberFormat)(
        _ctx.order.get_shares.seller + (_ctx.order.status != "cancelled" && _ctx.order.status != "returned" && _ctx.order.send_by != null ? _ctx.order.get_total_bill.send_price : 0)
      ))} <span class="currency">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span></span></div><div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.affiliate_share"))}: </span> ${ssrInterpolate(unref(useNumberFormat)(_ctx.order.get_shares.affiliate))} <span class="currency">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span></span></div></div></div><div class="row mb-3">`);
      if (_ctx.payment_transaction) {
        _push(`<div class="col-12 mb-1"><span class="text-dark-auto">${_ctx.$t("messages.sentence.order_payment_gateway", { gateway: _ctx.payment_transaction.payment_gateway + "" }) ?? ""}</span></div>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.is_snapppay || _ctx.is_digipay_upg || _ctx.is_azki) {
        _push(`<div class="col-12"><span class="text-dark-auto">${_ctx.$t("messages.sentence.order_payment_way_is_upg") ?? ""}</span></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div><div class="row send-details mb-4"><div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.sentence.send_way"))}: </span> ${ssrInterpolate(_ctx.order.get_send_method["type"] == "post" ? _ctx.order.get_send_method["item"]["name"] : _ctx.$t("messages.sentence.receive_in_person"))}</span></div><div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2">`);
      if (_ctx.order.get_address.type == "user") {
        _push(`<span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.sentence.recipient_firstname"))}: </span> ${ssrInterpolate(_ctx.order.get_address.address.first_name + " " + _ctx.order.get_address.address.last_name)}</span>`);
      } else {
        _push(`<span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.sentence.recipient_firstname"))}: </span> ${ssrInterpolate(_ctx.order.user.get_name)}</span>`);
      }
      _push(`</div><div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2">`);
      if (_ctx.order.get_address.type == "user") {
        _push(`<span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.sentence.recipient_phone"))}: </span> ${ssrInterpolate(_ctx.order.get_address.address.phone)}</span>`);
      } else {
        _push(`<span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.sentence.recipient_phone"))}: </span> ${ssrInterpolate(_ctx.order.user.phone)}</span>`);
      }
      _push(`</div>`);
      if (_ctx.order.get_address.type == "shop") {
        _push(`<div class="divider mb-3"></div>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.order.get_address.type == "shop") {
        _push(`<div class="col-12 mb-3"><span class="fw-bold text-dark fs-8">${ssrInterpolate(_ctx.$t("messages.sentence.address_of_selected_receiving_center"))}:</span></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="col-xl-2 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.word.town"))}: </span> ${ssrInterpolate(_ctx.order.get_address.address.state.replace("استان", ""))}</span></div><div class="col-xl-2 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.word.city"))}: </span> ${ssrInterpolate(_ctx.order.get_address.address.city)}</span></div><div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.word.postal_code"))}: </span> ${ssrInterpolate(_ctx.order.get_address.address.postal_code)}</span></div>`);
      if (_ctx.order.get_address.type == "shop") {
        _push(`<div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.word.telephone"))}: </span> ${ssrInterpolate(_ctx.order.get_address.address.phone)}</span></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="col-xl-2 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.word.map"))}: </span><span class="link" data-bs-toggle="modal" data-bs-target="#showMap">${ssrInterpolate(_ctx.$t("messages.word.display"))} <i class="ri-map-pin-2-line ms-1"></i></span></span><div class="modal fade" id="showMap" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-lg modal-dialog-centered"><div class="modal-content"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.word.map"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12"><div class="map-container">`);
      _push(ssrRenderComponent(unref(NeshanMap), {
        ref_key: "Map",
        ref: Map,
        mapKey: _ctx.$page.props.neshan.map_key,
        serviceKey: _ctx.$page.props.neshan.service_key,
        center: unref(mapResult),
        zoom: unref(mapResult).zoom,
        defaultType: "neshan",
        hideLayers: true,
        traffic: false,
        cluster: false,
        hideSearchContainer: true,
        class: "map"
      }, null, _parent));
      _push(`<div class="readonly-map"></div></div></div></div></div><div class="modal-footer"><button class="btn btn-primary" type="button" data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(_ctx.$t("messages.word.close"))}</button></div></div></div></div></div><div class="col-12 user-order-item-header--meta"><span class="user-order-meta mb-0"><span class="text-muted">${ssrInterpolate(_ctx.$t("messages.sentence.full_address"))}: </span><span class="fw-bold ms-1">${ssrInterpolate(_ctx.order.get_address.address.full_address)}</span></span></div></div>`);
      if (_ctx.order.description != null) {
        _push(`<div class="row mb-4"><div class="col-12"><div class="card bg-light"><div class="card-body py-3"><div class="title fw-bold lts-05 mb-2">${ssrInterpolate(_ctx.$t("messages.sentence.order_description"))}</div><div class="lts-05 lh-25">${unref(useNl2br)(_ctx.order.description) ?? ""}</div></div></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div><div class="user-order-item-content mb-4"><div class="mb-1 mt-2 mb-4"><div class="fw-bold text-dark"><i class="ri-pantone-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.consignments_information"))}</div></div><!--[-->`);
      ssrRenderList(_ctx.order.consignments, (consignment, index) => {
        _push(`<div class="consignment-section mb-4"><div class="d-flex align-items-start justify-content-between flex-sm-row flex-column mb-3 mb-sm-0"><span class="consignment-section-header fw-bold d-block fs-8 mb-2 mb-sm-3">`);
        if (consignment.store != null) {
          _push(`<!--[--><span class="me-1">${ssrInterpolate(_ctx.$t("messages.sentence.consignment_of_store"))}:</span>`);
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("admin.stores.show", consignment.store.uuid),
            class: "link"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(consignment.store.name)}`);
              } else {
                return [
                  createTextVNode(toDisplayString(consignment.store.name), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`<!--]-->`);
        } else {
          _push(`<span>${ssrInterpolate(_ctx.$t("messages.sentence.main_shop"))}</span>`);
        }
        _push(`<span class="d-block fw-normal w-100 mt-2">${ssrInterpolate(_ctx.$t("messages.sentence.consignment_uuid"))}: <span>${ssrInterpolate(consignment.uuid)}</span></span></span>`);
        if (consignment.has_awaiting_request_from_seller) {
          _push(`<div>`);
          if (consignment.store != null) {
            _push(`<button data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#requestFormSeller-" + consignment.id)} class="btn btn-dark fs-8 pt-1 pb-1 ps-3 pe-3 lts-05 mt-2">${ssrInterpolate(_ctx.$t("messages.sentence.request_from_seller"))}</button>`);
          } else {
            _push(`<!---->`);
          }
          if (consignment.store != null) {
            _push(`<div class="modal fade"${ssrRenderAttr("id", "requestFormSeller-" + consignment.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-lg modal-dialog-centered"><div class="modal-content"><form><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.request_from_seller"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12 order-addresses"><div class="row"><div class="col-12 mb-3"><span class="d-block fw-bold">${ssrInterpolate(_ctx.$t("messages.sentence.select_receipt_address"))}</span><span class="d-block fw-normal fs-9 lts-05 text-gray">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_548752"))}</span></div><!--[-->`);
            ssrRenderList(_ctx.paymentMeta.get_reception_centers_addresses, (address, index2) => {
              _push(`<div class="${ssrRenderClass({
                "col-lg-4": true,
                "col-md-6": true,
                "user-address-item": true,
                "active-address": unref(requestFormSellerForm).address == address
              })}"${ssrRenderAttr("data-address", address.id)}><div class="custom-radio-box"><div class="custom-radio-box-label"${ssrRenderAttr(
                "data-placeholder",
                unref(requestFormSellerForm).address == address ? _ctx.$t("messages.word.selected") : _ctx.$t("messages.sentence.select_this_address")
              )}><span class="d-block user-address-recipient mb-2">${ssrInterpolate(address.state + ", " + address.city)}</span><span class="d-block user-contact-items"><span class="user-contact-item"><span class="value full-address lts-05">${ssrInterpolate(address.full_address)}</span></span><span class="user-contact-item"><span class="fs-9 me-1">${ssrInterpolate(_ctx.$t("messages.word.postal_code"))}:</span><span class="value">${ssrInterpolate(address.postal_code)}</span></span><span class="user-contact-item"><i class="ri-phone-line icon"></i><span class="value">${ssrInterpolate(address.phone)}</span></span></span></div></div></div>`);
            });
            _push(`<!--]--></div></div></div></div><div class="modal-footer"><button class="btn btn-light" type="button" data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(_ctx.$t("messages.word.close"))}</button><button class="btn btn-primary" type="submit">${ssrInterpolate(_ctx.$t("messages.word.request"))}</button></div></form></div></div></div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        if (consignment.status == "awaiting_seller") {
          _push(`<div>`);
          if (consignment.store != null) {
            _push(`<button data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#cancelRequestFormSeller-" + consignment.id)} class="btn btn-danger-bordered rgba pt-1 pb-1 fs-8 ps-3 pe-3 lts-05 mt-2">${ssrInterpolate(_ctx.$t("messages.sentence.cancel_receiving_request"))}</button>`);
          } else {
            _push(`<!---->`);
          }
          if (consignment.store != null) {
            _push(`<div class="modal fade"${ssrRenderAttr("id", "cancelRequestFormSeller-" + consignment.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.cancel_receiving_request_from_seller"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12"><span class="d-flex lh-30">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_112548"))}</span></div></div></div><div class="modal-footer"><button class="btn btn-light" type="button" data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(_ctx.$t("messages.word.close"))}</button><button class="btn btn-danger" type="submit">${ssrInterpolate(_ctx.$t("messages.word.cancel"))}</button></div></form></div></div></div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        if (consignment.status == "sent_to_main_storage") {
          _push(`<div>`);
          if (consignment.store != null) {
            _push(`<button data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#receivedFormSeller-" + consignment.id)} class="btn btn-success-bordered rgba pt-1 pb-1 fs-8 ps-3 pe-3 mt-2">${ssrInterpolate(_ctx.$t("messages.word.received"))}؟ </button>`);
          } else {
            _push(`<!---->`);
          }
          if (consignment.store != null) {
            _push(`<div class="modal fade"${ssrRenderAttr("id", "receivedFormSeller-" + consignment.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-md modal-dialog-centered"><div class="modal-content"><form><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.consignment_received_from_seller"))}؟</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12"><span class="d-flex mb-3 lh-30">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_455478"))}</span><span class="d-flex mb-3 lh-30">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_789563"))}</span><span class="d-flex lts-05 text-gray">${ssrInterpolate(_ctx.$t("messages.sentence.consignment_post_tracking_code"))}: <span class="badge bg-dark fs-8 ms-1" style="${ssrRenderStyle({ "font-weight": "bold !important" })}">${ssrInterpolate(consignment.tracking_code)}</span></span></div></div></div><div class="modal-footer"><button class="btn btn-light" type="button" data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(_ctx.$t("messages.word.close"))}</button><button class="btn btn-success" type="submit">${ssrInterpolate(_ctx.$t("messages.word.received"))}</button></div></form></div></div></div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div><div class="table-responsive"><table class="table" style="${ssrRenderStyle({ "min-width": "950px", "width": "100%" })}"><thead><tr><th class="first-small">${ssrInterpolate(_ctx.$t("messages.word.image"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.title"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.storage"))}</th><th class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.total_paid_amount"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.count"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.status"))}</th><th class="first-small"><i class="ri-settings-4-line"></i></th></tr></thead><tbody><!--[-->`);
        ssrRenderList(consignment.consignment_items, (item) => {
          _push(`<tr><td class="first-small"><img class="br-10" width="35" height="35"${ssrRenderAttr("src", item.product.get_images[0]["link"])}${ssrRenderAttr("alt", item.product.get_images[0]["alt"])}></td><td><a class="product-title product-title-min-300 link fw-normal mb-2" target="_blank"${ssrRenderAttr("href", _ctx.route("main.products.show", item.product.slug))}>${ssrInterpolate(item.product.title)}</a><ul class="list-of-props-for-table"><!--[-->`);
          ssrRenderList(item.get_props, (prop, index2) => {
            _push(`<!--[-->`);
            if (prop.type == "color") {
              _push(`<li><span class="text-gray fs-9 me-1">${ssrInterpolate(_ctx.$t("messages.word.color"))}:</span>`);
              if (prop["value"]["image"] != null) {
                _push(`<span class="shadow-2 color-box add-image" style="${ssrRenderStyle({ "width": "14px", "height": "14px", "border-radius": "5px" })}"><img${ssrRenderAttr("src", prop["value"]["image"])} alt="رنگ"></span>`);
              } else {
                _push(`<span class="shadow-2 d-inline-block ms-1" style="${ssrRenderStyle("background-color:" + prop["value"]["color"] + "; width: 14px; height: 14px; border-radius: 5px")}"></span>`);
              }
              _push(`<span class="fs-9 ms-1">${ssrInterpolate(prop["value"]["label"])}</span></li>`);
            } else {
              _push(`<li><span class="text-gray fs-9">${ssrInterpolate(prop["name"])}:</span><span class="fs-9 ms-1">${ssrInterpolate(prop["value"])}</span></li>`);
            }
            _push(`<!--]-->`);
          });
          _push(`<!--]--></ul></td><td>`);
          if (item.store != null) {
            _push(`<div>`);
            if (item.status == "ready_to_send") {
              _push(`<span><span class="fw-bold fs-8 lts-05 text-info clickable" data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#submitted-main-storage-" + consignment.id)}>${ssrInterpolate(_ctx.$t("messages.word.show"))}</span><div class="modal fade"${ssrRenderAttr("id", "submitted-main-storage-" + consignment.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.received_storage_address"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12"><div class="table-responsive mb-1"><table class="table" style="${ssrRenderStyle({ "width": "100%", "min-width": "100%" })}"><tbody><tr><td class="white-space-nowrap">${ssrInterpolate(_ctx.$t("messages.word.town"))}</td><td>${ssrInterpolate(consignment.get_address.state.replace("استان", ""))}</td></tr><tr><td class="white-space-nowrap">${ssrInterpolate(_ctx.$t("messages.word.city"))}</td><td>${ssrInterpolate(consignment.get_address.city)}</td></tr><tr><td class="white-space-nowrap">${ssrInterpolate(_ctx.$t("messages.word.postal_code"))}</td><td>${ssrInterpolate(consignment.get_address.postal_code)}</td></tr><tr><td class="white-space-nowrap">${ssrInterpolate(_ctx.$t("messages.sentence.full_address"))}</td><td>${ssrInterpolate(consignment.get_address.full_address)}</td></tr><tr><td class="white-space-nowrap">${ssrInterpolate(_ctx.$t("messages.word.telephone"))}</td><td>${ssrInterpolate(consignment.get_address.phone)}</td></tr></tbody></table></div></div></div></div><div class="modal-footer"><button class="btn btn-light" type="button" data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(_ctx.$t("messages.word.close"))}</button></div></div></div></div></span>`);
            } else {
              _push(`<span>-</span>`);
            }
            _push(`</div>`);
          } else {
            _push(`<span>${ssrInterpolate(item.storage.name)}</span>`);
          }
          _push(`</td><td>${ssrInterpolate(unref(useNumberFormat)(item.get_full_count_price))} <span class="unit unit-sm"></span></td><td>${ssrInterpolate(unref(useNumberFormat)(item.count))}</td><td class="first-small lts-05" style="${ssrRenderStyle({ "width": "100px" })}">`);
          if (item.status == "awaiting_seller_send") {
            _push(`<span class="badge bg-info">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_seller_send"))}</span>`);
          } else {
            _push(`<!---->`);
          }
          if (item.status == "awaiting_request_from_seller") {
            _push(`<span class="badge bg-info">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_request"))}</span>`);
          } else {
            _push(`<!---->`);
          }
          if (item.status == "awaiting_seller") {
            _push(`<span class="badge bg-warning">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_seller"))}</span>`);
          } else {
            _push(`<!---->`);
          }
          if (item.status == "awaiting_receipt_from_seller") {
            _push(`<span class="badge bg-purple">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_receipt_from_seller"))}</span>`);
          } else {
            _push(`<!---->`);
          }
          if (item.status == "ready_to_send") {
            _push(`<span class="badge bg-success">${ssrInterpolate(_ctx.$t("messages.sentence.ready_to_send"))}</span>`);
          } else {
            _push(`<!---->`);
          }
          if (item.status == "sent") {
            _push(`<span class="badge bg-success">${ssrInterpolate(_ctx.$t("messages.word.sent"))}</span>`);
          } else {
            _push(`<!---->`);
          }
          if (item.status == "delivered") {
            _push(`<span class="badge bg-success">${ssrInterpolate(_ctx.$t("messages.word.delivered"))}</span>`);
          } else {
            _push(`<!---->`);
          }
          if (item.status == "cancelled") {
            _push(`<span class="badge bg-danger">${ssrInterpolate(_ctx.$t("messages.word.cancelled"))}</span>`);
          } else {
            _push(`<!---->`);
          }
          if (item.status == "returned") {
            _push(`<span class="badge bg-danger">${ssrInterpolate(_ctx.$t("messages.word.returned"))}</span>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</td><td class="dropdown"><i class="ri-more-2-fill" data-bs-toggle="dropdown"></i><div class="dropdown-menu shadow-smooth-2"><ul><li><a href="javascript:void(0)" data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#action-" + item.id)} class="dropdown-item no-btn"><i class="ri-wallet-3-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.financial_statistic"))}</a></li>`);
          if (item.status != "delivered" && item.status != "sent" && item.status != "cancelled" && item.status != "returned") {
            _push(`<li>`);
            if (!_ctx.is_digipay_upg) {
              _push(`<a href="javascript:void(0)" data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#cancel-item-" + item.id)} class="dropdown-item no-btn"><i class="ri-close-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.cancel_product"))}</a>`);
            } else {
              _push(`<!---->`);
            }
            _push(`</li>`);
          } else {
            _push(`<!---->`);
          }
          if (item.status != "delivered" && item.status != "sent" && item.status != "cancelled" && item.status != "returned") {
            _push(`<li>`);
            if (_ctx.is_snapppay && item.count > 1) {
              _push(`<a href="javascript:void(0)" data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#cancel-item-count-" + item.id)} class="dropdown-item no-btn"><i class="ri-close-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.cancel_product_count"))}</a>`);
            } else {
              _push(`<!---->`);
            }
            _push(`</li>`);
          } else {
            _push(`<!---->`);
          }
          if (item.status == "cancelled") {
            _push(`<li><a href="javascript:void(0)" data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#cancellation-reason-" + item.id)} class="dropdown-item no-btn"><i class="ri-information-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.product_cancellation_reason"))}</a></li>`);
          } else {
            _push(`<!---->`);
          }
          if (item.status == "sent") {
            _push(`<li>`);
            if (!_ctx.is_snapppay) {
              _push(`<a href="javascript:void(0)" data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#return-item-" + item.id)} class="dropdown-item no-btn"><i class="ri-arrow-go-back-line"></i> ${ssrInterpolate(_ctx.$t("messages.word.return"))}</a>`);
            } else {
              _push(`<!---->`);
            }
            _push(`</li>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</ul></div><div class="modal fade"${ssrRenderAttr("id", "action-" + item.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.financial_statistic"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12">`);
          if (item.status == "cancelled" || item.status == "returned") {
            _push(`<div class="mb-3"><span class="fs-8 fw-bold text-danger lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_411125"))}</span></div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<div class="table-responsive"><table class="table mb-4" style="${ssrRenderStyle({ "width": "100%", "min-width": "100%" })}"><tbody><tr><td class="lts-05">${ssrInterpolate(_ctx.$t("messages.word.price"))} <span class="fs-10 text-gray fw-normal">(${ssrInterpolate(_ctx.$t("messages.sentence.each_unit"))})</span></td><td>${ssrInterpolate(unref(useNumberFormat)(item.price + item.discount))} <span class="unit unit-sm"></span></td></tr><tr><td class="lts-05">${ssrInterpolate(_ctx.$t("messages.word.discount"))} <span class="fs-10 text-gray fw-normal">(${ssrInterpolate(_ctx.$t("messages.sentence.each_unit"))})</span></td><td class="text-danger">${ssrInterpolate(unref(useNumberFormat)(item.discount))} `);
          if (item.discount > 0) {
            _push(`<span class="unit-red unit-sm"></span>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</td></tr><tr><td class="lts-05">${ssrInterpolate(_ctx.$t("messages.word.count"))}</td><td>${ssrInterpolate(unref(useNumberFormat)(item.count))}</td></tr><tr><td class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.total_amount"))}</td><td>${ssrInterpolate(unref(useNumberFormat)((item.price + item.discount) * item.count))} <span class="unit unit-sm"></span></td></tr><tr><td class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.total_discount"))}</td><td class="text-danger">${ssrInterpolate(unref(useNumberFormat)(item.discount * item.count))} `);
          if (item.discount > 0) {
            _push(`<span class="unit-red unit-sm"></span>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</td></tr><tr><td class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.total_paid_amount"))}</td><td>${ssrInterpolate(unref(useNumberFormat)(item.price * item.count))} <span class="unit unit-sm"></span></td></tr></tbody></table>`);
          if (item.get_shares.affiliate_information != null) {
            _push(`<!--[--><span class="mb-2 fw-bold lts-05 fs-8 d-flex">${ssrInterpolate(_ctx.$t("messages.sentence.affiliate_share"))}</span><table class="table" style="${ssrRenderStyle({ "width": "100%", "min-width": "100%" })}"><tbody><tr><td class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.sales_associate"))}</td><td><a${ssrRenderAttr("href", _ctx.route("admin.users.show", item.get_shares.affiliate_information.user.id))} class="link" target="_blank">${ssrInterpolate(item.get_shares.affiliate_information.user.get_name)}</a></td></tr><tr><td class="lts-05">${ssrInterpolate(_ctx.$t("messages.word.level"))}</td><td>`);
            if (item.get_shares.affiliate_information.user.get_level == "bronze") {
              _push(`<span>${ssrInterpolate(_ctx.$t("messages.word.bronze"))}</span>`);
            } else {
              _push(`<!---->`);
            }
            if (item.get_shares.affiliate_information.user.get_level == "silver") {
              _push(`<span>${ssrInterpolate(_ctx.$t("messages.word.silver"))}</span>`);
            } else {
              _push(`<!---->`);
            }
            if (item.get_shares.affiliate_information.user.get_level == "gold") {
              _push(`<span>${ssrInterpolate(_ctx.$t("messages.word.gold"))}</span>`);
            } else {
              _push(`<!---->`);
            }
            _push(`</td></tr><tr><td class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.affiliate_commission"))}</td><td>${ssrInterpolate(item.get_shares.affiliate_information.commission)}%</td></tr><tr><td class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.share_amount"))}</td><td>${ssrInterpolate(unref(useNumberFormat)(item.get_shares.affiliate))} <span class="unit unit-sm"></span></td></tr></tbody></table><span class="text-gray lts-05 fs-9 d-flex mb-4">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_548184"))}</span><!--]-->`);
          } else {
            _push(`<!---->`);
          }
          if (item.store != null) {
            _push(`<!--[--><span class="mb-2 fw-bold lts-05 fs-8 d-flex">${ssrInterpolate(_ctx.$t("messages.sentence.main_shop_share"))}</span><table class="table mb-4" style="${ssrRenderStyle({ "width": "100%", "min-width": "100%" })}"><tbody><tr><td class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.main_shop_commission"))}</td><td>${ssrInterpolate(item.product.commission)}%</td></tr><tr><td class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.share_amount"))}</td><td>${ssrInterpolate(unref(useNumberFormat)(item.get_shares.shop))} <span class="unit unit-sm"></span></td></tr></tbody></table><!--]-->`);
          } else {
            _push(`<!---->`);
          }
          if (item.store != null) {
            _push(`<!--[--><span class="mb-2 fw-bold lts-05 fs-8 d-flex">${ssrInterpolate(_ctx.$t("messages.sentence.seller_share"))}</span><table class="table" style="${ssrRenderStyle({ "width": "100%", "min-width": "100%" })}"><tbody><tr><td class="lts-05">${ssrInterpolate(_ctx.$t("messages.word.seller"))}</td>`);
            if (item.store != null) {
              _push(`<td><a${ssrRenderAttr("href", _ctx.route("admin.stores.show", item.store.uuid))} class="link ms-1" target="_blank">${ssrInterpolate(item.store.name)}</a></td>`);
            } else {
              _push(`<td><span class="fw-bold">${ssrInterpolate(_ctx.$t("messages.sentence.main_shop"))}</span></td>`);
            }
            _push(`</tr><tr><td class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.share_amount"))}</td><td>${ssrInterpolate(unref(useNumberFormat)(item.get_shares.seller))} <span class="unit unit-sm"></span></td></tr></tbody></table><!--]-->`);
          } else {
            _push(`<!---->`);
          }
          _push(`</div></div></div></div><div class="modal-footer"><button class="btn btn-primary" type="button" data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(_ctx.$t("messages.word.close"))}</button></div></div></div></div><div class="modal fade"${ssrRenderAttr("id", "cancel-item-" + item.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><form><div class="modal-content"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.cancel_product"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12"><div class="row"><div class="col-12 mb-1"><label for="eaFirstName" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.reason"))}: </label><textarea type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.write_product_cancellation_reason") + " ...")} class="form-control" name="reason" id="eaFirstName">${ssrInterpolate(unref(cancelProductForm).reason)}</textarea></div><div class="col-12 mb-4"><span class="fs-9 text-gray lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_466589"))}</span></div><div class="mb-3"><span class="fs-8 fw-bold text-danger lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_478525"))}</span></div></div></div></div></div><div class="modal-footer"><button class="btn btn-light" type="button" data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(_ctx.$t("messages.word.cancel"))}</button><button class="btn btn-danger" type="submit">${ssrInterpolate(_ctx.$t("messages.sentence.cancel_product"))}</button></div></div></form></div></div><div class="modal fade"${ssrRenderAttr("id", "cancel-item-count-" + item.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><form><div class="modal-content"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.cancel_product"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12"><div class="row">`);
          if (_ctx.is_snapppay) {
            _push(`<div class="col-12 mb-4"><label for="eaFirstName" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.cancel_count"))}: </label>`);
            _push(ssrRenderComponent(_sfc_main$3, {
              modelValue: unref(cancelProductCountForm).count,
              "onUpdate:modelValue": ($event) => unref(cancelProductCountForm).count = $event,
              required: "",
              style: { "direction": "ltr" }
            }, null, _parent));
            _push(`</div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<div class="mb-3"><span class="fs-8 fw-bold text-danger lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_478525"))}</span></div></div></div></div></div><div class="modal-footer"><button class="btn btn-light" type="button" data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(_ctx.$t("messages.word.cancel"))}</button><button class="btn btn-danger" type="submit">${ssrInterpolate(_ctx.$t("messages.word.apply"))}</button></div></div></form></div></div>`);
          if (item.status == "cancelled") {
            _push(`<div class="modal fade"${ssrRenderAttr("id", "cancellation-reason-" + item.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><div class="modal-header"><div class="modal-title lts-05 fs-5 text-danger">${ssrInterpolate(_ctx.$t("messages.sentence.product_cancellation_reason"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12"><div class="row"><div class="col-12 mb-4"><span class="lts-05 lh-30">${unref(useNl2br)(item.reason) ?? ""}</span></div></div></div></div></div><div class="modal-footer"><button class="btn btn-light" type="button" data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(_ctx.$t("messages.word.close"))}</button></div></div></div></div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<div class="modal fade"${ssrRenderAttr("id", "return-item-" + item.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.return_product"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12"><div class="mb-2"><span class="d-block fw-bold text-danger lh-25 mb-1">${ssrInterpolate(_ctx.$t("messages.word.important"))}:</span><span class="d-block fw-normal text-dark lts-05 lh-25 mb-2">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_599023"))}</span><span class="d-block fw-normal text-dark lts-05 lh-25 mb-2">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_207025"))}</span><span class="d-block fw-normal text-dark lts-05 lh-25 mb-2">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_487052"))}</span><span class="d-block fw-normal text-dark lts-05 lh-25">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_150890"))}</span></div><div class="mb-3"><span class="d-block fw-bold text-dark lts-05 lh-25">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_980021"))}</span></div></div></div></div><div class="modal-footer"><form><button class="btn btn-light me-2" type="button" data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(_ctx.$t("messages.word.cancel"))}</button><button class="btn btn-danger" type="submit">${ssrInterpolate(_ctx.$t("messages.word.return"))}</button></form></div></div></div></div></td></tr>`);
        });
        _push(`<!--]--></tbody></table>`);
        if (consignment.store != null && consignment.is_all_product_sent && consignment.is_products_awaiting_receipt_from_seller) {
          _push(`<div class="message-box mt-3"><span class="d-flex text-gray lts-05 fs-8 mb-2">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_114421"))}</span><span class="d-flex text-dark fs-8 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.post_tracking_code"))}: ${ssrInterpolate(consignment.tracking_code)}</span></div>`);
        } else {
          _push(`<!---->`);
        }
        if (consignment.store != null && consignment.status == "awaiting_seller") {
          _push(`<div class="message-box mt-3"><span class="d-flex text-warning lts-05 fs-8 mb-2">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_584785"))}</span><span class="d-flex text-dark fs-8 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.submited_storage_address"))}: <span class="fw-bold ms-1 text-info clickable" data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#submitted-main-storage-" + consignment.id)}>${ssrInterpolate(_ctx.$t("messages.word.show"))}</span></span><div class="modal fade"${ssrRenderAttr("id", "submitted-main-storage-" + consignment.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.submited_storage_address"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12"><div class="table-responsive mb-1"><table class="table" style="${ssrRenderStyle({ "width": "100%", "min-width": "100%" })}"><tbody><tr><td class="white-space-nowrap">${ssrInterpolate(_ctx.$t("messages.word.town"))}</td><td>${ssrInterpolate(consignment.get_address.state.replace("استان", ""))}</td></tr><tr><td class="white-space-nowrap">${ssrInterpolate(_ctx.$t("messages.word.city"))}</td><td>${ssrInterpolate(consignment.get_address.city)}</td></tr><tr><td class="white-space-nowrap">${ssrInterpolate(_ctx.$t("messages.word.postal_code"))}</td><td>${ssrInterpolate(consignment.get_address.postal_code)}</td></tr><tr><td class="white-space-nowrap">${ssrInterpolate(_ctx.$t("messages.sentence.full_address"))}</td><td>${ssrInterpolate(consignment.get_address.full_address)}</td></tr><tr><td class="white-space-nowrap">${ssrInterpolate(_ctx.$t("messages.word.telephone"))}</td><td>${ssrInterpolate(consignment.get_address.phone)}</td></tr></tbody></table></div><span class="d-flex text-gray lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_544784"))}</span></div></div></div><div class="modal-footer"><button class="btn btn-light" type="button" data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(_ctx.$t("messages.word.close"))}</button></div></div></div></div></div>`);
        } else {
          _push(`<!---->`);
        }
        if (consignment.status == "cancelled") {
          _push(`<div class="message-box mt-3"><span class="d-flex text-danger fw-bold fs-8 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_478854"))}</span></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div></div>`);
      });
      _push(`<!--]--></div>`);
      if (_ctx.order.status == "registered") {
        _push(`<div class="user-order-item-footer row mb-3"><div class="col-12 d-flex align-item-center justify-content-end">`);
        if (_ctx.order.get_address["type"] == "user" && _ctx.order.send_by == null) {
          _push(`<a${ssrRenderAttr("href", _ctx.route("admin.orders.send_sticker", _ctx.order.id))} target="_blank" class="btn btn-link user-order-detail-link fs-8 lts-05 me-4"><i class="ri-emoji-sticker-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.print_send_sticker"))}</a>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<a href="javascript:void(0)" data-bs-toggle="modal" data-bs-target="#changeOrderStatus" class="btn btn-link fw-bold user-order-detail-link lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.change_status"))} <i class="ri-arrow-left-s-fill"></i></a></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.order.status == "registered") {
        _push(`<div class="modal fade" id="changeOrderStatus" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-lg modal-dialog-centered"><div class="modal-content modal-order-status"><div class="modal-header pt-2"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.change_order_status"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row">`);
        if (_ctx.order.send_by != null) {
          _push(`<div class="col-12 mb-3"><span class="d-inline-block alert alert-info fs-8 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_597785"))}</span></div>`);
        } else {
          _push(`<!---->`);
        }
        if (!_ctx.order.is_all_item_cancelled && _ctx.order.send_by == null) {
          _push(`<div class="col-md-6 col-6 mb-3"><div class="${ssrRenderClass({ "order-status-label": true, sent: unref(changeOrderStatusForm).status == "sent" })}">${ssrInterpolate(_ctx.$t("messages.word.the_sent"))}</div></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="${ssrRenderClass({
          "col-md-6 col-6 mb-3": !_ctx.order.is_all_item_cancelled && _ctx.order.send_by == null,
          "col-12 mb-3": _ctx.order.is_all_item_cancelled && _ctx.order.send_by != null
        })}"><div class="${ssrRenderClass({ "order-status-label": true, cancelled: unref(changeOrderStatusForm).status == "cancelled" })}">${ssrInterpolate(_ctx.$t("messages.word.the_cancelled"))}</div></div>`);
        if (unref(changeOrderStatusForm).status == "sent" && _ctx.order.send_by == null) {
          _push(`<div class="col-12 mt-4">`);
          if (!_ctx.order.is_all_item_cancelled) {
            _push(`<!--[-->`);
            if (_ctx.order.is_ready_to_send) {
              _push(`<div class="row">`);
              if (_ctx.order.get_total_bill.cancel.price > 0) {
                _push(`<!--[-->`);
                if (_ctx.payment_transaction && _ctx.is_snapppay) {
                  _push(`<div><p class="text-dark-auto">${_ctx.$t("messages.sentence.msg_id_7451254012", { gateway: _ctx.payment_transaction.payment_gateway + "" }) ?? ""}</p></div>`);
                } else {
                  _push(`<div class="col-12 mb-4"><span class="lts-05 lh-30 text-dark-auto">${_ctx.$t("messages.sentence.cancelled_bill_return_to_user_amount", {
                    amount: unref(useNumberFormat)(_ctx.order.get_total_bill.cancel.price)
                  }) ?? ""}</span></div>`);
                }
                _push(`<div class="col-12 mb-4"><div class="border"></div></div><!--]-->`);
              } else {
                _push(`<!---->`);
              }
              if (_ctx.order.get_consolidated_shares.seller.length > 0 || _ctx.order.get_consolidated_shares.affiliate.length > 0) {
                _push(`<!--[--><div class="col-12 mb-3"><span class="text-dark fs-7 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_580025"))}</span></div><div class="col-12 mb-2"><div class="table-responsive"><table class="table" style="${ssrRenderStyle({ "width": "100%", "min-width": "100%" })}"><tbody><!--[-->`);
                ssrRenderList(_ctx.order.get_consolidated_shares.seller, (seller) => {
                  _push(`<tr><td class="lts-05"><span class="text-gray fs-8 me-1">${ssrInterpolate(_ctx.$t("messages.word.seller"))}</span>`);
                  _push(ssrRenderComponent(unref(Link), {
                    href: _ctx.route("admin.stores.show", seller.information.id),
                    class: "link"
                  }, {
                    default: withCtx((_, _push2, _parent2, _scopeId) => {
                      if (_push2) {
                        _push2(`${ssrInterpolate(seller.information.name)}`);
                      } else {
                        return [
                          createTextVNode(toDisplayString(seller.information.name), 1)
                        ];
                      }
                    }),
                    _: 2
                  }, _parent));
                  _push(`</td><td class="lts-05">${ssrInterpolate(unref(useNumberFormat)(seller.share))} <span class="currency">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span></td></tr>`);
                });
                _push(`<!--]--><!--[-->`);
                ssrRenderList(_ctx.order.get_consolidated_shares.affiliate, (affiliate) => {
                  _push(`<tr><td class="lts-05"><span class="text-gray fs-8 me-1">${ssrInterpolate(_ctx.$t("messages.sentence.sales_associate"))}</span>`);
                  _push(ssrRenderComponent(unref(Link), {
                    href: _ctx.route("admin.users.show", affiliate.information.id),
                    class: "link"
                  }, {
                    default: withCtx((_, _push2, _parent2, _scopeId) => {
                      if (_push2) {
                        _push2(`${ssrInterpolate(affiliate.information.get_name)}`);
                      } else {
                        return [
                          createTextVNode(toDisplayString(affiliate.information.get_name), 1)
                        ];
                      }
                    }),
                    _: 2
                  }, _parent));
                  _push(`</td><td class="lts-05">${ssrInterpolate(unref(useNumberFormat)(affiliate.share))} <span class="currency">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span></td></tr>`);
                });
                _push(`<!--]--></tbody></table></div></div><div class="col-12 mb-4"><span class="text-dark fs-7 lh-30 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_547850"))}</span></div><div class="col-12 mb-4"><div class="border"></div></div><!--]-->`);
              } else {
                _push(`<!---->`);
              }
              if (_ctx.order.get_address["type"] != "shop") {
                _push(`<!--[--><div class="col-12 mb-2"><label for="eaTrackingCode" class="form-label">${ssrInterpolate(_ctx.order.get_send_method["type"] == "post" && _ctx.order.get_send_method["item"]["uuid"] == "peyk" ? _ctx.$t("messages.sentence.courier_phone_number") : _ctx.$t("messages.sentence.post_tracking_code"))}:</label><input${ssrRenderAttr("value", unref(changeOrderStatusForm).tracking_code)} type="text" required class="form-control" name="tracking_code" id="eaTrackingCode"></div><div class="col-12 mb-4"><span class="description fs-8 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_784596"))}</span></div><!--]-->`);
              } else {
                _push(`<div class="col-12 mb-2"><span class="lts-05">${_ctx.$t("messages.sentence.order_delivered_status_message", {
                  status: `<span class='fw-bold text-success'>` + _ctx.$t("messages.sentence.receive_in_person") + `</span>`,
                  button: `<span class='fw-bold text-primary'>` + _ctx.$t("messages.word.delivered") + `</span>`
                }) ?? ""}</span></div>`);
              }
              _push(`</div>`);
            } else {
              _push(`<div class="row"><div class="col-12 ps-4 pe-4"><span class="text-danger fw-bold me-1">${ssrInterpolate(_ctx.$t("messages.word.attention"))}:</span><span class="lts-05 text-dark lh-30">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_588963"))}</span></div></div>`);
            }
            _push(`<!--]-->`);
          } else {
            _push(`<!---->`);
          }
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        if (unref(changeOrderStatusForm).status == "cancelled") {
          _push(`<div class="col-12 mt-4"><div class="row">`);
          if (_ctx.payment_transaction && (_ctx.is_snapppay || _ctx.is_digipay_upg)) {
            _push(`<div><p class="text-dark-auto">${_ctx.$t("messages.sentence.msg_id_54812069", { gateway: _ctx.payment_transaction.payment_gateway + "" }) ?? ""}</p></div>`);
          } else {
            _push(`<div class="col-12 mb-4"><span class="text-dark-auto lts-05 lh-30">${_ctx.$t("messages.sentence.cancelled_bill_return_to_user_amount", {
              amount: unref(useNumberFormat)(
                _ctx.order.get_total_bill.price + _ctx.order.get_total_bill.send_price - (_ctx.order.get_discount != null ? _ctx.order.get_discount["amount"] : 0)
              )
            }) ?? ""}</span></div>`);
          }
          _push(`<div class="col-12 mb-4"><div class="border"></div></div><div class="col-12 mb-2"><label for="eaReason" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.order_cancelling_reason"))}: </label><textarea type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.write_order_cancelling_reason") + " ...")} required class="form-control" name="reason" id="eaReason" rows="4">${ssrInterpolate(unref(changeOrderStatusForm).reason)}</textarea></div><div class="col-12 mb-4"><span class="description fs-8 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_874525"))}</span></div></div></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div></div>`);
        if (unref(changeOrderStatusForm).status != "") {
          _push(`<div class="modal-footer">`);
          if (unref(changeOrderStatusForm).status == "sent") {
            _push(`<!--[-->`);
            if (_ctx.order.is_ready_to_send) {
              _push(`<div class="col-12 d-flex align-items-center justify-content-end"><button data-bs-toggle="modal" data-bs-target="#changeOrderStatusConfirm" type="button" class="btn btn-primary lts-05 shadow-1">${ssrInterpolate(_ctx.order.get_address["type"] != "shop" ? _ctx.$t("messages.word.apply") : _ctx.$t("messages.word.delivered"))}</button></div>`);
            } else {
              _push(`<!---->`);
            }
            _push(`<!--]-->`);
          } else {
            _push(`<div class="col-12 d-flex align-items-center justify-content-end"><button data-bs-toggle="modal" data-bs-target="#changeOrderStatusConfirm" type="button" class="btn btn-primary lts-05 shadow-1">${ssrInterpolate(_ctx.$t("messages.word.apply"))}</button></div>`);
          }
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="modal fade" id="changeOrderStatusConfirm" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.confirm_change_order_status_title"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12 mb-4"><span class="fw-bold text-danger lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.confirm_change_order_status"))}</span></div></div></div><div class="modal-footer"><button type="button" class="btn btn-sm btn-danger px-3" data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(_ctx.$t("messages.word.cancel"))}</button><button type="submit" class="btn btn-sm btn-success px-3" data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(_ctx.$t("messages.word.confirm"))}</button></div></form></div></div></div></div></div></div></div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Orders/Show.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
