import { defineComponent, unref, withCtx, createBlock, createCommentVNode, openBlock, toDisplayString, useSSRContext } from "vue";
import { ssrRenderComponent, ssrRenderStyle, ssrInterpolate, ssrRenderList, ssrRenderAttr } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./AdminLayout-CD07IMsK.js";
import { Head, Link } from "@inertiajs/vue3";
import { _ as _sfc_main$3 } from "./Pagination-C1AQrLe3.js";
import { _ as _sfc_main$2 } from "./Files-B6eiTnN6.js";
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "laravel-vue-i18n";
import "./SearchList-BZnYMQPN.js";
import "lodash/debounce.js";
import "./useRandomNum-DNNSqR7b.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Sessions",
  __ssrInlineRender: true,
  props: {
    sessions: {},
    current_session: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.active_sessions")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.word.sessions")
      }, null, _parent));
      _push(`<div class="user-list list mb-4"><div class="card"><div class="card-body"><div class="table-responsive mb-4"><table class="table" style="${ssrRenderStyle({ "min-width": "900px" })}"><thead><tr><th>${ssrInterpolate(_ctx.$t("messages.word.device"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.location"))}</th><th>${ssrInterpolate(_ctx.$t("messages.sentence.ip_identifier"))}</th><th>${ssrInterpolate(_ctx.$t("messages.sentence.login_time"))}</th><th class="first-small"><i class="ri-settings-4-line"></i></th></tr></thead><tbody><!--[-->`);
      ssrRenderList(_ctx.sessions.data, (session) => {
        _push(`<tr><td>`);
        if (_ctx.current_session == session.id) {
          _push(`<div class="w-100 d-block mb-2"><span class="badge bg-success">${ssrInterpolate(_ctx.$t("messages.sentence.current_session"))}</span></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="w-100 d-block mb-2"><span>${ssrInterpolate(_ctx.$t("messages.word.browser"))}:</span> ${ssrInterpolate(session.full_meta.browser)}</div><div class="w-100 d-block"><span>${ssrInterpolate(_ctx.$t("messages.word.operation_system"))}:</span> ${ssrInterpolate(session.full_meta.platform)}</div></td>`);
        if (session.full_meta.location != null) {
          _push(`<td><div class="w-100 d-block mb-2"><span>${ssrInterpolate(_ctx.$t("messages.word.country"))}:</span> ${ssrInterpolate(session.full_meta.location.country)}</div><div class="w-100 d-block"><span>${ssrInterpolate(_ctx.$t("messages.word.city"))}:</span> ${ssrInterpolate(session.full_meta.location.city)}</div></td>`);
        } else {
          _push(`<td><div class="w-100 d-block mb-2"><span>${ssrInterpolate(_ctx.$t("messages.word.country"))}:</span> ${ssrInterpolate(_ctx.$t("messages.word.unknown"))}</div><div class="w-100 d-block"><span>${ssrInterpolate(_ctx.$t("messages.word.city"))}:</span> ${ssrInterpolate(_ctx.$t("messages.word.unknown"))}</div></td>`);
        }
        _push(`<td>${ssrInterpolate(session.ip)}</td><td>${ssrInterpolate(session.jalali_created_at[2])}</td><td class="dropdown"><i class="ri-more-2-fill" data-bs-toggle="dropdown"></i><div class="dropdown-menu shadow-smooth-2"><ul>`);
        if (_ctx.current_session != session.id) {
          _push(`<li><a class="dropdown-item lts-05" href="javascript:void(0)" data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#terminate-session-" + session.id)}><i class="ri-delete-bin-line"></i> ${ssrInterpolate(_ctx.$t("messages.word.terminate"))}</a></li>`);
        } else if (_ctx.current_session == session.id) {
          _push(`<li><a class="dropdown-item lts-05" href="javascript:void(0)" data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#terminate-session-" + session.id)}><i class="ri-login-box-line"></i> ${ssrInterpolate(_ctx.$t("messages.word.logout"))}</a></li>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</ul></div><div class="modal fade"${ssrRenderAttr("id", "terminate-session-" + session.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form action="#" style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header">`);
        if (_ctx.current_session != session.id) {
          _push(`<div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.is_terminate_session"))}</div>`);
        } else if (_ctx.current_session == session.id) {
          _push(`<div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.is_logout"))}</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-footer">`);
        _push(ssrRenderComponent(unref(Link), {
          as: "button",
          href: _ctx.route("admin.profile.sessions.terminate", session.id),
          method: "delete",
          data: { session_id: session.id },
          class: "btn btn-sm btn-danger px-3",
          "data-bs-dismiss": "modal",
          "aria-label": "Close"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              if (_ctx.current_session != session.id) {
                _push2(`<span${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.terminate"))}</span>`);
              } else if (_ctx.current_session == session.id) {
                _push2(`<span${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.logout"))}</span>`);
              } else {
                _push2(`<!---->`);
              }
            } else {
              return [
                _ctx.current_session != session.id ? (openBlock(), createBlock("span", { key: 0 }, toDisplayString(_ctx.$t("messages.word.terminate")), 1)) : _ctx.current_session == session.id ? (openBlock(), createBlock("span", { key: 1 }, toDisplayString(_ctx.$t("messages.word.logout")), 1)) : createCommentVNode("", true)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</div></form></div></div></div></td></tr>`);
      });
      _push(`<!--]--></tbody></table></div>`);
      if (_ctx.sessions.data.length == 0) {
        _push(`<div class="product-list-empty"><div class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_sfc_main$3, {
        links: _ctx.sessions.links
      }, null, _parent));
      _push(`</div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Account/Sessions.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
