import { defineComponent, unref, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderStyle, ssrRenderAttr } from "vue/server-renderer";
/* empty css               */
import { Head } from "@inertiajs/vue3";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "SendSticker",
  __ssrInlineRender: true,
  props: {
    orderId: {},
    address: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.sentence.print_send_sticker") + " - " + _ctx.$page.props.appName
      }, null, _parent));
      _push(`<div class="page-wrapper"><div class="container"><div class="row"><div x-data class="col-12 d-flex align-items-center justify-content-between mt-5"><button class="btn btn-primary">${ssrInterpolate(_ctx.$t("messages.word.print"))} <i class="ri-printer-line"></i></button><div class="link back-to">${ssrInterpolate(_ctx.$t("messages.word.close"))} <i class="ri-arrow-left-s-fill"></i></div></div><div class="col-12 mt-4"><div id="printSendSticker" style="${ssrRenderStyle({ "direction": "rtl" })}"><table class="table" style="${ssrRenderStyle({ "border": "2px solid #eaeef2", "width": "100%", "min-width": "initial" })}"><tbody><tr><td class="text-start p-3"><div class="d-flex align-items-center justify-content-between mb-3"><div style="${ssrRenderStyle({ "font-size": "18px", "font-weight": "bold" })}">${ssrInterpolate(_ctx.$t("messages.word.sender"))}: ${ssrInterpolate(_ctx.$page.props.appName)}</div><img class="me-4"${ssrRenderAttr("src", _ctx.$page.props.appLogo)} alt="logo" style="${ssrRenderStyle({ "width": "80px", "height": "auto", "max-height": "40px" })}"></div><div><div class="d-inline-block me-3">${ssrInterpolate(_ctx.$t("messages.word.town"))}: ${ssrInterpolate(_ctx.$page.props.shopAddressTown)}</div><div class="d-inline-block me-3">${ssrInterpolate(_ctx.$t("messages.word.city"))}: ${ssrInterpolate(_ctx.$page.props.shopAddressCity)}</div><div class="d-inline-block">${ssrInterpolate(_ctx.$t("messages.sentence.full_address"))}: ${ssrInterpolate(_ctx.$page.props.shopAddress)}</div></div><div class="d-flex mt-3 w-100"><span>${ssrInterpolate(_ctx.$t("messages.word.postal_code"))}: ${ssrInterpolate(_ctx.$page.props.shopAddressPostalCode)}</span><span class="ms-4">${ssrInterpolate(_ctx.$t("messages.word.telephone"))}: ${ssrInterpolate(_ctx.$page.props.supportPhone)}</span></div></td></tr><tr><td style="${ssrRenderStyle({ "background": "white !important", "border-top": "2px solid #eaeef2" })}" class="text-start p-3" colspan="2"><div class="mb-4" style="${ssrRenderStyle({ "font-size": "18px", "font-weight": "bold" })}">${ssrInterpolate(_ctx.$t("messages.word.receiver"))}: ${ssrInterpolate(_ctx.address.first_name + " " + _ctx.address.last_name)}</div><div><div class="d-inline-block me-3">${ssrInterpolate(_ctx.$t("messages.word.town"))}: ${ssrInterpolate(_ctx.address.state)}</div><div class="d-inline-block me-3">${ssrInterpolate(_ctx.$t("messages.word.city"))}: ${ssrInterpolate(_ctx.address.city)}</div><div class="d-inline-block">${ssrInterpolate(_ctx.$t("messages.sentence.full_address"))}: ${ssrInterpolate(_ctx.address.full_address)}</div></div><div class="d-flex mt-3 w-100"><span>${ssrInterpolate(_ctx.$t("messages.word.postal_code"))}: ${ssrInterpolate(_ctx.address.postal_code)}</span><span class="ms-4">${ssrInterpolate(_ctx.$t("messages.word.telephone"))}: ${ssrInterpolate(_ctx.address.phone)}</span></div></td></tr></tbody></table></div></div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Orders/SendSticker.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
