import { defineComponent, resolveDirective, unref, withCtx, createTextVNode, toDisplayString, mergeProps, useSSRContext } from "vue";
import { ssrRenderComponent, ssrRenderStyle, ssrInterpolate, ssrRenderList, ssrRenderClass, ssrRenderAttrs, ssrGetDirectiveProps, ssrRenderAttr } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./AdminLayout-CD07IMsK.js";
import { Head, Link } from "@inertiajs/vue3";
import { _ as _sfc_main$3 } from "./SearchList-BZnYMQPN.js";
import { _ as _sfc_main$4 } from "./FilterList-CWxGcEKk.js";
import { _ as _sfc_main$5 } from "./Pagination-C1AQrLe3.js";
import { _ as _sfc_main$2 } from "./Files-B6eiTnN6.js";
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "lodash/debounce.js";
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "laravel-vue-i18n";
import "./useRandomNum-DNNSqR7b.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Sellers",
  __ssrInlineRender: true,
  props: {
    transactions: {},
    keyword: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      const _directive_tooltip = resolveDirective("tooltip");
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.seller_transaction_list")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.sentence.seller_transaction_list")
      }, null, _parent));
      _push(`<div class="user-list list mb-4"><div class="card"><div class="card-body">`);
      _push(ssrRenderComponent(_sfc_main$3, {
        keyword: _ctx.keyword,
        placeholder: _ctx.$t("messages.sentence.transaction_id") + " ..."
      }, null, _parent));
      _push(ssrRenderComponent(_sfc_main$4, {
        filters: {
          accepted: _ctx.$t("messages.word.successful"),
          rejected: _ctx.$t("messages.word.unsuccessful"),
          income: _ctx.$t("messages.word.income"),
          returned: _ctx.$t("messages.word.returns")
        }
      }, null, _parent));
      _push(`<div class="table-responsive simplebar-container mb-4"><table class="table" style="${ssrRenderStyle({ "min-width": "990px" })}"><thead><tr><th>${ssrInterpolate(_ctx.$t("messages.word.type"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.price"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.user"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.description"))}</th><th>${ssrInterpolate(_ctx.$t("messages.sentence.transaction_id"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.status"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.date"))}</th></tr></thead><tbody><!--[-->`);
      ssrRenderList(_ctx.transactions.data, (transaction) => {
        _push(`<tr><td>`);
        if (transaction.amount > 0) {
          _push(`<span class="text-success fw-bold fs-8">${ssrInterpolate(_ctx.$t("messages.word.deposit"))}</span>`);
        } else if (transaction.amount < 0 && transaction.type == "bank_withdrawal") {
          _push(`<span class="text-info fw-bold fs-8">${ssrInterpolate(_ctx.$t("messages.sentence.bank_withdrawal"))}</span>`);
        } else if (transaction.amount < 0) {
          _push(`<span class="text-danger fw-bold fs-8">${ssrInterpolate(_ctx.$t("messages.word.withdrawal"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</td><td class="white-space-nowrap">`);
        if (transaction.type == "seller_withdrawal" || transaction.type == "affiliate_withdrawal") {
          _push(`<span class="${ssrRenderClass({ "negative-number fw-bold": true, "text-info": true })}">${ssrInterpolate(transaction.get_formatted_amount.replace("-", ""))}</span>`);
        } else {
          _push(`<span class="${ssrRenderClass({ "negative-number fw-bold": true, "text-danger": transaction.amount < 0, "text-success": transaction.amount > 0 })}">${ssrInterpolate(transaction.get_formatted_amount)}</span>`);
        }
        _push(`<span class="currency">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span></td><td class="white-space-nowrap">`);
        _push(ssrRenderComponent(unref(Link), {
          class: "link",
          href: _ctx.route("admin.users.show", transaction.user.id)
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(transaction.user.get_name)}`);
            } else {
              return [
                createTextVNode(toDisplayString(transaction.user.get_name), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</td><td class="fs-8">${transaction.description ?? ""}</td><td><div class="d-flex align-items-center"><span class="lh-15">${ssrInterpolate(transaction.transaction_id)}</span>`);
        if (transaction.status == "accepted" && transaction.type == "user_charge") {
          _push(`<span${ssrRenderAttrs(mergeProps({
            class: "info-icon clickable ms-2",
            "data-bs-toggle": "modal",
            "data-bs-target": "#payment-information-" + transaction.id
          }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.sentence.payment_information"), void 0, { top: true })))}><i class="ri-file-info-line"></i></span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div><div class="modal fade"${ssrRenderAttr("id", "payment-information-" + transaction.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-lgs modal-dialog-centered"><div class="modal-content"><form style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.payment_information"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12"><div class="table-responsive"><table class="table" style="${ssrRenderStyle({ "width": "100%", "min-width": "100%" })}"><tbody><tr><td>${ssrInterpolate(_ctx.$t("messages.sentence.payment_gateway"))}</td><td>${ssrInterpolate(transaction.payment_gateway)}</td></tr><tr><td class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.payment_gateway_tracking_code"))}</td><td${ssrRenderAttrs(mergeProps({ class: "clickable" }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.sentence.copy_payment_uuid"), void 0, { top: true })))}>${ssrInterpolate(transaction.gateway_reference_id)}</td></tr></tbody></table></div></div></div></div><div class="modal-footer"><button class="btn btn-primary" type="button" data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(_ctx.$t("messages.word.close"))}</button></div></form></div></div></div></td><td>`);
        if (transaction.status == "waiting_admin") {
          _push(`<span class="badge bg-info rounded-pill fs-7">${ssrInterpolate(_ctx.$t("messages.word.awaiting_admin"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        if (transaction.status == "waiting_payment") {
          _push(`<span class="badge bg-info rounded-pill fs-7">${ssrInterpolate(_ctx.$t("messages.word.awaiting_pay"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        if (transaction.status == "accepted") {
          _push(`<span class="badge bg-success rounded-pill fs-7">${ssrInterpolate(_ctx.$t("messages.word.successful"))}</span>`);
        } else if (transaction.status == "rejected" && transaction.type != "seller_withdrawal" && transaction.type != "affiliate_withdrawal") {
          _push(`<span class="badge bg-danger rounded-pill fs-7">${ssrInterpolate(_ctx.$t("messages.word.unsuccessful"))}</span>`);
        } else if (transaction.status == "rejected" && transaction.type == "bank_withdrawal") {
          _push(`<span class="badge bg-danger rounded-pill fs-7">${ssrInterpolate(_ctx.$t("messages.word.rejected"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</td><td class="lts-05 fs-9 white-space-nowrap">${ssrInterpolate(transaction.jalali_created_at[2])}</td></tr>`);
      });
      _push(`<!--]--></tbody></table></div><div class="d-block bg-light br-10 mb-3 p-2"><ul class="list-description d-flex flex-wrap" style="${ssrRenderStyle({ "list-style": "none" })}"><li class="me-3"><span class="text-success fw-bold">${ssrInterpolate(_ctx.$t("messages.word.deposit"))}:</span> ${ssrInterpolate(_ctx.$t("messages.sentence.deposit_to_user_wallet"))}</li><li class="me-3"><span class="text-danger fw-bold">${ssrInterpolate(_ctx.$t("messages.word.withdrawal"))}:</span> ${ssrInterpolate(_ctx.$t("messages.sentence.withdrawal_from_user_wallet"))}</li><li class="me-3"><span class="text-info fw-bold lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.withdrawal_income"))}:</span> ${ssrInterpolate(_ctx.$t("messages.sentence.withdrawal_from_user_wallet"))}</li></ul></div>`);
      if (_ctx.transactions.data.length == 0) {
        _push(`<div class="product-list-empty"><div class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_sfc_main$5, {
        links: _ctx.transactions.links
      }, null, _parent));
      _push(`</div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Financial/Transactions/Sellers.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
