import { defineComponent, ref, watch, mergeProps, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrRenderAttr } from "vue/server-renderer";
import { router, usePage } from "@inertiajs/vue3";
import Debounce from "lodash/debounce.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "SearchList",
  __ssrInlineRender: true,
  props: {
    placeholder: {},
    keyword: {},
    s: { type: Boolean },
    routeParam: {}
  },
  setup(__props) {
    const props = __props;
    const $queryStrings = (...args) => {
      let queryString = usePage().url;
      if (queryString.indexOf("?") === -1) {
        return {};
      }
      queryString = queryString.substring(queryString.indexOf("?") + 1);
      let object = Object.fromEntries(new URLSearchParams(queryString));
      for (let qs in object) {
        if (qs == "page" || qs == "p") {
          delete object[qs];
        }
        continue;
      }
      return Object.assign(object, ...args);
    };
    const keyword = ref(props.keyword.search);
    watch(
      keyword,
      Debounce((value) => {
        let params = { ...$queryStrings(), search: value };
        if (props.s != void 0 && props.s) {
          params = { ...$queryStrings(), s: value };
        }
        if (value == null || value == "") {
          delete params["search"];
          delete params["s"];
        }
        router.get(route(usePage().props.currentRouteName, props.routeParam), params, { preserveState: true, replace: true });
      }, 300)
    );
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<form${ssrRenderAttrs(mergeProps({
        class: "search-file-container mb-3",
        action: "javascript:void(0)"
      }, _attrs))}><input${ssrRenderAttr("value", keyword.value)} class="form-control" type="text" name="keyword"${ssrRenderAttr("placeholder", _ctx.placeholder)}><button class="btn btn-primary" type="button"><i class="ri-search-2-line"></i></button></form>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Common/SearchList.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as _
};
