import { defineComponent, ref, watch, mergeProps, unref, withCtx, createTextVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrInterpolate, ssrRenderClass, ssrRenderAttr, ssrRenderComponent, ssrRenderStyle, ssrIncludeBooleanAttr, ssrLooseContain } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./AuthLayout-DZ-VIaI_.js";
import { useForm, Link } from "@inertiajs/vue3";
import { _ as _sfc_main$2 } from "./NumInput-Bt6uFGO4.js";
import Dropdown from "primevue/dropdown/dropdown.esm.js";
import NeshanMap from "@neshan-maps-platform/vue3-openlayers";
import "toastify-js";
import "./useToastify-D_n0s7Uc.js";
import "laravel-vue-i18n";
import "./useHexToRgb-G7J9N7Ap.js";
/* empty css             */
import "./useRandomStr-4MeWbtRd.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Register",
  __ssrInlineRender: true,
  props: {
    store: {},
    companyType: {}
  },
  setup(__props) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _i;
    const props = __props;
    const level = ref("account-status");
    const Map = ref();
    const registerSellerForm = useForm({
      // level
      level: level.value,
      // type
      type: props.store != null ? props.store.type : "",
      // genuine
      national_number: props.store != null && props.store.type == "genuine" ? props.store.get_information.national_number : "",
      national_card_image: null,
      // legal
      company_name: props.store != null && props.store.type == "legal" ? props.store.get_information.company_name : "",
      company_type: props.store != null && props.store.type == "legal" ? props.store.get_information.company_type_id : "",
      company_national_number: props.store != null && props.store.type == "legal" ? props.store.get_information.company_national_number : "",
      company_economic_number: props.store != null && props.store.type == "legal" ? props.store.get_information.company_economic_number : "",
      company_signatory: props.store != null && props.store.type == "legal" ? props.store.get_information.company_signatory : "",
      legal_identity_image: null,
      // both
      store_name: props.store != null ? props.store.name : "",
      bank_sheba: "",
      map: props.store != null && ((_a = props.store.get_information) == null ? void 0 : _a.map) !== void 0 ? props.store.get_information.map : { longitude: 54.36281969540723, latitude: 32.69672648316882, zoom: 4.7, selected: false },
      state: props.store != null && ((_c = (_b = props.store.get_information) == null ? void 0 : _b.address) == null ? void 0 : _c.state) !== void 0 ? props.store.get_information.address.state : "",
      city: props.store != null && ((_e = (_d = props.store.get_information) == null ? void 0 : _d.address) == null ? void 0 : _e.city) !== void 0 ? props.store.get_information.address.city : "",
      full_address: props.store != null && ((_g = (_f = props.store.get_information) == null ? void 0 : _f.address) == null ? void 0 : _g.full_address) !== void 0 ? props.store.get_information.address.full_address : "",
      postal_code: props.store != null && ((_i = (_h = props.store.get_information) == null ? void 0 : _h.address) == null ? void 0 : _i.postal_code) !== void 0 ? props.store.get_information.address.postal_code : ""
    });
    const mapResult = (event) => {
      var _a2;
      if (event.apiData !== void 0) {
        registerSellerForm.map.longitude = event.coords[0];
        registerSellerForm.map.latitude = event.coords[1];
        registerSellerForm.map.zoom = (_a2 = Map.value) == null ? void 0 : _a2.state.zoom;
        registerSellerForm.map.selected = true;
      }
    };
    watch(level, (value) => {
      if (value == "location" && registerSellerForm.map.selected == true) {
        setTimeout(() => {
          var _a2;
          (_a2 = Map.value) == null ? void 0 : _a2.reverse([registerSellerForm.map.longitude, registerSellerForm.map.latitude], {
            useMarker: true
          });
        }, 1500);
      }
    });
    const acceptRules = ref(false);
    ref();
    const nationalCardImageUrl = ref(props.store != null && props.store.get_information.national_card_image_url !== void 0 ? props.store.get_information.national_card_image_url : null);
    ref();
    const legalIdentityImageUrl = ref(props.store != null && props.store.get_information.legal_identity_image_url !== void 0 ? props.store.get_information.legal_identity_image_url : null);
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "container-fluid seller-register-container" }, _attrs))}><div class="auth-container seller-register"><div class="page-title mt-5">${ssrInterpolate(_ctx.$t("messages.sentence.sellers_register"))}</div><div class="page-description lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.seller_register_request_form"))} ${ssrInterpolate(_ctx.$page.props.appName)}</div><ul class="navigation-items"><li class="${ssrRenderClass({ item: true, active: level.value == "account-status", passed: level.value == "account-information" || level.value == "location" || level.value == "submit" })}"><div class="item-icon"></div><span class="item-text lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.account_type"))}</span></li><li class="${ssrRenderClass({ item: true, active: level.value == "account-information", passed: level.value == "location" || level.value == "submit" })}"><div class="item-icon"></div><span class="item-text lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.complete_information"))}</span></li><li class="${ssrRenderClass({ item: true, active: level.value == "location", passed: level.value == "submit" })}"><div class="item-icon"></div><span class="item-text lts-05">${ssrInterpolate(_ctx.$t("messages.word.address"))}</span></li><li class="${ssrRenderClass({ item: true, active: level.value == "submit" })}"><div class="item-icon"></div><span class="item-text lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.submit_request"))}</span></li></ul><div class="page-contents">`);
      if (level.value == "account-status") {
        _push(`<div class="row mb-5"><div class="form-box form-box-center col-md-6 col-12 mb-3"><div class="card shadow-1"><div class="card-body"><div class="form-title lts-05 mt-0 mb-3">${ssrInterpolate(_ctx.$t("messages.sentence.genuine_seller"))}</div><p class="desc lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.genuine_seller_description"))}</p><button class="btn btn-primary lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.i_am_genuine_seller"))} <i class="ri-arrow-left-s-line"></i></button></div></div></div><div class="form-box form-box-center col-md-6 col-12 mb-3"><div class="card shadow-1"><div class="card-body"><div class="form-title lts-05 mt-0 mb-3">${ssrInterpolate(_ctx.$t("messages.sentence.legal_seller"))}</div><p class="desc lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.legal_seller_description"))}</p><button class="btn btn-primary lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.i_am_legal_seller"))} <i class="ri-arrow-left-s-line"></i></button></div></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (level.value == "account-information") {
        _push(`<div class="row mb-5">`);
        if (unref(registerSellerForm).type == "genuine") {
          _push(`<div class="form-box col-12 mb-3"><div class="card shadow-1"><div class="card-body"><div class="form-title lts-05 mt-0 mb-3"><i class="back-button ri-arrow-right-line me-3"></i><div>${ssrInterpolate(_ctx.$t("messages.sentence.genuine_seller_complete_information"))}</div></div><p class="desc lts-05 alert alert-light d-inline-flex">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_548524"))}</p><div class="row mb-3"><div class="col-sm-6 col-12 mb-4"><label for="eaStoreName" class="form-label required">${ssrInterpolate(_ctx.$t("messages.sentence.store_title"))}</label><input${ssrRenderAttr("value", unref(registerSellerForm).store_name)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.msg_id_985532") + " ...")} required class="form-control" id="eaStoreName"><span class="form-control-description">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_478552"))}</span></div><div class="col-sm-6 col-12 mb-4"><label for="eaNationalNumber" class="form-label required">${ssrInterpolate(_ctx.$t("messages.word.national_number"))}</label>`);
          _push(ssrRenderComponent(_sfc_main$2, {
            modelValue: unref(registerSellerForm).national_number,
            "onUpdate:modelValue": ($event) => unref(registerSellerForm).national_number = $event,
            type: "text",
            placeholder: _ctx.$t("messages.sentence.msg_id_658952"),
            minlength: "10",
            maxlength: "10",
            class: "form-control",
            id: "eaNationalNumber",
            required: ""
          }, null, _parent));
          _push(`</div><div class="col-sm-6 col-12 mb-4"><span class="form-label mb-2 d-flex lts-05 text-dark required">${ssrInterpolate(_ctx.$t("messages.sentence.national_card_image"))}</span><label class="identity-documents clickable" for="nationalCardInput">`);
          if (nationalCardImageUrl.value != null) {
            _push(`<img${ssrRenderAttr("src", nationalCardImageUrl.value)}>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<input type="file" class="custom-input-file-input" id="nationalCardInput" accept=".png,.jpg,.jpeg">`);
          if (nationalCardImageUrl.value == null) {
            _push(`<div class="d-flex flex-column align-items-center justify-content-center"><span class="fw-bold lts-05 mb-2">${ssrInterpolate(_ctx.$t("messages.sentence.national_card_image_hint"))}</span><span class="lts-05 fs-8 text-gray mb-4">${ssrInterpolate(_ctx.$t("messages.sentence.national_card_image_upload_hint"))}</span><div class="select-image"><span class="label"><i class="ri-arrow-up-fill me-1"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.select_image"))}</span></div></div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</label></div></div><div class="d-flex align-item-center justify-content-end"><button class="btn btn-primary lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.next_step"))} <i class="ri-arrow-left-s-line"></i></button></div></div></div></div>`);
        } else {
          _push(`<!---->`);
        }
        if (unref(registerSellerForm).type == "legal") {
          _push(`<div class="form-box col-12 mb-3"><div class="card shadow-1"><div class="card-body"><div class="form-title lts-05 mt-0 mb-3"><i class="back-button ri-arrow-right-line me-3"></i><div>${ssrInterpolate(_ctx.$t("messages.sentence.legal_seller_complete_information"))}</div></div><p class="desc lts-05 alert alert-light d-inline-flex">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_554125"))}</p><div class="row mb-3"><div class="col-sm-6 col-12 mb-4"><label for="eaCompanyStoreName" class="form-label required">${ssrInterpolate(_ctx.$t("messages.sentence.store_title"))}</label><input${ssrRenderAttr("value", unref(registerSellerForm).store_name)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.msg_id_985532") + " ...")} required class="form-control" id="eaCompanyStoreName"><span class="form-control-description">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_478552"))}</span></div><div class="col-sm-6 col-12 mb-4"><label for="eaCompanyName" class="form-label required">${ssrInterpolate(_ctx.$t("messages.sentence.company_name"))}</label><input${ssrRenderAttr("value", unref(registerSellerForm).company_name)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.company_name"))} required class="form-control" id="eaCompanyName"></div><div class="col-sm-6 col-12 mb-4"><label class="form-label required">${ssrInterpolate(_ctx.$t("messages.sentence.company_type"))}</label>`);
          _push(ssrRenderComponent(unref(Dropdown), {
            modelValue: unref(registerSellerForm).company_type,
            "onUpdate:modelValue": ($event) => unref(registerSellerForm).company_type = $event,
            options: _ctx.companyType,
            optionLabel: "label",
            optionValue: "id",
            placeholder: _ctx.$t("messages.sentence.select_company_type"),
            type: "text",
            readonly: "",
            class: "pvc-dropdown"
          }, null, _parent));
          _push(`</div><div class="col-sm-6 col-12 mb-4"><label for="eaCompanyNationalNumber" class="form-label required">${ssrInterpolate(_ctx.$t("messages.sentence.company_national_number"))}</label>`);
          _push(ssrRenderComponent(_sfc_main$2, {
            modelValue: unref(registerSellerForm).company_national_number,
            "onUpdate:modelValue": ($event) => unref(registerSellerForm).company_national_number = $event,
            type: "text",
            placeholder: _ctx.$t("messages.sentence.company_national_number"),
            required: "",
            class: "form-control",
            id: "eaCompanyNationalNumber"
          }, null, _parent));
          _push(`</div><div class="col-sm-6 col-12 mb-4"><label for="eaCompanyEconomicNumber" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.economic_code"))}</label><input${ssrRenderAttr("value", unref(registerSellerForm).company_economic_number)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.economic_code"))} required class="form-control" id="eaCompanyEconomicNumber"></div><div class="col-sm-6 col-12 mb-4"><label for="eaCompanySignatory" class="form-label required">${ssrInterpolate(_ctx.$t("messages.sentence.signature_owners"))}</label><input${ssrRenderAttr("value", unref(registerSellerForm).company_signatory)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.signature_owners"))} class="form-control" id="eaCompanySignatory" required><span class="form-control-description">${ssrInterpolate(_ctx.$t("messages.sentence.seprate_person_name_with_commas"))}</span></div><div class="col-sm-6 col-12 mb-4"><span class="form-label mb-1 d-flex lts-05 text-dark required">${ssrInterpolate(_ctx.$t("messages.sentence.company_signatory_national_cards_image"))}</span><span class="text-gray fs-9 mb-2 d-flex lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_548852"))}</span><label class="identity-documents clickable" for="legalIdentityInput">`);
          if (legalIdentityImageUrl.value != null) {
            _push(`<img${ssrRenderAttr("src", legalIdentityImageUrl.value)}>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<input type="file" class="custom-input-file-input" id="legalIdentityInput" accept=".png,.jpg,.jpeg">`);
          if (legalIdentityImageUrl.value == null) {
            _push(`<div class="d-flex flex-column align-items-center justify-content-center"><span class="fw-bold lts-05 mb-2">${ssrInterpolate(_ctx.$t("messages.sentence.national_card_image_hint"))}</span><span class="lts-05 fs-8 text-gray mb-4">${ssrInterpolate(_ctx.$t("messages.sentence.national_card_image_upload_hint"))}</span><div class="select-image"><span class="label"><i class="ri-arrow-up-fill me-1"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.select_image"))}</span></div></div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</label></div></div><div class="d-flex align-item-center justify-content-end"><button class="btn btn-primary lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.next_step"))} <i class="ri-arrow-left-s-line"></i></button></div></div></div></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      if (level.value == "location") {
        _push(`<div class="row mb-5"><div class="form-box col-12 mb-3"><div class="card shadow-1"><div class="card-body"><div class="form-title lts-05 mt-0 mb-4"><i class="back-button ri-arrow-right-line me-3"></i>`);
        if (unref(registerSellerForm).type == "genuine") {
          _push(`<div>${ssrInterpolate(_ctx.$t("messages.sentence.your_address"))}</div>`);
        } else {
          _push(`<!---->`);
        }
        if (unref(registerSellerForm).type == "legal") {
          _push(`<div>${ssrInterpolate(_ctx.$t("messages.sentence.company_address"))}</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div><p class="desc lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_258458"))}</p><div class="row"><div class="col-md-4 col-12 mb-4"><label for="eaState" class="form-label required">${ssrInterpolate(_ctx.$t("messages.word.town"))}</label><input${ssrRenderAttr("value", unref(registerSellerForm).state)} id="eaState" type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.town"))} required class="form-control"></div><div class="col-md-4 col-12 mb-4"><label for="eaCity" class="form-label required">${ssrInterpolate(_ctx.$t("messages.word.city"))}</label><input${ssrRenderAttr("value", unref(registerSellerForm).city)} id="eaCity" type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.city"))} required class="form-control"></div><div class="col-md-4 col-12 mb-4"><label for="eaPostalCode" class="form-label required">${ssrInterpolate(_ctx.$t("messages.word.postal_code"))}</label>`);
        _push(ssrRenderComponent(_sfc_main$2, {
          modelValue: unref(registerSellerForm).postal_code,
          "onUpdate:modelValue": ($event) => unref(registerSellerForm).postal_code = $event,
          id: "eaPostalCode",
          minlength: "10",
          maxlength: "10",
          type: "text",
          placeholder: _ctx.$t("messages.word.postal_code"),
          required: "",
          class: "form-control"
        }, null, _parent));
        _push(`</div><div class="col-12 mb-4"><label for="eaFullAddress" class="form-label required">${ssrInterpolate(_ctx.$t("messages.sentence.full_address"))}</label><textarea id="eaFullAddress" type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.write_full_address"))} required class="form-control">${ssrInterpolate(unref(registerSellerForm).full_address)}</textarea></div><div class="col-12 mb-4"><div class="form-label required text-dark lts-05 mb-3">${ssrInterpolate(_ctx.$t("messages.sentence.select_full_address_from_map"))}:</div><div class="map-container">`);
        _push(ssrRenderComponent(unref(NeshanMap), {
          ref_key: "Map",
          ref: Map,
          mapKey: _ctx.$page.props.neshan.map_key,
          serviceKey: _ctx.$page.props.neshan.service_key,
          center: unref(registerSellerForm).map,
          zoom: unref(registerSellerForm).map.zoom,
          defaultType: "neshan",
          hideLayers: true,
          traffic: false,
          cluster: false,
          hideSearchContainer: true,
          onOnClick: mapResult,
          class: "map"
        }, null, _parent));
        _push(`</div></div></div><div class="d-flex align-item-center justify-content-end"><button class="btn btn-primary lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.next_step"))} <i class="ri-arrow-left-s-line"></i></button></div></div></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (level.value == "submit") {
        _push(`<div class="row mb-5"><div class="form-box col-12 mb-3"><div class="card shadow-1"><div class="card-body"><div class="form-title lts-05 mt-0 mb-4"><i class="back-button ri-arrow-right-line me-3"></i><div>${ssrInterpolate(_ctx.$t("messages.sentence.submit_final_review_request"))}</div></div><p class="desc lts-05 alert alert-light d-inline-flex">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_215485"))}</p><p class="desc lts-05 mb-5">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_198525"))}</p><div class="d-flex align-item-center justify-content-between"><div class="form-check form-switch mb-3"><label class="form-check-label lts-05"><a class="link"${ssrRenderAttr("href", _ctx.route("main.pages.show", "terms"))} target="_blank">${ssrInterpolate(_ctx.$t("messages.sentence.terms_and_conditions"))}</a> ${ssrInterpolate(_ctx.$t("messages.sentence.i_accept_the_rules"))} <input${ssrIncludeBooleanAttr(Array.isArray(acceptRules.value) ? ssrLooseContain(acceptRules.value, null) : acceptRules.value) ? " checked" : ""} class="form-check-input clickable" type="checkbox" role="switch" style="${ssrRenderStyle({ "transform": "scale(1.1)" })}"></label></div><button class="btn btn-primary lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.submit_review_request"))} <i class="ri-inbox-unarchive-line"></i></button></div></div></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div><div class="auth-footer">`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("index"),
        class: "lts-05"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.home_page"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("messages.sentence.home_page")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`<span></span>`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("main.forms.show", "contact-us"),
        class: "lts-05"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.contact_us"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("messages.sentence.contact_us")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`<span></span>`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("main.pages.show", "seller-guide"),
        class: "lts-05"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.seller_guide"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("messages.sentence.seller_guide")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></div></div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Store/Register/Register.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
