import { defineComponent, unref, withCtx, createVNode, createTextVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderComponent, ssrRenderList, ssrInterpolate, ssrRenderAttr, ssrRenderStyle, ssrIncludeBooleanAttr } from "vue/server-renderer";
import { _ as _sfc_main$1, a as _sfc_main$2 } from "./StoreLayout-D2_RagXW.js";
import { useForm, Head, Link } from "@inertiajs/vue3";
import { _ as _sfc_main$4 } from "./Pagination-C1AQrLe3.js";
import { _ as _sfc_main$3 } from "./FilterList-CWxGcEKk.js";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "jquery";
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
import "./SearchList-BZnYMQPN.js";
import "lodash/debounce.js";
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "./useRandomNum-DNNSqR7b.js";
import "bootstrap";
import "./useNl2br-BIw8h5gy.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "QuestionList",
  __ssrInlineRender: true,
  props: {
    questions: {},
    keyword: {}
  },
  setup(__props) {
    const sendAmswerForm = useForm({
      answer: null
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.question_list")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.sentence.question_list")
      }, null, _parent));
      _push(`<div class="comment-list orders-list list"><div class="card"><div class="card-body"><div class="comments orders">`);
      _push(ssrRenderComponent(_sfc_main$3, {
        filters: { awaiting_questions: _ctx.$t("messages.sentence.question_awaiting_verify"), awaiting_answers: _ctx.$t("messages.sentence.answer_awaiting_verify") }
      }, null, _parent));
      _push(`<div class="comment-items user-order-items"><!--[-->`);
      ssrRenderList(_ctx.questions.data, (question) => {
        _push(`<div class="comment-item user-order-item"><div class="user-order-item-header"><div class="mb-3"><div class="row">`);
        if (question.status == "awaiting") {
          _push(`<div class="col-sm-auto mb-2"><span class="user-order-meta has-circle-animation yellow"><span class="text-muted lts-05 me-1">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_verify"))}</span></span></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="col-sm-auto mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.word.user"))}: </span><a href="javascript:void(0)" class="link link-icon">${ssrInterpolate(question.user.get_name)}</a></span></div><div class="col-sm-auto mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.sentence.answer_count"))}: </span> ${ssrInterpolate(question.answers.length)}</span></div><div class="col-sm-auto mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.word.date"))}: </span> ${ssrInterpolate(question.jalali_created_at[0])}</span></div><div class="col-sm-auto mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.word.product"))}: </span><a${ssrRenderAttr("href", _ctx.route("main.products.show", question.product.slug))} target="_blank" class="link link-icon">${ssrInterpolate(question.product.title)} <i class="ri-external-link-line"></i></a></span></div></div></div><div class="row send-details mb-4"><div class="col-12 user-order-item-header--meta mb-3"><span class="user-order-meta user-order-meta--question mb-0"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.sentence.question_content"))}: </span><span class="fw-bold">${ssrInterpolate(question.question)}</span></span></div><div class="col-12"><!--[-->`);
        ssrRenderList(question.answers, (answer) => {
          _push(`<div class="answer"><div class="dropdown d-flex align-items-start justify-content-between mb-2"><div>`);
          if (answer.status == "awaiting") {
            _push(`<div class="col-sm-auto mb-1"><span class="user-order-meta has-circle-animation yellow"><span class="text-muted lts-05 me-1">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_verify"))}</span></span></div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<span class="answer-title">${ssrInterpolate(_ctx.$t("messages.word.answer"))}</span></div>`);
          if (answer.status == "awaiting" || answer.user.id == _ctx.$page.props.auth.user.id) {
            _push(`<!--[--><i data-bs-toggle="dropdown" class="ri-more-2-fill answer-dropdown-icon"></i><div class="dropdown-menu shadow-smooth-2 mb-1 mt-1"><ul>`);
            if (answer.status == "awaiting") {
              _push(`<li>`);
              _push(ssrRenderComponent(unref(Link), {
                href: _ctx.route("seller.questions.answers.accept", answer.id),
                method: "post",
                "preserve-scroll": "",
                as: "button",
                class: "dropdown-item lts-05"
              }, {
                default: withCtx((_, _push2, _parent2, _scopeId) => {
                  if (_push2) {
                    _push2(`<i class="ri-question-line me-1"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.word.accept"))}`);
                  } else {
                    return [
                      createVNode("i", { class: "ri-question-line me-1" }),
                      createTextVNode(" " + toDisplayString(_ctx.$t("messages.word.accept")), 1)
                    ];
                  }
                }),
                _: 2
              }, _parent));
              _push(`</li>`);
            } else {
              _push(`<!---->`);
            }
            if (answer.status == "awaiting" || answer.user.id == _ctx.$page.props.auth.user.id) {
              _push(`<li><button data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#answer-delete-" + answer.id)} class="dropdown-item no-btn"><i class="ri-delete-bin-line me-1"></i> ${ssrInterpolate(_ctx.$t("messages.word.delete"))}</button></li>`);
            } else {
              _push(`<!---->`);
            }
            _push(`</ul></div><!--]-->`);
          } else {
            _push(`<!---->`);
          }
          _push(`<div class="modal fade"${ssrRenderAttr("id", "answer-delete-" + answer.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.are_you_sure_delete_answer"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-footer">`);
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("seller.questions.answers.delete", answer.id),
            method: "delete",
            as: "button",
            "preserve-scroll": "",
            "data-bs-dismiss": "modal",
            "aria-label": "Close",
            class: "btn btn-sm btn-danger px-3"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(_ctx.$t("messages.word.delete"))}`);
              } else {
                return [
                  createTextVNode(toDisplayString(_ctx.$t("messages.word.delete")), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</div></div></div></div></div><span class="answer-user-name">${ssrInterpolate(answer.user.get_name)} `);
          if (answer.user.type == "owner" || answer.user.type == "admin") {
            _push(`<span class="badge">${ssrInterpolate(_ctx.$t("messages.word.admin"))}</span>`);
          } else if (answer.user.seller) {
            _push(`<span class="badge">${ssrInterpolate(_ctx.$t("messages.word.seller"))}</span>`);
          } else if (answer.is_buyer) {
            _push(`<span class="badge">${ssrInterpolate(_ctx.$t("messages.word.buyer"))}</span>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</span><p class="answer-content">${ssrInterpolate(answer.answer)}</p><div class="comment-footer"><span class="me-2 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.users_reaction"))}</span><button type="button" preserve-scroll class="comment-like">${ssrInterpolate(answer.vote_up)}</button><button type="button" preserve-scroll class="comment-dislike">${ssrInterpolate(answer.vote_down)}</button></div></div>`);
        });
        _push(`<!--]--></div></div><div class="row"><div class="col-12 d-flex align-items-center justify-content-end dropup"><a href="javascript:void(0)" data-bs-toggle="dropdown" class="btn btn-link fw-bold user-order-detail-link">${ssrInterpolate(_ctx.$t("messages.sentence.action_menu"))} <i class="ri-arrow-left-s-fill"></i></a><div class="dropdown-menu shadow-smooth-2 mb-1 mt-1"><ul>`);
        if (question.status == "awaiting") {
          _push(`<li>`);
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("seller.questions.accept", question.id),
            method: "post",
            as: "button",
            "preserve-scroll": "",
            class: "dropdown-item lts-05"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<i class="ri-question-line me-1"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.word.accept"))}`);
              } else {
                return [
                  createVNode("i", { class: "ri-question-line me-1" }),
                  createTextVNode(" " + toDisplayString(_ctx.$t("messages.word.accept")), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</li>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<li><a class="dropdown-item lts-05" href="javascript:void(0)" data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#question-answer-" + question.id)}><i class="ri-send-plane-2-line me-1"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.send_answer"))}</a></li>`);
        if (question.status == "awaiting") {
          _push(`<li><button data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#question-delete-" + question.id)} class="dropdown-item no-btn"><i class="ri-delete-bin-line me-1"></i> ${ssrInterpolate(_ctx.$t("messages.word.delete"))}</button></li>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</ul></div><div class="modal fade"${ssrRenderAttr("id", "question-answer-" + question.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.send_answer"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12"><label class="form-label">${ssrInterpolate(_ctx.$t("messages.word.answer"))}: <textarea type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.write_your_answer") + " ...")} required class="form-control">${ssrInterpolate(unref(sendAmswerForm).answer)}</textarea></label></div></div></div><div class="modal-footer"><button${ssrIncludeBooleanAttr(unref(sendAmswerForm).processing) ? " disabled" : ""} data-bs-dismiss="modal" aria-label="Close" class="btn btn-sm btn-primary px-3">${ssrInterpolate(_ctx.$t("messages.word.send"))}</button></div></form></div></div></div><div class="modal fade"${ssrRenderAttr("id", "question-delete-" + question.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.are_you_sure_delete_question"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-footer">`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("seller.questions.delete", question.id),
          method: "delete",
          as: "button",
          "preserve-scroll": "",
          "data-bs-dismiss": "modal",
          "aria-label": "Close",
          class: "btn btn-sm btn-danger px-3"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("messages.word.delete"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("messages.word.delete")), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</div></div></div></div></div></div></div></div>`);
      });
      _push(`<!--]--></div>`);
      if (_ctx.questions.data.length == 0) {
        _push(`<div class="cart-empty"><div class="empty-content-icon"><img${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/template/orders.svg")} alt=""></div><div class="empty-content-message text-center"><p class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</p></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.questions.data.length > 0) {
        _push(ssrRenderComponent(_sfc_main$4, {
          links: _ctx.questions.links
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Store/Products/Questions/QuestionList.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
