import { defineComponent, ref, watch, unref, useSSRContext } from "vue";
import { ssrInterpolate, ssrRenderList, ssrRenderClass, ssrRenderAttr, ssrIncludeBooleanAttr, ssrLooseContain } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./MainLayout-CahYFWjG.js";
import { useForm } from "@inertiajs/vue3";
import { u as useNumberFormat } from "../ssr.js";
/* empty css                       */
/* empty css                              */
/* empty css                           */
/* empty css             */
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
import "./AdminNavigation-BYBoZNuA.js";
import "./useHexToRgb-G7J9N7Ap.js";
import "./useRandomStr-4MeWbtRd.js";
import "jquery";
import "@vue/server-renderer";
import "@inertiajs/vue3/server";
import "ziggy-js";
import "laravel-vue-i18n";
import "axios";
import "lodash/debounce.js";
import "swiper/bundle";
import "swiper";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Payment",
  __ssrInlineRender: true,
  props: {
    selectedAddress: {},
    sepratedConsignments: {},
    itemsCount: {},
    financial: {},
    discount: {},
    customerClubScore: {},
    paymentGateways: {},
    vpn_warning_status: { type: Boolean }
  },
  setup(__props) {
    const props = __props;
    const checkDiscountForm = useForm({
      code: props.discount != null ? props.discount.information.code : null
    });
    const selectedPaymentGateway = ref(props.paymentGateways.length > 0 ? props.paymentGateways[0].id : null);
    const paymentForm = useForm({
      payment_gateway: selectedPaymentGateway.value,
      use_wallet: true,
      description: null
    });
    watch(selectedPaymentGateway, (value) => {
      if (value == "snapppay" || value == "digipay" || value == "azki") {
        paymentForm.use_wallet = false;
      } else {
        paymentForm.use_wallet = true;
      }
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[--><div class="container"><div class="row"><div class="col-xl-9 col-lg-8 mb-3"><div class="card shadow-1 cart payment-gateways-list time-and-send-container payment-gateway-radio-box mb-4"><div class="card-body pt-2"><div class="send-address-title mb-4">${ssrInterpolate(_ctx.$t("messages.sentence.choose_payment_gateway"))}:</div><!--[-->`);
      ssrRenderList(_ctx.paymentGateways, (pg, index) => {
        _push(`<div class="radio-send-method mb-3">`);
        if (pg.id == "snapppay") {
          _push(`<div class="${ssrRenderClass(selectedPaymentGateway.value == pg.id ? "custom-radio snapppay custom-radio--active" : "custom-radio snapppay")}"><input type="radio" class="custom-radio-input"${ssrRenderAttr("id", "pg-" + index)}><label${ssrRenderAttr("for", "pg-" + index)} class="custom-radio-label"><span class="label"><span class="icon"><img${ssrRenderAttr("src", _ctx.$page.props.appUrl + pg["icon"])} alt="درگاه پرداخت"></span><span class="detail"><span class="title mb-2">${ssrInterpolate(pg.label)}</span><span class="subtitle lts-05">${ssrInterpolate(pg["description"])}</span></span></span></label></div>`);
        } else {
          _push(`<div class="${ssrRenderClass(selectedPaymentGateway.value == pg.id ? "custom-radio common custom-radio--active" : "custom-radio common")}"><input type="radio" class="custom-radio-input"${ssrRenderAttr("id", "pg-" + index)}><label${ssrRenderAttr("for", "pg-" + index)} class="custom-radio-label"><span class="label">`);
          if (pg["icon"] !== void 0 && pg["icon"] != null) {
            _push(`<span class="icon"><img${ssrRenderAttr("src", _ctx.$page.props.appUrl + pg["icon"])} alt="درگاه پرداخت"></span>`);
          } else {
            _push(`<span class="icon"><i class="ri-bank-card-2-line"></i></span>`);
          }
          _push(`<span class="detail"><span class="title">${ssrInterpolate(pg.label)}</span><span class="subtitle lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.online_payment_with_all_bank_card"))}</span></span></span></label></div>`);
        }
        _push(`</div>`);
      });
      _push(`<!--]-->`);
      if (_ctx.paymentGateways.length == 0) {
        _push(`<div class="d-flex mb-3"><span class="lts-05 text-gray">${ssrInterpolate(_ctx.$t("messages.sentence.no_any_active_payment_gateway_and_payment_disabled"))}</span></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div><div class="discount-container card shadow-1 mb-4"><div class="card-body"><div class="row"><div class="col-md-6 col-12"><div class="checkout"><div class="checkout-row mb-3"><div class="checkout-row-label fw-bold lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.do_you_have_discount_code"))}</div></div><div class="form-element-row with-btn"><input${ssrRenderAttr("value", unref(checkDiscountForm).code)} type="text" class="form-control"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.enter_your_discount_code") + " ...")}><button type="button" class="btn btn-light">${ssrInterpolate(_ctx.$t("messages.word.apply"))}</button></div></div></div></div></div></div><div class="card shadow-1 cart mb-4"><div class="card-body p-3"><div class="row px-2 py-1"><div class="col-12"><label class="form-label" for="eaOrderDescription">${ssrInterpolate(_ctx.$t("messages.sentence.order_description"))} <span class="badge bg-light text-gray">${ssrInterpolate(_ctx.$t("messages.word.optional"))}</span></label></div><div class="col-12"><textarea class="form-control lts-05" name="order-description" id="eaOrderDescription" rows="3"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.order_description_placeholder"))}>${ssrInterpolate(unref(paymentForm).description)}</textarea></div></div></div></div><div class="card shadow-1 cart time-and-send-container mb-4"><div class="card-body d-flex align-items-center p-3"><i class="ri-information-line text-gray me-3"></i><span class="text-gray lh-30 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_448796"))}</span></div></div></div><div class="col-xl-3 col-lg-4 mb-3"><div class="cart-sidebar"><div class="card shadow-1 mb-3"><div class="card-body"><div class="checkout"><div class="checkout-row"><div class="checkout-row-label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.ware_prices"))} (${ssrInterpolate(_ctx.itemsCount)})</div><div class="checkout-row-value lts-05"><span class="fs-6">${ssrInterpolate(unref(useNumberFormat)(_ctx.financial.totalPrice))}</span><span class="unit unit-sm"></span></div></div><div class="checkout-row"><div class="checkout-row-label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.ware_discounts"))}</div><div class="checkout-row-value lts-05"><span class="fs-6 text-danger">${ssrInterpolate(unref(useNumberFormat)(_ctx.financial.totalDiscount))}</span><span class="unit-red unit-sm"></span></div></div><div class="checkout-row"><div class="checkout-row-label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.send_price"))}</div>`);
      if (_ctx.selectedAddress != null && _ctx.selectedAddress.type == "user") {
        _push(`<!--[-->`);
        if (Object.keys(_ctx.sepratedConsignments).length === 1 && Object.keys(_ctx.sepratedConsignments).includes("main")) {
          _push(`<!--[-->`);
          if (_ctx.sepratedConsignments.main.send_method != null && _ctx.sepratedConsignments.main.send_method["type"] == "post" && _ctx.sepratedConsignments.main.send_method["item"]["uuid"] == "paskeraye") {
            _push(`<div class="checkout-row-value lts-05"><span class="fs-8">${ssrInterpolate(_ctx.$t("messages.sentence.payment_on_spot"))}</span></div>`);
          } else if (_ctx.sepratedConsignments.main.freeSend) {
            _push(`<div class="checkout-row-value lts-05"><span class="fs-8">${ssrInterpolate(_ctx.$t("messages.word.free"))}</span></div>`);
          } else {
            _push(`<div class="checkout-row-value lts-05"><span class="fs-6">${ssrInterpolate(unref(useNumberFormat)(_ctx.financial.sendPrice))}</span><span class="unit unit-sm"></span></div>`);
          }
          _push(`<!--]-->`);
        } else {
          _push(`<div class="checkout-row-value lts-05"><span class="fs-6">${ssrInterpolate(unref(useNumberFormat)(_ctx.financial.sendPrice))}</span><span class="unit unit-sm"></span></div>`);
        }
        _push(`<!--]-->`);
      } else if (_ctx.selectedAddress != null && _ctx.selectedAddress.type == "shop") {
        _push(`<div class="checkout-row-value lts-05"><span class="fs-8">${ssrInterpolate(_ctx.$t("messages.sentence.receive_in_person"))}</span></div>`);
      } else {
        _push(`<div class="checkout-row-value lts-05"><span class="fs-8">${ssrInterpolate(_ctx.$t("messages.sentence.please_choose"))}</span></div>`);
      }
      _push(`</div>`);
      if (_ctx.discount != null) {
        _push(`<div class="discount-widget-container mb-3"><div class="checkout pt-0 pb-0"><div class="checkout-row pb-0"><div class="checkout-row-label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.discount_code_aplied"))}</div><div class="checkout-row-value lts-05"><span class="fs-8 badge bg-info">${ssrInterpolate(_ctx.discount.information.code)}</span></div></div><div class="checkout-row"><div class="checkout-row-label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.deduct_the_amount"))}:</div><div class="checkout-row-value lts-05"><span class="fs-8 text-danger">${ssrInterpolate(unref(useNumberFormat)(_ctx.discount.amount))} -</span><span class="unit-red unit-xs"></span></div></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (selectedPaymentGateway.value != "snapppay" && selectedPaymentGateway.value != "digipay" && selectedPaymentGateway.value != "azki") {
        _push(`<div class="wallet-container mb-3"><div class="checkout pt-0 pb-0"><div class="checkout-row wallet-container-show"><div class="checkout-row-label fs-8 lts-05">${ssrInterpolate(unref(paymentForm).use_wallet && _ctx.$page.props.auth.wallet.amount > 0 ? _ctx.$t("messages.sentence.remaining_inventory") : _ctx.$t("messages.sentence.wallet_amount"))}</div><div class="${ssrRenderClass(
          unref(paymentForm).use_wallet && _ctx.$page.props.auth.wallet.amount > 0 ? "checkout-row-value checkout-row-value--show lts-05" : "checkout-row-value lts-05"
        )}"><div>`);
        if (unref(paymentForm).use_wallet) {
          _push(`<span class="fs-6">${ssrInterpolate(unref(useNumberFormat)(_ctx.financial.totalFinalPrice - _ctx.$page.props.auth.wallet.amount > 0 ? 0 : _ctx.$page.props.auth.wallet.amount - _ctx.financial.totalFinalPrice))}</span>`);
        } else {
          _push(`<span class="fs-6">${ssrInterpolate(_ctx.$page.props.auth.wallet.get_formatted_amount)}</span>`);
        }
        _push(`<span class="unit unit-sm"></span></div>`);
        if (_ctx.$page.props.auth.wallet.amount > 0) {
          _push(`<div>`);
          if (_ctx.financial.totalFinalPrice - _ctx.$page.props.auth.wallet.amount > 0) {
            _push(`<!--[--><span class="fs-6 text-danger white-space-nowrap">${ssrInterpolate(unref(useNumberFormat)(_ctx.$page.props.auth.wallet.amount))} -</span><span class="unit-red unit-xs"></span><!--]-->`);
          } else {
            _push(`<!--[--><span class="fs-6 text-danger white-space-nowrap">${ssrInterpolate(unref(useNumberFormat)(_ctx.$page.props.auth.wallet.amount - (_ctx.$page.props.auth.wallet.amount - _ctx.financial.totalFinalPrice)))} - </span><span class="unit-red unit-xs"></span><!--]-->`);
          }
          _push(`</div>`);
        } else {
          _push(`<div></div>`);
        }
        _push(`</div></div><div class="checkout-row"><div class="use-wallet form-check form-switch"><label class="form-check-label flex-grow-1 fs-8 title lts-05" for="useWalletAmount">${ssrInterpolate(_ctx.$t("messages.sentence.using_wallet_amount"))}</label><input${ssrIncludeBooleanAttr(Array.isArray(unref(paymentForm).use_wallet) ? ssrLooseContain(unref(paymentForm).use_wallet, null) : unref(paymentForm).use_wallet) ? " checked" : ""} class="form-check-input" type="checkbox" role="switch" id="useWalletAmount"></div></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="checkout-row"><div class="checkout-row-label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.cart_total_pay_price"))}</div><div class="checkout-row-value lts-05">`);
      if (unref(paymentForm).use_wallet) {
        _push(`<!--[-->`);
        if (_ctx.financial.totalFinalPrice - _ctx.$page.props.auth.wallet.amount > 0) {
          _push(`<span class="fs-6">${ssrInterpolate(unref(useNumberFormat)(_ctx.financial.totalFinalPrice - _ctx.$page.props.auth.wallet.amount))}</span>`);
        } else {
          _push(`<span class="fs-6">0</span>`);
        }
        _push(`<!--]-->`);
      } else {
        _push(`<span class="fs-6">${ssrInterpolate(unref(useNumberFormat)(_ctx.financial.totalFinalPrice))}</span>`);
      }
      _push(`<span class="unit unit-sm"></span></div></div><div class="checkout-row checkout-action">`);
      if (_ctx.vpn_warning_status) {
        _push(`<button data-bs-toggle="modal" data-bs-target="#vpnWarningModal" type="button" class="btn btn-block btn-primary lts-05">${ssrInterpolate(_ctx.$t("messages.word.payment"))}</button>`);
      } else {
        _push(`<button${ssrIncludeBooleanAttr(unref(paymentForm).processing) ? " disabled" : ""} type="button" class="btn btn-block btn-primary lts-05">${ssrInterpolate(_ctx.$t("messages.word.payment"))} `);
        if (unref(paymentForm).processing) {
          _push(`<i class="ri-refresh-line i-spin"></i>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</button>`);
      }
      _push(`</div><div class="checkout-row checkout-footer"><div class="checkout-row-label lts-05"><span class="d-flex"><i class="ri-copper-coin-fill text-warning me-1"></i><span class="fs-7 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.customer_club_points"))}</span></span></div><div class="checkout-row-value--small lts-05"><span class="fw-bold">${ssrInterpolate(unref(useNumberFormat)(_ctx.customerClubScore))}</span> <span class="fs-8 text-gray">${ssrInterpolate(_ctx.$t("messages.word.score"))}</span></div></div></div></div></div>`);
      if (_ctx.$page.props.payment_meta.free_post_min_price > 0) {
        _push(`<div class="card shadow-1 mb-3"><div class="send-free card-body"><div class="title"><div class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.orders_free_send"))}</div><span class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.orders_above_price", { price: _ctx.$page.props.payment_meta.get_formatted_free_post_min_price }))}</span></div><i class="ri-truck-line"></i></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div></div><div class="modal fade" id="vpnWarningModal" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><div class="modal-body"><div class="row"><div class="col-12 mb-4"><div class="text-center fw-bold fs-6 lts-05 mb-2">${ssrInterpolate(_ctx.$t("messages.sentence.vpn_warning_title"))}</div><span class="d-block w-100 text-center fs-7 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.vpn_warning_description"))}</span></div></div></div><div class="modal-footer"><button${ssrIncludeBooleanAttr(unref(paymentForm).processing) ? " disabled" : ""} type="button" class="btn btn-block btn-primary lts-05">${ssrInterpolate(_ctx.$t("messages.word.payment"))} `);
      if (unref(paymentForm).processing) {
        _push(`<i class="ri-refresh-line i-spin"></i>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</button></div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Main/Cart/Payment.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
