import { defineComponent, watch, mergeProps, unref, withCtx, createBlock, openBlock, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrRenderList, ssrRenderClass, ssrRenderComponent } from "vue/server-renderer";
import { Link } from "@inertiajs/vue3";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "Pagination",
  __ssrInlineRender: true,
  props: {
    links: {},
    preserveScroll: { type: Boolean },
    preserveState: { type: Boolean },
    only: {}
  },
  setup(__props) {
    const props = __props;
    watch(props.links, (value) => {
      console.log(value);
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "pagination-container" }, _attrs))}><nav aria-label="Page navigation example"><ul class="pagination"><!--[-->`);
      ssrRenderList(_ctx.links, (link, index) => {
        _push(`<!--[-->`);
        if (link.url != null) {
          _push(`<li class="${ssrRenderClass({ "page-item": true, active: link.active })}">`);
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.$page.props.appEnv == "production" ? link.url.replace("http://", "https://") : link.url,
            "preserve-state": _ctx.preserveState,
            "preserve-scroll": _ctx.preserveScroll,
            only: _ctx.only != void 0 ? ["" + _ctx.only] : void 0,
            class: "page-link"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                if (link.label.includes("Previous")) {
                  _push2(`<i class="ri-arrow-right-double-line"${_scopeId}></i>`);
                } else if (link.label.includes("Next")) {
                  _push2(`<i class="ri-arrow-left-double-line"${_scopeId}></i>`);
                } else {
                  _push2(`<span${_scopeId}>${link.label ?? ""}</span>`);
                }
              } else {
                return [
                  link.label.includes("Previous") ? (openBlock(), createBlock("i", {
                    key: 0,
                    class: "ri-arrow-right-double-line"
                  })) : link.label.includes("Next") ? (openBlock(), createBlock("i", {
                    key: 1,
                    class: "ri-arrow-left-double-line"
                  })) : (openBlock(), createBlock("span", {
                    key: 2,
                    innerHTML: link.label
                  }, null, 8, ["innerHTML"]))
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</li>`);
        } else {
          _push(`<li class="page-item"><a href="javascript:void(0)" class="page-link">`);
          if (link.label.includes("Previous")) {
            _push(`<i class="ri-arrow-right-double-line"></i>`);
          } else if (link.label.includes("Next")) {
            _push(`<i class="ri-arrow-left-double-line"></i>`);
          } else {
            _push(`<span>${link.label ?? ""}</span>`);
          }
          _push(`</a></li>`);
        }
        _push(`<!--]-->`);
      });
      _push(`<!--]--></ul></nav></div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Common/Pagination.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as _
};
