import { defineComponent, onMounted, unref, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderList, ssrRenderClass, ssrRenderAttr } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./MainLayout-CahYFWjG.js";
import { router, Head } from "@inertiajs/vue3";
import { _ as _sfc_main$2 } from "./Pagination-C1AQrLe3.js";
import $ from "jquery";
/* empty css                       */
/* empty css                              */
/* empty css                           */
/* empty css             */
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
import "./AdminNavigation-BYBoZNuA.js";
import "./useHexToRgb-G7J9N7Ap.js";
import "./useRandomStr-4MeWbtRd.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Notifications",
  __ssrInlineRender: true,
  props: {
    notifications: {}
  },
  setup(__props) {
    onMounted(() => {
      $(document).on("click", ".link-to-target", (e) => {
        let targetType = $(e.target).attr("target");
        let parameter = $(e.target).attr("parameter");
        if (targetType == "ticket") {
          router.get(route("user.tickets.show", parameter));
        }
        if (targetType == "product") {
          router.visit(route("main.products.show", parameter));
        }
        if (targetType == "article") {
          router.visit(route("main.articles.show", parameter));
        }
      });
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.notifications")
      }, null, _parent));
      _push(`<div class="card shadow-1 panel-content"><div class="card-body"><div class="row"><div class="col-lg-12 mb-3"><div class="panel-content--title mb-4 lts-05">${ssrInterpolate(_ctx.$t("messages.word.notifications"))}</div><div class="notifications"><div class="row"><div class="col-12 mb-2"><!--[-->`);
      ssrRenderList(_ctx.notifications.data, (notification, index) => {
        _push(`<div class="${ssrRenderClass({ "notification-item": true, unread: notification.read_at == null })}">`);
        if (notification.read_at == null) {
          _push(`<div class="w-100 d-block mb-2"><span class="badge bg-info">${ssrInterpolate(_ctx.$t("messages.sentence.not_read"))}</span></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<span class="title">${notification.data["message"] ?? ""}</span><span class="body">${ssrInterpolate(notification.data["date"])}</span></div>`);
      });
      _push(`<!--]--></div></div></div></div>`);
      if (_ctx.notifications.data.length == 0) {
        _push(`<div class="cart-empty"><div class="empty-content-icon"><img${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/template/orders.svg")}></div><div class="empty-content-message text-center"><p class="mb-4 lts-05 fs-8">${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</p></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.notifications.data.length != 0) {
        _push(ssrRenderComponent(_sfc_main$2, {
          links: _ctx.notifications.links
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/User/Account/Notifications.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
