import { defineComponent, onMounted, unref, useSSRContext } from "vue";
import { ssrRenderComponent, ssrRenderList, ssrInterpolate } from "vue/server-renderer";
import { _ as _sfc_main$1, a as _sfc_main$2 } from "./StoreLayout-D2_RagXW.js";
import { router, Head } from "@inertiajs/vue3";
import { _ as _sfc_main$3 } from "./Pagination-C1AQrLe3.js";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "jquery";
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
import "./SearchList-BZnYMQPN.js";
import "lodash/debounce.js";
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "./useRandomNum-DNNSqR7b.js";
import "bootstrap";
import "./useNl2br-BIw8h5gy.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Notifications",
  __ssrInlineRender: true,
  props: {
    notifications: {}
  },
  setup(__props) {
    onMounted(() => {
      $(document).on("click", ".link-to-target", (e) => {
        let targetType = $(e.target).attr("target");
        let parameter = $(e.target).attr("parameter");
        if (targetType == "ticket") {
          router.get(route("seller.tickets.show", parameter));
        }
        if (targetType == "product") {
          router.get(route("seller.products.edit", parameter));
        }
        if (targetType == "article") {
          router.get(route("seller.articles.edit", parameter));
        }
      });
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.notifications")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.word.notifications"),
        item: _ctx.$t("messages.word.notifications")
      }, null, _parent));
      _push(`<div class="notification-list mb-4 mt-4"><div class="card"><div class="card-body p-0"><div class="row"><!--[-->`);
      ssrRenderList(_ctx.notifications.data, (notification, index) => {
        _push(`<div class="col-12 mb-2"><div class="card"><div class="card-body">`);
        if (notification.read_at == null) {
          _push(`<div class="w-100 d-block mb-2"><span class="badge bg-info">${ssrInterpolate(_ctx.$t("messages.sentence.not_read"))}</span></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="w-100 d-block text-dark lh-30">${notification.data["message"] ?? ""}</div><span class="white-space-nowrap text-gray lts-05 fs-9">${ssrInterpolate(notification.data["date"])}</span></div></div></div>`);
      });
      _push(`<!--]--></div>`);
      if (_ctx.notifications.data.length == 0) {
        _push(`<div class="product-list-empty"><div class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_sfc_main$3, {
        links: _ctx.notifications.links
      }, null, _parent));
      _push(`</div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Store/Account/Notifications.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
