import { defineComponent, ref, watch, unref, withCtx, createVNode, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderStyle, ssrRenderAttr } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./AdminLayout-CD07IMsK.js";
import { router, useForm, Head, Link } from "@inertiajs/vue3";
import Dropdown from "primevue/dropdown/dropdown.esm.js";
import { _ as _sfc_main$2 } from "./Files-B6eiTnN6.js";
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "laravel-vue-i18n";
import "./Pagination-C1AQrLe3.js";
import "./SearchList-BZnYMQPN.js";
import "lodash/debounce.js";
import "./useRandomNum-DNNSqR7b.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Manage",
  __ssrInlineRender: true,
  props: {
    menus: {},
    menuPlaceList: {}
  },
  setup(__props) {
    const props = __props;
    const menuForEdit = ref(0);
    watch(menuForEdit, (value) => {
      router.get(route("admin.menus.edit", value));
    });
    const menuList = ref([]);
    for (let menu in props.menus) {
      menuList.value.push({ id: props.menus[menu].id, label: props.menus[menu].name });
    }
    const createMenuForm = useForm({
      name: null,
      place: null
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.menus")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.word.menus")
      }, null, _parent));
      _push(`<div class="menu-container row mb-4"><div class="col-12 mb-4"><div class="card"><div class="card-body menu-action-container d-flex align-items-center justify-content-between"><div class="edit-menu d-flex align-items-center">`);
      _push(ssrRenderComponent(unref(Dropdown), {
        class: "pvc-dropdown",
        modelValue: menuForEdit.value,
        "onUpdate:modelValue": ($event) => menuForEdit.value = $event,
        options: menuList.value,
        display: "chip",
        optionLabel: "label",
        optionValue: "id",
        placeholder: _ctx.$t("messages.sentence.select_menu_to_edit")
      }, null, _parent));
      _push(ssrRenderComponent(unref(Link), {
        as: "button",
        disabled: menuForEdit.value == 0,
        href: _ctx.route("admin.menus.edit", menuForEdit.value),
        class: "btn btn-dark btn-square shadow-1 ms-2 lts-05"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="ri-pencil-fill"${_scopeId}></i>`);
          } else {
            return [
              createVNode("i", { class: "ri-pencil-fill" })
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div><button class="create-menu btn btn-primary shadow-1 lts-05" data-bs-toggle="modal" data-bs-target="#addMenu">${ssrInterpolate(_ctx.$t("messages.sentence.create_new_menu"))} <i class="ri-add-line"></i></button><div class="modal fade" id="addMenu" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.create_new_menu"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12 mb-4"><label for="eaMenuTitle" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.menu_title"))}</label><input${ssrRenderAttr("value", unref(createMenuForm).name)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.menu_title"))} class="form-control" id="eaMenuTitle"></div><div class="col-12 mb-4"><label class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.menu_place"))}</label>`);
      _push(ssrRenderComponent(unref(Dropdown), {
        class: "pvc-dropdown",
        modelValue: unref(createMenuForm).place,
        "onUpdate:modelValue": ($event) => unref(createMenuForm).place = $event,
        options: _ctx.menuPlaceList,
        display: "chip",
        optionLabel: "label",
        optionValue: "id",
        placeholder: _ctx.$t("messages.sentence.select_menu_place")
      }, null, _parent));
      _push(`</div></div></div><div class="modal-footer"><button data-bs-dismiss="modal" class="btn btn-sm btn-primary px-3">${ssrInterpolate(_ctx.$t("messages.sentence.create_menu"))}</button></div></form></div></div></div></div></div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Menu/Manage.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
