import { defineComponent, ref, computed, onMounted, watch, onBeforeUnmount, mergeProps, useSSRContext, reactive, resolveDirective, unref, withCtx, createVNode } from "vue";
import { ssrRenderAttrs, ssrRenderComponent, ssrInterpolate, ssrGetDirectiveProps, ssrRenderClass, ssrRenderStyle } from "vue/server-renderer";
import { _ as _sfc_main$2 } from "./AdminLayout-CD07IMsK.js";
import { Head, Link } from "@inertiajs/vue3";
import { _ as _sfc_main$3 } from "./Files-B6eiTnN6.js";
import { EditorState } from "@codemirror/state";
import { EditorView, lineNumbers } from "@codemirror/view";
import { json } from "@codemirror/lang-json";
import { basicSetup } from "codemirror";
import { syntaxHighlighting, HighlightStyle } from "@codemirror/language";
import { tags } from "@lezer/highlight";
import { _ as _export_sfc } from "../ssr.js";
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "laravel-vue-i18n";
import "./Pagination-C1AQrLe3.js";
import "./SearchList-BZnYMQPN.js";
import "lodash/debounce.js";
import "./useRandomNum-DNNSqR7b.js";
import "@vue/server-renderer";
import "@inertiajs/vue3/server";
import "ziggy-js";
import "axios";
import "swiper/bundle";
import "jquery";
import "swiper";
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "CodeMirrorJsonViewer",
  __ssrInlineRender: true,
  props: {
    value: {},
    height: {}
  },
  setup(__props) {
    const props = __props;
    const editorRef = ref(null);
    let editorView = null;
    const editorHeight = computed(() => typeof props.height === "number" ? `${props.height}px` : props.height || "600px");
    const fullHeightExtension = computed(
      () => EditorView.theme({
        ".cm-scroller": {
          height: editorHeight.value,
          overflow: "auto",
          fontFamily: '"Fira Code", monospace',
          fontSize: "14px",
          direction: "ltr"
        },
        ".cm-content": {
          height: editorHeight.value,
          minHeight: editorHeight.value,
          fontFamily: '"Fira Code", monospace',
          fontSize: "14px"
        },
        ".cm-line": { minHeight: "20px" }
      })
    );
    const lightTheme = EditorView.baseTheme({
      "&": { backgroundColor: "#f5f5f5", color: "#2d2d2d" },
      ".cm-content": { caretColor: "transparent" },
      ".cm-line": { color: "#2d2d2d" },
      ".cm-gutters": {
        backgroundColor: "#f5f5f5",
        color: "#9ca3af",
        borderRight: "1px solid #e5e7eb"
      },
      ".cm-activeLine": { backgroundColor: "transparent" },
      ".cm-activeLineGutter": { backgroundColor: "transparent", color: "#9ca3af" },
      ".cm-cursor": { borderLeftColor: "transparent" }
    });
    const highlightStyle = syntaxHighlighting(
      HighlightStyle.define([
        { tag: tags.keyword, color: "#7c3aed" },
        { tag: tags.string, color: "#059669" },
        { tag: tags.number, color: "#b45309" },
        { tag: tags.variableName, color: "#374151" },
        { tag: tags.propertyName, color: "#dc2626" },
        { tag: tags.operator, color: "#2563eb" },
        { tag: tags.comment, color: "#9ca3af", fontStyle: "italic" }
      ])
    );
    const getDocString = (val) => {
      if (typeof val === "string") return val;
      try {
        return JSON.stringify(val, null, 2);
      } catch {
        return String(val);
      }
    };
    const createEditor = (doc) => {
      return new EditorView({
        state: EditorState.create({
          doc,
          extensions: [basicSetup, lineNumbers(), json(), fullHeightExtension.value, lightTheme, highlightStyle, EditorView.editable.of(false)]
        }),
        parent: editorRef.value
      });
    };
    onMounted(() => {
      if (editorRef.value) {
        editorView = createEditor(getDocString(props.value));
      }
    });
    watch(
      () => props.value,
      (newVal) => {
        if (editorView) {
          editorView.setState(
            EditorState.create({
              doc: getDocString(newVal),
              extensions: [basicSetup, lineNumbers(), json(), fullHeightExtension.value, lightTheme, highlightStyle, EditorView.editable.of(false)]
            })
          );
        }
      }
    );
    onBeforeUnmount(() => {
      editorView == null ? void 0 : editorView.destroy();
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({
        ref_key: "editorRef",
        ref: editorRef,
        class: "codemirror-editor-container"
      }, _attrs))} data-v-f5b244b7></div>`);
    };
  }
});
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Common/CodeMirrorJsonViewer.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const CodeMirrorJsonViewer = /* @__PURE__ */ _export_sfc(_sfc_main$1, [["__scopeId", "data-v-f5b244b7"]]);
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$2
  },
  __name: "Manage",
  __ssrInlineRender: true,
  props: {
    apiKey: {}
  },
  setup(__props) {
    const loading = ref(false);
    const productJsonOutput = reactive({
      products: {
        success: true,
        response: {
          current_page: 1,
          data: [
            {
              id: 1,
              uuid: "p-123456789",
              user_id: 1,
              edited_by: 1,
              brand: {
                id: 1,
                title: "عنوان برند",
                slug: "نامک",
                logo: "https://domain.com/media/library/2025-01-27/1/file.1737927464.31207.webp",
                status: "publish",
                created_at: "2025-01-26T21:39:56.000000Z",
                updated_at: "2025-10-05T20:46:19.000000Z"
              },
              category: {
                id: 1,
                title: "عنوان دسته‌بندی",
                slug: "نامک",
                image: "https://domain.com/media/library/2025-01-26/1/file.1737922577.36938.webp",
                status: "publish",
                created_at: "2025-01-25T15:59:38.000000Z",
                updated_at: "2025-09-05T16:43:06.000000Z"
              },
              title: "عنوان محصول",
              title_en: "product english title",
              content: "محتوای نقد و بررسی محصول در اینجا قرار میگیرد.",
              warnings: "هشدار ها و توضیحات اضافی",
              tabs: [],
              guide: "راهنمای متغیر های محصول در اینجا قرار میگیرد.",
              images: [
                {
                  link: "https://domain.com/media/library/2025-10-06/1/file.1759758169.10534.webp",
                  alt: "عنوان تصویر"
                },
                {
                  link: "https://domain.com/media/library/2025-10-06/1/file.1759758125.77972.webp",
                  alt: "عنوان تصویر"
                }
              ],
              videos: [],
              model_3d: null,
              attrs: [
                {
                  key: "عنوان ویژگی برجسته",
                  value: "مقدار ویژگی برجسه"
                },
                {
                  key: "عنوان ویژگی برجسته",
                  value: "مقدار ویژگی برجسه"
                }
              ],
              specifications: [
                {
                  id: 1,
                  title: "مشخصات فنی",
                  keys: [
                    {
                      id: 1,
                      key: "کلید",
                      value: "مقدار"
                    },
                    {
                      id: 2,
                      key: "کلید",
                      value: "مقدار"
                    }
                  ]
                }
              ],
              seo_title: "عنوان سئو",
              seo_description: "توضیحات سئو",
              seo_keywords: "کلمات کلیدی سئو (منسوخ شده)",
              seo_canonical: "لینک کنونیکال",
              view_count: 1e3,
              in_stock_status: true,
              inquiry_options: {
                landline_phone: "00000000",
                cellular_phone: "00000000000"
              },
              variables: [
                {
                  name: "رنگ",
                  type: "color",
                  active: true
                },
                {
                  name: "گارانتی",
                  type: "warranty",
                  active: true
                },
                {
                  name: "سایز",
                  type: "text",
                  active: true
                }
              ],
              inventories: [
                /** آرایه ای از تنوع موجودی های محصول */
              ],
              commission: 1,
              // برحسب درصد
              is_vip: false,
              comment_status: true,
              question_status: true,
              status: "publish",
              created_at: "2025-10-05T21:36:38.000000Z",
              updated_at: "2025-10-07T14:01:18.000000Z"
            }
          ],
          per_page: 1,
          total: 1
        },
        code: 200
      },
      product: {
        success: true,
        response: {
          id: 1,
          uuid: "p-123456789",
          user_id: 1,
          edited_by: 1,
          brand: {
            id: 1,
            title: "عنوان برند",
            slug: "نامک",
            logo: "https://domain.com/media/library/2025-01-27/1/file.1737927464.31207.webp",
            status: "publish",
            created_at: "2025-01-26T21:39:56.000000Z",
            updated_at: "2025-10-05T20:46:19.000000Z"
          },
          category: {
            id: 1,
            title: "عنوان دسته‌بندی",
            slug: "نامک",
            image: "https://domain.com/media/library/2025-01-26/1/file.1737922577.36938.webp",
            status: "publish",
            created_at: "2025-01-25T15:59:38.000000Z",
            updated_at: "2025-09-05T16:43:06.000000Z"
          },
          title: "عنوان محصول",
          title_en: "product english title",
          content: "محتوای نقد و بررسی محصول در اینجا قرار میگیرد.",
          warnings: "هشدار ها و توضیحات اضافی",
          tabs: [],
          guide: "راهنمای متغیر های محصول در اینجا قرار میگیرد.",
          images: [
            {
              link: "https://domain.com/media/library/2025-10-06/1/file.1759758169.10534.webp",
              alt: "عنوان تصویر"
            },
            {
              link: "https://domain.com/media/library/2025-10-06/1/file.1759758125.77972.webp",
              alt: "عنوان تصویر"
            }
          ],
          videos: [],
          model_3d: null,
          attrs: [
            {
              key: "عنوان ویژگی برجسته",
              value: "مقدار ویژگی برجسه"
            },
            {
              key: "عنوان ویژگی برجسته",
              value: "مقدار ویژگی برجسه"
            }
          ],
          specifications: [
            {
              id: 1,
              title: "مشخصات فنی",
              keys: [
                {
                  id: 1,
                  key: "کلید",
                  value: "مقدار"
                },
                {
                  id: 2,
                  key: "کلید",
                  value: "مقدار"
                }
              ]
            }
          ],
          seo_title: "عنوان سئو",
          seo_description: "توضیحات سئو",
          seo_keywords: "کلمات کلیدی سئو (منسوخ شده)",
          seo_canonical: "لینک کنونیکال",
          view_count: 1e3,
          in_stock_status: true,
          inquiry_options: {
            landline_phone: "00000000",
            cellular_phone: "00000000000"
          },
          variables: [
            {
              name: "رنگ",
              type: "color",
              active: true
            },
            {
              name: "گارانتی",
              type: "warranty",
              active: true
            },
            {
              name: "سایز",
              type: "text",
              active: true
            }
          ],
          inventories: [
            /** آرایه ای از تنوع موجودی های محصول */
          ],
          commission: 1,
          // برحسب درصد
          is_vip: false,
          comment_status: true,
          question_status: true,
          status: "publish",
          created_at: "2025-10-05T21:36:38.000000Z",
          updated_at: "2025-10-07T14:01:18.000000Z"
        },
        code: 200
      },
      product_create: {
        success: true,
        message: "محصول با موفقیت ایجاد شد",
        product_uuid: "p-123456789",
        code: 200
      },
      product_update: {
        success: true,
        message: "محصول با موفقیت ویرایش شد",
        code: 200
      },
      product_delete: {
        success: true,
        message: "محصول با موفقیت حذف شد",
        code: 200
      }
    });
    const inventoryJsonOutput = {
      inventories: {
        success: true,
        response: {
          current_page: 1,
          data: [
            {
              id: 1,
              uuid: "inv-123456789",
              variables: [
                {
                  id: 1,
                  name: "رنگ",
                  type: "color",
                  value: {
                    label: "فیروزه ای",
                    color: "#48d1cc",
                    image: null
                  }
                },
                {
                  id: 2,
                  name: "گارانتی",
                  type: "warranty",
                  value: "18 ماهه شرکتی"
                }
              ],
              price: 1e6,
              discount_price: 85e4,
              discount_expire: "1404/07/25",
              discount_tree: [
                {
                  count: 5,
                  price: 8e5
                },
                {
                  count: 10,
                  price: 75e4
                }
              ],
              count: 100,
              min_sale: 1,
              max_sale: null,
              original: true,
              used: false,
              weight: 400,
              image: {
                url: "https://domain.com/media/library/2025-10-07/1/file.1759847668.25274.webp",
                alt: "a32"
              },
              price_changes: {
                price: [11e5],
                date: ["04/07/15"]
              },
              send_time: "ارسال 1 هفته کاری",
              status: "publish",
              created_at: "2025-10-07T14:01:04.000000Z",
              updated_at: "2025-10-07T14:43:55.000000Z",
              store: null,
              storage: {
                id: 2,
                uuid: "storage-123456",
                name: "تهران",
                address: "انبار مرکزی تهران",
                product_count: 10,
                created_at: "2025-01-25T15:54:09.000000Z",
                updated_at: "2025-01-25T15:54:09.000000Z"
              },
              product: {
                id: 1,
                uuid: "p-123456789",
                title: "عنوان محصول",
                slug: "نامک",
                variables: {
                  "40": {
                    child: "0",
                    name: "رنگ",
                    type: "color"
                  },
                  "41": {
                    child: "40",
                    name: "گارانتی",
                    type: "warranty"
                  }
                },
                commission: 1.5,
                created_at: "2025-01-28T16:39:41.000000Z",
                updated_at: "2025-10-08T18:01:47.000000Z"
              }
            }
          ],
          per_page: 1,
          total: 1
        },
        code: 200
      },
      inventory: {
        success: true,
        response: {
          id: 1,
          uuid: "inv-123456789",
          variables: [
            {
              id: 1,
              name: "رنگ",
              type: "color",
              value: {
                label: "فیروزه ای",
                color: "#48d1cc",
                image: null
              }
            },
            {
              id: 2,
              name: "گارانتی",
              type: "warranty",
              value: "18 ماهه شرکتی"
            }
          ],
          price: 1e6,
          discount_price: 85e4,
          discount_expire: "1404/07/25",
          discount_tree: [
            {
              count: 5,
              price: 8e5
            },
            {
              count: 10,
              price: 75e4
            }
          ],
          count: 100,
          min_sale: 1,
          max_sale: null,
          original: true,
          used: false,
          weight: 400,
          image: {
            url: "https://domain.com/media/library/2025-10-07/1/file.1759847668.25274.webp",
            alt: "a32"
          },
          price_changes: {
            price: [11e5],
            date: ["04/07/15"]
          },
          send_time: "ارسال 1 هفته کاری",
          status: "publish",
          created_at: "2025-10-07T14:01:04.000000Z",
          updated_at: "2025-10-07T14:43:55.000000Z",
          store: null,
          storage: {
            id: 2,
            uuid: "storage-123456",
            name: "تهران",
            address: "انبار مرکزی تهران",
            product_count: 10,
            created_at: "2025-01-25T15:54:09.000000Z",
            updated_at: "2025-01-25T15:54:09.000000Z"
          },
          product: {
            id: 1,
            uuid: "p-123456789",
            title: "عنوان محصول",
            slug: "نامک",
            variables: {
              "40": {
                child: "0",
                name: "رنگ",
                type: "color"
              },
              "41": {
                child: "40",
                name: "گارانتی",
                type: "warranty"
              }
            },
            commission: 1.5,
            created_at: "2025-01-28T16:39:41.000000Z",
            updated_at: "2025-10-08T18:01:47.000000Z"
          }
        },
        code: 200
      },
      inventory_create: {
        success: true,
        message: "موجودی ایجاد شد",
        inventory_uuid: "inv-123456789",
        code: 200
      },
      inventory_update: {
        success: true,
        message: "موجودی بروزرسانی شد",
        inventory_uuid: "inv-123456789",
        code: 200
      },
      inventory_delete: {
        success: true,
        message: "موجودی حذف شد",
        code: 200
      }
    };
    const storageJsonOutput = {
      storages: {
        success: true,
        response: {
          current_page: 1,
          data: [
            {
              id: 2,
              uuid: "storage-123456",
              name: "تهران",
              address: "انبار مرکزی تهران",
              created_at: "2025-01-25T15:54:09.000000Z",
              updated_at: "2025-01-25T15:54:09.000000Z"
            }
          ],
          per_page: 20,
          total: 2
        },
        code: 200
      }
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _directive_tooltip = resolveDirective("tooltip");
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.web_service")
      }, null, _parent));
      _push(`<div class="container-fluid web-service-container">`);
      _push(ssrRenderComponent(_sfc_main$3, {
        title: _ctx.$t("messages.word.web_service")
      }, null, _parent));
      _push(`<div class="web-service mb-4"><div class="card p-3"><div class="card-body"><div class="fw-bold text-dark fs-6 mb-2">${ssrInterpolate(_ctx.$t("messages.sentence.api_key"))}</div><div class="api-key-section d-flex align-items-center justify-content-between bg-light br-20 p-2 mb-3">`);
      if (_ctx.apiKey) {
        _push(`<div class="api-key-code text-end ps-3 clickable">${ssrInterpolate(_ctx.apiKey)}</div>`);
      } else {
        _push(`<div class="api-key-code text-end ps-3 text-gray fs-8">${ssrInterpolate(_ctx.$t("messages.sentence.no_keys_have_been_created_yet"))}</div>`);
      }
      _push(`<div>`);
      if (_ctx.apiKey != null) {
        _push(ssrRenderComponent(unref(Link), mergeProps({
          href: _ctx.route("admin.web_service.delete_key"),
          as: "button",
          method: "delete",
          class: "btn btn-square btn-sm btn-danger me-1"
        }, ssrGetDirectiveProps(_ctx, _directive_tooltip, "حذف کلید", void 0, { right: true })), {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<i class="${ssrRenderClass({ "ri-delete-bin-5-line": true, "i-spin": loading.value })}"${_scopeId}></i>`);
            } else {
              return [
                createVNode("i", {
                  class: { "ri-delete-bin-5-line": true, "i-spin": loading.value }
                }, null, 2)
              ];
            }
          }),
          _: 1
        }, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`<button${ssrRenderAttrs(mergeProps({ class: "btn btn-square btn-sm btn-dark" }, ssrGetDirectiveProps(_ctx, _directive_tooltip, "بازسازی کلید", void 0, { right: true })))}><i class="${ssrRenderClass({ "ri-refresh-line": true, "i-spin": loading.value })}"></i></button></div></div><p class="lts-05 text-gray fs-8 mb-0"><span class="fw-bold text-danger">توجه: </span> کلید api باید بصورت محرمانه حفظ و استفاده شود. لو رفتن این کلید باعث نفوذ و دستکاری در فروشگاه میشود. چنانچه از این کلید استفاده ای نمی‌کنید آن را حذف کنید. </p></div></div></div><div class="card p-3 mb-4"><div class="card-body"><h5 class="fw-bold text-dark mb-4">📘 مستندات API محصولات</h5><div class="accordion lts-05" id="accordionMenu"><div class="accordion-item"><h2 class="accordion-header"><button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-products-index" aria-expanded="false" aria-controls="collapse-products-index"><i class="ri-arrow-drop-left-line me-1"></i> ۱. دریافت لیست محصولات </button></h2><div id="collapse-products-index" class="accordion-collapse collapse" data-bs-parent="#accordionMenu"><div class="accordion-body"><p class="mb-4 text-dark lts-05">برای دریافت لیست کامل محصولات فروشگاه استفاده می‌شود.</p><h6 class="fw-bold text-dark mt-3 mb-2">کلیات:</h6><table class="table table-bordered fs-8 mb-5"><tbody><tr><th class="bg-light w-25">Method</th><td class="text-end">GET</td></tr><tr><th class="bg-light">Endpoint</th><td class="text-end bg-white">/api/v1/products</td></tr><tr><th class="bg-light">Header</th><td class="text-end"><code>X-API-KEY: YOUR_API_KEY</code></td></tr></tbody></table><h6 class="fw-bold text-dark mt-3 mb-2">پارامترهای Query:</h6><table class="table table-bordered fs-8 mb-5"><thead class="table-light"><tr><th>نام</th><th>نوع</th><th>اجباری</th><th>توضیحات</th></tr></thead><tbody><tr><td>page</td><td>integer</td><td>❌</td><td>شماره صفحه</td></tr><tr><td>per_page</td><td>integer</td><td>❌</td><td>تعداد آیتم‌ها در هر صفحه (پیش‌فرض: 100)</td></tr><tr><td>status</td><td>string</td><td>❌</td><td>فیلتر بر اساس وضعیت (publish, draft)</td></tr></tbody></table><h6 class="fw-bold text-dark mt-3 mb-2">نمونه پاسخ (JSON):</h6>`);
      _push(ssrRenderComponent(CodeMirrorJsonViewer, {
        value: productJsonOutput.products
      }, null, _parent));
      _push(`</div></div></div><div class="accordion-item"><h2 class="accordion-header"><button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-products-show" aria-expanded="false" aria-controls="collapse-products-show"><i class="ri-arrow-drop-left-line me-1"></i> ۲. مشاهده جزئیات محصول </button></h2><div id="collapse-products-show" class="accordion-collapse collapse" data-bs-parent="#accordionMenu"><div class="accordion-body"><p class="mb-4 text-dark lts-05">برای دریافت جزئیات کامل یک محصول با استفاده از <b>(شناسه محصول)</b> استفاده می‌شود.</p><h6 class="fw-bold text-dark mt-3 mb-2">کلیات:</h6><table class="table table-bordered fs-8 mb-5"><tbody><tr><th class="bg-light w-25">Method</th><td class="text-end">GET</td></tr><tr><th class="bg-light">Endpoint</th><td class="text-end bg-white">/api/v1/products/show/{uuid}</td></tr><tr><th class="bg-light">Header</th><td class="text-end"><code>X-API-KEY: YOUR_API_KEY</code></td></tr></tbody></table><h6 class="fw-bold text-dark mt-3 mb-2">پارامتر مسیر:</h6><table class="table table-bordered fs-8 mb-5"><thead class="table-light"><tr><th>نام</th><th>نوع</th><th>اجباری</th><th>توضیحات</th></tr></thead><tbody><tr><td>uuid</td><td>string</td><td>✅</td><td>شناسه یکتا محصول</td></tr></tbody></table><h6 class="fw-bold text-dark mt-3 mb-2">نمونه پاسخ (JSON):</h6>`);
      _push(ssrRenderComponent(CodeMirrorJsonViewer, {
        value: productJsonOutput.product
      }, null, _parent));
      _push(`</div></div></div><div class="accordion-item"><h2 class="accordion-header"><button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-products-create" aria-expanded="false" aria-controls="collapse-products-create"><i class="ri-arrow-drop-left-line me-1"></i> ۳. ایجاد محصول جدید </button></h2><div id="collapse-products-create" class="accordion-collapse collapse" data-bs-parent="#accordionMenu"><div class="accordion-body"><p class="mb-4 text-dark lts-05">برای ایجاد یک محصول جدید در فروشگاه از این متد استفاده می‌شود.</p><h6 class="fw- text-dark mt-3 mb-2">کلیات:</h6><table class="table table-bordered fs-8 mb-5"><tbody><tr><th class="bg-light w-25">Method</th><td class="text-end">POST</td></tr><tr><th class="bg-light">Endpoint</th><td class="text-end bg-white">/api/v1/products/create</td></tr><tr><th class="bg-light">Header</th><td class="text-end"><code>X-API-KEY: YOUR_API_KEY</code></td></tr></tbody></table><h6 class="fw-bold text-dark mt-3 mb-2">بدنه درخواست (JSON):</h6><table class="table table-bordered fs-8 mb-5"><thead class="table-light"><tr><th>نام</th><th>نوع</th><th>اجباری</th><th>توضیحات</th></tr></thead><tbody><tr><td>user_id</td><td>integer</td><td>✅</td><td>ID کاربر (باید نوع admin یا owner باشد)</td></tr><tr><td>uuid</td><td>string</td><td>❌</td><td>شناسه یکتا محصول (در صورت ندادن، خودکار ساخته می‌شود)</td></tr><tr><td>category_id</td><td>integer</td><td>✅</td><td>شناسه دسته‌بندی محصول (اگر از قبل وجود نداشته باشد خطا میدهد)</td></tr><tr><td>brand</td><td>string</td><td>❌</td><td>نام برند محصول (اگر وجود نداشته باشد برندی با این نام ساخته میشود)</td></tr><tr><td>title</td><td>string</td><td>✅</td><td>عنوان فارسی محصول</td></tr><tr><td>title_en</td><td>string</td><td>❌</td><td>عنوان انگلیسی محصول</td></tr><tr><td>slug</td><td>string</td><td>❌</td><td>نامک یکتا برای URL محصول (در صورت تکراری بودن خطا می‌دهد) (در صورت خالی بودن خودکار پر میشود)</td></tr><tr><td>content</td><td>string</td><td>❌</td><td>توضیحات کامل محصول</td></tr><tr><td>warnings</td><td>string</td><td>❌</td><td>هشدارها یا نکات احتیاطی درباره محصول</td></tr><tr><td>guide</td><td>string</td><td>❌</td><td>راهنمای متغیر های محصول</td></tr><tr><td>tabs</td><td>array</td><td>❌</td><td><div class="mb-2">تب‌های توضیحی محصول</div><div class="d-flex align-items-center justify-content-between bg-dark br-15 p-2"><span class="fs-9 text-gray">مثال:</span><span style="${ssrRenderStyle({ "direction": "ltr" })}">[{&quot;title&quot;: &quot;عنوان &quot;, &quot;content&quot;: &quot;محتوا&quot;},{...}]</span></div></td></tr><tr><td>attrs</td><td>array</td><td>❌</td><td><div class="mb-2">ویژگی های برجسته محصول</div><div class="d-flex align-items-center justify-content-between bg-dark br-15 p-2"><span class="fs-9 text-gray">مثال:</span><span style="${ssrRenderStyle({ "direction": "ltr" })}">[{&quot;key&quot;: &quot;عنوان &quot;, &quot;value&quot;: &quot;مقدار&quot;},{...}]</span></div></td></tr><tr><td>images</td><td>array</td><td>❌</td><td><div class="mb-2">تصایر محصول (اگر فایل براساس نام در کتابخانه مدیا موجود باشد مجدد بارگذاری نمیشود).</div><div class="d-flex align-items-center justify-content-between bg-dark br-15 p-2"><span class="fs-9 text-gray">مثال:</span><span style="${ssrRenderStyle({ "direction": "ltr" })}">[{&quot;src&quot;: &quot;لینک مستقیم تصویر&quot;, &quot;alt&quot;: &quot;توضیح تصویر&quot;},{...}]</span></div></td></tr><tr><td>videos</td><td>object</td><td>❌</td><td><div class="mb-2">ویدیوی معرفی محصول</div><div class="d-flex align-items-center justify-content-between bg-dark br-15 p-2"><span class="fs-9 text-gray">مثال:</span><span style="${ssrRenderStyle({ "direction": "ltr" })}">{&quot;type&quot;: &quot;url یا aparat&quot;,&quot;link&quot;: &quot;لینک مستقیم ویدیو&quot;,&quot;embed&quot;: &quot;کد امبد آپارات&quot;}</span></div></td></tr><tr><td>model_3d</td><td>string (url)</td><td>❌</td><td>آدرس مدل سه‌بعدی محصول</td></tr><tr><td>price_model</td><td>object array</td><td>❌</td><td><div class="mb-2">متغیر های محصول</div><div class="d-flex align-items-center justify-content-between bg-dark br-15 p-2 mb-1"><span class="fs-9 text-gray">آرایه کلی برای درخواست:</span><span style="${ssrRenderStyle({ "direction": "ltr" })}">[{&quot;type&quot;:&quot;نوع&quot;,&quot;name&quot;:&quot;عنوان&quot;,&quot;active&quot;:&quot;true یا false&quot;}, ...]</span></div><div class="d-flex align-items-center justify-content-between bg-dark br-15 p-2 mb-1"><span class="fs-9 text-gray">دارای رنگبندی:</span><span style="${ssrRenderStyle({ "direction": "ltr" })}">{&quot;type&quot;:&quot;color&quot;,&quot;name&quot;:&quot;رنگ&quot;,&quot;active&quot;:&quot;true یا false&quot;}</span></div><div class="d-flex align-items-center justify-content-between bg-dark br-15 p-2 mb-1"><span class="fs-9 text-gray">دارای گارانتی:</span><span style="${ssrRenderStyle({ "direction": "ltr" })}">{&quot;type&quot;:&quot;warranty&quot;,&quot;name&quot;:&quot;گارانتی&quot;,&quot;active&quot;:&quot;true یا false&quot;}</span></div><div class="d-flex align-items-center justify-content-between bg-dark br-15 p-2"><span class="fs-9 text-gray">متغییر دلخواه:</span><span style="${ssrRenderStyle({ "direction": "ltr" })}">{&quot;type&quot;:&quot;text&quot;,&quot;name&quot;:&quot;سایز&quot;,&quot;active&quot;:&quot;true یا false&quot;}</span></div></td></tr><tr><td>commission</td><td>integer</td><td>❌</td><td>درصد کمیسیون فروشنده (بین 0 تا 100)</td></tr><tr><td>in_stock_status</td><td>boolean</td><td>❌</td><td>وضعیت موجودی محصول (اگر false باشد باید تلفن تماس پر باشد)</td></tr><tr><td>inquiry_options</td><td>object</td><td>❌</td><td><div class="mb-2">اطلاعات تماس برای استعلام شامل تلفن ثابت و تلفن همراه</div><div class="d-flex align-items-center justify-content-between bg-dark br-15 p-2"><span class="fs-9 text-gray">مثال:</span><span style="${ssrRenderStyle({ "direction": "ltr" })}">{&quot;landline_phone&quot;: &quot;تلفن ثابت&quot;, &quot;cellular_phone&quot;: &quot;تلفن همراه&quot;}</span></div></td></tr><tr><td>seo_title</td><td>string</td><td>❌</td><td>عنوان سئو برای نمایش در نتایج موتورهای جستجو</td></tr><tr><td>seo_description</td><td>string</td><td>❌</td><td>توضیحات سئو</td></tr><tr><td>seo_canonical</td><td>string (url)</td><td>❌</td><td>آدرس canonical صفحه محصول (اگر خالی باشد خودکار با همین محصول پر میشود)</td></tr><tr><td>is_vip</td><td>boolean</td><td>❌</td><td>وضعیت ویژه بودن محصول (VIP)</td></tr><tr><td>comment_status</td><td>boolean</td><td>❌</td><td>فعال یا غیرفعال بودن بخش نظرات</td></tr><tr><td>question_status</td><td>boolean</td><td>❌</td><td>فعال بودن بخش پرسش و پاسخ کاربران</td></tr><tr><td>status</td><td>string</td><td>❌</td><td>وضعیت محصول (publish, draft) - (اگر پر نشود publish در نظر گرفته میشود)</td></tr></tbody></table><h6 class="fw-bold text-dark mt-3 mb-2">نمونه پاسخ (JSON):</h6>`);
      _push(ssrRenderComponent(CodeMirrorJsonViewer, {
        height: "130px",
        value: productJsonOutput.product_create
      }, null, _parent));
      _push(`</div></div></div><div class="accordion-item"><h2 class="accordion-header"><button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-products-update" aria-expanded="false" aria-controls="collapse-products-update"><i class="ri-arrow-drop-left-line me-1"></i> ۴. ویرایش محصول </button></h2><div id="collapse-products-update" class="accordion-collapse collapse" data-bs-parent="#accordionMenu"><div class="accordion-body"><p class="mb-4 text-dark lts-05">برای ویرایش جزئیات یک محصول موجود در فروشگاه استفاده می‌شود.</p><h6 class="fw-bold text-dark mt-3 mb-2">کلیات:</h6><table class="table table-bordered fs-8 mb-5"><tbody><tr><th class="bg-light w-25">Method</th><td class="text-end">PUT</td></tr><tr><th class="bg-light">Endpoint</th><td class="text-end bg-white">/api/v1/products/update/{uuid}</td></tr><tr><th class="bg-light">Header</th><td class="text-end"><code>X-API-KEY: YOUR_API_KEY</code></td></tr></tbody></table><h6 class="fw-bold text-dark mt-3 mb-2">پارامتر مسیر:</h6><table class="table table-bordered fs-8 mb-5"><thead class="table-light"><tr><th>نام</th><th>نوع</th><th>اجباری</th><th>توضیحات</th></tr></thead><tbody><tr><td>uuid</td><td>string</td><td>✅</td><td>شناسه یکتا محصول</td></tr></tbody></table><h6 class="fw-bold text-dark mt-3 mb-2">بدنه درخواست (JSON):</h6><table class="table table-bordered fs-8 mb-5"><thead class="table-light"><tr><th>نام</th><th>نوع</th><th>اجباری</th><th>توضیحات</th></tr></thead><tbody><tr><td>user_id</td><td>integer</td><td>✅</td><td>ID کاربر (باید نوع admin یا owner باشد)</td></tr><tr><td>category_id</td><td>integer</td><td>❌</td><td>شناسه دسته‌بندی محصول (اگر از قبل وجود نداشته باشد خطا میدهد)</td></tr><tr><td>brand</td><td>string</td><td>❌</td><td>نام برند محصول (اگر وجود نداشته باشد برندی با این نام ساخته میشود)</td></tr><tr><td>title</td><td>string</td><td>❌</td><td>عنوان فارسی محصول</td></tr><tr><td>title_en</td><td>string</td><td>❌</td><td>عنوان انگلیسی محصول</td></tr><tr><td>slug</td><td>string</td><td>❌</td><td>نامک یکتا برای URL محصول (در صورت تکراری بودن خطا می‌دهد) (در صورت خالی بودن خودکار پر میشود)</td></tr><tr><td>content</td><td>string</td><td>❌</td><td>توضیحات کامل محصول</td></tr><tr><td>warnings</td><td>string</td><td>❌</td><td>هشدارها یا نکات احتیاطی درباره محصول</td></tr><tr><td>guide</td><td>string</td><td>❌</td><td>راهنمای متغیر های محصول</td></tr><tr><td>tabs</td><td>array</td><td>❌</td><td><div class="mb-2">تب‌های توضیحی محصول</div><div class="d-flex align-items-center justify-content-between bg-dark br-15 p-2"><span class="fs-9 text-gray">مثال:</span><span style="${ssrRenderStyle({ "direction": "ltr" })}">[{&quot;title&quot;: &quot;عنوان &quot;, &quot;content&quot;: &quot;محتوا&quot;},{...}]</span></div></td></tr><tr><td>attrs</td><td>array</td><td>❌</td><td><div class="mb-2">ویژگی های برجسته محصول</div><div class="d-flex align-items-center justify-content-between bg-dark br-15 p-2"><span class="fs-9 text-gray">مثال:</span><span style="${ssrRenderStyle({ "direction": "ltr" })}">[{&quot;key&quot;: &quot;عنوان &quot;, &quot;value&quot;: &quot;مقدار&quot;},{...}]</span></div></td></tr><tr><td>images</td><td>array</td><td>❌</td><td><div class="mb-2">تصایر محصول (اگر فایل براساس نام در کتابخانه مدیا موجود باشد مجدد بارگذاری نمیشود).</div><div class="d-flex align-items-center justify-content-between bg-dark br-15 p-2"><span class="fs-9 text-gray">مثال:</span><span style="${ssrRenderStyle({ "direction": "ltr" })}">[{&quot;src&quot;: &quot;لینک مستقیم تصویر&quot;, &quot;alt&quot;: &quot;توضیح تصویر&quot;},{...}]</span></div></td></tr><tr><td>videos</td><td>object</td><td>❌</td><td><div class="mb-2">ویدیوی معرفی محصول</div><div class="d-flex align-items-center justify-content-between bg-dark br-15 p-2"><span class="fs-9 text-gray">مثال:</span><span style="${ssrRenderStyle({ "direction": "ltr" })}">{&quot;type&quot;: &quot;url یا aparat&quot;,&quot;link&quot;: &quot;لینک مستقیم ویدیو&quot;,&quot;embed&quot;: &quot;کد امبد آپارات&quot;}</span></div></td></tr><tr><td>model_3d</td><td>string (url)</td><td>❌</td><td>آدرس مدل سه‌بعدی محصول</td></tr><tr><td>price_model</td><td>object array</td><td>❌</td><td><div class="mb-2">متغیر های محصول <span class="text-danger">(توجه: تنها در صورتی که محصول تنوع موجودی نداشته باشد بروزرسانی میشود)</span></div><div class="d-flex align-items-center justify-content-between bg-dark br-15 p-2 mb-1"><span class="fs-9 text-gray">آرایه کلی برای درخواست:</span><span style="${ssrRenderStyle({ "direction": "ltr" })}">[{&quot;type&quot;:&quot;نوع&quot;,&quot;name&quot;:&quot;عنوان&quot;,&quot;active&quot;:&quot;true یا false&quot;}, ...]</span></div><div class="d-flex align-items-center justify-content-between bg-dark br-15 p-2 mb-1"><span class="fs-9 text-gray">دارای رنگبندی:</span><span style="${ssrRenderStyle({ "direction": "ltr" })}">{&quot;type&quot;:&quot;color&quot;,&quot;name&quot;:&quot;رنگ&quot;,&quot;active&quot;:&quot;true یا false&quot;}</span></div><div class="d-flex align-items-center justify-content-between bg-dark br-15 p-2 mb-1"><span class="fs-9 text-gray">دارای گارانتی:</span><span style="${ssrRenderStyle({ "direction": "ltr" })}">{&quot;type&quot;:&quot;warranty&quot;,&quot;name&quot;:&quot;گارانتی&quot;,&quot;active&quot;:&quot;true یا false&quot;}</span></div><div class="d-flex align-items-center justify-content-between bg-dark br-15 p-2"><span class="fs-9 text-gray">متغییر دلخواه:</span><span style="${ssrRenderStyle({ "direction": "ltr" })}">{&quot;type&quot;:&quot;text&quot;,&quot;name&quot;:&quot;سایز&quot;,&quot;active&quot;:&quot;true یا false&quot;}</span></div></td></tr><tr><td>commission</td><td>integer</td><td>❌</td><td>درصد کمیسیون فروشنده (بین 0 تا 100)</td></tr><tr><td>in_stock_status</td><td>boolean</td><td>❌</td><td>وضعیت موجودی محصول (اگر false باشد باید تلفن تماس پر باشد)</td></tr><tr><td>inquiry_options</td><td>object</td><td>❌</td><td><div class="mb-2">اطلاعات تماس برای استعلام شامل تلفن ثابت و تلفن همراه</div><div class="d-flex align-items-center justify-content-between bg-dark br-15 p-2"><span class="fs-9 text-gray">مثال:</span><span style="${ssrRenderStyle({ "direction": "ltr" })}">{&quot;landline_phone&quot;: &quot;تلفن ثابت&quot;, &quot;cellular_phone&quot;: &quot;تلفن همراه&quot;}</span></div></td></tr><tr><td>seo_title</td><td>string</td><td>❌</td><td>عنوان سئو برای نمایش در نتایج موتورهای جستجو</td></tr><tr><td>seo_description</td><td>string</td><td>❌</td><td>توضیحات سئو</td></tr><tr><td>seo_canonical</td><td>string (url)</td><td>❌</td><td>آدرس canonical صفحه محصول (اگر خالی باشد خودکار با همین محصول پر میشود)</td></tr><tr><td>is_vip</td><td>boolean</td><td>❌</td><td>وضعیت ویژه بودن محصول (VIP)</td></tr><tr><td>comment_status</td><td>boolean</td><td>❌</td><td>فعال یا غیرفعال بودن بخش نظرات</td></tr><tr><td>question_status</td><td>boolean</td><td>❌</td><td>فعال بودن بخش پرسش و پاسخ کاربران</td></tr><tr><td>status</td><td>string</td><td>❌</td><td>وضعیت محصول (publish, draft) - (اگر پر نشود publish در نظر گرفته میشود)</td></tr></tbody></table><h6 class="fw-bold text-dark mt-3 mb-2">نمونه پاسخ (JSON):</h6>`);
      _push(ssrRenderComponent(CodeMirrorJsonViewer, {
        height: "130px",
        value: productJsonOutput.product_update
      }, null, _parent));
      _push(`</div></div></div><div class="accordion-item"><h2 class="accordion-header"><button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-products-delete" aria-expanded="false" aria-controls="collapse-products-delete"><i class="ri-arrow-drop-left-line me-1"></i> ۵. حذف محصول </button></h2><div id="collapse-products-delete" class="accordion-collapse collapse" data-bs-parent="#accordionMenu"><div class="accordion-body"><p class="mb-4 text-dark lts-05">برای حذف یک محصول از فروشگاه بر اساس uuid استفاده می‌شود.</p><h6 class="fw-bold text-dark mt-3 mb-2">کلیات:</h6><table class="table table-bordered fs-8 mb-5"><tbody><tr><th class="bg-light w-25">Method</th><td class="text-end">DELETE</td></tr><tr><th class="bg-light">Endpoint</th><td class="text-end bg-white">/api/v1/products/delete/{uuid}</td></tr><tr><th class="bg-light">Header</th><td class="text-end"><code>X-API-KEY: YOUR_API_KEY</code></td></tr></tbody></table><h6 class="fw-bold text-dark mt-3 mb-2">پارامتر مسیر:</h6><table class="table table-bordered fs-8 mb-5"><thead class="table-light"><tr><th>نام</th><th>نوع</th><th>اجباری</th><th>توضیحات</th></tr></thead><tbody><tr><td>uuid</td><td>string</td><td>✅</td><td>شناسه یکتا محصول</td></tr></tbody></table><h6 class="fw-bold text-dark mt-3 mb-2">نمونه پاسخ (JSON):</h6>`);
      _push(ssrRenderComponent(CodeMirrorJsonViewer, {
        height: "130px",
        value: productJsonOutput.product_delete
      }, null, _parent));
      _push(`</div></div></div></div></div></div><div class="card p-3 mb-4"><div class="card-body"><h5 class="fw-bold text-dark mb-4">📘 مستندات API موجودی‌ها</h5><div class="accordion lts-05" id="accordionInventoryMenu"><div class="accordion-item"><h2 class="accordion-header"><button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-inventories-index" aria-expanded="false" aria-controls="collapse-inventories-index"><i class="ri-arrow-drop-left-line me-1"></i> ۱. دریافت لیست موجودی‌های محصول </button></h2><div id="collapse-inventories-index" class="accordion-collapse collapse" data-bs-parent="#accordionInventoryMenu"><div class="accordion-body"><p class="mb-4 text-dark lts-05">برای دریافت لیست موجودی‌های یک محصول خاص استفاده می‌شود.</p><h6 class="fw-bold text-dark mt-3 mb-2">کلیات:</h6><table class="table table-bordered fs-8 mb-5"><tbody><tr><th class="bg-light w-25">Method</th><td class="text-end">GET</td></tr><tr><th class="bg-light">Endpoint</th><td class="text-end bg-white">/api/v1/inventories/product/{product_uuid}</td></tr><tr><th class="bg-light">Header</th><td class="text-end"><code>X-API-KEY: YOUR_API_KEY</code></td></tr></tbody></table><h6 class="fw-bold text-dark mt-3 mb-2">پارامتر مسیر:</h6><table class="table table-bordered fs-8 mb-5"><thead class="table-light"><tr><th>نام</th><th>نوع</th><th>اجباری</th><th>توضیحات</th></tr></thead><tbody><tr><td>product_uuid</td><td>string</td><td>✅</td><td>شناسه یکتا محصول</td></tr></tbody></table><h6 class="fw-bold text-dark mt-3 mb-2">پارامترهای Query:</h6><table class="table table-bordered fs-8 mb-5"><thead class="table-light"><tr><th>نام</th><th>نوع</th><th>اجباری</th><th>توضیحات</th></tr></thead><tbody><tr><td>page</td><td>integer</td><td>❌</td><td>شماره صفحه</td></tr><tr><td>per_page</td><td>integer</td><td>❌</td><td>تعداد آیتم‌ها در هر صفحه (پیش‌فرض: 100)</td></tr></tbody></table><h6 class="fw-bold text-dark mt-3 mb-2">نمونه پاسخ (JSON):</h6>`);
      _push(ssrRenderComponent(CodeMirrorJsonViewer, {
        value: inventoryJsonOutput.inventories
      }, null, _parent));
      _push(`</div></div></div><div class="accordion-item"><h2 class="accordion-header"><button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-inventories-show" aria-expanded="false" aria-controls="collapse-inventories-show"><i class="ri-arrow-drop-left-line me-1"></i> ۲. مشاهده جزئیات موجودی </button></h2><div id="collapse-inventories-show" class="accordion-collapse collapse" data-bs-parent="#accordionInventoryMenu"><div class="accordion-body"><p class="mb-4 text-dark lts-05">برای دریافت جزئیات یک موجودی خاص با استفاده از UUID موجودی.</p><h6 class="fw-bold text-dark mt-3 mb-2">کلیات:</h6><table class="table table-bordered fs-8 mb-5"><tbody><tr><th class="bg-light w-25">Method</th><td class="text-end">GET</td></tr><tr><th class="bg-light">Endpoint</th><td class="text-end bg-white">/api/v1/inventories/show/{inventory_uuid}</td></tr><tr><th class="bg-light">Header</th><td class="text-end"><code>X-API-KEY: YOUR_API_KEY</code></td></tr></tbody></table><h6 class="fw-bold text-dark mt-3 mb-2">پارامتر مسیر:</h6><table class="table table-bordered fs-8 mb-5"><thead class="table-light"><tr><th>نام</th><th>نوع</th><th>اجباری</th><th>توضیحات</th></tr></thead><tbody><tr><td>inventory_uuid</td><td>string</td><td>✅</td><td>شناسه یکتا موجودی</td></tr></tbody></table><h6 class="fw-bold text-dark mt-3 mb-2">نمونه پاسخ (JSON):</h6>`);
      _push(ssrRenderComponent(CodeMirrorJsonViewer, {
        value: inventoryJsonOutput.inventory
      }, null, _parent));
      _push(`</div></div></div><div class="accordion-item"><h2 class="accordion-header"><button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-inventories-create" aria-expanded="false" aria-controls="collapse-inventories-create"><i class="ri-arrow-drop-left-line me-1"></i> ۳. ایجاد موجودی جدید برای محصول </button></h2><div id="collapse-inventories-create" class="accordion-collapse collapse" data-bs-parent="#accordionInventoryMenu"><div class="accordion-body"><p class="mb-4 text-dark lts-05">ایجاد موجودی جدید برای محصول مشخص با UUID محصول.</p><h6 class="fw-bold text-dark mt-3 mb-2">کلیات:</h6><table class="table table-bordered fs-8 mb-5"><tbody><tr><th class="bg-light w-25">Method</th><td class="text-end">POST</td></tr><tr><th class="bg-light">Endpoint</th><td class="text-end bg-white">/api/v1/inventories/product/{product_uuid}/create</td></tr><tr><th class="bg-light">Header</th><td class="text-end"><code>X-API-KEY: YOUR_API_KEY</code></td></tr></tbody></table><h6 class="fw-bold text-dark mt-3 mb-2">پارامتر مسیر:</h6><table class="table table-bordered fs-8 mb-5"><thead class="table-light"><tr><th>نام</th><th>نوع</th><th>اجباری</th><th>توضیحات</th></tr></thead><tbody><tr><td>product_uuid</td><td>string</td><td>✅</td><td>شناسه یکتا محصول</td></tr></tbody></table><h6 class="fw-bold text-dark mt-3 mb-2">بدنه درخواست (JSON):</h6><table class="table table-bordered fs-8 mb-5"><thead class="table-light"><tr><th>نام</th><th>نوع</th><th>اجباری</th><th>توضیحات</th></tr></thead><tbody><tr><td>user_id</td><td>integer</td><td>✅</td><td>شناسه کاربر (admin یا owner)</td></tr><tr><td>storage_uuid</td><td>string</td><td>✅</td><td>شناسه انبار (در جدول لیست انبار ها قابل رویت است)</td></tr><tr><td>variables</td><td>nested object</td><td>✅</td><td><div class="mb-2">متغیر های موجودی - در صورتی که محصول متغییر داشته باشد ضروری است</div><div class="mb-2"> ابتدا باید از وبسرویس, جزئیات محصولی که قصد وارد کردن موجودی در آن را داریم, دریافت شود. سپس مقدار object مربوط به variables محصول را عینا برداشته و با تکمیل کردن value برای هر متغیر ان را در ورودی variables به api ایجاد موجودی پاس دهیم. </div><div class="mb-2"> بنابراین مقدار key هر متغیر از این طریق به دست می‌آید. که در مثال زیر key متغیر رنگ 7 است و مقدار key متغیر ظرفیت باطری 8 است که مقدار child متغیر رنگ به عنوان شروع متغیر ها 0 صفر و مقدار child متغیر ظرفیت باطری برابر با 7 که key مربوط به متغیر سطح بالاتر یعنی رنگ میباشد, که نهایتا کل این object از وبسرویس دریافت جزئیات محصول بدست آمده است و عینا کپی و پس از ست کردن مقدار value در ورودی variables وبسرویس ایجاد موجودی استفاده میشود. </div><div class="d-flex align-items-center justify-content-between bg-dark br-15 p-2"><span class="fs-9 text-gray">مثال:</span><span style="${ssrRenderStyle({ "direction": "ltr" })}">{&quot;7&quot;: {&quot;child&quot;: &quot;0&quot;,&quot;name&quot;: &quot;رنگ&quot;,&quot;type&quot;: &quot;color&quot;, &quot;value&quot;: { &quot;label&quot;: &quot;سیاه&quot;,&quot;color&quot;: &quot;#000000&quot;}},&quot;8&quot;: {&quot;child&quot;: &quot;7&quot;,&quot;name&quot;: &quot;ظرفیت باطری&quot;, &quot;type&quot;: &quot;text&quot;,&quot;value&quot;: &quot;5900 میلی آمپر&quot;}}</span></div></td></tr><tr><td>price</td><td>integer</td><td>✅</td><td>قیمت</td></tr><tr><td>discount_price</td><td>integer</td><td>❌</td><td>قیمت تخفیف</td></tr><tr><td>discount_expire</td><td>string (Y/m/d)</td><td>❌</td><td>تاریخ انقضا تخفیف</td></tr><tr><td>discount_tree</td><td>array</td><td>❌</td><td><div class="mb-2">لیست تخفیف پلکانی</div><div class="d-flex align-items-center justify-content-between bg-dark br-15 p-2"><span class="fs-9 text-gray">مثال:</span><span style="${ssrRenderStyle({ "direction": "ltr" })}">[{&quot;count&quot;: 5,&quot;price&quot;: 4000000},{ &quot;count&quot;: 10, &quot;price&quot;: 300000}]</span></div></td></tr><tr><td>count</td><td>integer</td><td>✅</td><td>تعداد موجودی</td></tr><tr><td>min_sale</td><td>integer</td><td>❌</td><td>حداقل فروش (پیش‌فرض: 1)</td></tr><tr><td>max_sale</td><td>integer</td><td>❌</td><td>حداکثر فروش</td></tr><tr><td>original</td><td>boolean</td><td>❌</td><td>اصالت کالا</td></tr><tr><td>used</td><td>boolean</td><td>❌</td><td>وضعیت کالا</td></tr><tr><td>weight</td><td>integer</td><td>❌</td><td>وزن محصول (برحسب گرم)</td></tr><tr><td>purchase_price</td><td>integer</td><td>❌</td><td>قیمت خرید (صرفا جنبه اطلاعرسانی به مدیر را دارد)</td></tr><tr><td>image</td><td>object</td><td>❌</td><td><div class="mb-2">تصویر مرتبط با موجودی (اگر فایل براساس نام در کتابخانه مدیا موجود باشد مجدد بارگذاری نمیشود)</div><div class="d-flex align-items-center justify-content-between bg-dark br-15 p-2"><span class="fs-9 text-gray">مثال:</span><span style="${ssrRenderStyle({ "direction": "ltr" })}">{&quot;url&quot;: &quot;لینک تصویر&quot;,&quot;alt&quot;: &quot;عنوان تصویر&quot;}</span></div></td></tr><tr><td>send_time</td><td>string</td><td>❌</td><td>زمان ارسال - (مثال: 3 روز کاری)</td></tr></tbody></table><h6 class="fw-bold text-dark mt-3 mb-2">نمونه پاسخ (JSON):</h6>`);
      _push(ssrRenderComponent(CodeMirrorJsonViewer, {
        height: "130px",
        value: inventoryJsonOutput.inventory_create
      }, null, _parent));
      _push(`</div></div></div><div class="accordion-item"><h2 class="accordion-header"><button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-inventories-update" aria-expanded="false" aria-controls="collapse-inventories-update"><i class="ri-arrow-drop-left-line me-1"></i> ۴. ویرایش موجودی </button></h2><div id="collapse-inventories-update" class="accordion-collapse collapse" data-bs-parent="#accordionInventoryMenu"><div class="accordion-body"><p class="mb-4 text-dark lts-05">ویرایش یک موجودی موجود با استفاده از UUID موجودی.</p><h6 class="fw-bold text-dark mt-3 mb-2">کلیات:</h6><table class="table table-bordered fs-8 mb-5"><tbody><tr><th class="bg-light w-25">Method</th><td class="text-end">PUT</td></tr><tr><th class="bg-light">Endpoint</th><td class="text-end bg-white">/api/v1/inventories/update/{inventory_uuid}</td></tr><tr><th class="bg-light">Header</th><td class="text-end"><code>X-API-KEY: YOUR_API_KEY</code></td></tr></tbody></table><h6 class="fw-bold text-dark mt-3 mb-2">پارامتر مسیر:</h6><table class="table table-bordered fs-8 mb-5"><thead class="table-light"><tr><th>نام</th><th>نوع</th><th>اجباری</th><th>توضیحات</th></tr></thead><tbody><tr><td>inventory_uuid</td><td>string</td><td>✅</td><td>شناسه یکتا موجودی</td></tr></tbody></table><h6 class="fw-bold text-dark mt-3 mb-2">بدنه درخواست (JSON):</h6><table class="table table-bordered fs-8 mb-5"><thead class="table-light"><tr><th>نام</th><th>نوع</th><th>اجباری</th><th>توضیحات</th></tr></thead><tbody><tr><td>user_id</td><td>integer</td><td>✅</td><td>شناسه کاربر (admin یا owner)</td></tr><tr><td>storage_uuid</td><td>string</td><td>❌</td><td>شناسه انبار (در جدول لیست انبار ها قابل رویت است)</td></tr><tr><td>variables</td><td>nested object</td><td>✅</td><td><div class="mb-2">متغیر های موجودی - در صورتی که محصول متغییر داشته باشد ضروری است</div><div class="mb-2"> پس از دریافت جزئیات موجودی از وبسرویس, میتوانیم با تغییر و بروزرسانی value مربوط به هر متغیر, عینا مقدار برگشت داده شده رو به وب سرویس بروزرسانی موجودی پاس دهیم تا مقدار متغیر ها برای این موجودی ویرایش شوند. </div><div class="mb-2"> در صورتی که نمیخواهیم متغیر های موجودی ویرایش شوند, و تنها قصد ویرایش سایر مقادیر را داریم, میبایست خروجی variables دریافت شده از وب سرویس جزئیات موجودی رو عینا در ویرایش موجودی برای ورود variables پاس دهیم. </div><div class="mb-2"> در مثال زیر, کل object از وبسرویس دریافت جزئیات موجودی دریافت شده است (شامل key ها و ترتیب child ها) و پس از ویرایش مقدار value هر متغیر مجددا عینا همین object را به وبسرویس ویرایش موجودی پاس داده ایم. </div><div class="d-flex align-items-center justify-content-between bg-dark br-15 p-2"><span class="fs-9 text-gray">مثال:</span><span style="${ssrRenderStyle({ "direction": "ltr" })}">{&quot;191&quot;: {&quot;child&quot;: &quot;0&quot;,&quot;name&quot;: &quot;رنگ&quot;,&quot;type&quot;: &quot;color&quot;,&quot;value&quot;: {&quot;label&quot;: &quot;سیاه&quot;,&quot;color&quot;: &quot;#000000&quot;}},&quot;192&quot;: { &quot;child&quot;: &quot;191&quot;,&quot;name&quot;: &quot;ظرفیت باطری&quot;, &quot;type&quot;: &quot;text&quot;,&quot;value&quot;: &quot;6500 میلی آمپر&quot;}</span></div></td></tr><tr><td>price</td><td>integer</td><td>❌</td><td>قیمت</td></tr><tr><td>discount_price</td><td>integer</td><td>❌</td><td>قیمت تخفیف</td></tr><tr><td>discount_expire</td><td>string (Y/m/d)</td><td>❌</td><td>تاریخ انقضا تخفیف</td></tr><tr><td>discount_tree</td><td>array</td><td>❌</td><td><div class="mb-2">لیست تخفیف پلکانی</div><div class="d-flex align-items-center justify-content-between bg-dark br-15 p-2"><span class="fs-9 text-gray">مثال:</span><span style="${ssrRenderStyle({ "direction": "ltr" })}">[{&quot;count&quot;: 5,&quot;price&quot;: 4000000},{ &quot;count&quot;: 10, &quot;price&quot;: 300000}]</span></div></td></tr><tr><td>count</td><td>integer</td><td>❌</td><td>تعداد موجودی</td></tr><tr><td>min_sale</td><td>integer</td><td>❌</td><td>حداقل فروش (پیش‌فرض: 1)</td></tr><tr><td>max_sale</td><td>integer</td><td>❌</td><td>حداکثر فروش</td></tr><tr><td>original</td><td>boolean</td><td>❌</td><td>اصالت کالا</td></tr><tr><td>used</td><td>boolean</td><td>❌</td><td>وضعیت کالا</td></tr><tr><td>weight</td><td>integer</td><td>❌</td><td>وزن محصول (برحسب گرم)</td></tr><tr><td>purchase_price</td><td>integer</td><td>❌</td><td>قیمت خرید (صرفا جنبه اطلاعرسانی به مدیر را دارد)</td></tr><tr><td>image</td><td>object</td><td>❌</td><td><div class="mb-2">تصویر مرتبط با موجودی (اگر فایل براساس نام در کتابخانه مدیا موجود باشد مجدد بارگذاری نمیشود)</div><div class="d-flex align-items-center justify-content-between bg-dark br-15 p-2"><span class="fs-9 text-gray">مثال:</span><span style="${ssrRenderStyle({ "direction": "ltr" })}">{&quot;url&quot;: &quot;لینک تصویر&quot;,&quot;alt&quot;: &quot;عنوان تصویر&quot;}</span></div></td></tr><tr><td>send_time</td><td>string</td><td>❌</td><td>زمان ارسال - (مثال: 3 روز کاری)</td></tr></tbody></table><h6 class="fw-bold text-dark mt-3 mb-2">نمونه پاسخ (JSON):</h6>`);
      _push(ssrRenderComponent(CodeMirrorJsonViewer, {
        height: "130px",
        value: inventoryJsonOutput.inventory_update
      }, null, _parent));
      _push(`</div></div></div><div class="accordion-item"><h2 class="accordion-header"><button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-inventories-delete" aria-expanded="false" aria-controls="collapse-inventories-delete"><i class="ri-arrow-drop-left-line me-1"></i> ۵. حذف موجودی </button></h2><div id="collapse-inventories-delete" class="accordion-collapse collapse" data-bs-parent="#accordionInventoryMenu"><div class="accordion-body"><p class="mb-4 text-dark lts-05">حذف موجودی با استفاده از UUID موجودی.</p><h6 class="fw-bold text-dark mt-3 mb-2">کلیات:</h6><table class="table table-bordered fs-8 mb-5"><tbody><tr><th class="bg-light w-25">Method</th><td class="text-end">DELETE</td></tr><tr><th class="bg-light">Endpoint</th><td class="text-end bg-white">/api/v1/inventories/delete/{inventory_uuid}</td></tr><tr><th class="bg-light">Header</th><td class="text-end"><code>X-API-KEY: YOUR_API_KEY</code></td></tr></tbody></table><h6 class="fw-bold text-dark mt-3 mb-2">پارامتر مسیر:</h6><table class="table table-bordered fs-8 mb-5"><thead class="table-light"><tr><th>نام</th><th>نوع</th><th>اجباری</th><th>توضیحات</th></tr></thead><tbody><tr><td>inventory_uuid</td><td>string</td><td>✅</td><td>شناسه یکتا موجودی</td></tr></tbody></table><h6 class="fw-bold text-dark mt-3 mb-2">نمونه پاسخ (JSON):</h6>`);
      _push(ssrRenderComponent(CodeMirrorJsonViewer, {
        height: "130px",
        value: inventoryJsonOutput.inventory_delete
      }, null, _parent));
      _push(`</div></div></div></div></div></div><div class="card p-3 mb-4"><div class="card-body"><h5 class="fw-bold text-dark mb-4">📘 مستندات API انبارها</h5><div class="accordion lts-05" id="accordionStoragesMenu"><div class="accordion-item"><h2 class="accordion-header"><button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-storages-index" aria-expanded="false" aria-controls="collapse-storages-index"><i class="ri-arrow-drop-left-line me-1"></i> ۱. دریافت لیست انبارها </button></h2><div id="collapse-storages-index" class="accordion-collapse collapse" data-bs-parent="#accordionStoragesMenu"><div class="accordion-body"><p class="mb-4 text-dark lts-05">برای دریافت لیست انبار های فروشگاه اصلی استفاده میشود.</p><h6 class="fw-bold text-dark mt-3 mb-2">کلیات:</h6><table class="table table-bordered fs-8 mb-5"><tbody><tr><th class="bg-light w-25">Method</th><td class="text-end">GET</td></tr><tr><th class="bg-light">Endpoint</th><td class="text-end bg-white">/api/v1/storages/</td></tr><tr><th class="bg-light">Header</th><td class="text-end"><code>X-API-KEY: YOUR_API_KEY</code></td></tr></tbody></table><h6 class="fw-bold text-dark mt-3 mb-2">پارامترهای Query:</h6><table class="table table-bordered fs-8 mb-5"><thead class="table-light"><tr><th>نام</th><th>نوع</th><th>اجباری</th><th>توضیحات</th></tr></thead><tbody><tr><td>page</td><td>integer</td><td>❌</td><td>شماره صفحه</td></tr><tr><td>per_page</td><td>integer</td><td>❌</td><td>تعداد آیتم‌ها در هر صفحه (پیش‌فرض: 20)</td></tr></tbody></table><h6 class="fw-bold text-dark mt-3 mb-2">نمونه پاسخ (JSON):</h6>`);
      _push(ssrRenderComponent(CodeMirrorJsonViewer, {
        height: "400px",
        value: storageJsonOutput.storages
      }, null, _parent));
      _push(`</div></div></div><div class="accordion-item"><h2 class="accordion-header"><button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-storages-products" aria-expanded="false" aria-controls="collapse-storages-products"><i class="ri-arrow-drop-left-line me-1"></i> ۱. دریافت لیست محصولات یک انبار </button></h2><div id="collapse-storages-products" class="accordion-collapse collapse" data-bs-parent="#accordionStoragesMenu"><div class="accordion-body"><p class="mb-4 text-dark lts-05">برای دریافت لیست کامل محصولات یک انبار بر اساس شناسه انبار استفاده می‌شود.</p><h6 class="fw-bold text-dark mt-3 mb-2">کلیات:</h6><table class="table table-bordered fs-8 mb-5"><tbody><tr><th class="bg-light w-25">Method</th><td class="text-end">GET</td></tr><tr><th class="bg-light">Endpoint</th><td class="text-end bg-white">/api/v1/storages/products/{storage_uuid}</td></tr><tr><th class="bg-light">Header</th><td class="text-end"><code>X-API-KEY: YOUR_API_KEY</code></td></tr></tbody></table><h6 class="fw-bold text-dark mt-3 mb-2">پارامتر مسیر:</h6><table class="table table-bordered fs-8 mb-5"><thead class="table-light"><tr><th>نام</th><th>نوع</th><th>اجباری</th><th>توضیحات</th></tr></thead><tbody><tr><td>storage_uuid</td><td>string</td><td>✅</td><td>شناسه یکتا انبار</td></tr></tbody></table><h6 class="fw-bold text-dark mt-3 mb-2">پارامترهای Query:</h6><table class="table table-bordered fs-8 mb-5"><thead class="table-light"><tr><th>نام</th><th>نوع</th><th>اجباری</th><th>توضیحات</th></tr></thead><tbody><tr><td>page</td><td>integer</td><td>❌</td><td>شماره صفحه</td></tr><tr><td>per_page</td><td>integer</td><td>❌</td><td>تعداد آیتم‌ها در هر صفحه (پیش‌فرض: 100)</td></tr><tr><td>status</td><td>string</td><td>❌</td><td>فیلتر بر اساس وضعیت (publish, draft)</td></tr></tbody></table><h6 class="fw-bold text-dark mt-3 mb-2">نمونه پاسخ (JSON):</h6>`);
      _push(ssrRenderComponent(CodeMirrorJsonViewer, {
        value: productJsonOutput.products
      }, null, _parent));
      _push(`</div></div></div></div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/WebService/Manage.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
