import { defineComponent, ref, mergeProps, unref, withCtx, createBlock, openBlock, toDisplayString, createTextVNode, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrRenderComponent, ssrRenderAttr, ssrInterpolate, ssrIncludeBooleanAttr } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./AuthLayout-DZ-VIaI_.js";
import { useForm, usePage, Link } from "@inertiajs/vue3";
import "toastify-js";
import "./useToastify-D_n0s7Uc.js";
import { _ as _sfc_main$2 } from "./NumInput-Bt6uFGO4.js";
import "./useHexToRgb-G7J9N7Ap.js";
/* empty css             */
import "./useRandomStr-4MeWbtRd.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Login",
  __ssrInlineRender: true,
  props: {
    canResetPassword: { type: Boolean },
    status: {},
    prev: {}
  },
  setup(__props) {
    const props = __props;
    const loginForm = useForm({
      phone: "",
      prev: props.prev
    });
    const dark = ref(usePage().props.dark);
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "auth-container" }, _attrs))}><div class="logo-container">`);
      _push(ssrRenderComponent(unref(Link), {
        class: "logo",
        href: _ctx.route("index")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            if (_ctx.$page.props.appLogo != null) {
              _push2(`<img${ssrRenderAttr("src", dark.value ? _ctx.$page.props.appLogoDark : _ctx.$page.props.appLogo)}${ssrRenderAttr("alt", _ctx.$page.props.appFullName)}${_scopeId}>`);
            } else {
              _push2(`<span${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.logo"))}</span>`);
            }
          } else {
            return [
              _ctx.$page.props.appLogo != null ? (openBlock(), createBlock("img", {
                key: 0,
                src: dark.value ? _ctx.$page.props.appLogoDark : _ctx.$page.props.appLogo,
                alt: _ctx.$page.props.appFullName
              }, null, 8, ["src", "alt"])) : (openBlock(), createBlock("span", { key: 1 }, toDisplayString(_ctx.$t("messages.word.logo")), 1))
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div><div class="card shadow-1"><div class="card-body">`);
      if (_ctx.prev != null) {
        _push(`<div class="back-button d-flex align-item-start justify-content-end"><i class="ri-arrow-left-line fs-5"></i></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="auth-title lts-05">${ssrInterpolate(_ctx.$t("messages.word.login"))} <span>${ssrInterpolate(_ctx.$t("messages.word.or"))}</span> ${ssrInterpolate(_ctx.$t("messages.word.register"))}</div><form class="auth-form"><div class="form-element-row mb-4">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        class: "phone-input",
        onKeyup: ($event) => unref(loginForm).clearErrors(),
        modelValue: unref(loginForm).phone,
        "onUpdate:modelValue": ($event) => unref(loginForm).phone = $event,
        name: "phone",
        minlength: "11",
        maxlength: "11",
        autocomplete: "phone",
        type: "tel",
        inputmode: "numeric",
        placeholder: _ctx.$t("messages.sentence.phone_number_with_zero"),
        autofocus: ""
      }, null, _parent));
      if ("phone" in unref(loginForm).errors) {
        _push(`<span class="form-error-msg d-flex lts-05 mt-2">${ssrInterpolate(unref(loginForm).errors.phone)}</span>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div><div class="form-element-row mb-3"><button class="btn btn-primary" type="submit"${ssrIncludeBooleanAttr(unref(loginForm).processing) ? " disabled" : ""}>${ssrInterpolate(_ctx.$t("messages.word.continue"))}</button></div><div class="form-element-row"><div class="privacy-notice lts-05">${_ctx.$t("messages.sentence.login_mean_is_accept_terms", {
        terms: `<a href='${_ctx.route("main.pages.show", "terms")}' target='_blank' class='link'> ${_ctx.$t("messages.word.terms")} </a>`
      }) ?? ""}</div></div></form></div></div><div class="auth-footer">`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("index"),
        class: "lts-05"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.home_page"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("messages.sentence.home_page")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`<span></span>`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("main.products.index"),
        class: "lts-05"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.product_archive"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("messages.sentence.product_archive")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Auth/Login.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
