import { defineComponent, ref, unref, withCtx, createTextVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderStyle, ssrRenderAttr, ssrIncludeBooleanAttr, ssrLooseContain, ssrRenderList, ssrRenderClass } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./AdminLayout-CD07IMsK.js";
import { useForm, Head, Link } from "@inertiajs/vue3";
import { _ as _sfc_main$5 } from "./Pagination-C1AQrLe3.js";
import { _ as _sfc_main$3 } from "./SearchList-BZnYMQPN.js";
import { _ as _sfc_main$4 } from "./FilterList-CWxGcEKk.js";
import "toastify-js";
import "./useToastify-D_n0s7Uc.js";
import ProgressBar from "primevue/progressbar/progressbar.esm.js";
import "laravel-vue-i18n";
import { _ as _sfc_main$2 } from "./Files-B6eiTnN6.js";
import "simplebar";
import "resize-observer-polyfill";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "lodash/debounce.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "./useRandomNum-DNNSqR7b.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "List",
  __ssrInlineRender: true,
  props: {
    files: {},
    keyword: {}
  },
  setup(__props) {
    ref();
    const fileType = ref();
    const imageUrl = ref();
    const sizeToMB = ref();
    const uploadFileForm = useForm({
      file: null,
      description: null,
      optimization: true,
      cropImage: false,
      addWatermark: false
    });
    const editMediaForm = useForm({
      description: ""
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.media_library")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.sentence.media_library")
      }, null, _parent));
      _push(`<div class="row"><div class="col-12 mb-4"><div class="card upload-file-container"><div class="card-body"><form class="mb-5"><div class="form-element-row form-element-row-file">`);
      if (fileType.value == null) {
        _push(`<div class="text-center"><div class="fs-6 fw-bold text-dark mb-2">${ssrInterpolate(_ctx.$t("messages.sentence.select_yout_file_for_upload"))}</div><div class="fs-7 text-muted mb-2">${ssrInterpolate(_ctx.$t("messages.sentence.file_allowed_formats"))}</div><div class="fs-7 text-muted mb-4">${ssrInterpolate(_ctx.$t("messages.sentence.image_allowed_size"))}</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="custom-input-file">`);
      if (fileType.value == null) {
        _push(`<label for="uploadFile" class="custom-input-file-label"><span class="label"><i class="ri-arrow-up-fill me-1"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.select_file"))}</span></label>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<input type="file" class="custom-input-file-input" id="uploadFile" accept=".png,.jpg,.jpeg,.webp,.gif,.svg,.mp4,.mp3,.pdf,.zip"></div>`);
      if (fileType.value != null && !unref(uploadFileForm).processing) {
        _push(`<div class="row after-select-container"><div class="col-xl-2 col-lg-2 col-md-3 col-12 mb-4 mb-md-0">`);
        if (fileType.value == "image") {
          _push(`<div class="file-grid"><div class="file-grid--level-one"><div class="file-grid--level-two"><div class="image" style="${ssrRenderStyle({ "background-image": "url(" + imageUrl.value + ")" })}"></div></div></div></div>`);
        } else if (fileType.value == "pdf" || fileType.value == "zip" || fileType.value == "mp3" || fileType.value == "mp4") {
          _push(`<div class="file-grid other-file"><div class="file-grid--level-one"><div class="file-grid--level-two"><div class="image image-with-file">`);
          if (fileType.value == "pdf") {
            _push(`<img${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/icon/file/pdf.png")}>`);
          } else if (fileType.value == "zip") {
            _push(`<img${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/icon/file/zip.png")}>`);
          } else if (fileType.value == "mp3") {
            _push(`<img${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/icon/file/mp3.png")}>`);
          } else if (fileType.value == "mp4") {
            _push(`<img${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/icon/file/mp4.png")}>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<span class="file-size">${ssrInterpolate(sizeToMB.value + "MB")}</span></div></div></div></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div><div class="col-xl-10 col-lg-10 col-md-9 col-12 d-flex flex-column justify-content-center">`);
        if (fileType.value != null) {
          _push(`<div class="file-description mb-3"><input${ssrRenderAttr("value", unref(uploadFileForm).description)} type="text" class="form-control"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.file_full_name_for_seo"))}></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="d-flex justify-content-between align-items-center upload-bottom-action-bar">`);
        if (fileType.value == "image") {
          _push(`<div class="image-crop"><label class="lts-05"><input${ssrIncludeBooleanAttr(Array.isArray(unref(uploadFileForm).optimization) ? ssrLooseContain(unref(uploadFileForm).optimization, null) : unref(uploadFileForm).optimization) ? " checked" : ""} class="form-check-input" type="checkbox"> ${ssrInterpolate(_ctx.$t("messages.sentence.image_optimization"))}</label><label class="ms-4 lts-05"><input${ssrIncludeBooleanAttr(Array.isArray(unref(uploadFileForm).cropImage) ? ssrLooseContain(unref(uploadFileForm).cropImage, null) : unref(uploadFileForm).cropImage) ? " checked" : ""} class="form-check-input" type="checkbox"> ${ssrInterpolate(_ctx.$t("messages.sentence.crop_image_square"))}</label><label class="ms-4 lts-05"><input${ssrIncludeBooleanAttr(Array.isArray(unref(uploadFileForm).addWatermark) ? ssrLooseContain(unref(uploadFileForm).addWatermark, null) : unref(uploadFileForm).addWatermark) ? " checked" : ""} class="form-check-input" type="checkbox"> ${ssrInterpolate(_ctx.$t("messages.sentence.add_watermark_to_image"))}</label></div>`);
        } else {
          _push(`<div></div>`);
        }
        _push(`<div class="custom-input-file">`);
        if (fileType.value != null) {
          _push(`<button${ssrIncludeBooleanAttr(unref(uploadFileForm).processing) ? " disabled" : ""} type="submit" class="btn btn-primary shadow-1"><i class="ri-upload-2-line"></i> ${ssrInterpolate(_ctx.$t("messages.word.upload"))}</button>`);
        } else {
          _push(`<!---->`);
        }
        if (fileType.value != null) {
          _push(`<button type="button" class="btn btn-danger btn-square btn-sm ms-2 shadow-1"><i class="ri-delete-bin-line"></i></button>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(uploadFileForm).processing) {
        _push(`<div class="row uploading-progress"><div class="col-12">`);
        if (unref(uploadFileForm).progress) {
          _push(ssrRenderComponent(unref(ProgressBar), {
            value: unref(uploadFileForm).progress.percentage
          }, null, _parent));
        } else {
          _push(`<!---->`);
        }
        _push(`</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></form>`);
      _push(ssrRenderComponent(_sfc_main$3, {
        keyword: _ctx.keyword,
        placeholder: _ctx.$t("messages.sentence.file_id") + " ..."
      }, null, _parent));
      _push(ssrRenderComponent(_sfc_main$4, {
        filters: { images: _ctx.$t("messages.word.images"), videos: _ctx.$t("messages.word.videos"), audius: _ctx.$t("messages.word.audio"), pdf: "PDF", zip: "Zip" }
      }, null, _parent));
      _push(`<div class="row file-container mb-4"><!--[-->`);
      ssrRenderList(_ctx.files.data, (file) => {
        _push(`<div class="col-xl-2 col-md-4 col-sm-4 col-6 mb-4"><div class="${ssrRenderClass({ file: true, "shadow-1": true, dropdown: true, "other-file": file.type != "image" })}">`);
        if (file.type == "image") {
          _push(`<div class="file-grid"><div class="file-grid--level-one"><div class="file-grid--level-two"><div class="image" style="${ssrRenderStyle({ "background-image": "url(" + _ctx.$page.props.appUrl + file.url + ")" })}"></div></div></div></div>`);
        } else {
          _push(`<div class="file-grid"><div class="file-grid--level-one"><div class="file-grid--level-two"><div class="image image-with-file">`);
          if (file.type == "pdf") {
            _push(`<img${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/icon/file/pdf.png")} alt="pdf">`);
          } else if (file.type == "zip") {
            _push(`<img${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/icon/file/zip.png")} alt="zip">`);
          } else if (file.type == "audio") {
            _push(`<img${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/icon/file/mp3.png")} alt="mp3">`);
          } else if (file.type == "video") {
            _push(`<img${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/icon/file/mp4.png")} alt="mp4">`);
          } else {
            _push(`<!---->`);
          }
          _push(`<span class="file-size">${ssrInterpolate(file.name)}</span></div></div></div></div>`);
        }
        _push(`<i class="ri-more-2-fill image-details" data-bs-toggle="dropdown"></i><div class="dropdown-menu shadow-smooth-1"><ul><li><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.file_id"))}: </span><span class="value">${ssrInterpolate(file.id)}</span></li><li><span class="title">${ssrInterpolate(_ctx.$t("messages.word.description"))}: </span><span class="value">${ssrInterpolate(file.description != null ? file.description : _ctx.$t("messages.word.empty"))}</span></li><li><span class="title">${ssrInterpolate(_ctx.$t("messages.word.file_format"))}: </span><span class="value">${ssrInterpolate(file.extension)}</span></li><li><span class="title">${ssrInterpolate(_ctx.$t("messages.word.volume"))}: </span><span class="value">${ssrInterpolate(Math.round(file.size / 1e3 * 100) / 100)} ${ssrInterpolate(_ctx.$t("messages.word.megabyte"))}</span></li><li><span class="title">${ssrInterpolate(_ctx.$t("messages.word.date"))}: </span><span class="value">${ssrInterpolate(file.jalali_created_at[2])}</span></li><li class="copy-file-url"><form action="#"><button class="no-btn" type="button">${ssrInterpolate(_ctx.$t("messages.sentence.copy_link"))}</button></form></li><li class="copy-file-url"><button data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#edit-media-" + file.id)} class="no-btn" type="button">${ssrInterpolate(_ctx.$t("messages.word.edit"))}</button></li><li class="remove-image"><button data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#delete-media-" + file.id)} class="no-btn" type="submit">${ssrInterpolate(_ctx.$t("messages.sentence.delete_file"))}</button></li></ul></div><div class="modal fade"${ssrRenderAttr("id", "edit-media-" + file.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.word.edit"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12"><label class="form-label" for="eaEditFileAlt">${ssrInterpolate(_ctx.$t("messages.word.description"))}</label><input${ssrRenderAttr("value", unref(editMediaForm).description)} type="text" class="form-control"></div></div></div><div class="modal-footer"><button class="btn btn-sm btn-light px-3" type="button" data-bs-dismiss="modal">${ssrInterpolate(_ctx.$t("messages.word.cancel"))}</button><button class="btn btn-sm btn-primary px-3" data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(_ctx.$t("messages.word.update"))}</button></div></form></div></div></div><div class="modal fade"${ssrRenderAttr("id", "delete-media-" + file.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form action="#" style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.are_you_sure_delete_file"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><label class="lts-05"><strong class="text-danger">${ssrInterpolate(_ctx.$t("messages.word.warning"))}:</strong> ${ssrInterpolate(_ctx.$t("messages.sentence.file_deleted_from_wherever_used"))}</label></div><div class="modal-footer"><button class="btn btn-sm btn-light px-3" type="button" data-bs-dismiss="modal">${ssrInterpolate(_ctx.$t("messages.word.cancel"))}</button>`);
        _push(ssrRenderComponent(unref(Link), {
          as: "button",
          href: _ctx.route("admin.files.destroy", file.id),
          method: "delete",
          class: "btn btn-sm btn-danger px-3",
          "data-bs-dismiss": "modal",
          "aria-label": "Close"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("messages.word.delete"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("messages.word.delete")), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</div></form></div></div></div></div></div>`);
      });
      _push(`<!--]--></div>`);
      if (_ctx.files.data.length == 0) {
        _push(`<div class="product-list-empty"><div class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_sfc_main$5, {
        links: _ctx.files.links
      }, null, _parent));
      _push(`</div></div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Files/List.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
