import { defineComponent, unref, withCtx, createTextVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderComponent, ssrRenderStyle, ssrInterpolate, ssrRenderList, ssrRenderAttr } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./MainLayout-CahYFWjG.js";
import { Head, Link } from "@inertiajs/vue3";
import { _ as _sfc_main$2 } from "./Pagination-C1AQrLe3.js";
/* empty css                       */
/* empty css                              */
/* empty css                           */
/* empty css             */
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
import "./AdminNavigation-BYBoZNuA.js";
import "./useHexToRgb-G7J9N7Ap.js";
import "./useRandomStr-4MeWbtRd.js";
import "jquery";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "List",
  __ssrInlineRender: true,
  props: {
    product_comments: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.your_comments")
      }, null, _parent));
      _push(`<div class="card shadow-1 panel-content" style="${ssrRenderStyle({ "min-height": "100%" })}"><div class="card-body"><div class="row"><div class="col-lg-12 mb-3"><div class="panel-content--title mb-4 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.your_comments"))}</div><div class="comments"><div class="row"><!--[-->`);
      ssrRenderList(_ctx.product_comments.data, (comment) => {
        _push(`<!--[-->`);
        if (comment.get_product_status) {
          _push(`<div class="col-12 mb-3"><div class="comment"><div class="comment-header"><span>${ssrInterpolate(comment.user.get_name)}</span><span class="date">${ssrInterpolate(comment.jalali_created_at[0])}</span><span class="badge">${ssrInterpolate(_ctx.$t("messages.word.buyer"))}</span></div><div class="comment-body">`);
          if (comment.buy_suggest == "1") {
            _push(`<span class="suggestion suggest"><i class="ri-thumb-up-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.i_suggest"))}</span>`);
          } else if (comment.buy_suggest == "0") {
            _push(`<span class="suggestion not-suggest"><i class="ri-thumb-down-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.i_dont_suggest"))}</span>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<div class="product-info mb-3"><span class="fs-9 fw-bold">${ssrInterpolate(_ctx.$t("messages.word.product"))}: </span>`);
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("main.products.show", comment.product.slug),
            class: "link"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(comment.product.title)}`);
              } else {
                return [
                  createTextVNode(toDisplayString(comment.product.title), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</div><p class="lts-05">${ssrInterpolate(comment.content)}</p><ul><!--[-->`);
          ssrRenderList(comment.get_strengths, (strength, index) => {
            _push(`<li class="comment-evaluation positive">${ssrInterpolate(strength)}</li>`);
          });
          _push(`<!--]--><!--[-->`);
          ssrRenderList(comment.get_weakness, (weakness, index) => {
            _push(`<li class="comment-evaluation negative">${ssrInterpolate(weakness)}</li>`);
          });
          _push(`<!--]--></ul>`);
          if (comment.get_answer != null) {
            _push(`<div class="comment-answer mt-4"><span class="user-order-meta mb-2">${ssrInterpolate(comment.get_answer.user.name)} <span class="text-light-gray fs-10 ms-2">${ssrInterpolate(comment.get_answer.user.role.label)}</span></span><p class="fw-bold mb-0">${ssrInterpolate(comment.get_answer.content)}</p></div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</div><div class="comment-footer"><span class="me-2 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.users_reaction"))}</span><button class="comment-like">${ssrInterpolate(comment.vote_up)}</button><button class="comment-dislike">${ssrInterpolate(comment.vote_down)}</button></div></div></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<!--]-->`);
      });
      _push(`<!--]--></div></div></div>`);
      if (_ctx.product_comments.data.length == 0) {
        _push(`<div class="cart-empty"><div class="empty-content-icon"><img${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/template/orders.svg")}></div><div class="empty-content-message text-center"><p class="mb-4 lts-05 fs-8">${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</p></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.product_comments.data.length != 0) {
        _push(ssrRenderComponent(_sfc_main$2, {
          links: _ctx.product_comments.links
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/User/Comments/List.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
