import { defineComponent, resolveDirective, unref, withCtx, createTextVNode, createVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderStyle, ssrRenderList, ssrRenderAttr, ssrRenderAttrs, ssrGetDirectiveProps } from "vue/server-renderer";
import { _ as _sfc_main$1, a as _sfc_main$2 } from "./StoreLayout-D2_RagXW.js";
import { Head, Link } from "@inertiajs/vue3";
import { _ as _sfc_main$5 } from "./Pagination-C1AQrLe3.js";
import { _ as _sfc_main$3 } from "./SearchList-BZnYMQPN.js";
import { _ as _sfc_main$4 } from "./FilterList-CWxGcEKk.js";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "jquery";
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "./useRandomNum-DNNSqR7b.js";
import "bootstrap";
import "./useNl2br-BIw8h5gy.js";
import "lodash/debounce.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "List",
  __ssrInlineRender: true,
  props: {
    articles: {},
    keyword: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      const _directive_tooltip = resolveDirective("tooltip");
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.article_list")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.sentence.article_list")
      }, null, _parent));
      _push(`<div class="product-list list mb-4"><div class="card"><div class="card-body"><div class="action-container mb-4 d-flex align-items-center justify-content-end">`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("seller.articles.create"),
        as: "button",
        class: "btn btn-primary"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.create_article"))} <i class="ri-add-line"${_scopeId}></i>`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("messages.sentence.create_article")) + " ", 1),
              createVNode("i", { class: "ri-add-line" })
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div>`);
      _push(ssrRenderComponent(_sfc_main$3, {
        keyword: _ctx.keyword,
        placeholder: _ctx.$t("messages.word.title") + " " + _ctx.$t("messages.word.article") + " ..."
      }, null, _parent));
      _push(ssrRenderComponent(_sfc_main$4, {
        filters: {
          publish: _ctx.$t("messages.word.published"),
          awaiting: _ctx.$t("messages.sentence.awaiting_verify"),
          draft: _ctx.$t("messages.word.draft"),
          mostViewer: _ctx.$t("messages.word.most_viewed")
        }
      }, null, _parent));
      _push(`<div class="table-responsive mb-4"><table class="table" style="${ssrRenderStyle({ "min-width": "900px" })}"><thead><tr><th class="first-small">${ssrInterpolate(_ctx.$t("messages.word.image"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.title"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.author"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.status"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.view"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.last_update"))}</th><th class="first-small"><i class="ri-settings-4-line"></i></th></tr></thead><tbody><!--[-->`);
      ssrRenderList(_ctx.articles.data, (article) => {
        _push(`<tr><td><img class="br-10" width="35" height="35"${ssrRenderAttr("src", article.get_image.url)}${ssrRenderAttr("alt", article.title)}></td><td${ssrRenderAttrs(ssrGetDirectiveProps(_ctx, _directive_tooltip, article.editor_choice ? _ctx.$t("messages.sentence.editor_choice") : null, void 0, { bottom: true }))}>`);
        _push(ssrRenderComponent(unref(Link), {
          class: "product-title product-title-min-300",
          href: _ctx.route("seller.articles.edit", article.slug)
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(article.title)}`);
            } else {
              return [
                createTextVNode(toDisplayString(article.title), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        if (article.editor_choice) {
          _push(`<i class="ri-star-s-fill vip-product"></i>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</td><td>`);
        if (article.user.type == "owner" || article.user.type == "admin") {
          _push(`<a class="link fs-8 fw-normal"${ssrRenderAttr("href", _ctx.route("blog.articles.index", { profile: article.user.id }))} target="_blank">${ssrInterpolate(article.user.get_name)}</a>`);
        } else if (article.user.seller) {
          _push(`<a class="link fs-8 fw-normal"${ssrRenderAttr("href", _ctx.route("blog.articles.index", { profile: article.user.store.uuid }))} target="_blank">${ssrInterpolate(article.user.store.name)}</a>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</td><td>${ssrInterpolate(article.get_formatted_view_count)}</td><td class="lts-05">`);
        if (article.status == "publish") {
          _push(`<span class="badge bg-success">${ssrInterpolate(_ctx.$t("messages.word.published"))}</span>`);
        } else if (article.status == "draft") {
          _push(`<span class="badge bg-warning">${ssrInterpolate(_ctx.$t("messages.word.draft"))}</span>`);
        } else if (article.status == "awaiting") {
          _push(`<span class="badge bg-info">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_verify"))}</span>`);
        } else if (article.status == "rejected") {
          _push(`<span class="badge bg-danger">${ssrInterpolate(_ctx.$t("messages.word.rejected"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</td><td>${ssrInterpolate(article.jalali_updated_at[3])}</td><td class="dropdown"><i class="ri-more-2-fill" data-bs-toggle="dropdown"></i><div class="dropdown-menu shadow-smooth-2"><ul>`);
        if (article.status == "publish") {
          _push(`<li><a class="dropdown-item lts-05" target="_blank"${ssrRenderAttr("href", _ctx.route("blog.articles.show", article.slug))}><i class="ri-eye-line"></i> ${ssrInterpolate(_ctx.$t("messages.word.view") + " " + _ctx.$t("messages.word.article"))}</a></li>`);
        } else {
          _push(`<!---->`);
        }
        if (article.status != "publish" && article.status != "draft") {
          _push(`<li>`);
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("seller.articles.edit", article.slug),
            as: "button",
            class: "dropdown-item lts-05"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<i class="ri-pencil-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.word.edit"))}`);
              } else {
                return [
                  createVNode("i", { class: "ri-pencil-line" }),
                  createTextVNode(" " + toDisplayString(_ctx.$t("messages.word.edit")), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</li>`);
        } else {
          _push(`<!---->`);
        }
        if (article.status != "publish" && article.status != "draft") {
          _push(`<li><a href="javascript:void(0)" data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#remove-article-" + article.id)} class="dropdown-item no-btn"><i class="ri-delete-bin-line"></i> ${ssrInterpolate(_ctx.$t("messages.word.delete") + " " + _ctx.$t("messages.word.article"))}</a></li>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</ul></div><div class="modal fade"${ssrRenderAttr("id", "remove-article-" + article.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.are_yo_sure_delete_article"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-footer">`);
        _push(ssrRenderComponent(unref(Link), {
          as: "button",
          href: _ctx.route("seller.articles.destroy", article.slug),
          method: "delete",
          data: { status: "deleted" },
          class: "btn btn-sm btn-danger px-3",
          "data-bs-dismiss": "modal",
          "aria-label": "Close"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("messages.word.delete"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("messages.word.delete")), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</div></form></div></div></div></td></tr>`);
      });
      _push(`<!--]--></tbody></table></div>`);
      if (_ctx.articles.data.length == 0) {
        _push(`<div class="product-list-empty"><div class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_sfc_main$5, {
        links: _ctx.articles.links
      }, null, _parent));
      _push(`</div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Store/Blog/Articles/List.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
