import { defineComponent, onMounted, reactive, ref, unref, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderAttr, ssrRenderList } from "vue/server-renderer";
import { _ as _sfc_main$2 } from "./Files-B6eiTnN6.js";
import "toastify-js";
import "./useToastify-D_n0s7Uc.js";
import { _ as _sfc_main$1 } from "./AdminLayout-CD07IMsK.js";
import { useForm, Head } from "@inertiajs/vue3";
import "laravel-vue-i18n";
import Sortable from "sortablejs";
import $ from "jquery";
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "./Pagination-C1AQrLe3.js";
import "./SearchList-BZnYMQPN.js";
import "lodash/debounce.js";
import "./useRandomNum-DNNSqR7b.js";
import "simplebar";
import "resize-observer-polyfill";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "List",
  __ssrInlineRender: true,
  props: {
    faqs: {}
  },
  setup(__props) {
    const props = __props;
    onMounted(() => {
      if ($("#accordionMenu").length) {
        Sortable.create(document.getElementById("accordionMenu"), {
          handle: ".handle",
          animation: 150
        });
      }
    });
    const faqItems = reactive(props.faqs);
    const question = ref("");
    const answer = ref("");
    useForm({
      items: null
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.faqs")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.word.faqs")
      }, null, _parent));
      _push(`<div class="category-container row mb-4 mt-4"><div class="col-12 mb-4"><div class="mb-4"><div class="card-body"><div class="d-flex align-items-center justify-content-end"><button data-bs-toggle="modal" data-bs-target="#addFaq" class="btn btn-dark shadow-1 lts-05 fs-8">${ssrInterpolate(_ctx.$t("messages.sentence.add_faq_item"))} <i class="ri-add-line"></i></button></div><div class="modal fade" id="addFaq" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-lg modal-dialog-centered"><div class="modal-content"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.add_faq_item"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12 mb-4"><label for="faqQuestion" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.question"))}</label><input${ssrRenderAttr("value", question.value)} id="faqQuestion" type="text" class="form-control"></div><div class="col-12 mb-4"><label for="faqAnswer" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.answer"))}</label><textarea id="faqAnswer" class="form-control lh-30" rows="7">${ssrInterpolate(answer.value)}</textarea></div></div></div><div class="modal-footer"><button class="btn btn-sm btn-primary px-3">${ssrInterpolate(_ctx.$t("messages.word.add"))}</button></div></div></div></div></div></div><div class="row"><div class="col-12 mb-4"><div class="accordion" id="accordionMenu"><!--[-->`);
      ssrRenderList(faqItems, (faq, index) => {
        _push(`<div${ssrRenderAttr("index", index)} class="accordion-item"><h2 class="accordion-header"><button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"${ssrRenderAttr("data-bs-target", "#collapse-menu-" + index)} aria-expanded="false"${ssrRenderAttr("aria-controls", "collapse-menu-" + index)}><i class="ri-draggable me-2 handle"></i> ${ssrInterpolate(index + 1 + ". ")} <input type="text"${ssrRenderAttr("id", "fqQuestion" + index)} class="form-control mx-3"${ssrRenderAttr("value", faq.question)}></button></h2><div${ssrRenderAttr("id", "collapse-menu-" + index)} class="accordion-collapse collapse" data-bs-parent="#accordionMenu"><div class="accordion-body"><div class="row"><div class="col-12 mb-2"><textarea class="form-control lh-30"${ssrRenderAttr("id", "fqAnswer" + index)} rows="6">${ssrInterpolate(faq.answer)}</textarea></div><div class="col-12 d-flex align-items-center justify-content-end mb-2"><button class="btn btn-xs btn-square btn-danger px-3"><i class="ri-delete-bin-5-line"></i></button></div></div></div></div></div>`);
      });
      _push(`<!--]-->`);
      if (faqItems.length == 0) {
        _push(`<div class="empty-item bg-white lts-05 p-5 text-center">${ssrInterpolate(_ctx.$t("messages.sentence.no_items_have_been_added_yet"))}</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div>`);
      if (faqItems.length > 0) {
        _push(`<div class="col-12 d-flex align-items-center justify-content-end"><button class="btn btn-primary">${ssrInterpolate(_ctx.$t("messages.sentence.save_changes"))}</button></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Faq/List.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
