import { defineComponent, ref, unref, withCtx, createTextVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderStyle, ssrRenderAttr, ssrRenderList } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./AdminLayout-CD07IMsK.js";
import { useForm, Head, Link } from "@inertiajs/vue3";
import { _ as _sfc_main$4 } from "./Pagination-C1AQrLe3.js";
import { _ as _sfc_main$3 } from "./SearchList-BZnYMQPN.js";
import MultiSelect from "primevue/multiselect/multiselect.esm.js";
import { _ as _sfc_main$2 } from "./Files-B6eiTnN6.js";
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "lodash/debounce.js";
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "laravel-vue-i18n";
import "./useRandomNum-DNNSqR7b.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "List",
  __ssrInlineRender: true,
  props: {
    roles: {},
    permissions: {},
    keyword: {}
  },
  setup(__props) {
    const props = __props;
    const permissionsList = ref([]);
    for (let permission in props.permissions) {
      permissionsList.value.push(props.permissions[permission]);
    }
    const crForm = useForm({
      label: null,
      permissions: null
    });
    const editForm = useForm({
      label: null,
      permissions: []
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.role_list")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.word.roles")
      }, null, _parent));
      _push(`<div class="user-list list mb-4"><div class="card"><div class="card-body"><div class="d-flex align-items-center justify-content-end mb-4"><button data-bs-toggle="modal" data-bs-target="#add-role" class="btn btn-primary">${ssrInterpolate(_ctx.$t("messages.sentence.create_new_role"))} <i class="ri-add-line"></i></button><div class="modal fade" id="add-role" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.create_new_role"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12 mb-4"><label for="eaRoleTitle" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.name"))}</label><input${ssrRenderAttr("value", unref(crForm).label)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.role_name_placeholder"))} class="form-control" id="eaRoleTitle"></div><div class="col-12 mb-4"><label class="form-label">${ssrInterpolate(_ctx.$t("messages.word.permissions"))}</label>`);
      _push(ssrRenderComponent(unref(MultiSelect), {
        class: "pvc-multiselect",
        modelValue: unref(crForm).permissions,
        "onUpdate:modelValue": ($event) => unref(crForm).permissions = $event,
        options: permissionsList.value,
        display: "chip",
        optionLabel: "label",
        optionValue: "id",
        placeholder: _ctx.$t("messages.sentence.select_permissions")
      }, null, _parent));
      _push(`</div></div></div><div class="modal-footer"><button class="btn btn-sm btn-primary px-3">${ssrInterpolate(_ctx.$t("messages.word.create"))}</button></div></form></div></div></div></div>`);
      _push(ssrRenderComponent(_sfc_main$3, {
        keyword: _ctx.keyword,
        placeholder: _ctx.$t("messages.sentence.role_name_or_code") + " ..."
      }, null, _parent));
      _push(`<div class="table-responsive mb-4"><table class="table" style="${ssrRenderStyle({ "min-width": "900px" })}"><thead><tr><th>${ssrInterpolate(_ctx.$t("messages.word.name"))}</th><th>${ssrInterpolate(_ctx.$t("messages.sentence.role_user_count"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.permissions"))}</th><th class="first-small"><i class="ri-settings-4-line"></i></th></tr></thead><tbody><!--[-->`);
      ssrRenderList(_ctx.roles.data, (role) => {
        _push(`<tr><td>${ssrInterpolate(role.label)}</td><td>${ssrInterpolate(role.users.length)}</td><td><span class="text-badge" role="button" data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#rule-permissions-" + role.id)}>${ssrInterpolate(_ctx.$t("messages.word.show"))}</span><div class="modal fade"${ssrRenderAttr("id", "rule-permissions-" + role.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form action="#" style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.role_permission_list"))}: <span class="ms-1">${ssrInterpolate(role.label)}</span></div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12"><!--[-->`);
        ssrRenderList(role.permissions, (permission) => {
          _push(`<p class="mb-2">${ssrInterpolate(permission.label)}</p>`);
        });
        _push(`<!--]--></div></div></div></form></div></div></div></td><td class="dropdown"><i class="ri-more-2-fill" data-bs-toggle="dropdown"></i><div class="dropdown-menu shadow-smooth-2"><ul><li><a class="dropdown-item lts-05" href="javascript:void(0)" data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#edit-role-" + role.id)}><i class="ri-pencil-line"></i> ${ssrInterpolate(_ctx.$t("messages.word.edit"))}</a></li><li><a class="dropdown-item lts-05" href="javascript:void(0)" data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#remove-role-" + role.id)}><i class="ri-delete-bin-line"></i> ${ssrInterpolate(_ctx.$t("messages.word.delete"))}</a></li></ul></div><div class="modal fade edit-role-modal"${ssrRenderAttr("id", "edit-role-" + role.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.word.edit"))}: <span class="ms-1">${ssrInterpolate(role.label)}</span></div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12 mb-4"><label for="eaRoleTitle" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.name"))}</label><input${ssrRenderAttr("value", unref(editForm).label)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.role_name_placeholder"))} class="form-control" id="eaRoleTitle"></div><div class="col-12 mb-4"><label class="form-label">${ssrInterpolate(_ctx.$t("messages.word.permissions"))}</label>`);
        _push(ssrRenderComponent(unref(MultiSelect), {
          class: "pvc-multiselect",
          modelValue: unref(editForm).permissions,
          "onUpdate:modelValue": ($event) => unref(editForm).permissions = $event,
          options: permissionsList.value,
          display: "chip",
          optionLabel: "label",
          optionValue: "id",
          placeholder: _ctx.$t("messages.sentence.select_permissions")
        }, null, _parent));
        _push(`</div></div></div><div class="modal-footer"><button class="btn btn-sm btn-primary px-3">${ssrInterpolate(_ctx.$t("messages.word.edit"))}</button></div></form></div></div></div><div class="modal fade"${ssrRenderAttr("id", "remove-role-" + role.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form action="#" style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.are_you_sure_delete_role"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-footer">`);
        _push(ssrRenderComponent(unref(Link), {
          as: "button",
          href: _ctx.route("admin.roles.destroy", role.id),
          method: "delete",
          class: "btn btn-sm btn-danger px-3",
          "data-bs-dismiss": "modal",
          "aria-label": "Close"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("messages.word.delete"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("messages.word.delete")), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</div></form></div></div></div></td></tr>`);
      });
      _push(`<!--]--></tbody></table></div>`);
      if (_ctx.roles.data.length == 0) {
        _push(`<div class="product-list-empty"><div class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_sfc_main$4, {
        links: _ctx.roles.links
      }, null, _parent));
      _push(`</div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Roles/List.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
