import { defineComponent, unref, withCtx, createTextVNode, createVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderStyle, ssrRenderList, ssrRenderAttr } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./MainLayout-CahYFWjG.js";
import { Head, Link } from "@inertiajs/vue3";
import { _ as _sfc_main$2 } from "./SearchList-BZnYMQPN.js";
import { _ as _sfc_main$3 } from "./FilterList-CWxGcEKk.js";
import { _ as _sfc_main$4 } from "./Pagination-C1AQrLe3.js";
/* empty css                       */
/* empty css                              */
/* empty css                           */
/* empty css             */
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
import "./AdminNavigation-BYBoZNuA.js";
import "./useHexToRgb-G7J9N7Ap.js";
import "./useRandomStr-4MeWbtRd.js";
import "jquery";
import "lodash/debounce.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "List",
  __ssrInlineRender: true,
  props: {
    tickets: {},
    keyword: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.ticket_list")
      }, null, _parent));
      _push(`<div class="card shadow-1 panel-content"><div class="card-body"><div class="panel-content--title panel-content--title-with-button mb-4 lts-05">${ssrInterpolate(_ctx.$t("messages.word.tickets"))} `);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("user.tickets.create"),
        class: "btn btn-primary shadow-1 lts-05 px-4"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.create_new_ticket"))} <i class="ri-send-plane-2-line ms-2"${_scopeId}></i>`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("messages.sentence.create_new_ticket")) + " ", 1),
              createVNode("i", { class: "ri-send-plane-2-line ms-2" })
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div><div class="ticket-list mb-3">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        keyword: _ctx.keyword,
        placeholder: _ctx.$t("messages.sentence.ticket_title") + " ..."
      }, null, _parent));
      _push(ssrRenderComponent(_sfc_main$3, {
        filters: { waiting_admin: _ctx.$t("messages.sentence.awaiting_answer"), waiting_user: _ctx.$t("messages.word.answered"), closed: _ctx.$t("messages.word.closed") }
      }, null, _parent));
      _push(`<div class="table-responsive simplebar-container"><table class="table" style="${ssrRenderStyle({ "min-width": "900px" })}"><thead><tr><th>${ssrInterpolate(_ctx.$t("messages.word.title"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.priority"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.last_update"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.status"))}</th></tr></thead><tbody><!--[-->`);
      ssrRenderList(_ctx.tickets.data, (ticket) => {
        _push(`<tr><td>`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("user.tickets.show", ticket.id),
          class: { link: true, "fw-normal": ticket.status == "waiting_admin" || ticket.status == "closed" }
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(ticket.title)}`);
            } else {
              return [
                createTextVNode(toDisplayString(ticket.title), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</td><td class="lts-05 fs-8">`);
        if (ticket.priority == "high") {
          _push(`<span>${ssrInterpolate(_ctx.$t("messages.word.high"))}</span>`);
        } else if (ticket.priority == "normal") {
          _push(`<span>${ssrInterpolate(_ctx.$t("messages.word.average"))}</span>`);
        } else if (ticket.priority == "low") {
          _push(`<span>${ssrInterpolate(_ctx.$t("messages.word.low"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</td><td class="lts-05 fs-8">${ssrInterpolate(ticket.jalali_updated_at[3])}</td><td>`);
        if (ticket.status == "waiting_admin") {
          _push(`<span class="badge bg-info rounded-pill fs-7">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_answer"))}</span>`);
        } else if (ticket.status == "waiting_user") {
          _push(`<span class="badge bg-success rounded-pill fs-7">${ssrInterpolate(_ctx.$t("messages.word.answered"))}</span>`);
        } else if (ticket.status == "closed") {
          _push(`<span class="badge bg-dark rounded-pill fs-7">${ssrInterpolate(_ctx.$t("messages.word.closed"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</td></tr>`);
      });
      _push(`<!--]--></tbody></table></div></div>`);
      if (_ctx.tickets.data.length == 0) {
        _push(`<div class="cart-empty"><div class="empty-content-icon"><img${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/template/orders.svg")}></div><div class="empty-content-message text-center"><p class="mb-4 lts-05 fs-8">${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</p></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.tickets.data.length != 0) {
        _push(ssrRenderComponent(_sfc_main$4, {
          links: _ctx.tickets.links
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/User/Tickets/List.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
