import { defineComponent, ref, resolveDirective, unref, withCtx, createTextVNode, createVNode, toDisplayString, createBlock, createCommentVNode, openBlock, mergeProps, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrIncludeBooleanAttr, ssrLooseEqual, ssrRenderClass, ssrRenderAttr, ssrRenderStyle, ssrRenderList, ssrRenderAttrs, ssrGetDirectiveProps } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./AdminLayout-CD07IMsK.js";
import { useForm, Head, Link } from "@inertiajs/vue3";
import { _ as _sfc_main$5 } from "./Pagination-C1AQrLe3.js";
import { _ as _sfc_main$3 } from "./SearchList-BZnYMQPN.js";
import { _ as _sfc_main$4 } from "./FilterList-CWxGcEKk.js";
import { _ as _sfc_main$2 } from "./Files-B6eiTnN6.js";
import { u as useNumberFormat } from "../ssr.js";
import Dropdown from "primevue/dropdown/dropdown.esm.js";
import "toastify-js";
import "./useToastify-D_n0s7Uc.js";
import "laravel-vue-i18n";
import "simplebar";
import "resize-observer-polyfill";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "lodash/debounce.js";
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "./useRandomNum-DNNSqR7b.js";
import "@vue/server-renderer";
import "@inertiajs/vue3/server";
import "ziggy-js";
import "axios";
import "swiper/bundle";
import "jquery";
import "swiper";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "List",
  __ssrInlineRender: true,
  props: {
    products: {},
    categories: {},
    brands: {},
    statusList: {},
    keyword: {}
  },
  setup(__props) {
    const props = __props;
    const addToAffiliateForm = useForm({
      bronze_commission: 0,
      silver_commission: 0,
      gold_commission: 0
    });
    const categoriesList = ref([]);
    for (let category2 in props.categories) {
      categoriesList.value.push(props.categories[category2]);
    }
    const category = ref();
    const addFromDigikalaForm = useForm({
      uuid: null,
      category: category.value,
      commission: 0,
      status: "publish"
    });
    const exportType = ref("all");
    const excelCategory = ref("all");
    const brand = ref("all");
    const excelCategoriesList = ref([]);
    excelCategoriesList.value.push({ id: "all", title: "همه دسته‌بندی ها" });
    for (let category2 in props.categories) {
      excelCategoriesList.value.push(props.categories[category2]);
    }
    const brandsList = ref([]);
    brandsList.value.push({ id: "all", title: "همه برند ها" });
    for (let brand2 in props.brands) {
      brandsList.value.push(props.brands[brand2]);
    }
    const selectedFileName = ref(null);
    useForm({
      file: null
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _directive_tooltip = resolveDirective("tooltip");
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.product_list")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.sentence.product_list")
      }, null, _parent));
      _push(`<div class="product-list list mb-4"><div class="card"><div class="card-body"><div class="action-container mb-3 d-flex align-items-center justify-content-start justify-content-md-end flex-wrap"><button type="button" class="btn btn-danger lts-05 me-2 mb-2 order-2 order-md-3" data-bs-toggle="modal" data-bs-target="#add-from-digikala">${ssrInterpolate(_ctx.$t("messages.sentence.import_from_digikala"))}</button>`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("admin.products.create"),
        as: "button",
        class: "btn btn-primary lts-05 mb-2 me-2 order-1 order-md-4"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.create_product"))} <i class="ri-add-line"${_scopeId}></i>`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("messages.sentence.create_product")) + " ", 1),
              createVNode("i", { class: "ri-add-line" })
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`<button data-bs-toggle="modal" data-bs-target="#importStorage" type="button" class="btn btn-light fs-8 fw-bold mb-2 me-2 order-3 order-md-1">${ssrInterpolate(_ctx.$t("messages.sentence.import_excel"))} <i class="ri-file-excel-2-line ms-2 fw-light fs-6"></i></button><div class="modal fade" id="importStorage" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.import_products_excel"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row upload-file-container"><div class="col-12 mb-4"><p class="lts-05 text-dark lh-25 mb-2">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_101252"))}</p><p class="lts-05 text-dark lh-25 mb-2">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_585420"))}</p><p class="lts-05 text-dark lh-25">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_100125"))}</p></div><div class="col-12 mb-3"><div class="form-element-row-file"><div class="custom-input-file">`);
      if (!selectedFileName.value) {
        _push(`<!--[--><label for="uploadFile" class="custom-input-file-label"><span class="label"><i class="ri-arrow-up-fill me-1"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.select_file"))}</span></label><input type="file" class="custom-input-file-input" id="uploadFile" accept=".xlsx"><!--]-->`);
      } else {
        _push(`<div class="selected-file-name"><i class="ri-file-excel-2-line me-1"></i> ${ssrInterpolate(selectedFileName.value)} <button type="button" class="btn btn-sm btn-link link text-danger ms-2">${ssrInterpolate(_ctx.$t("messages.word.delete"))}</button></div>`);
      }
      _push(`</div></div></div></div></div><div class="modal-footer"><button class="btn btn-success">${ssrInterpolate(_ctx.$t("messages.word.apply"))}</button></div></form></div></div></div><button data-bs-toggle="modal" data-bs-target="#exportStorage" type="button" class="btn btn-light fs-8 fw-bold mb-2 me-2 order-4 order-md-2">${ssrInterpolate(_ctx.$t("messages.sentence.export_excel"))} <i class="ri-file-excel-2-line ms-2 fw-light fs-6"></i></button><div class="modal fade" id="exportStorage" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.export_products_excel"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12 mb-3"><span class="lts-05 text-dark fw-bold">${ssrInterpolate(_ctx.$t("messages.word.type"))}:</span></div><div class="col-lg-4 col-12 mb-2"><label for="eaAll" class="form-label d-flex align-items-center white-space-nowrap clickable"><input${ssrIncludeBooleanAttr(ssrLooseEqual(exportType.value, "all")) ? " checked" : ""} type="radio" value="all" class="form-check-box clickable me-1" id="eaAll"> ${ssrInterpolate(_ctx.$t("messages.sentence.all_products"))}</label></div><div class="col-lg-4 col-12 mb-2"><label for="eaInstock" class="form-label d-flex align-items-center white-space-nowrap clickable"><input${ssrIncludeBooleanAttr(ssrLooseEqual(exportType.value, "instock")) ? " checked" : ""} type="radio" value="instock" class="form-check-box clickable me-1" id="eaInstock"> ${ssrInterpolate(_ctx.$t("messages.sentence.with_inventory"))}</label></div><div class="col-lg-4 col-12 mb-2"><label for="eaOutofstock" class="form-label d-flex align-items-center white-space-nowrap clickable"><input${ssrIncludeBooleanAttr(ssrLooseEqual(exportType.value, "outofstock")) ? " checked" : ""} type="radio" value="outofstock" class="form-check-box clickable me-1" id="eaOutofstock"> ${ssrInterpolate(_ctx.$t("messages.sentence.no_inventory"))}</label></div><div class="col-lg-4 col-12 mb-2"><label for="eaVip" class="form-label d-flex align-items-center white-space-nowrap clickable"><input${ssrIncludeBooleanAttr(ssrLooseEqual(exportType.value, "vip")) ? " checked" : ""} type="radio" value="vip" class="form-check-box clickable me-1" id="eaVip"> ${ssrInterpolate(_ctx.$t("messages.sentence.vip_products"))}</label></div><div class="col-lg-4 col-12 mb-2"><label for="eaPublished" class="form-label d-flex align-items-center white-space-nowrap clickable"><input${ssrIncludeBooleanAttr(ssrLooseEqual(exportType.value, "publish")) ? " checked" : ""} type="radio" value="publish" class="form-check-box clickable me-1" id="eaPublished"> ${ssrInterpolate(_ctx.$t("messages.word.published"))}</label></div><div class="col-lg-4 col-12 mb-2"><label for="eaDraft" class="form-label d-flex align-items-center white-space-nowrap clickable"><input${ssrIncludeBooleanAttr(ssrLooseEqual(exportType.value, "draft")) ? " checked" : ""} type="radio" value="draft" class="form-check-box clickable me-1" id="eaDraft"> ${ssrInterpolate(_ctx.$t("messages.word.draft"))}</label></div><div class="col-12 mb-2 mt-4"><span class="lts-05 text-dark fw-bold">${ssrInterpolate(_ctx.$t("messages.sentence.category_filter"))}:</span></div><div class="col-12 mb-4">`);
      _push(ssrRenderComponent(unref(Dropdown), {
        class: "pvc-multiselect pvc-multiselect-filter",
        modelValue: excelCategory.value,
        "onUpdate:modelValue": ($event) => excelCategory.value = $event,
        options: excelCategoriesList.value,
        filter: "",
        emptyFilterMessage: _ctx.$t("messages.sentence.no_items_found"),
        display: "chip",
        optionLabel: "title",
        optionValue: "id",
        appendTo: "#exportStorage",
        placeholder: _ctx.$t("messages.sentence.select_category")
      }, {
        option: withCtx((slotProps, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="category-template flex align-items-center"${_scopeId}><div class="${ssrRenderClass({
              "category-level-one": slotProps.option.level == "one",
              "category-level-two": slotProps.option.level == "two",
              "category-level-three": slotProps.option.level == "three"
            })}"${_scopeId}>`);
            if (slotProps.option.level == "three") {
              _push2(`<span${_scopeId}><i class="ri-arrow-drop-left-line"${_scopeId}></i></span>`);
            } else if (slotProps.option.level == "two") {
              _push2(`<span${_scopeId}><i class="circle-icon ri-circle-fill"${_scopeId}></i></span>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(` ${ssrInterpolate(slotProps.option.title)}</div></div>`);
          } else {
            return [
              createVNode("div", { class: "category-template flex align-items-center" }, [
                createVNode("div", {
                  class: {
                    "category-level-one": slotProps.option.level == "one",
                    "category-level-two": slotProps.option.level == "two",
                    "category-level-three": slotProps.option.level == "three"
                  }
                }, [
                  slotProps.option.level == "three" ? (openBlock(), createBlock("span", { key: 0 }, [
                    createVNode("i", { class: "ri-arrow-drop-left-line" })
                  ])) : slotProps.option.level == "two" ? (openBlock(), createBlock("span", { key: 1 }, [
                    createVNode("i", { class: "circle-icon ri-circle-fill" })
                  ])) : createCommentVNode("", true),
                  createTextVNode(" " + toDisplayString(slotProps.option.title), 1)
                ], 2)
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div><div class="col-12 mb-2"><span class="lts-05 text-dark fw-bold">${ssrInterpolate(_ctx.$t("messages.sentence.brand_filter"))}:</span></div><div class="col-12 mb-3">`);
      _push(ssrRenderComponent(unref(Dropdown), {
        class: "pvc-dropdown",
        modelValue: brand.value,
        "onUpdate:modelValue": ($event) => brand.value = $event,
        options: brandsList.value,
        display: "chip",
        optionLabel: "title",
        optionValue: "id",
        filter: "",
        appendTo: "#exportStorage",
        placeholder: _ctx.$t("messages.sentence.select_brand")
      }, null, _parent));
      _push(`</div></div></div><div class="modal-footer"><a${ssrRenderAttr("href", _ctx.route("admin.products.export", { type: exportType.value, category: excelCategory.value, brand: brand.value }))} class="btn btn-sm btn-primary px-3">${ssrInterpolate(_ctx.$t("messages.word.download"))}</a></div></div></div></div></div><div class="modal fade add-from-digikala" id="add-from-digikala" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.import_from_digikala"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12 mb-4"><label for="eaTitle" class="form-label required">${ssrInterpolate(_ctx.$t("messages.sentence.product_uuid_in_digikala"))}</label><input${ssrRenderAttr("value", unref(addFromDigikalaForm).uuid)} type="text" placeholder="مثال: dkp-18577783" class="form-control" id="eaTitle"></div><div class="col-12 mb-4"><label for="eaCategories" class="form-label required">${ssrInterpolate(_ctx.$t("messages.word.category"))}</label>`);
      _push(ssrRenderComponent(unref(Dropdown), {
        class: "pvc-multiselect pvc-multiselect-filter",
        modelValue: category.value,
        "onUpdate:modelValue": ($event) => category.value = $event,
        options: categoriesList.value,
        filter: "",
        emptyFilterMessage: _ctx.$t("messages.sentence.no_items_found"),
        display: "chip",
        "append-to": "#add-from-digikala",
        optionLabel: "title",
        placeholder: _ctx.$t("messages.sentence.select_category")
      }, {
        option: withCtx((slotProps, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="category-template flex align-items-center"${_scopeId}><div class="${ssrRenderClass({
              "category-level-one": slotProps.option.level == "one",
              "category-level-two": slotProps.option.level == "two",
              "category-level-three": slotProps.option.level == "three"
            })}"${_scopeId}>`);
            if (slotProps.option.level == "three") {
              _push2(`<span${_scopeId}><i class="ri-arrow-drop-left-line"${_scopeId}></i></span>`);
            } else if (slotProps.option.level == "two") {
              _push2(`<span${_scopeId}><i class="circle-icon ri-circle-fill"${_scopeId}></i></span>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(` ${ssrInterpolate(slotProps.option.title)}</div></div>`);
          } else {
            return [
              createVNode("div", { class: "category-template flex align-items-center" }, [
                createVNode("div", {
                  class: {
                    "category-level-one": slotProps.option.level == "one",
                    "category-level-two": slotProps.option.level == "two",
                    "category-level-three": slotProps.option.level == "three"
                  }
                }, [
                  slotProps.option.level == "three" ? (openBlock(), createBlock("span", { key: 0 }, [
                    createVNode("i", { class: "ri-arrow-drop-left-line" })
                  ])) : slotProps.option.level == "two" ? (openBlock(), createBlock("span", { key: 1 }, [
                    createVNode("i", { class: "circle-icon ri-circle-fill" })
                  ])) : createCommentVNode("", true),
                  createTextVNode(" " + toDisplayString(slotProps.option.title), 1)
                ], 2)
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div><div class="col-12 mb-4"><div class="form-element-row"><label for="eaCommission" class="form-label fs-8">${ssrInterpolate(_ctx.$t("messages.sentence.product_comission_for_seller"))}: ${ssrInterpolate(unref(addFromDigikalaForm).commission)}%</label><input${ssrRenderAttr("value", unref(addFromDigikalaForm).commission)} id="eaCommission" type="range" class="form-range" min="0" max="100" step="0.1"></div></div><div class="col-12"><label class="form-label required lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.product_status"))}: </label>`);
      _push(ssrRenderComponent(unref(Dropdown), {
        class: "pvc-dropdown",
        modelValue: unref(addFromDigikalaForm).status,
        "onUpdate:modelValue": ($event) => unref(addFromDigikalaForm).status = $event,
        options: _ctx.statusList,
        display: "chip",
        optionLabel: "label",
        optionValue: "id",
        placeholder: _ctx.$t("messages.sentence.select_status")
      }, null, _parent));
      _push(`</div><div class="col-12 my-4"><div class="border"></div></div><div class="col-12"><p class="fs-8 lts-05 text-gray">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_541010"))}</p><p class="fs-8 lts-05 text-gray mb-0">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_120501"))}</p></div><div class="col-12 my-4"><div class="border"></div></div></div></div><div class="modal-footer"><button class="btn btn-sm btn-primary px-3"${ssrIncludeBooleanAttr(unref(addFromDigikalaForm).processing) ? " disabled" : ""}>${ssrInterpolate(_ctx.$t("messages.word.add"))} `);
      if (unref(addFromDigikalaForm).processing) {
        _push(`<i class="ri-refresh-line i-spin"></i>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</button></div></form></div></div></div>`);
      _push(ssrRenderComponent(_sfc_main$3, {
        keyword: _ctx.keyword,
        placeholder: _ctx.$t("messages.sentence.product_title_or_uuid") + " ..."
      }, null, _parent));
      _push(ssrRenderComponent(_sfc_main$4, {
        filters: {
          publish: _ctx.$t("messages.word.published"),
          awaiting: _ctx.$t("messages.sentence.awaiting_verify"),
          draft: _ctx.$t("messages.word.draft"),
          mostSale: _ctx.$t("messages.word.most_sale"),
          mostViewer: _ctx.$t("messages.word.most_viewed"),
          hasPrice: _ctx.$t("messages.sentence.with_inventory"),
          noPrice: _ctx.$t("messages.sentence.no_inventory"),
          outofstock: _ctx.$t("messages.word.outofstock")
        }
      }, null, _parent));
      _push(`<div class="d-block w-100 mb-3"><span class="fs-8 lts-05 text-gray">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_986331"))}</span></div><div class="table-responsive mb-4"><table class="table" style="${ssrRenderStyle({ "min-width": "1000px" })}"><thead><tr><th class="first-small">${ssrInterpolate(_ctx.$t("messages.word.image"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.title"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.inventories"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.by"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.status"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.uuid"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.last_update"))}</th><th class="first-small"><i class="ri-settings-4-line"></i></th></tr></thead><tbody><!--[-->`);
      ssrRenderList(_ctx.products.data, (product) => {
        _push(`<tr><td><img class="br-10" width="35" height="35"${ssrRenderAttr("src", product.get_images[0]["link"])}${ssrRenderAttr("alt", product.get_images[0]["alt"])}></td><td${ssrRenderAttrs(ssrGetDirectiveProps(_ctx, _directive_tooltip, product.is_vip ? _ctx.$t("messages.sentence.vip_product") : null, void 0, { top: true }))}>`);
        _push(ssrRenderComponent(unref(Link), {
          class: "product-title product-title-min-300",
          href: _ctx.route("admin.products.edit", product.slug)
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(product.title)}`);
            } else {
              return [
                createTextVNode(toDisplayString(product.title), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        if (product.is_vip) {
          _push(`<i class="ri-star-s-fill vip-product"></i>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</td><td class="white-space-nowrap">`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("admin.inventories.index", product.slug),
          class: "link active-link lts-05"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.manage_inventories"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("messages.sentence.manage_inventories")), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</td><td class="white-space-nowrap">`);
        if (product.user.type == "owner" || product.user.type == "admin") {
          _push(ssrRenderComponent(unref(Link), {
            class: "link fs-8 fw-normal",
            href: _ctx.route("admin.users.show", product.user_id)
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(product.user.get_name)}`);
              } else {
                return [
                  createTextVNode(toDisplayString(product.user.get_name), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
        } else if (product.user.seller) {
          _push(ssrRenderComponent(unref(Link), {
            class: "link fs-8 fw-normal",
            href: _ctx.route("admin.stores.show", product.user.store.uuid)
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(product.user.store.name)}`);
              } else {
                return [
                  createTextVNode(toDisplayString(product.user.store.name), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
        } else {
          _push(`<!---->`);
        }
        _push(`</td><td class="lts-05">`);
        if (product.status == "publish") {
          _push(`<span class="badge bg-success">${ssrInterpolate(_ctx.$t("messages.word.published"))}</span>`);
        } else if (product.status == "draft") {
          _push(`<span class="badge bg-warning">${ssrInterpolate(_ctx.$t("messages.word.draft"))}</span>`);
        } else if (product.status == "awaiting") {
          _push(`<span class="badge bg-info">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_verify"))}</span>`);
        } else if (product.status == "rejected") {
          _push(`<span class="badge bg-danger">${ssrInterpolate(_ctx.$t("messages.word.rejected"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        if (product.inventory_status.inquery) {
          _push(`<span class="badge bg-purple ms-1">${ssrInterpolate(_ctx.$t("messages.sentence.inventory_inquiry"))}</span>`);
        } else {
          _push(`<!--[-->`);
          if (!product.inventory_status.inventory) {
            _push(`<span${ssrRenderAttrs(mergeProps({ class: "badge bg-warning ms-1" }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.sentence.no_inventory_variation_recorded"), void 0, { top: true })))}>${ssrInterpolate(_ctx.$t("messages.sentence.no_inventory"))}</span>`);
          } else {
            _push(`<!---->`);
          }
          if (product.inventory_status.inventory && !product.inventory_status.instock) {
            _push(`<span${ssrRenderAttrs(mergeProps({ class: "badge bg-danger ms-1" }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.sentence.inventory_count_is_zero"), void 0, { top: true })))}>${ssrInterpolate(_ctx.$t("messages.word.outofstock"))}</span>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<!--]-->`);
        }
        _push(`</td><td${ssrRenderAttrs(mergeProps({ class: "lts-05 fs-8 clickable" }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.sentence.copy_product_uuid"), void 0, { top: true })))}>${ssrInterpolate(product.uuid)}</td><td class="lts-05 fs-8">${ssrInterpolate(product.jalali_updated_at[2])}</td><td class="dropdown"><i class="ri-more-2-fill" data-bs-toggle="dropdown"></i><div class="dropdown-menu shadow-smooth-2"><ul>`);
        if (product.status == "publish") {
          _push(`<li><a class="dropdown-item lts-05" target="_blank"${ssrRenderAttr("href", _ctx.route("main.products.show", product.slug))}><i class="ri-eye-line"></i> ${ssrInterpolate(_ctx.$t("messages.word.show"))}</a></li>`);
        } else {
          _push(`<!---->`);
        }
        if (product.status == "awaiting") {
          _push(`<li>`);
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("admin.products.edit", product.slug),
            as: "button",
            class: "dropdown-item lts-05"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<i class="ri-survey-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.sentence.check_and_confirm"))}`);
              } else {
                return [
                  createVNode("i", { class: "ri-survey-line" }),
                  createTextVNode(" " + toDisplayString(_ctx.$t("messages.sentence.check_and_confirm")), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</li>`);
        } else {
          _push(`<!---->`);
        }
        if (product.status == "publish" && _ctx.$page.props.auth.can["manage-affiliate"]) {
          _push(`<li><a class="dropdown-item lts-05" href="javascript:void(0)" data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#add-to-affiliate-" + product.id)}><i class="ri-user-voice-line"></i> ${ssrInterpolate(product.get_affiliate != null ? _ctx.$t("messages.sentence.edit_affiliate") : _ctx.$t("messages.sentence.add_to_affiliate"))}</a></li>`);
        } else {
          _push(`<!---->`);
        }
        if (product.status != "rejected") {
          _push(`<li>`);
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("admin.products.edit", product.slug),
            as: "button",
            class: "dropdown-item lts-05"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<i class="ri-pencil-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.word.edit"))}`);
              } else {
                return [
                  createVNode("i", { class: "ri-pencil-line" }),
                  createTextVNode(" " + toDisplayString(_ctx.$t("messages.word.edit")), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</li>`);
        } else {
          _push(`<!---->`);
        }
        if (product.status == "publish" || product.status == "draft") {
          _push(`<li>`);
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("admin.products.clone", product.slug),
            as: "button",
            method: "post",
            class: "dropdown-item lts-05"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<i class="ri-file-copy-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.word.copy"))}`);
              } else {
                return [
                  createVNode("i", { class: "ri-file-copy-line" }),
                  createTextVNode(" " + toDisplayString(_ctx.$t("messages.word.copy")), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</li>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<li>`);
        if (product.status == "publish") {
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("admin.products.destroy", product.slug),
            method: "delete",
            as: "button",
            data: { status: "draft" },
            class: "dropdown-item no-btn"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<i class="ri-spam-3-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.sentence.unpublish"))}`);
              } else {
                return [
                  createVNode("i", { class: "ri-spam-3-line" }),
                  createTextVNode(" " + toDisplayString(_ctx.$t("messages.sentence.unpublish")), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
        } else if (product.status == "draft") {
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("admin.products.destroy", product.slug),
            method: "delete",
            as: "button",
            data: { status: "publish" },
            class: "dropdown-item no-btn"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<i class="ri-spam-3-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.word.publish"))}`);
              } else {
                return [
                  createVNode("i", { class: "ri-spam-3-line" }),
                  createTextVNode(" " + toDisplayString(_ctx.$t("messages.word.publish")), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
        } else {
          _push(`<!---->`);
        }
        _push(`</li><li><a href="javascript:void(0)" data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#product-statistics-" + product.id)} class="dropdown-item no-btn"><i class="ri-bar-chart-2-line"></i> ${ssrInterpolate(_ctx.$t("messages.word.statistics"))}</a></li><li><a href="javascript:void(0)" data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#remove-product-" + product.id)} class="dropdown-item no-btn"><i class="ri-delete-bin-line"></i> ${ssrInterpolate(_ctx.$t("messages.word.delete"))}</a></li></ul></div><div class="modal fade"${ssrRenderAttr("id", "add-to-affiliate-" + product.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.add_to_affiliate"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12 mb-4"><p class="alert alert-light fs-7 lh-25 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_897754"))}</p></div><div class="col-12 mb-4"><div class="form-element-row"><label for="eaBronzeCommision" class="form-label fs-8">${ssrInterpolate(_ctx.$t("messages.word.bronze"))}: ${ssrInterpolate(unref(addToAffiliateForm).bronze_commission)}% </label><input${ssrRenderAttr("value", unref(addToAffiliateForm).bronze_commission)} id="eaBronzeCommision" type="range" class="form-range" min="0" max="100" step="0.1"></div></div><div class="col-12 mb-4"><div class="form-element-row"><label for="eaSilverCommision" class="form-label fs-8">${ssrInterpolate(_ctx.$t("messages.word.silver"))}: ${ssrInterpolate(unref(addToAffiliateForm).silver_commission)}% </label><input${ssrRenderAttr("value", unref(addToAffiliateForm).silver_commission)} id="eaSilverCommision" type="range" class="form-range" min="0" max="100" step="0.1"></div></div><div class="col-12 mb-4"><div class="form-element-row"><label for="eaGoldCommision" class="form-label fs-8">${ssrInterpolate(_ctx.$t("messages.word.gold"))}: ${ssrInterpolate(unref(addToAffiliateForm).gold_commission)}% </label><input${ssrRenderAttr("value", unref(addToAffiliateForm).gold_commission)} id="eaGoldCommision" type="range" class="form-range" min="0" max="100" step="0.1"></div></div><div class="col-12 mb-4"><span class="text-gray fs-9 fw-light lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_881125"))}</span></div></div></div><div class="modal-footer">`);
        if (product.get_affiliate != null) {
          _push(ssrRenderComponent(unref(Link), {
            as: "button",
            href: _ctx.route("admin.affiliate.delete", product.slug),
            method: "delete",
            class: "btn btn-sm btn-danger px-3",
            "data-bs-dismiss": "modal",
            "aria-label": "Close"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(_ctx.$t("messages.word.delete"))}`);
              } else {
                return [
                  createTextVNode(toDisplayString(_ctx.$t("messages.word.delete")), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
        } else {
          _push(`<!---->`);
        }
        _push(`<button type="submit" class="btn btn-sm btn-primary px-3" data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(product.get_affiliate != null ? _ctx.$t("messages.word.edit") : _ctx.$t("messages.word.add"))}</button></div></form></div></div></div><div class="modal fade"${ssrRenderAttr("id", "product-statistics-" + product.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-lgs modal-dialog-centered"><div class="modal-content"><form style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.product_statistics"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12"><div class="table-responsive"><table class="table" style="${ssrRenderStyle({ "width": "100%", "min-width": "100%" })}"><tbody><tr><td class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.product_uuid"))}</td><td${ssrRenderAttrs(mergeProps({ class: "clickable" }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.sentence.copy_product_uuid"), void 0, { top: true })))}>${ssrInterpolate(product.uuid)}</td></tr><tr><td>${ssrInterpolate(_ctx.$t("messages.word.view"))}</td><td>${ssrInterpolate(product.get_formatted_view_count)}</td></tr><tr><td>${ssrInterpolate(_ctx.$t("messages.word.sale"))}</td><td>${ssrInterpolate(unref(useNumberFormat)(Number(product.consignment_items_count)))}</td></tr><tr><td class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.couments_count"))}</td><td>${ssrInterpolate(product.comments_info.count)}</td></tr><tr><td class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.review_rating"))}</td><td>${ssrInterpolate(product.comments_info.rating)} <span><i class="ri-star-s-fill p-0 text-yellow"></i></span></td></tr><tr><td class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.questions_count"))}</td><td>${ssrInterpolate(product.questions_info.count)}</td></tr><tr><td class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.answers_count"))}</td><td>${ssrInterpolate(product.answers_info.count)}</td></tr></tbody></table></div></div></div></div><div class="modal-footer"><button class="btn btn-primary" type="button" data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(_ctx.$t("messages.word.close"))}</button></div></form></div></div></div><div class="modal fade"${ssrRenderAttr("id", "remove-product-" + product.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.are_you_sure_delete_product"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-footer">`);
        _push(ssrRenderComponent(unref(Link), {
          as: "button",
          href: _ctx.route("admin.products.destroy", product.slug),
          method: "delete",
          data: { status: "deleted" },
          class: "btn btn-sm btn-danger px-3",
          "data-bs-dismiss": "modal",
          "aria-label": "Close"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("messages.word.delete"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("messages.word.delete")), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</div></form></div></div></div></td></tr>`);
      });
      _push(`<!--]--></tbody></table></div>`);
      if (_ctx.products.data.length == 0) {
        _push(`<div class="product-list-empty"><div class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_sfc_main$5, {
        links: _ctx.products.links
      }, null, _parent));
      _push(`</div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Products/Products/List.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
