import { defineComponent, resolveDirective, unref, withCtx, createTextVNode, toDisplayString, mergeProps, createVNode, useSSRContext } from "vue";
import { ssrRenderComponent, ssrRenderStyle, ssrInterpolate, ssrRenderList, ssrGetDirectiveProps } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./AdminLayout-CD07IMsK.js";
import { Head, Link } from "@inertiajs/vue3";
import { _ as _sfc_main$3 } from "./SearchList-BZnYMQPN.js";
import { _ as _sfc_main$4 } from "./FilterList-CWxGcEKk.js";
import { _ as _sfc_main$5 } from "./Pagination-C1AQrLe3.js";
import { _ as _sfc_main$2 } from "./Files-B6eiTnN6.js";
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "lodash/debounce.js";
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "laravel-vue-i18n";
import "./useRandomNum-DNNSqR7b.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "List",
  __ssrInlineRender: true,
  props: {
    tickets: {},
    keyword: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      const _directive_tooltip = resolveDirective("tooltip");
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.ticket_list")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.word.tickets")
      }, null, _parent));
      _push(`<div class="user-list list mb-4"><div class="card"><div class="card-body">`);
      _push(ssrRenderComponent(_sfc_main$3, {
        keyword: _ctx.keyword,
        placeholder: _ctx.$t("messages.sentence.ticket_title") + " ..."
      }, null, _parent));
      _push(ssrRenderComponent(_sfc_main$4, {
        filters: {
          waiting_admin: _ctx.$t("messages.sentence.awaiting_answer"),
          waiting_user: _ctx.$t("messages.word.answered"),
          closed: _ctx.$t("messages.word.closed"),
          users: _ctx.$t("messages.word.users"),
          sellers: _ctx.$t("messages.word.sellers")
        }
      }, null, _parent));
      _push(`<div class="table-responsive simplebar-container mb-4"><table class="table" style="${ssrRenderStyle({ "min-width": "900px" })}"><thead><tr><th>${ssrInterpolate(_ctx.$t("messages.word.title"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.user"))}</th><th>${ssrInterpolate(_ctx.$t("messages.sentence.user_type"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.priority"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.status"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.last_update"))}</th><th class="first-small"><i class="ri-settings-4-line"></i></th></tr></thead><tbody><!--[-->`);
      ssrRenderList(_ctx.tickets.data, (ticket) => {
        _push(`<tr><td>`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("admin.tickets.show", ticket.id),
          class: { link: true, "fw-normal": ticket.status == "waiting_user" || ticket.status == "closed" }
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(ticket.title)}`);
            } else {
              return [
                createTextVNode(toDisplayString(ticket.title), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</td><td>`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("admin.users.show", ticket.user_id),
          class: "link fw-normal"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(ticket.user.get_name)}`);
            } else {
              return [
                createTextVNode(toDisplayString(ticket.user.get_name), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</td><td>`);
        if (ticket.user.type == "admin") {
          _push(`<span>${ssrInterpolate(_ctx.$t("messages.word.admin"))}</span>`);
        } else if (ticket.user.seller) {
          _push(`<span>${ssrInterpolate(_ctx.$t("messages.word.seller"))}</span>`);
        } else if (ticket.user.type == "user") {
          _push(`<span>${ssrInterpolate(_ctx.$t("messages.word.user"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</td><td class="lts-05 fs-8">`);
        if (ticket.priority == "high") {
          _push(`<span>${ssrInterpolate(_ctx.$t("messages.word.high"))}</span>`);
        } else if (ticket.priority == "normal") {
          _push(`<span>${ssrInterpolate(_ctx.$t("messages.word.average"))}</span>`);
        } else if (ticket.priority == "low") {
          _push(`<span>${ssrInterpolate(_ctx.$t("messages.word.low"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</td><td>`);
        if (ticket.status == "waiting_admin") {
          _push(`<span class="badge bg-info rounded-pill fs-7">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_answer"))}</span>`);
        } else if (ticket.status == "waiting_user") {
          _push(`<span class="badge bg-success rounded-pill fs-7">${ssrInterpolate(_ctx.$t("messages.word.answered"))}</span>`);
        } else if (ticket.status == "closed") {
          _push(`<span class="badge bg-dark rounded-pill fs-7">${ssrInterpolate(_ctx.$t("messages.word.closed"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</td><td class="lts-05 fs-8">${ssrInterpolate(ticket.jalali_updated_at[3])}</td><td>`);
        if (ticket.status != "closed") {
          _push(ssrRenderComponent(unref(Link), mergeProps({
            href: _ctx.route("admin.tickets.destroy", ticket.id),
            as: "button",
            method: "delete",
            class: "btn btn-dark btn-square btn-xs"
          }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.word.close"), void 0, { top: true })), {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<i class="ri-lock-line"${_scopeId}></i>`);
              } else {
                return [
                  createVNode("i", { class: "ri-lock-line" })
                ];
              }
            }),
            _: 2
          }, _parent));
        } else if (ticket.status == "closed") {
          _push(ssrRenderComponent(unref(Link), mergeProps({
            href: _ctx.route("admin.tickets.destroy", ticket.id),
            as: "button",
            method: "delete",
            class: "btn btn-success btn-square btn-xs"
          }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.word.open"), void 0, { top: true })), {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<i class="ri-lock-unlock-line"${_scopeId}></i>`);
              } else {
                return [
                  createVNode("i", { class: "ri-lock-unlock-line" })
                ];
              }
            }),
            _: 2
          }, _parent));
        } else {
          _push(`<!---->`);
        }
        _push(`</td></tr>`);
      });
      _push(`<!--]--></tbody></table></div>`);
      if (_ctx.tickets.data.length == 0) {
        _push(`<div class="product-list-empty"><div class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_sfc_main$5, {
        links: _ctx.tickets.links
      }, null, _parent));
      _push(`</div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Tickets/List.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
