import { defineComponent, unref, withCtx, createTextVNode, createVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderComponent, ssrRenderList, ssrInterpolate, ssrRenderAttr, ssrRenderStyle } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./AdminLayout-CD07IMsK.js";
import { useForm, Head, Link } from "@inertiajs/vue3";
import { _ as _sfc_main$5 } from "./Pagination-C1AQrLe3.js";
import { _ as _sfc_main$3 } from "./FilterList-CWxGcEKk.js";
import { _ as _sfc_main$4 } from "./NumInput-Bt6uFGO4.js";
import { _ as _sfc_main$2 } from "./Files-B6eiTnN6.js";
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "./useRandomStr-4MeWbtRd.js";
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "laravel-vue-i18n";
import "./SearchList-BZnYMQPN.js";
import "lodash/debounce.js";
import "./useRandomNum-DNNSqR7b.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "List",
  __ssrInlineRender: true,
  props: {
    comments: {},
    keyword: {}
  },
  setup(__props) {
    const sendAnswerForm = useForm({
      content: null
    });
    const editCommentForm = useForm({
      content: "",
      vote_up: "",
      vote_down: ""
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.article_comment_list")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.sentence.article_comment_list")
      }, null, _parent));
      _push(`<div class="comment-list orders-list list"><div class="card"><div class="card-body"><div class="comments orders">`);
      _push(ssrRenderComponent(_sfc_main$3, {
        filters: { publish: _ctx.$t("messages.word.published"), awaiting: _ctx.$t("messages.sentence.awaiting_verify") }
      }, null, _parent));
      _push(`<div class="comment-items user-order-items"><!--[-->`);
      ssrRenderList(_ctx.comments.data, (comment) => {
        _push(`<div class="comment-item user-order-item"><div class="user-order-item-header"><div class="mb-3"><div class="row">`);
        if (comment.status == "awaiting") {
          _push(`<div class="col-sm-auto mb-2"><span class="user-order-meta has-circle-animation yellow"><span class="text-muted lts-05 me-1">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_verify"))}</span></span></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="col-sm-auto mb-2"><span class="user-order-meta">`);
        if (comment.user.seller) {
          _push(`<!--[--><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.word.seller"))}: </span>`);
          _push(ssrRenderComponent(unref(Link), {
            class: "link link-icon",
            href: _ctx.route("admin.stores.show", comment.user.store.uuid)
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(comment.user.store.name)} <i class="ri-external-link-line"${_scopeId}></i>`);
              } else {
                return [
                  createTextVNode(toDisplayString(comment.user.store.name) + " ", 1),
                  createVNode("i", { class: "ri-external-link-line" })
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`<!--]-->`);
        } else {
          _push(`<!--[--><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.word.user"))}: </span>`);
          _push(ssrRenderComponent(unref(Link), {
            class: "link link-icon",
            href: _ctx.route("admin.users.show", comment.user.id)
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(comment.user.get_name)} <i class="ri-external-link-line"${_scopeId}></i>`);
              } else {
                return [
                  createTextVNode(toDisplayString(comment.user.get_name) + " ", 1),
                  createVNode("i", { class: "ri-external-link-line" })
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`<!--]-->`);
        }
        _push(`</span></div>`);
        if (comment.reply_to != null) {
          _push(`<div class="col-sm-auto mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.sentence.in_answer_to"))}: </span>`);
          if (comment.get_reply_to.user.seller) {
            _push(ssrRenderComponent(unref(Link), {
              class: "link link-icon",
              href: _ctx.route("admin.stores.show", comment.get_reply_to.user.store.uuid)
            }, {
              default: withCtx((_, _push2, _parent2, _scopeId) => {
                if (_push2) {
                  _push2(`${ssrInterpolate(comment.get_reply_to.user.store.name)} <i class="ri-external-link-line"${_scopeId}></i>`);
                } else {
                  return [
                    createTextVNode(toDisplayString(comment.get_reply_to.user.store.name) + " ", 1),
                    createVNode("i", { class: "ri-external-link-line" })
                  ];
                }
              }),
              _: 2
            }, _parent));
          } else {
            _push(ssrRenderComponent(unref(Link), {
              class: "link link-icon",
              href: _ctx.route("admin.users.show", comment.get_reply_to.user.id)
            }, {
              default: withCtx((_, _push2, _parent2, _scopeId) => {
                if (_push2) {
                  _push2(`${ssrInterpolate(comment.get_reply_to.user.get_name)} <i class="ri-external-link-line"${_scopeId}></i>`);
                } else {
                  return [
                    createTextVNode(toDisplayString(comment.get_reply_to.user.get_name) + " ", 1),
                    createVNode("i", { class: "ri-external-link-line" })
                  ];
                }
              }),
              _: 2
            }, _parent));
          }
          _push(`</span></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="col-sm-auto mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.word.like"))}: </span> ${ssrInterpolate(comment.vote_up)}</span></div><div class="col-sm-auto mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.word.unlike"))}: </span> ${ssrInterpolate(comment.vote_down)}</span></div><div class="col-sm-auto mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.word.date"))}: </span> ${ssrInterpolate(comment.jalali_created_at[0])}</span></div><div class="col-sm-auto mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.word.article"))}: </span><a class="link link-icon"${ssrRenderAttr("href", _ctx.route("blog.articles.show", comment.article.slug))} target="_blank">${ssrInterpolate(comment.article.title)} <i class="ri-external-link-line"></i></a></span></div></div></div><div class="row send-details mb-4"><div class="col-12 user-order-item-header--meta mb-3"><span class="user-order-meta mb-0"><span class="text-muted">${ssrInterpolate(_ctx.$t("messages.sentence.comment_content"))}: </span><span class="fw-bold ms-1">${ssrInterpolate(comment.content)}</span></span></div></div><div class="row"><div class="col-12 d-flex align-items-center justify-content-end dropup"><a href="javascript:void(0)" data-bs-toggle="dropdown" class="btn btn-link fw-bold user-order-detail-link">${ssrInterpolate(_ctx.$t("messages.sentence.action_menu"))} <i class="ri-arrow-left-s-fill"></i></a><div class="dropdown-menu shadow-smooth-2 mb-1 mt-1"><ul>`);
        if (comment.status == "awaiting") {
          _push(`<li>`);
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("admin.article.comments.accept", comment.id),
            method: "post",
            as: "button",
            class: "dropdown-item lts-05"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<i class="ri-chat-check-line me-1"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.word.accept"))}`);
              } else {
                return [
                  createVNode("i", { class: "ri-chat-check-line me-1" }),
                  createTextVNode(" " + toDisplayString(_ctx.$t("messages.word.accept")), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</li>`);
        } else {
          _push(`<!---->`);
        }
        if (comment.reply_to == null) {
          _push(`<li><a class="dropdown-item lts-05" href="javascript:void(0)" data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#comment-answer-" + comment.id)}><i class="ri-send-plane-2-line me-1"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.send_answer"))}</a></li>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<li><a class="dropdown-item lts-05" href="javascript:void(0)" data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#comment-edit-" + comment.id)}><i class="ri-pencil-line me-1"></i> ${ssrInterpolate(_ctx.$t("messages.word.edit"))}</a></li><li><button data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#comment-delete-" + comment.id)} class="dropdown-item no-btn"><i class="ri-delete-bin-line me-1"></i> ${ssrInterpolate(_ctx.$t("messages.word.delete"))}</button></li></ul></div><div class="modal fade"${ssrRenderAttr("id", "comment-answer-" + comment.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.send_answer"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12"><label class="form-label">${ssrInterpolate(_ctx.$t("messages.word.answer"))}: <textarea type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.write_your_answer") + " ...")} required class="form-control">${ssrInterpolate(unref(sendAnswerForm).content)}</textarea></label></div></div></div><div class="modal-footer"><button class="btn btn-sm btn-primary px-3" data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(_ctx.$t("messages.word.send"))}</button></div></form></div></div></div><div class="modal fade"${ssrRenderAttr("id", "comment-edit-" + comment.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.edit_comment"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12 mb-3"><label class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.comment_content"))}: <textarea type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.comment_content") + " ...")} required class="form-control">${ssrInterpolate(unref(editCommentForm).content)}</textarea></label></div><div class="col-sm-6 col-12 mb-3"><label for="eaFirstName" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.like"))} `);
        _push(ssrRenderComponent(_sfc_main$4, {
          modelValue: unref(editCommentForm).vote_up,
          "onUpdate:modelValue": ($event) => unref(editCommentForm).vote_up = $event,
          type: "text",
          required: "",
          class: "form-control"
        }, null, _parent));
        _push(`</label></div><div class="col-sm-6 col-12 mb-3"><label for="eaFirstName" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.unlike"))} `);
        _push(ssrRenderComponent(_sfc_main$4, {
          modelValue: unref(editCommentForm).vote_down,
          "onUpdate:modelValue": ($event) => unref(editCommentForm).vote_down = $event,
          type: "text",
          required: "",
          class: "form-control"
        }, null, _parent));
        _push(`</label></div></div></div><div class="modal-footer"><button data-bs-dismiss="modal" aria-label="Close" class="btn btn-sm btn-primary px-3">${ssrInterpolate(_ctx.$t("messages.word.edit"))}</button></div></form></div></div></div><div class="modal fade"${ssrRenderAttr("id", "comment-delete-" + comment.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.are_yo_sure_delete_comment"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-footer">`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("admin.article.comments.delete", comment.id),
          method: "delete",
          as: "button",
          "data-bs-dismiss": "modal",
          "aria-label": "Close",
          class: "btn btn-sm btn-danger px-3"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("messages.word.delete"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("messages.word.delete")), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</div></div></div></div></div></div></div></div>`);
      });
      _push(`<!--]--></div>`);
      if (_ctx.comments.data.length == 0) {
        _push(`<div class="cart-empty"><div class="empty-content-icon"><img${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/template/orders.svg")} alt=""></div><div class="empty-content-message text-center"><p class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</p></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.comments.data.length > 0) {
        _push(ssrRenderComponent(_sfc_main$5, {
          links: _ctx.comments.links
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Blog/Comments/List.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
