import { defineComponent, ref, watch, unref, withCtx, createTextVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderList, ssrRenderClass, ssrRenderAttr, ssrIncludeBooleanAttr } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./MainLayout-CahYFWjG.js";
import { useForm, Head, Link } from "@inertiajs/vue3";
import NeshanMap from "@neshan-maps-platform/vue3-openlayers";
import Dropdown from "primevue/dropdown/dropdown.esm.js";
/* empty css                       */
/* empty css                              */
/* empty css                           */
/* empty css             */
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
import "./AdminNavigation-BYBoZNuA.js";
import "./useHexToRgb-G7J9N7Ap.js";
import "./useRandomStr-4MeWbtRd.js";
import "jquery";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "List",
  __ssrInlineRender: true,
  props: {
    places: {},
    addresses: {}
  },
  setup(__props) {
    const props = __props;
    const selectedState = ref();
    const states = ref([]);
    for (let state in props.places) {
      states.value.push(state);
    }
    const selectedCity = ref();
    const cities = ref([]);
    watch(selectedState, (value) => {
      cities.value = [];
      if (selectedState.value != null) {
        for (let city of props.places[selectedState.value]) {
          cities.value.push(city);
        }
      }
    });
    const Map = ref();
    const MapEdit = ref();
    const createMapReset = ref(254896);
    const createAddressForm = useForm({
      first_name: null,
      last_name: null,
      state: selectedState.value,
      city: selectedCity.value,
      phone: "",
      postal_code: "",
      full_address: null,
      map: { longitude: 54.36281969540723, latitude: 32.69672648316882, zoom: 4.7, selected: false }
    });
    const mapResult = (event) => {
      var _a;
      if (event.apiData !== void 0) {
        createAddressForm.full_address = event.apiData.formatted_address;
        createAddressForm.map.longitude = event.coords[0];
        createAddressForm.map.latitude = event.coords[1];
        createAddressForm.map.zoom = (_a = Map.value) == null ? void 0 : _a.state.zoom;
        createAddressForm.map.selected = true;
      }
    };
    const editMapReset = ref(658963);
    ref();
    const editAddressForm = useForm({
      first_name: "",
      last_name: "",
      state: "",
      city: "",
      phone: "",
      postal_code: "",
      full_address: "",
      map: { longitude: 54.36281969540723, latitude: 32.69672648316882, zoom: 4.7, selected: false }
    });
    const editMapResult = (event) => {
      var _a;
      if (event.apiData !== void 0) {
        editAddressForm.full_address = event.apiData.formatted_address;
        editAddressForm.map = {
          longitude: event.coords[0],
          latitude: event.coords[1],
          zoom: (_a = MapEdit.value) == null ? void 0 : _a.state.zoom,
          selected: true
        };
      }
    };
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.addresses")
      }, null, _parent));
      _push(`<div class="card shadow-1 panel-content"><div class="card-body"><div class="row"><div class="col-lg-12 mb-3"><div class="panel-content--title mb-4 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.your_addresses"))}</div><div class="address-container"><div class="row"><!--[-->`);
      ssrRenderList(_ctx.addresses, (address) => {
        _push(`<div class="${ssrRenderClass({ "col-xl-3": true, "col-lg-4": true, "col-md-6": true, "user-address-item": true, "active-address": address.active })}"${ssrRenderAttr("data-address", address.id)}><div class="custom-radio-box"><label class="custom-radio-box-label"${ssrRenderAttr("data-placeholder", address.active ? _ctx.$t("messages.word.selected") : _ctx.$t("messages.sentence.select_this_address"))}><span class="d-block user-address-recipient mb-2">${ssrInterpolate(address.state + ", " + address.city)}</span><span class="d-block user-contact-items mb-3"><span class="user-contact-item"><span class="value full-address lts-05">${ssrInterpolate(address.full_address)}</span></span><span class="user-contact-item"><i class="ri-phone-line icon"></i><span class="value">${ssrInterpolate(address.phone)}</span></span><span class="user-contact-item"><i class="ri-user-line icon"></i><span class="value">${ssrInterpolate(address.first_name + " " + address.last_name)}</span></span></span><span class="d-flex align-items-center justify-content-end"><a href="javascript:void(0)" class="link border-bottom-0 fs-7 fw-bold" data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#delete-address-" + address.id)}>${ssrInterpolate(_ctx.$t("messages.word.delete"))}</a><span class="text-secondary mx-2">|</span><a href="javascript:void(0)" class="link border-bottom-0 fs-7 fw-bold" data-bs-toggle="modal" data-bs-target="#editAddressModal">${ssrInterpolate(_ctx.$t("messages.word.edit"))}</a></span>`);
        _push(ssrRenderComponent(unref(Link), {
          type: "button",
          class: "change-active-button",
          href: _ctx.route("user.addresses.change", address.id),
          as: "button",
          method: "post",
          data: { address_id: address.id }
        }, null, _parent));
        _push(`</label></div><div class="modal fade"${ssrRenderAttr("id", "delete-address-" + address.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><div class="modal-header pt-2"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.are_you_sure_delete_this_address"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-footer"><input type="hidden" name="address_id" value="">`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("user.addresses.destroy", address.id),
          method: "delete",
          as: "button",
          type: "button",
          "data-bs-dismiss": "modal",
          "aria-label": "Close",
          class: "btn btn-sm btn-danger px-3"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("messages.word.delete"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("messages.word.delete")), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</div></div></div></div></div>`);
      });
      _push(`<!--]--><div class="modal fade" id="editAddressModal" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-xl modal-dialog-centered"><div class="modal-content"><form><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.edit_address"))}:</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12 mb-2"><p class="alert alert-light fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_185521"))}</p></div><div class="col-md-6 mb-4"><div class="map-container">`);
      _push(ssrRenderComponent(unref(NeshanMap), {
        ref_key: "MapEdit",
        ref: MapEdit,
        mapKey: _ctx.$page.props.neshan.map_key,
        serviceKey: _ctx.$page.props.neshan.service_key,
        center: unref(editAddressForm).map,
        zoom: unref(editAddressForm).map.zoom,
        defaultType: "neshan",
        hideLayers: true,
        traffic: false,
        cluster: false,
        hideSearchContainer: true,
        onOnClick: editMapResult,
        class: "map",
        key: editMapReset.value
      }, null, _parent));
      _push(`</div></div><div class="col-md-6 add-address-container"><div class="row"><div class="col-lg-6 mb-3"><div class="form-element-row"><label for="eaFirstName" class="label fs-7">${ssrInterpolate(_ctx.$t("messages.sentence.recipient_firstname"))}</label><input${ssrRenderAttr("value", unref(editAddressForm).first_name)} type="text" id="eaFirstName" class="form-control"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.name"))}></div></div><div class="col-lg-6 mb-3"><div class="form-element-row"><label for="eaLastName" class="label fs-7">${ssrInterpolate(_ctx.$t("messages.sentence.recipient_lastname"))}</label><input${ssrRenderAttr("value", unref(editAddressForm).last_name)} type="text" id="eaLastName" class="form-control"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.lastname"))}></div></div><div class="col-lg-6 mb-3"><div class="form-element-row"><label for="eaState" class="label fs-7">${ssrInterpolate(_ctx.$t("messages.word.town"))}</label>`);
      _push(ssrRenderComponent(unref(Dropdown), {
        id: "eaState",
        class: "pvc-dropdown",
        modelValue: selectedState.value,
        "onUpdate:modelValue": ($event) => selectedState.value = $event,
        options: states.value,
        display: "chip",
        filter: "",
        appendTo: "self",
        placeholder: _ctx.$t("messages.sentence.select_state"),
        emptyMessage: _ctx.$t("messages.sentence.no_items_found"),
        emptyFilterMessage: _ctx.$t("messages.sentence.no_items_found")
      }, null, _parent));
      _push(`</div></div><div class="col-lg-6 mb-3"><div class="form-element-row"><label for="eaCity" class="label fs-7">${ssrInterpolate(_ctx.$t("messages.word.city"))}</label>`);
      _push(ssrRenderComponent(unref(Dropdown), {
        id: "eaCity",
        class: "pvc-dropdown",
        modelValue: selectedCity.value,
        "onUpdate:modelValue": ($event) => selectedCity.value = $event,
        options: cities.value,
        display: "chip",
        filter: "",
        appendTo: "self",
        placeholder: _ctx.$t("messages.sentence.select_city"),
        emptyMessage: _ctx.$t("messages.sentence.please_select_state_first"),
        emptyFilterMessage: _ctx.$t("messages.sentence.no_items_found")
      }, null, _parent));
      _push(`</div></div><div class="col-lg-6 mb-3"><div class="form-element-row"><label for="eaPhone" class="label fs-7">${ssrInterpolate(_ctx.$t("messages.sentence.recipient_phone"))}</label><input${ssrRenderAttr("value", unref(editAddressForm).phone)} type="text" id="eaPhone" minlength="11" maxlength="11" class="form-control" placeholder="ex: 09123456789"></div></div><div class="col-lg-6 mb-3"><div class="form-element-row"><label for="eaPostalCode" class="label fs-7">${ssrInterpolate(_ctx.$t("messages.word.postal_code"))}</label><input${ssrRenderAttr("value", unref(editAddressForm).postal_code)} type="text" id="eaPostalCode" minlength="10" maxlength="10" class="form-control"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.must_10digit_no_line"))}></div></div><div class="col-12 mb-3"><div class="form-element-row"><label for="eaFullAddress" class="label fs-7">${ssrInterpolate(_ctx.$t("messages.word.address"))}</label><textarea type="text" id="eaFullAddress" rows="5" class="form-control"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.write_full_address"))}>${ssrInterpolate(unref(editAddressForm).full_address)}</textarea></div></div></div></div></div></div><div class="modal-footer"><button${ssrIncludeBooleanAttr(unref(editAddressForm).processing) ? " disabled" : ""} class="btn btn-sm btn-primary px-3">${ssrInterpolate(_ctx.$t("messages.word.edit"))}</button></div></form></div></div></div><div class="col-xl-3 col-lg-4 col-md-6 user-address-item user-add-address-container"><div class="user-add-address--box" data-bs-toggle="modal" data-bs-target="#addAddressModal"><i class="ri-add-line"></i><span class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.add_new_address"))}</span></div><div class="modal fade" id="addAddressModal" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-xl modal-dialog-centered"><div class="modal-content"><form><div class="modal-header pb-1"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.add_new_address"))}:</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12 mb-2"><p class="alert alert-light fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_185521"))}</p></div><div class="col-md-6 mb-4"><div class="map-container">`);
      _push(ssrRenderComponent(unref(NeshanMap), {
        ref_key: "Map",
        ref: Map,
        mapKey: _ctx.$page.props.neshan.map_key,
        serviceKey: _ctx.$page.props.neshan.service_key,
        center: unref(createAddressForm).map,
        zoom: unref(createAddressForm).map.zoom,
        defaultType: "neshan",
        hideLayers: true,
        traffic: false,
        cluster: false,
        hideSearchContainer: true,
        onOnClick: mapResult,
        class: "map",
        key: createMapReset.value
      }, null, _parent));
      _push(`</div></div><div class="col-md-6 add-address-container"><div class="row"><div class="col-lg-6 mb-3"><div class="form-element-row"><label for="eaFirstName" class="label fs-7">${ssrInterpolate(_ctx.$t("messages.sentence.recipient_firstname"))}</label><input${ssrRenderAttr("value", unref(createAddressForm).first_name)} type="text" id="eaFirstName" class="form-control"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.name"))}></div></div><div class="col-lg-6 mb-3"><div class="form-element-row"><label for="eaLastName" class="label fs-7">${ssrInterpolate(_ctx.$t("messages.sentence.recipient_lastname"))}</label><input${ssrRenderAttr("value", unref(createAddressForm).last_name)} type="text" id="eaLastName" class="form-control"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.lastname"))}></div></div><div class="col-lg-6 mb-3"><div class="form-element-row"><label for="eaState" class="label fs-7">${ssrInterpolate(_ctx.$t("messages.word.town"))}</label>`);
      _push(ssrRenderComponent(unref(Dropdown), {
        id: "eaState",
        class: "pvc-dropdown",
        modelValue: selectedState.value,
        "onUpdate:modelValue": ($event) => selectedState.value = $event,
        options: states.value,
        display: "chip",
        filter: "",
        appendTo: "self",
        placeholder: _ctx.$t("messages.sentence.select_state"),
        emptyMessage: _ctx.$t("messages.sentence.no_items_found"),
        emptyFilterMessage: _ctx.$t("messages.sentence.no_items_found")
      }, null, _parent));
      _push(`</div></div><div class="col-lg-6 mb-3"><div class="form-element-row"><label for="eaCity" class="label fs-7">${ssrInterpolate(_ctx.$t("messages.word.city"))}</label>`);
      _push(ssrRenderComponent(unref(Dropdown), {
        id: "eaCity",
        class: "pvc-dropdown",
        modelValue: selectedCity.value,
        "onUpdate:modelValue": ($event) => selectedCity.value = $event,
        options: cities.value,
        display: "chip",
        filter: "",
        appendTo: "self",
        placeholder: _ctx.$t("messages.sentence.select_city"),
        emptyMessage: _ctx.$t("messages.sentence.please_select_state_first"),
        emptyFilterMessage: _ctx.$t("messages.sentence.no_items_found")
      }, null, _parent));
      _push(`</div></div><div class="col-lg-6 mb-3"><div class="form-element-row"><label for="eaPhone" class="label fs-7">${ssrInterpolate(_ctx.$t("messages.sentence.recipient_phone"))}</label><input${ssrRenderAttr("value", unref(createAddressForm).phone)} type="text" id="eaPhone" minlength="11" maxlength="11" class="form-control" placeholder="ex: 09123456789"></div></div><div class="col-lg-6 mb-3"><div class="form-element-row"><label for="eaPostalCode" class="label fs-7">${ssrInterpolate(_ctx.$t("messages.word.postal_code"))}</label><input${ssrRenderAttr("value", unref(createAddressForm).postal_code)} type="text" id="eaPostalCode" minlength="10" maxlength="10" class="form-control"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.must_10digit_no_line"))}></div></div><div class="col-12 mb-3"><div class="form-element-row"><label for="eaFullAddress" class="label fs-7">${ssrInterpolate(_ctx.$t("messages.word.address"))}</label><textarea type="text" id="eaFullAddress" rows="5" class="form-control"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.write_full_address"))}>${ssrInterpolate(unref(createAddressForm).full_address)}</textarea></div></div></div></div></div></div><div class="modal-footer pt-0"><button${ssrIncludeBooleanAttr(unref(createAddressForm).processing) ? " disabled" : ""} class="btn btn-sm btn-primary px-3">${ssrInterpolate(_ctx.$t("messages.sentence.add_address"))}</button></div></form></div></div></div></div></div></div></div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/User/Addresses/List.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
