import { defineComponent, resolveDirective, unref, withCtx, createTextVNode, createVNode, toDisplayString, mergeProps, createBlock, openBlock, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderList, ssrRenderAttr, ssrRenderAttrs, ssrGetDirectiveProps, ssrRenderStyle } from "vue/server-renderer";
import { _ as _sfc_main$1, a as _sfc_main$2 } from "./StoreLayout-D2_RagXW.js";
import { Head, Link } from "@inertiajs/vue3";
import { _ as _sfc_main$4 } from "./Pagination-C1AQrLe3.js";
import { _ as _sfc_main$3 } from "./SearchList-BZnYMQPN.js";
import { _ as _sfc_main$5 } from "./FilterList-CWxGcEKk.js";
import { u as useRandomNum } from "./useRandomNum-DNNSqR7b.js";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "jquery";
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "bootstrap";
import "./useNl2br-BIw8h5gy.js";
import "lodash/debounce.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "List",
  __ssrInlineRender: true,
  props: {
    products: {},
    searchableProducts: {},
    keyword: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      const _directive_tooltip = resolveDirective("tooltip");
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.product_list")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.sentence.product_list")
      }, null, _parent));
      _push(`<div class="product-list seller-product-list list mb-4"><div class="card"><div class="card-body"><div class="action-container d-flex flex-sm-row flex-column align-items-end justify-content-between"><button data-bs-toggle="modal" data-bs-target="#helpProduct" class="btn btn-light shadow-1 lts-05 mb-2 mb-sm-4">${ssrInterpolate(_ctx.$t("messages.word.guide"))}</button><div class="d-flex align-items-center justify-content-end mb-4"><button data-bs-toggle="modal" data-bs-target="#addProduct" class="btn btn-light shadow-1 lts-05 me-2">${ssrInterpolate(_ctx.$t("messages.sentence.add_from_products"))} <i class="ri-play-list-add-line ms-2"></i></button>`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("seller.products.create"),
        as: "button",
        class: "btn btn-primary lts-05"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.create_product"))} <i class="ri-add-line"${_scopeId}></i>`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("messages.sentence.create_product")) + " ", 1),
              createVNode("i", { class: "ri-add-line" })
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></div><div class="modal fade" id="addProduct" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-lg modal-dialog-centered"><div class="modal-content"><div class="modal-header pt-2"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.search_for_product_to_add_to_your_list"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body pb-0">`);
      _push(ssrRenderComponent(_sfc_main$3, {
        keyword: _ctx.keyword,
        s: true,
        placeholder: _ctx.$t("messages.sentence.product_title_or_uuid") + " ..."
      }, null, _parent));
      _push(`<div class="archive-products simplebar-container"><div class="row mx-0"><!--[-->`);
      ssrRenderList(_ctx.searchableProducts.data, (product) => {
        _push(`<div class="col-xl-3 col-lg-4 col-6"><div class="card product"><div class="card-body"><div class="product-thumbnail"><a target="_blank"${ssrRenderAttr("href", _ctx.route("main.products.show", product.slug))}><img${ssrRenderAttr("src", product.get_images[0]["link"])}${ssrRenderAttr("alt", product.title)}></a></div><div class="product-body"><h2 data-bs-toggle="tooltip" data-bs-placement="top"${ssrRenderAttr("title", _ctx.$t("messages.sentence.show_product_in_shop"))} class="product-title mb-0"><a class="lts-05" target="_blank"${ssrRenderAttr("href", _ctx.route("main.products.show", product.slug))}>${ssrInterpolate(product.title)}</a></h2></div>`);
        if (product.has_in_store_list) {
          _push(`<div${ssrRenderAttrs(mergeProps({ class: "btn btn-light btn-square btn-xs add-item-to-compare shadow-2" }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.sentence.already_added"), void 0, { top: true })))}><i class="ri-check-line"></i></div>`);
        } else {
          _push(ssrRenderComponent(unref(Link), mergeProps({
            href: _ctx.route("seller.products.add", product.slug),
            method: "post",
            as: "button",
            class: "btn btn-primary btn-square btn-xs add-item-to-compare shadow-2",
            "data-bs-dismiss": "modal",
            "aria-label": "Close"
          }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.sentence.add_to_my_product_list"), void 0, { top: true })), {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<i class="ri-add-line"${_scopeId}></i>`);
              } else {
                return [
                  createVNode("i", { class: "ri-add-line" })
                ];
              }
            }),
            _: 2
          }, _parent));
        }
        _push(`<ul class="product-colors"><!--[-->`);
        ssrRenderList(product.unique_color, (color, index) => {
          _push(`<li style="${ssrRenderStyle({ "background-color": color.value.color })}" data-bs-toggle="tooltip" data-bs-placement="top"${ssrRenderAttr("title", color.value.label)}></li>`);
        });
        _push(`<!--]--></ul></div></div></div>`);
      });
      _push(`<!--]-->`);
      if (_ctx.searchableProducts.data.length == 0) {
        _push(`<div class="col-12 mt-4"><div class="product-list-empty"><div class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="col-12 mt-4">`);
      _push(ssrRenderComponent(_sfc_main$4, {
        key: unref(useRandomNum)(1e3, 9999),
        links: _ctx.searchableProducts.links,
        "preserve-state": true
      }, null, _parent));
      _push(`</div></div></div></div></div></div></div><div class="modal fade" id="helpProduct" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-lg modal-dialog-centered"><div class="modal-content"><div class="modal-header pt-2"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.product_shipping_and_pricing_guide"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body pb-0"><ul class="modal-ul-text"><li><p class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_547522"))}</p></li><li><p class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_145282"))}</p></li><li><p class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_695236"))}</p></li><li><p class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_845125"))}</p></li></ul><div class="alert alert-light" style="${ssrRenderStyle({ "list-style": "none" })}"><p class="lts-05 mt-2">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_145826"))}:</p><ul class="modal-ul-text"><li><p class="lts-05 mb-1"><span class="fw-bold">${ssrInterpolate(_ctx.$t("messages.sentence.single_price"))}:</span> ${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_485256"))}</p></li><li><p class="lts-05 mb-1"><span class="fw-bold">${ssrInterpolate(_ctx.$t("messages.sentence.has_sales_variables"))}:</span> ${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_451258"))}</p></li><li><p class="lts-05 mb-2"><span class="fw-bold">${ssrInterpolate(_ctx.$t("messages.sentence.has_the_ability_to_offer_step_discount"))}:</span> ${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_595632"))}</p></li></ul></div></div></div></div></div>`);
      _push(ssrRenderComponent(_sfc_main$3, {
        keyword: _ctx.keyword,
        placeholder: _ctx.$t("messages.sentence.product_title_or_uuid") + " ..."
      }, null, _parent));
      _push(ssrRenderComponent(_sfc_main$5, {
        filters: {
          createdByYou: _ctx.$t("messages.sentence.created_by_you"),
          hasPrice: _ctx.$t("messages.sentence.with_inventory"),
          mostSale: _ctx.$t("messages.word.most_sale"),
          mostViewer: _ctx.$t("messages.word.most_viewed")
        }
      }, null, _parent));
      _push(`<div class="table-responsive mb-4"><table class="table" style="${ssrRenderStyle({ "min-width": "1000px" })}"><thead><tr><th class="first-small">${ssrInterpolate(_ctx.$t("messages.word.image"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.title"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.inventories"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.uuid"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.by"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.status"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.last_update"))}</th><th class="first-small"><i class="ri-settings-4-line"></i></th></tr></thead><tbody><!--[-->`);
      ssrRenderList(_ctx.products.data, (product) => {
        _push(`<tr><td><img class="br-10" width="35" height="35"${ssrRenderAttr("src", product.get_images[0]["link"])}${ssrRenderAttr("alt", product.get_images[0]["alt"])}></td><td${ssrRenderAttrs(ssrGetDirectiveProps(_ctx, _directive_tooltip, product.is_vip ? _ctx.$t("messages.sentence.vip_product") : null, void 0, { top: true }))}><a class="product-title" target="_blank"${ssrRenderAttr("href", _ctx.route("main.products.show", product.slug))}>${ssrInterpolate(product.title)}</a>`);
        if (product.is_vip) {
          _push(`<i class="ri-star-s-fill vip-product"></i>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</td><td class="white-space-nowrap">`);
        if (product.status != "rejected") {
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("seller.inventories.index", product.slug),
            class: "link active-link lts-05"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.manage_inventories"))}`);
              } else {
                return [
                  createTextVNode(toDisplayString(_ctx.$t("messages.sentence.manage_inventories")), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
        } else {
          _push(`<span>${ssrInterpolate(_ctx.$t("messages.word.unauthorized"))}</span>`);
        }
        _push(`</td><td${ssrRenderAttrs(mergeProps({ class: "clickable" }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.sentence.copy_product_uuid"), void 0, { top: true })))}><span class="fs-9 badge bg-dark">${ssrInterpolate(product.uuid)}</span></td><td>`);
        if (product.user.type == "owner" || product.user.type == "admin") {
          _push(`<span>${ssrInterpolate(_ctx.$page.props.appName)}</span>`);
        } else if (product.user.seller) {
          _push(`<span>${ssrInterpolate(product.user.store.name)}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</td><td class="lts-05">`);
        if (product.status == "publish") {
          _push(`<span class="badge bg-success">${ssrInterpolate(_ctx.$t("messages.word.published"))}</span>`);
        } else if (product.status == "draft") {
          _push(`<span class="badge bg-warning">${ssrInterpolate(_ctx.$t("messages.word.draft"))}</span>`);
        } else if (product.status == "awaiting") {
          _push(`<span class="badge bg-info">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_verify"))}</span>`);
        } else if (product.status == "rejected") {
          _push(`<span class="badge bg-danger">${ssrInterpolate(_ctx.$t("messages.word.rejected"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</td><td class="lts-05 fs-8">${ssrInterpolate(product.jalali_updated_at[3])}</td><td class="dropdown"><i class="ri-more-2-fill" data-bs-toggle="dropdown"></i><div class="dropdown-menu shadow-smooth-2"><ul>`);
        if (product.status == "publish") {
          _push(`<li><a class="dropdown-item lts-05" target="_blank"${ssrRenderAttr("href", _ctx.route("main.products.show", product.slug))}><i class="ri-eye-line"></i> ${ssrInterpolate(_ctx.$t("messages.word.show"))}</a></li>`);
        } else {
          _push(`<!---->`);
        }
        if (product.user_id == _ctx.$page.props.auth.user.id && product.status != "publish" && product.status != "draft") {
          _push(`<li>`);
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("seller.products.edit", product.slug),
            as: "button",
            class: "dropdown-item lts-05"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<i class="ri-pencil-line"${_scopeId}></i>`);
                if (product.status != "rejected") {
                  _push2(`<span${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.edit"))}</span>`);
                } else {
                  _push2(`<span${_scopeId}>${ssrInterpolate(_ctx.$t("messages.sentence.product_review"))}</span>`);
                }
              } else {
                return [
                  createVNode("i", { class: "ri-pencil-line" }),
                  product.status != "rejected" ? (openBlock(), createBlock("span", { key: 0 }, toDisplayString(_ctx.$t("messages.word.edit")), 1)) : (openBlock(), createBlock("span", { key: 1 }, toDisplayString(_ctx.$t("messages.sentence.product_review")), 1))
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</li>`);
        } else {
          _push(`<!---->`);
        }
        if (product.status != "rejected") {
          _push(`<li><a href="javascript:void(0)" data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#remove-product-" + product.id)} class="dropdown-item no-btn lts-05"><i class="ri-delete-bin-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.remove_product_from_my_list"))}</a></li>`);
        } else {
          _push(`<!---->`);
        }
        if (product.status == "rejected" || product.status == "awaiting" && product.reason == "create") {
          _push(`<li><a href="javascript:void(0)" data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#remove-permanent-product-" + product.id)} class="dropdown-item no-btn"><i class="ri-delete-bin-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.permanent_delete"))}</a></li>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</ul></div><div class="modal fade"${ssrRenderAttr("id", "remove-product-" + product.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.are_you_sure_you_want_to_delete_product_form_your_list"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div>`);
        if (product.store_has_inventory) {
          _push(`<div class="modal-body"><p class="d-block alert text-danger alert-danger lts-05 lh-25 p-3">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_548596"))}</p></div>`);
        } else if (product.user_id == _ctx.$page.props.auth.user.id) {
          _push(`<div class="modal-body"><p class="d-block alert text-danger alert-danger lts-05 lh-25 p-3">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_365895"))}</p><p class="d-block alert text-danger alert-danger lts-05 lh-25 p-3">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_458965"))}</p></div>`);
        } else {
          _push(`<!---->`);
        }
        if (!product.store_has_inventory && product.user_id != _ctx.$page.props.auth.user.id) {
          _push(`<div class="modal-footer">`);
          _push(ssrRenderComponent(unref(Link), {
            as: "button",
            href: _ctx.route("seller.products.delete", product.slug),
            method: "post",
            class: "btn btn-sm btn-danger px-3",
            "data-bs-dismiss": "modal",
            "aria-label": "Close"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(_ctx.$t("messages.word.delete"))}`);
              } else {
                return [
                  createTextVNode(toDisplayString(_ctx.$t("messages.word.delete")), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</form></div></div></div><div class="modal fade"${ssrRenderAttr("id", "remove-permanent-product-" + product.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.are_you_sure_you_want_to_permanently_delete_product"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div>`);
        if (product.status == "rejected" || product.status == "awaiting" && product.reason == "create") {
          _push(`<div class="modal-footer">`);
          _push(ssrRenderComponent(unref(Link), {
            as: "button",
            href: _ctx.route("seller.products.destroy", product.slug),
            method: "delete",
            class: "btn btn-sm btn-danger px-3",
            "data-bs-dismiss": "modal",
            "aria-label": "Close"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(_ctx.$t("messages.word.delete"))}`);
              } else {
                return [
                  createTextVNode(toDisplayString(_ctx.$t("messages.word.delete")), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</form></div></div></div></td></tr>`);
      });
      _push(`<!--]--></tbody></table></div>`);
      if (_ctx.products.data.length == 0) {
        _push(`<div class="product-list-empty"><div class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_sfc_main$4, {
        links: _ctx.products.links
      }, null, _parent));
      _push(`</div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Store/Products/Products/List.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
