import { defineComponent, ref, reactive, unref, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderList, ssrRenderAttr, ssrRenderStyle, ssrIncludeBooleanAttr } from "vue/server-renderer";
import { _ as _sfc_main$1, a as _sfc_main$2 } from "./StoreLayout-D2_RagXW.js";
import { useForm, Head } from "@inertiajs/vue3";
import { _ as _sfc_main$3 } from "./FormatedNumInput-D4wHj270.js";
import MultiSelect from "primevue/multiselect/multiselect.esm.js";
import { u as useRandomStr } from "./useRandomStr-4MeWbtRd.js";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "jquery";
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
import "./Pagination-C1AQrLe3.js";
import "./SearchList-BZnYMQPN.js";
import "lodash/debounce.js";
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "./useRandomNum-DNNSqR7b.js";
import "bootstrap";
import "./useNl2br-BIw8h5gy.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "List",
  __ssrInlineRender: true,
  props: {
    places: {},
    abandonedCartTimePeriodList: {},
    paymentMeta: {}
  },
  setup(__props) {
    const props = __props;
    const cities = ref([]);
    for (let state in props.places) {
      for (let city of props.places[state]) {
        cities.value.push(state + ": شهر " + city);
      }
    }
    const postWays = reactive(props.paymentMeta.get_post_ways);
    if (postWays.length == 0) {
      postWays.push({
        id: useRandomStr(10),
        uuid: "pishtaz",
        name: "پست پیشتاز",
        description: "اداره ملی پست ایران",
        price: {
          base: 0,
          excessWeight: 0
        },
        places: null,
        max_weight: null,
        sendPeriod: "",
        status: false
      });
      postWays.push({
        id: useRandomStr(10),
        uuid: "peyk",
        name: "پیک درون شهری",
        description: "ارسال از طریق پیک شهری",
        price: {
          base: 0,
          excessWeight: 0
        },
        places: [],
        max_weight: null,
        sendPeriod: "",
        status: false
      });
      postWays.push({
        id: useRandomStr(10),
        uuid: "paskeraye",
        name: "پس کرایه",
        description: "پرداخت در محل",
        price: null,
        places: null,
        max_weight: null,
        sendPeriod: "",
        status: false
      });
    }
    const paymentMetaForm = useForm({
      post_ways: postWays,
      free_post_min_price: props.paymentMeta.get_formatted_free_post_min_price
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.transportation_settings")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.sentence.transportation_settings")
      }, null, _parent));
      _push(`<div class="payment-meta mb-5"><form><div class="card"><div class="card-body p-4 pb-2"><div class="row mb-4">`);
      if (_ctx.$page.props.auth.store != null && !_ctx.$page.props.auth.store.direct_post) {
        _push(`<div class="col-12 mb-4"><div class="d-inline-block lts-05 alert alert-warning">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_548779"))}</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="tab-title col-12 lts-05 mb-4"><div>${ssrInterpolate(_ctx.$t("messages.sentence.free_send_settings"))}</div></div><div class="col-12 mb-4"><label for="eaFreeSendAmount" class="form-label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.min_price_for_free_send"))} <span class="currency">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span></label>`);
      _push(ssrRenderComponent(_sfc_main$3, {
        modelValue: unref(paymentMetaForm).free_post_min_price,
        "onUpdate:modelValue": ($event) => unref(paymentMetaForm).free_post_min_price = $event,
        type: "text",
        placeholder: _ctx.$t("messages.sentence.min_price_for_free_send") + " (تومان)",
        class: "form-control mb-2",
        id: "eaFreeSendAmount"
      }, null, _parent));
      _push(`<span class="lts-05 text-gray fs-8">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_201105"))}</span></div></div><div class="col-12 mb-5"><div class="border"></div></div><div class="send-way-component mb-4"><div class="tab-title lts-05 mb-3"><div>${ssrInterpolate(_ctx.$t("messages.sentence.transportation_methods"))} <span>${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_458752"))}</span></div></div><div class="send-way-items"><!--[-->`);
      ssrRenderList(postWays, (sendWay, index) => {
        _push(`<div class="row send-way-item mb-3"><div class="col-12 d-flex align-items-center justify-content-between mb-4"><div class="title-container d-flex flex-column"><span class="fw-bold text-dark lts-05 mb-1">${ssrInterpolate(sendWay.name)}</span><span class="fw-normal lts-05 fs-8 text-gray">${ssrInterpolate(sendWay.description)}</span></div><div class="d-flex align-items-center justify-content-end">`);
        if (sendWay.status) {
          _push(`<button type="button" class="btn btn-switch btn-on fs-9 me-2">${ssrInterpolate(_ctx.$t("messages.word.active"))}</button>`);
        } else {
          _push(`<button type="button" class="btn btn-switch btn-off fs-9 me-2">${ssrInterpolate(_ctx.$t("messages.word.deactive"))}</button>`);
        }
        if (sendWay.uuid.includes("custom")) {
          _push(`<button class="btn btn-square btn-danger btn-xs"><i class="ri-delete-bin-5-line"></i></button>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div></div>`);
        if (sendWay.uuid.includes("custom")) {
          _push(`<!--[--><div class="col-sm-4 col-12 mb-3"><label class="form-label lts-05 mb-1"><span>${ssrInterpolate(_ctx.$t("messages.sentence.post_way_title"))}</span><input type="text"${ssrRenderAttr("value", sendWay.name)}${ssrRenderAttr("placeholder", _ctx.$t("messages.word.title"))} class="form-control"${ssrRenderAttr("name", unref(useRandomStr)(10))}></label></div><div class="col-sm-8 col-12 mb-3"><label class="form-label lts-05 mb-1"><span>${ssrInterpolate(_ctx.$t("messages.word.description"))}</span><input type="text"${ssrRenderAttr("value", sendWay.description)}${ssrRenderAttr("placeholder", _ctx.$t("messages.word.description"))} class="form-control"${ssrRenderAttr("name", unref(useRandomStr)(10))}></label></div><div class="col-12"></div><!--]-->`);
        } else {
          _push(`<!---->`);
        }
        if (sendWay.price != null) {
          _push(`<!--[--><div class="col-sm-4 col-12 mb-3"><label class="form-label lts-05"><span class="required-field">${ssrInterpolate(_ctx.$t("messages.sentence.base_price"))} <span class="unit unit-sm"></span></span>`);
          _push(ssrRenderComponent(_sfc_main$3, {
            type: "text",
            modelValue: sendWay.price.base,
            "onUpdate:modelValue": ($event) => sendWay.price.base = $event,
            placeholder: _ctx.$t("messages.sentence.send_base_price"),
            class: "form-control",
            name: "judpdmv"
          }, null, _parent));
          _push(`</label></div><div class="col-sm-4 col-12 mb-3"><label class="form-label lts-05 mb-1"><span>${ssrInterpolate(_ctx.$t("messages.sentence.excess_weight_price"))} <span class="unit unit-sm"></span></span>`);
          _push(ssrRenderComponent(_sfc_main$3, {
            type: "text",
            modelValue: sendWay.price.excessWeight,
            "onUpdate:modelValue": ($event) => sendWay.price.excessWeight = $event,
            placeholder: _ctx.$t("messages.sentence.excess_weight_price"),
            class: "form-control",
            name: "judpdmv"
          }, null, _parent));
          _push(`</label><span class="text-gray lts-05 fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_266698"))}</span></div><div class="col-sm-4 col-12 mb-3"><label class="form-label lts-05 mb-1"><span>${ssrInterpolate(_ctx.$t("messages.sentence.max_consignment_weight"))} <span class="badge bg-dark ms-1" style="${ssrRenderStyle({ "padding": "3px 5px !important" })}">${ssrInterpolate(_ctx.$t("messages.word.kg"))}</span></span>`);
          _push(ssrRenderComponent(_sfc_main$3, {
            type: "text",
            modelValue: sendWay.max_weight,
            "onUpdate:modelValue": ($event) => sendWay.max_weight = $event,
            placeholder: _ctx.$t("messages.sentence.max_consignment_weight"),
            class: "form-control",
            name: "judpdmv"
          }, null, _parent));
          _push(`</label><span class="text-gray lts-05 fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_166692"))}</span></div><!--]-->`);
        } else {
          _push(`<!---->`);
        }
        if (sendWay.places != null) {
          _push(`<div class="col-12 mb-3"><div class="form-element-row"><label for="eaState" class="form-label lts-05"><span class="required-field mb-1 d-block">${ssrInterpolate(_ctx.$t("messages.sentence.cities_covered"))}</span>`);
          _push(ssrRenderComponent(unref(MultiSelect), {
            id: "eaState",
            class: "pvc-dropdown cities-multiselect",
            modelValue: sendWay.places,
            "onUpdate:modelValue": ($event) => sendWay.places = $event,
            options: cities.value,
            display: "chip",
            closeOnSelect: false,
            filter: "",
            placeholder: _ctx.$t("messages.sentence.select_cities"),
            emptyMessage: _ctx.$t("messages.sentence.no_items_found"),
            emptyFilterMessage: _ctx.$t("messages.sentence.no_items_found")
          }, null, _parent));
          _push(`</label></div></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="col-12 mb-4"><label for="eaPostPerion" class="form-label required">${ssrInterpolate(_ctx.$t("messages.sentence.determine_time_period"))}</label><input${ssrRenderAttr("value", sendWay.sendPeriod)} id="eaPostPerion" type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.example_send_time_period"))} class="form-control"></div></div>`);
      });
      _push(`<!--]--></div><button type="button" class="btn btn-square btn-primary"><i class="ri-add-line"></i></button></div><div class="col-12 mb-4"><div class="border"></div></div><div class="col-12 d-flex align-items-center justify-content-end mb-2"><button type="submit" class="btn btn-primary lts-05 shadow-1"${ssrIncludeBooleanAttr(unref(paymentMetaForm).processing) ? " disabled" : ""}>${ssrInterpolate(_ctx.$t("messages.sentence.save_changes"))} `);
      if (unref(paymentMetaForm).processing) {
        _push(`<i class="ri-refresh-line i-spin"></i>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</button></div></div></div></form></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Store/Transportation/List.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
