import { defineComponent, unref, withCtx, createTextVNode, createVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderStyle, ssrRenderList, ssrRenderAttr } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./AdminLayout-CD07IMsK.js";
import { Head, Link } from "@inertiajs/vue3";
import { _ as _sfc_main$5 } from "./Pagination-C1AQrLe3.js";
import { _ as _sfc_main$3 } from "./SearchList-BZnYMQPN.js";
import { _ as _sfc_main$4 } from "./FilterList-CWxGcEKk.js";
import { _ as _sfc_main$2 } from "./Files-B6eiTnN6.js";
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "lodash/debounce.js";
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "laravel-vue-i18n";
import "./useRandomNum-DNNSqR7b.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "List",
  __ssrInlineRender: true,
  props: {
    brands: {},
    keyword: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.brands")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.word.brands")
      }, null, _parent));
      _push(`<div class="user-list list mb-4"><div class="card"><div class="card-body"><div class="action-container mb-4 d-flex align-items-center justify-content-end">`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("admin.brands.create"),
        as: "button",
        class: "btn btn-primary"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.create_brand"))} <i class="ri-add-line"${_scopeId}></i>`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("messages.sentence.create_brand")) + " ", 1),
              createVNode("i", { class: "ri-add-line" })
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div>`);
      _push(ssrRenderComponent(_sfc_main$3, {
        keyword: _ctx.keyword,
        placeholder: _ctx.$t("messages.sentence.brand_title") + " ..."
      }, null, _parent));
      _push(ssrRenderComponent(_sfc_main$4, {
        filters: {
          active: _ctx.$t("messages.word.active"),
          archive: _ctx.$t("messages.word.archive"),
          mostProduct: _ctx.$t("messages.word.most_product"),
          mostViewer: _ctx.$t("messages.word.most_viewed")
        }
      }, null, _parent));
      _push(`<div class="table-responsive mb-4"><table class="table" style="${ssrRenderStyle({ "min-width": "900px" })}"><thead><tr><th class="first-small">${ssrInterpolate(_ctx.$t("messages.word.logo"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.name"))}</th><th style="${ssrRenderStyle({ "width": "100px" })}">${ssrInterpolate(_ctx.$t("messages.word.status"))}</th><th style="${ssrRenderStyle({ "width": "170px" })}">${ssrInterpolate(_ctx.$t("messages.word.edit"))}</th><th class="first-small"><i class="ri-settings-4-line"></i></th></tr></thead><tbody><!--[-->`);
      ssrRenderList(_ctx.brands.data, (brand) => {
        _push(`<tr><td><img width="35" height="35" class="br-10 shadow-1"${ssrRenderAttr("src", brand.get_logo)}${ssrRenderAttr("alt", brand.title)}></td><td>`);
        _push(ssrRenderComponent(unref(Link), {
          class: "link",
          href: _ctx.route("admin.brands.edit", brand.slug)
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(brand.title)}`);
            } else {
              return [
                createTextVNode(toDisplayString(brand.title), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</td>`);
        if (brand.status == "publish") {
          _push(`<td><span class="badge bg-success">${ssrInterpolate(_ctx.$t("messages.word.active"))}</span></td>`);
        } else if (brand.status == "archive") {
          _push(`<td><span class="badge bg-warning">${ssrInterpolate(_ctx.$t("messages.word.archive"))}</span></td>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<td>${ssrInterpolate(brand.jalali_updated_at[3])}</td><td class="dropdown"><i class="ri-more-2-fill" data-bs-toggle="dropdown"></i><div class="dropdown-menu shadow-smooth-2"><ul><li><a class="dropdown-item lts-05" target="_blank"${ssrRenderAttr("href", _ctx.route("main.brands.show", brand.slug))}><i class="ri-eye-line"></i> ${ssrInterpolate(_ctx.$t("messages.word.show"))}</a></li><li>`);
        _push(ssrRenderComponent(unref(Link), {
          class: "dropdown-item lts-05",
          href: _ctx.route("admin.brands.edit", brand.slug)
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<i class="ri-pencil-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.word.edit"))}`);
            } else {
              return [
                createVNode("i", { class: "ri-pencil-line" }),
                createTextVNode(" " + toDisplayString(_ctx.$t("messages.word.edit")), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</li><li><a href="javascript:void(0)" data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#statistics-" + brand.id)} class="dropdown-item no-btn"><i class="ri-bar-chart-2-line"></i> ${ssrInterpolate(_ctx.$t("messages.word.statistics"))}</a></li>`);
        if (brand.status == "publish" && brand.products_count == 0) {
          _push(`<li><a class="dropdown-item lts-05" href="javascript:void(0)" data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#remove-brand-" + brand.id)}><i class="ri-delete-bin-line"></i> ${ssrInterpolate(_ctx.$t("messages.word.delete"))}</a></li>`);
        } else if (brand.status == "publish") {
          _push(`<li><a class="dropdown-item lts-05" href="javascript:void(0)" data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#change-brand-status-" + brand.id)}><i class="ri-archive-drawer-line"></i> ${ssrInterpolate(_ctx.$t("messages.word.archive"))}</a></li>`);
        } else {
          _push(`<li>`);
          _push(ssrRenderComponent(unref(Link), {
            class: "dropdown-item lts-05",
            href: _ctx.route("admin.brands.destroy", brand.slug),
            as: "button",
            method: "delete"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<i class="ri-corner-up-right-double-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.word.publish"))}`);
              } else {
                return [
                  createVNode("i", { class: "ri-corner-up-right-double-line" }),
                  createTextVNode(" " + toDisplayString(_ctx.$t("messages.word.publish")), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</li>`);
        }
        _push(`</ul></div><div class="modal fade"${ssrRenderAttr("id", "statistics-" + brand.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-lgs modal-dialog-centered"><div class="modal-content"><form style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.brand_statistics"))}: <span class="ms-1">${ssrInterpolate(brand.title)}</span></div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12"><div class="table-responsive"><table class="table" style="${ssrRenderStyle({ "width": "100%", "min-width": "100%" })}"><tbody><tr><td class="lts-05">${ssrInterpolate(_ctx.$t("messages.word.uuid"))}</td><td class="clickable">${ssrInterpolate(brand.uuid)}</td></tr><tr><td>${ssrInterpolate(_ctx.$t("messages.word.view"))}</td><td>${ssrInterpolate(brand.get_formatted_view_count)}</td></tr><tr><td class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.products_count"))}</td><td>${ssrInterpolate(brand.products_count)}</td></tr><tr><td class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.articles_count"))}</td><td>${ssrInterpolate(brand.articles_count)}</td></tr></tbody></table></div></div></div></div><div class="modal-footer"><button class="btn btn-primary" type="button" data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(_ctx.$t("messages.word.close"))}</button></div></form></div></div></div><div class="modal fade"${ssrRenderAttr("id", "change-brand-status-" + brand.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form action="#" style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.are_you_sure_archive_brand"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-footer">`);
        _push(ssrRenderComponent(unref(Link), {
          as: "button",
          href: _ctx.route("admin.brands.destroy", brand.slug),
          method: "delete",
          class: "btn btn-sm btn-danger px-3",
          "data-bs-dismiss": "modal",
          "aria-label": "Close"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("messages.word.archive"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("messages.word.archive")), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</div></form></div></div></div><div class="modal fade"${ssrRenderAttr("id", "remove-brand-" + brand.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form action="#" style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.are_you_sure_delete_brand"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-footer">`);
        _push(ssrRenderComponent(unref(Link), {
          as: "button",
          href: _ctx.route("admin.brands.destroy", brand.slug),
          method: "delete",
          class: "btn btn-sm btn-danger px-3",
          "data-bs-dismiss": "modal",
          "aria-label": "Close"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("messages.word.delete"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("messages.word.delete")), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</div></form></div></div></div></td></tr>`);
      });
      _push(`<!--]--></tbody></table></div>`);
      if (_ctx.brands.data.length == 0) {
        _push(`<div class="product-list-empty"><div class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_sfc_main$5, {
        links: _ctx.brands.links
      }, null, _parent));
      _push(`</div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Products/Brand/List.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
