import { defineComponent, unref, withCtx, createTextVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderStyle, ssrRenderList } from "vue/server-renderer";
import { _ as _sfc_main$3 } from "./SearchList-BZnYMQPN.js";
import { _ as _sfc_main$4 } from "./FilterList-CWxGcEKk.js";
import { _ as _sfc_main$5 } from "./Pagination-C1AQrLe3.js";
import { _ as _sfc_main$1 } from "./AdminLayout-CD07IMsK.js";
import { Head, Link } from "@inertiajs/vue3";
import { _ as _sfc_main$2 } from "./Files-B6eiTnN6.js";
import { u as useNumberFormat } from "../ssr.js";
import "lodash/debounce.js";
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "laravel-vue-i18n";
import "./useRandomNum-DNNSqR7b.js";
import "@vue/server-renderer";
import "@inertiajs/vue3/server";
import "ziggy-js";
import "axios";
import "swiper/bundle";
import "jquery";
import "swiper";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "List",
  __ssrInlineRender: true,
  props: {
    payments: {},
    keyword: {},
    totalAwaiting: {},
    totalPaid: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.pending_payments")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.sentence.pending_payments")
      }, null, _parent));
      _push(`<div class="user-list list mb-4"><div class="card"><div class="card-body"><div class="d-block mb-2"><div class="d-inline-block alert alert-light me-3 mb-2"><span class="text-gray fs-8 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.total_awaiting_payment"))}: </span><span class="fw-bold text-dark">${ssrInterpolate(unref(useNumberFormat)(_ctx.totalAwaiting))}<span class="unit unit-sm"></span></span></div><div class="d-inline-block alert alert-light mb-0"><span class="text-gray fs-8 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.total_paid_payment"))}: </span><span class="fw-bold text-dark">${ssrInterpolate(unref(useNumberFormat)(_ctx.totalPaid))}<span class="unit unit-sm"></span></span></div></div><div class="d-block text-gray fs-8 mb-2"><span class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_850259"))}</span></div>`);
      _push(ssrRenderComponent(_sfc_main$3, {
        keyword: _ctx.keyword,
        placeholder: _ctx.$t("messages.sentence.order_uuid") + " ..."
      }, null, _parent));
      _push(ssrRenderComponent(_sfc_main$4, {
        filters: {
          awaiting: _ctx.$t("messages.word.awaiting"),
          paid: _ctx.$t("messages.word.paid")
        }
      }, null, _parent));
      _push(`<div class="table-responsive mb-4"><table class="table" style="${ssrRenderStyle({ "min-width": "1100px" })}"><thead><tr><th>${ssrInterpolate(_ctx.$t("messages.sentence.order_uuid"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.user"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.type"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.amount"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.status"))}</th><th>${ssrInterpolate(_ctx.$t("messages.sentence.paid_date"))}</th><th>${ssrInterpolate(_ctx.$t("messages.sentence.creation_date"))}</th><th class="first-small"><i class="ri-settings-4-line"></i></th></tr></thead><tbody><!--[-->`);
      ssrRenderList(_ctx.payments.data, (payment) => {
        _push(`<tr><td>`);
        _push(ssrRenderComponent(unref(Link), {
          class: "link",
          href: _ctx.route("admin.orders.show", payment.order.id),
          style: { "color": "#3ecaf6" }
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(payment.order.uuid)}`);
            } else {
              return [
                createTextVNode(toDisplayString(payment.order.uuid), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</td><td class="white-space-nowrap">`);
        _push(ssrRenderComponent(unref(Link), {
          class: "link",
          href: _ctx.route("admin.users.show", payment.user.id)
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(payment.user.get_name)}`);
            } else {
              return [
                createTextVNode(toDisplayString(payment.user.get_name), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</td><td>`);
        if (payment.type == "seller") {
          _push(`<span>${ssrInterpolate(_ctx.$t("messages.word.seller"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        if (payment.type == "affiliate") {
          _push(`<span>${ssrInterpolate(_ctx.$t("messages.sentence.sales_associate"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</td><td><span class="fw-bold">${ssrInterpolate(unref(useNumberFormat)(payment.amount))}</span><span class="unit unit-sm"></span></td><td>`);
        if (payment.status == "awaiting") {
          _push(`<span class="badge bg-info rounded-pill fs-7">${ssrInterpolate(_ctx.$t("messages.word.awaiting"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        if (payment.status == "paid") {
          _push(`<span class="badge bg-success rounded-pill fs-7">${ssrInterpolate(_ctx.$t("messages.word.paid"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</td><td class="lts-05 fs-9 white-space-nowrap">${ssrInterpolate(payment.jalali_paid_at != null ? payment.jalali_paid_at : _ctx.$t("messages.sentence.waiting_confirm"))}</td><td class="lts-05 fs-9 white-space-nowrap">${ssrInterpolate(payment.jalali_created_at[2])}</td><td class="text-center white-space-nowrap">`);
        if (payment.order.status == "delivered" && payment.status != "paid") {
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("admin.pending_payments.pay", payment.id),
            method: "post",
            as: "button",
            class: "btn btn-sm btn-success fs-9 fw-bold py-1 px-3 br-10 lts-05"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.confirm_deposit"))}`);
              } else {
                return [
                  createTextVNode(toDisplayString(_ctx.$t("messages.sentence.confirm_deposit")), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
        } else {
          _push(`<span>-</span>`);
        }
        _push(`</td></tr>`);
      });
      _push(`<!--]--></tbody></table></div>`);
      if (_ctx.payments.data.length == 0) {
        _push(`<div class="product-list-empty"><div class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_sfc_main$5, {
        links: _ctx.payments.links
      }, null, _parent));
      _push(`</div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Financial/PendingPayments/List.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
