import { defineComponent, ref, onMounted, onUnmounted, mergeProps, useSSRContext } from "vue";
import { ssrRenderAttrs } from "vue/server-renderer";
import Chart from "chart.js/auto";
import $ from "jquery";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "LineChart",
  __ssrInlineRender: true,
  props: {
    id: {},
    labels: {},
    datasets: {}
  },
  setup(__props) {
    const props = __props;
    const legendTextColor = ref("#000000");
    Chart.register({
      id: "changeLegendHeight",
      beforeInit(chart) {
        const fitValue = chart.legend.fit;
        chart.legend.fit = function fit() {
          fitValue.bind(chart.legend)();
          this.height += 15;
        };
      }
    });
    let lineChartOptions = {
      type: "line",
      data: { labels: props.labels, datasets: [] },
      options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
          changeLegendHeight: true,
          legend: {
            display: true,
            position: "top",
            align: "start",
            labels: {
              generateLabels: (chart) => {
                return chart.data.datasets.map((dataset, i) => ({
                  datasetIndex: i,
                  text: dataset.label,
                  fillStyle: dataset.borderColor,
                  strokeStyle: dataset.borderColor,
                  fontColor: legendTextColor.value
                }));
              },
              boxHeight: 7,
              usePointStyle: true,
              pointStyle: "circle",
              font: { family: "IRANYekanX", size: 12, weight: "normal" },
              padding: 15
            }
          },
          tooltip: {
            titleFont: { family: "IRANYekanX" },
            bodyFont: { family: "IRANYekanX" },
            backgroundColor: "rgba(0, 0, 0, 0.6)",
            displayColors: false
          }
        },
        scales: {
          x: { ticks: { color: "#1c1c25", font: { family: "IRANYekanX", size: 11 }, padding: 10 }, grid: { color: "#eeeeee" }, border: { width: 1, color: "#eeeeee" } },
          y: { display: false, beginAtZero: false }
        }
      }
    };
    if (props.datasets.one) {
      lineChartOptions.data.datasets.push({
        label: props.datasets.one.label,
        data: props.datasets.one.data,
        fill: false,
        tension: 0.3,
        backgroundColor: "#fff",
        borderColor: props.datasets.one.color,
        pointBorderColor: "#fff",
        pointBackgroundColor: "#1c1c25",
        pointBorderWidth: 3,
        pointHoverRadius: 10,
        pointHoverBackgroundColor: "#FC2055",
        pointHoverBorderColor: "#fff",
        pointHoverBorderWidth: 3,
        pointRadius: 5,
        pointHitRadius: 10,
        spanGaps: false
      });
    }
    if (props.datasets.two) {
      lineChartOptions.data.datasets.push({
        label: props.datasets.two.label,
        data: props.datasets.two.data,
        fill: false,
        tension: 0.3,
        backgroundColor: "#fff",
        borderColor: props.datasets.two.color,
        pointBorderColor: "#fff",
        pointBackgroundColor: "#141E41",
        pointBorderWidth: 3,
        pointHoverRadius: 10,
        pointHoverBackgroundColor: "#FC2055",
        pointHoverBorderColor: "#fff",
        pointHoverBorderWidth: 3,
        pointRadius: 5,
        pointHitRadius: 10,
        spanGaps: false
      });
    }
    const changeChartColor = (chart) => {
      var _a, _b;
      const isLight = $("body").attr("id") === "light";
      legendTextColor.value = isLight ? "#000000" : "#ffffff";
      const xScale = (_b = (_a = chart.options) == null ? void 0 : _a.scales) == null ? void 0 : _b.x;
      if (xScale) {
        xScale.ticks.color = isLight ? "#1c1c25" : "#ffffff";
        xScale.grid.color = isLight ? "#eeeeee" : "#414150";
        xScale.border.color = isLight ? "#eeeeee" : "#414150";
      }
      if (chart.data.datasets[0]) {
        chart.data.datasets[0].pointBorderColor = isLight ? "#ffffff" : "#353542";
        chart.data.datasets[0].pointBackgroundColor = isLight ? "#1c1c25" : "#ffffff";
      }
      if (props.datasets.two && chart.data.datasets[1]) {
        chart.data.datasets[1].pointBorderColor = isLight ? "#ffffff" : "#353542";
        chart.data.datasets[1].pointBackgroundColor = isLight ? "#1c1c25" : "#ffffff";
      }
      chart.update();
    };
    let lineChartStatistics = null;
    onMounted(() => {
      const canvas = document.querySelector("#line-chart-" + props.id);
      if (canvas) {
        lineChartStatistics = new Chart(canvas, lineChartOptions);
        changeChartColor(lineChartStatistics);
        $("#darkLight").on("click", () => {
          if (lineChartStatistics) changeChartColor(lineChartStatistics);
        });
      }
    });
    onUnmounted(() => {
      lineChartStatistics == null ? void 0 : lineChartStatistics.destroy();
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<canvas${ssrRenderAttrs(mergeProps({
        id: "line-chart-" + _ctx.id,
        width: "600",
        height: "150"
      }, _attrs))}></canvas>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/UI/Chart/LineChart.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as _
};
