import { defineComponent, useModel, watch, ref, onMounted, mergeProps, unref, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrGetDynamicModelProps } from "vue/server-renderer";
import { u as useRandomStr } from "./useRandomStr-4MeWbtRd.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "FormatedNumInput",
  __ssrInlineRender: true,
  props: {
    "modelValue": { required: true },
    "modelModifiers": {}
  },
  emits: ["update:modelValue"],
  setup(__props, { expose: __expose }) {
    const model = useModel(__props, "modelValue");
    watch(model, (value) => {
      if (value != null && value != "") {
        const p2e = (s) => s.replace(/[۰-۹]/g, (d) => "۰۱۲۳۴۵۶۷۸۹".indexOf(d));
        const a2e = (s) => s.replace(/[٠-٩]/g, (d) => "٠١٢٣٤٥٦٧٨٩".indexOf(d));
        let toEng = a2e(p2e(value));
        let toNumber = toEng.replace(/\D+/g, "");
        let nf = new Intl.NumberFormat("en-US");
        model.value = nf.format(toNumber);
      }
    });
    const input = ref(null);
    onMounted(() => {
      var _a, _b;
      if ((_a = input.value) == null ? void 0 : _a.hasAttribute("autofocus")) {
        (_b = input.value) == null ? void 0 : _b.focus();
      }
    });
    __expose({ focus: () => {
      var _a;
      return (_a = input.value) == null ? void 0 : _a.focus();
    } });
    return (_ctx, _push, _parent, _attrs) => {
      let _temp0;
      _push(`<input${ssrRenderAttrs((_temp0 = mergeProps({
        type: "text",
        class: "form-control",
        value: model.value,
        ref_key: "input",
        ref: input,
        name: unref(useRandomStr)(15)
      }, _attrs), mergeProps(_temp0, ssrGetDynamicModelProps(_temp0, model.value))))}>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Common/FormatedNumInput.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as _
};
