import { defineComponent, onMounted, mergeProps, unref, withCtx, createTextVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrRenderStyle, ssrInterpolate, ssrRenderComponent, ssrRenderList } from "vue/server-renderer";
import { Link, usePage } from "@inertiajs/vue3";
import SimpleBar from "simplebar";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "FilterList",
  __ssrInlineRender: true,
  props: {
    filters: {},
    routeParam: {}
  },
  setup(__props) {
    const props = __props;
    if (typeof window !== "undefined") {
      onMounted(() => {
        window.ResizeObserver = ResizeObserver;
        document.querySelectorAll(".simplebar-container").forEach((el) => {
          new SimpleBar(el, {
            autoHide: true
          });
        });
      });
    }
    const $queryStrings = (...args) => {
      let queryString = usePage().url;
      if (queryString.indexOf("?") === -1) {
        return {};
      }
      queryString = queryString.substring(queryString.indexOf("?") + 1);
      let object = Object.fromEntries(new URLSearchParams(queryString));
      for (let qs in object) {
        if (qs == "search" || qs == "cat" || qs == "tag" || qs == "profile" || qs == "random" || qs == "color" || qs == "price" || qs == "available" || qs == "discount") {
          continue;
        }
        delete object[qs];
      }
      return {
        search: Object.assign(object, ...args),
        all: Object.fromEntries(new URLSearchParams(queryString))
      };
    };
    const $filterArgs = (index, filter, ...args) => {
      let str = `{ "${index}": ${filter} }`;
      let obj = str.replace(/'/g, '"');
      return Object.assign(JSON.parse(obj), ...args);
    };
    const isActive = (key, value) => {
      let queryStrings = { ...$queryStrings().all };
      if (queryStrings.hasOwnProperty(key) && value) {
        return true;
      }
      if (key == "all") {
        let all = true;
        for (let filter in props.filters) {
          if (filter in queryStrings) {
            all = false;
          }
        }
        return all;
      }
      return false;
    };
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({
        class: "filters simplebar-container mb-3 w-100",
        style: { "max-width": "100%" }
      }, _attrs))}><ul class="nav nav-pills nav-tabs align-items-center" id="sort-tab" role="tablist" style="${ssrRenderStyle({ "min-width": "1000px" })}"><li class="d-inline-flex filter-list-title lts-05 align-items-center nav-item me-3 text-muted"><i class="ri-equalizer-line me-2"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.sort_by"))}: </li><li class="nav-item" role="presentation">`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route(unref(usePage)().props.currentRouteName, { ..._ctx.routeParam, ...$queryStrings().search }),
        as: "button",
        replace: "",
        "preserve-scroll": "",
        class: { "nav-link": true, "lts-05": true, active: isActive("all", true) }
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("messages.word.all"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("messages.word.all")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li><!--[-->`);
      ssrRenderList(_ctx.filters, (filter, index) => {
        _push(`<li class="nav-item" role="presentation">`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route(unref(usePage)().props.currentRouteName, { ..._ctx.routeParam, ...$queryStrings().search, ...$filterArgs(index, true) }),
          as: "button",
          replace: "",
          "preserve-scroll": "",
          class: { "nav-link": true, "lts-05": true, active: isActive(index, true) }
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(filter)}`);
            } else {
              return [
                createTextVNode(toDisplayString(filter), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</li>`);
      });
      _push(`<!--]--></ul></div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Common/FilterList.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as _
};
